/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.debug.DebugModelCallback;
import edu.rice.cs.drjava.model.junit.ConcJUnitUtils;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsModelCallback;
import edu.rice.cs.drjava.model.repl.newjvm.InterpretResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVM;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVMRemoteI;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.concurrent.StateMonitor;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.newjvm.AbstractMasterJVM;
import edu.rice.cs.util.newjvm.SlaveRemote;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.swing.JOptionPane;

public class MainJVM
extends AbstractMasterJVM
implements MainJVMRemoteI {
    private static final int MAX_STARTUP_FAILURES = 3;
    private static final int STARTUP_TIMEOUT = 10000;
    private final StateMonitor<State> _state;
    private final ResultHandler _handler = new ResultHandler();
    private volatile InteractionsModelCallback _interactionsModel;
    private volatile JUnitModelCallback _junitModel;
    private volatile DebugModelCallback _debugModel;
    private volatile boolean _allowAssertions = false;
    private volatile Iterable<File> _startupClassPath;
    private volatile File _workingDir;

    public MainJVM(File wd) {
        super(InterpreterJVM.class.getName());
        this._workingDir = wd;
        this._interactionsModel = new DummyInteractionsModel();
        this._junitModel = new DummyJUnitModel();
        this._debugModel = new DummyDebugModel();
        this._state = new StateMonitor<FreshState>(new FreshState());
        this._startupClassPath = ReflectUtil.SYSTEM_CLASS_PATH;
    }

    public void startInterpreterJVM() {
        this._state.value().start();
    }

    public void stopInterpreterJVM() {
        this._state.value().stop();
    }

    public void restartInterpreterJVM(boolean force) {
        this._state.value().restart(force);
    }

    @Override
    public void dispose() {
        this._state.value().dispose();
    }

    @Override
    protected void handleSlaveConnected(SlaveRemote newSlave) {
        InterpreterJVMRemoteI slaveCast = (InterpreterJVMRemoteI)newSlave;
        this._state.value().started(slaveCast);
    }

    @Override
    protected void handleSlaveQuit(int status) {
        DebugUtil.debug.logValue("Slave quit", "status", status);
        this._state.value().stopped(status);
    }

    @Override
    protected void handleSlaveWontStart(Exception e) {
        DebugUtil.debug.log("Slave won't start", e);
        this._state.value().startFailed(e);
    }

    @Override
    public void systemErrPrint(String s) {
        DebugUtil.debug.logStart();
        this._interactionsModel.replSystemErrPrint(s);
        DebugUtil.debug.logEnd();
    }

    @Override
    public void systemOutPrint(String s) {
        DebugUtil.debug.logStart();
        this._interactionsModel.replSystemOutPrint(s);
        DebugUtil.debug.logEnd();
    }

    @Override
    public String getConsoleInput() {
        String s = this._interactionsModel.getConsoleInput();
        return s;
    }

    @Override
    public void nonTestCase(boolean isTestAll, boolean didCompileFail) {
        this._junitModel.nonTestCase(isTestAll, didCompileFail);
    }

    @Override
    public void classFileError(ClassFileError e) {
        this._junitModel.classFileError(e);
    }

    @Override
    public void testSuiteStarted(int numTests) {
        this._junitModel.testSuiteStarted(numTests);
    }

    @Override
    public void testStarted(String testName) {
        this._junitModel.testStarted(testName);
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        this._junitModel.testEnded(testName, wasSuccessful, causedError);
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) {
        this._junitModel.testSuiteEnded(errors);
    }

    @Override
    public File getFileForClassName(String className) {
        return this._junitModel.getFileForClassName(className);
    }

    public void setInteractionsModel(InteractionsModelCallback model) {
        this._interactionsModel = model;
    }

    public void setJUnitModel(JUnitModelCallback model) {
        this._junitModel = model;
    }

    public void setDebugModel(DebugModelCallback model) {
        this._debugModel = model;
    }

    public void setAllowAssertions(boolean allow) {
        this._allowAssertions = allow;
    }

    public void setStartupClassPath(String classPath) {
        this._startupClassPath = IOUtil.parsePath(classPath);
    }

    public void setWorkingDirectory(File dir) {
        this._workingDir = dir;
    }

    protected InterpretResult.Visitor<Void> resultHandler() {
        return this._handler;
    }

    public boolean interpret(String s) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(true);
        if (remote == null) {
            return false;
        }
        try {
            DebugUtil.debug.logStart("Interpreting " + s);
            InterpretResult result = remote.interpret(s);
            result.apply(this.resultHandler());
            DebugUtil.debug.logEnd("result", (Object)result);
            return true;
        }
        catch (RemoteException e) {
            DebugUtil.debug.logEnd();
            this._handleRemoteException(e);
            return false;
        }
    }

    public Option<Pair<String, String>> getVariableToString(String var) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return Option.none();
        }
        try {
            return Option.some(remote.getVariableToString(var));
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return Option.none();
        }
    }

    public boolean addProjectClassPath(File f) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.addProjectClassPath(f);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean addBuildDirectoryClassPath(File f) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.addBuildDirectoryClassPath(f);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean addProjectFilesClassPath(File f) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.addProjectFilesClassPath(f);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean addExternalFilesClassPath(File f) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.addExternalFilesClassPath(f);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean addExtraClassPath(File f) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.addExtraClassPath(f);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public Option<Iterable<File>> getClassPath() {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return Option.none();
        }
        try {
            return Option.some(remote.getClassPath());
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return Option.none();
        }
    }

    public boolean setPackageScope(String packageName) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.interpret("package " + packageName + ";");
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public Option<List<String>> findTestClasses(List<String> classNames, List<File> files) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return Option.none();
        }
        try {
            return Option.some(remote.findTestClasses(classNames, files));
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return Option.none();
        }
    }

    public boolean runTestSuite() {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(true);
        if (remote == null) {
            return false;
        }
        try {
            return remote.runTestSuite();
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean addInterpreter(String name) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.addInterpreter(name);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean removeInterpreter(String name) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.removeInterpreter(name);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public Option<Pair<Boolean, Boolean>> setActiveInterpreter(String name) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return Option.none();
        }
        try {
            return Option.some(remote.setActiveInterpreter(name));
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return Option.none();
        }
    }

    public Option<Pair<Boolean, Boolean>> setToDefaultInterpreter() {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return Option.none();
        }
        try {
            return Option.some(remote.setToDefaultInterpreter());
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return Option.none();
        }
    }

    public boolean setEnforceAllAccess(boolean enforce) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.setEnforceAllAccess(enforce);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean setEnforcePrivateAccess(boolean enforce) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.setEnforcePrivateAccess(enforce);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean setRequireSemicolon(boolean require) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.setRequireSemicolon(require);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    public boolean setRequireVariableType(boolean require) {
        InterpreterJVMRemoteI remote = this._state.value().interpreter(false);
        if (remote == null) {
            return false;
        }
        try {
            remote.setRequireVariableType(require);
            return true;
        }
        catch (RemoteException e) {
            this._handleRemoteException(e);
            return false;
        }
    }

    private void _doStartup() {
        boolean junitLocationConfigured;
        String slaveMemory;
        int debugPort;
        File shortF;
        boolean repeat;
        File dir = this._workingDir;
        if (dir == FileOps.NULL_FILE) {
            dir = IOUtil.WORKING_DIRECTORY;
        }
        ArrayList<String> jvmArgs = new ArrayList<String>();
        final CompletionMonitor cm = new CompletionMonitor();
        do {
            repeat = false;
            File junitLocation = DrJava.getConfig().getSetting(OptionConstants.JUNIT_LOCATION);
            boolean javaVersion7 = JavaVersion.CURRENT.supports(JavaVersion.JAVA_7);
            boolean concJUnitAvailable = !javaVersion7 && (DrJava.getConfig().getSetting(OptionConstants.JUNIT_LOCATION_ENABLED) == false || ConcJUnitUtils.isValidConcJUnitFile(junitLocation));
            File rtLocation = DrJava.getConfig().getSetting(OptionConstants.RT_CONCJUNIT_LOCATION);
            boolean rtLocationConfigured = ConcJUnitUtils.isValidRTConcJUnitFile(rtLocation);
            if (DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("all-threads, no-join, lucky") && !rtLocationConfigured && rtLocation != null && !FileOps.NULL_FILE.equals(rtLocation) && rtLocation.exists()) {
                DrJava.getConfig().setSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED, "all-threads, no-join");
                rtLocationConfigured = false;
                JOptionPane.showMessageDialog(null, "The selected file is invalid and was disabled:\n" + rtLocation, "Invalid ConcJUnit Runtime File", 0);
            }
            if (!concJUnitAvailable || !rtLocationConfigured || !DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("all-threads, no-join, lucky")) continue;
            try {
                shortF = FileOps.getShortFile(rtLocation);
                if (ConcJUnitUtils.isCompatibleRTConcJUnitFile(shortF)) {
                    jvmArgs.add("-Xbootclasspath/p:" + shortF.getAbsolutePath().replace(File.separatorChar, '/'));
                    continue;
                }
                repeat = true;
                cm.reset();
                boolean attempted = ConcJUnitUtils.showIncompatibleWantToRegenerateDialog(null, new Runnable(){

                    @Override
                    public void run() {
                        cm.signal();
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        cm.signal();
                    }
                });
                while (!cm.attemptEnsureSignaled()) {
                }
                if (attempted) continue;
                repeat = false;
            }
            catch (IOException ioe) {
                DrJava.getConfig().setSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED, "all-threads, no-join");
                rtLocationConfigured = false;
                JOptionPane.showMessageDialog(null, "There was a problem with the selected file, and it was disabled:\n" + rtLocation, "Invalid ConcJUnit Runtime File", 0);
            }
        } while (repeat);
        if (this._allowAssertions) {
            jvmArgs.add("-ea");
        }
        if ((debugPort = this._getDebugPort()) > -1) {
            jvmArgs.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + debugPort);
            jvmArgs.add("-Xdebug");
            jvmArgs.add("-Xnoagent");
            jvmArgs.add("-Djava.compiler=NONE");
        }
        if (!"".equals(slaveMemory = DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_XMX)) && !OptionConstants.heapSizeChoices.get(0).equals(slaveMemory)) {
            jvmArgs.add("-Xmx" + slaveMemory + "M");
        }
        String slaveArgs = DrJava.getConfig().getSetting(OptionConstants.SLAVE_JVM_ARGS);
        if (PlatformFactory.ONLY.isMacPlatform()) {
            jvmArgs.add("-Xdock:name=Interactions");
        }
        for (File f : this._interactionsModel.getCompilerBootClassPath()) {
            try {
                shortF = FileOps.getShortFile(f);
                jvmArgs.add("-Xbootclasspath/a:" + shortF.getAbsolutePath().replace(File.separatorChar, '/'));
            }
            catch (IOException ioe) {}
        }
        jvmArgs.addAll(ArgumentTokenizer.tokenize(slaveArgs));
        JVMBuilder jvmb = new JVMBuilder(this._startupClassPath).directory(dir).jvmArguments(jvmArgs);
        File junitLocation = DrJava.getConfig().getSetting(OptionConstants.JUNIT_LOCATION);
        boolean bl = junitLocationConfigured = ConcJUnitUtils.isValidJUnitFile(junitLocation) || ConcJUnitUtils.isValidConcJUnitFile(junitLocation);
        if (DrJava.getConfig().getSetting(OptionConstants.JUNIT_LOCATION_ENABLED).booleanValue() && !junitLocationConfigured && junitLocation != null && !FileOps.NULL_FILE.equals(junitLocation) && junitLocation.exists()) {
            DrJava.getConfig().setSetting(OptionConstants.JUNIT_LOCATION_ENABLED, false);
            junitLocationConfigured = false;
        }
        ArrayList<File> extendedClassPath = new ArrayList<File>();
        if (DrJava.getConfig().getSetting(OptionConstants.JUNIT_LOCATION_ENABLED).booleanValue() && junitLocationConfigured) {
            extendedClassPath.add(junitLocation);
        }
        for (File f : jvmb.classPath()) {
            extendedClassPath.add(f);
        }
        jvmb = jvmb.classPath(IterUtil.asSizedIterable(extendedClassPath));
        Map<String, String> props = jvmb.propertiesCopy();
        boolean all = DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("all-threads, no-join, lucky");
        boolean noLucky = DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("all-threads, no-join");
        boolean onlyThreads = DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("all-threads");
        boolean none = DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("none (use JUnit)");
        props.put("edu.rice.cs.cunit.concJUnit.check.threads.enabled", new Boolean(!none).toString());
        props.put("edu.rice.cs.cunit.concJUnit.check.join.enabled", new Boolean(all || noLucky).toString());
        props.put("edu.rice.cs.cunit.concJUnit.check.lucky.enabled", new Boolean(all).toString());
        jvmb = jvmb.properties(props);
        this.invokeSlave(jvmb);
    }

    private int _getDebugPort() {
        int port = -1;
        try {
            port = this._interactionsModel.getDebugPort();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return port;
    }

    private void _handleRemoteException(RemoteException e) {
        if (e instanceof UnmarshalException) {
            if (e.getCause() instanceof EOFException) {
                return;
            }
            if (e.getCause() instanceof SocketException && e.getCause().getMessage().equals("Connection reset")) {
                return;
            }
        }
        DrJavaErrorHandler.record(e);
    }

    public static class DummyDebugModel
    implements DebugModelCallback {
        public void notifyDebugInterpreterAssignment(String name) {
        }
    }

    public static class DummyJUnitModel
    implements JUnitModelCallback {
        @Override
        public void nonTestCase(boolean isTestAll, boolean didCompileFail) {
        }

        @Override
        public void classFileError(ClassFileError e) {
        }

        @Override
        public void testSuiteStarted(int numTests) {
        }

        @Override
        public void testStarted(String testName) {
        }

        @Override
        public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        }

        @Override
        public void testSuiteEnded(JUnitError[] errors) {
        }

        @Override
        public File getFileForClassName(String className) {
            return null;
        }

        @Override
        public Iterable<File> getClassPath() {
            return IterUtil.empty();
        }

        @Override
        public void junitJVMReady() {
        }
    }

    public static class DummyInteractionsModel
    implements InteractionsModelCallback {
        @Override
        public int getDebugPort() throws IOException {
            return -1;
        }

        @Override
        public void replSystemOutPrint(String s) {
        }

        @Override
        public void replSystemErrPrint(String s) {
        }

        @Override
        public String getConsoleInput() {
            throw new IllegalStateException("Cannot request input from dummy interactions model!");
        }

        @Override
        public void setInputListener(InputListener il) {
            throw new IllegalStateException("Cannot set the input listener of dummy interactions model!");
        }

        @Override
        public void changeInputListener(InputListener from, InputListener to2) {
            throw new IllegalStateException("Cannot change the input listener of dummy interactions model!");
        }

        @Override
        public void replReturnedVoid() {
        }

        @Override
        public void replReturnedResult(String result, String style) {
        }

        @Override
        public void replThrewException(String message, StackTraceElement[] stackTrace) {
        }

        @Override
        public void replThrewException(String message) {
        }

        @Override
        public void replReturnedSyntaxError(String errorMessage, String interaction, int startRow, int startCol, int endRow, int endCol) {
        }

        @Override
        public void replCalledSystemExit(int status) {
        }

        @Override
        public void interpreterResetting() {
        }

        @Override
        public void interpreterResetFailed(Throwable th) {
        }

        @Override
        public void interpreterWontStart(Exception e) {
        }

        @Override
        public void interpreterReady(File wd) {
        }

        @Override
        public List<File> getCompilerBootClassPath() {
            return new ArrayList<File>();
        }

        @Override
        public String transformCommands(String interactionsString) {
            return interactionsString;
        }
    }

    private class ResultHandler
    implements InterpretResult.Visitor<Void> {
        private ResultHandler() {
        }

        @Override
        public Void forNoValue() {
            MainJVM.this._interactionsModel.replReturnedVoid();
            return null;
        }

        @Override
        public Void forObjectValue(String objString, String objTypeString) {
            MainJVM.this._interactionsModel.replReturnedResult(objString, "object.return.style");
            return null;
        }

        @Override
        public Void forStringValue(String s) {
            MainJVM.this._interactionsModel.replReturnedResult('\"' + s + '\"', "string.return.style");
            return null;
        }

        @Override
        public Void forCharValue(Character c) {
            MainJVM.this._interactionsModel.replReturnedResult("'" + c + "'", "character.return.style");
            return null;
        }

        @Override
        public Void forNumberValue(Number n) {
            MainJVM.this._interactionsModel.replReturnedResult(n.toString(), "number.return.style");
            return null;
        }

        @Override
        public Void forBooleanValue(Boolean b) {
            MainJVM.this._interactionsModel.replReturnedResult(b.toString(), "object.return.style");
            return null;
        }

        @Override
        public Void forEvalException(String message, StackTraceElement[] stackTrace) {
            MainJVM.this._interactionsModel.replThrewException(message, stackTrace);
            return null;
        }

        @Override
        public Void forException(String message) {
            MainJVM.this._interactionsModel.replThrewException(message);
            return null;
        }

        @Override
        public Void forUnexpectedException(Throwable t) {
            MainJVM.this._interactionsModel.replReturnedVoid();
            throw new UnexpectedException(t);
        }

        @Override
        public Void forBusy() {
            MainJVM.this._interactionsModel.replReturnedVoid();
            throw new UnexpectedException("MainJVM.interpret() called when InterpreterJVM was busy!");
        }
    }

    private class DisposedState
    extends State {
        private DisposedState() {
        }

        @Override
        public InterpreterJVMRemoteI interpreter(boolean used) {
            throw new IllegalStateException("MainJVM is disposed");
        }

        @Override
        public void start() {
            throw new IllegalStateException("MainJVM is disposed");
        }

        @Override
        public void stop() {
            throw new IllegalStateException("MainJVM is disposed");
        }

        @Override
        public void restart(boolean force) {
            throw new IllegalStateException("MainJVM is disposed");
        }

        @Override
        public void dispose() {
        }

        public void stopped() {
        }
    }

    private class StoppingState
    extends State {
        private StoppingState() {
        }

        @Override
        public InterpreterJVMRemoteI interpreter(boolean used) {
            return null;
        }

        @Override
        public void start() {
            try {
                ((State)MainJVM.this._state.ensureNotState(this, 10000L)).start();
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public void stop() {
        }

        @Override
        public void restart(boolean force) {
            if (!MainJVM.this._state.compareAndSet(this, new RestartingState())) {
                ((State)MainJVM.this._state.value()).restart(force);
            }
        }

        @Override
        public void dispose() {
            if (MainJVM.this._state.compareAndSet(this, new DisposedState())) {
                MainJVM.super.dispose();
            } else {
                ((State)MainJVM.this._state.value()).dispose();
            }
        }

        @Override
        public void stopped(int status) {
            if (!MainJVM.this._state.compareAndSet(this, new FreshState())) {
                ((State)MainJVM.this._state.value()).stopped(status);
            }
        }
    }

    private class RestartingState
    extends State {
        private RestartingState() {
        }

        @Override
        public InterpreterJVMRemoteI interpreter(boolean used) {
            try {
                return ((State)MainJVM.this._state.ensureNotState(this, 10000L)).interpreter(used);
            }
            catch (TimeoutException e) {
                return null;
            }
            catch (InterruptedException e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
            if (!MainJVM.this._state.compareAndSet(this, new StoppingState())) {
                ((State)MainJVM.this._state.value()).stop();
            }
        }

        @Override
        public void restart(boolean force) {
        }

        @Override
        public void dispose() {
            if (MainJVM.this._state.compareAndSet(this, new DisposedState())) {
                MainJVM.super.dispose();
            } else {
                ((State)MainJVM.this._state.value()).dispose();
            }
        }

        @Override
        public void stopped(int status) {
            if (MainJVM.this._state.compareAndSet(this, new StartingState())) {
                MainJVM.this._doStartup();
            } else {
                ((State)MainJVM.this._state.value()).stopped(status);
            }
        }
    }

    private class FreshRunningState
    extends RunningState {
        public FreshRunningState(InterpreterJVMRemoteI interpreter) {
            super(interpreter);
        }

        @Override
        public InterpreterJVMRemoteI interpreter(boolean used) {
            if (used) {
                MainJVM.this._state.compareAndSet(this, new RunningState(this._interpreter));
                return ((State)MainJVM.this._state.value()).interpreter(used);
            }
            return super.interpreter(used);
        }

        @Override
        public void restart(boolean force) {
            if (force) {
                super.restart(force);
            } else {
                MainJVM.this._interactionsModel.interpreterReady(MainJVM.this._workingDir);
            }
        }
    }

    private class RunningState
    extends State {
        protected final InterpreterJVMRemoteI _interpreter;

        public RunningState(InterpreterJVMRemoteI interpreter) {
            this._interpreter = interpreter;
        }

        @Override
        public InterpreterJVMRemoteI interpreter(boolean used) {
            return this._interpreter;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
            if (MainJVM.this._state.compareAndSet(this, new StoppingState())) {
                MainJVM.this.quitSlave();
            } else {
                ((State)MainJVM.this._state.value()).stop();
            }
        }

        @Override
        public void restart(boolean force) {
            if (MainJVM.this._state.compareAndSet(this, new RestartingState())) {
                MainJVM.this._interactionsModel.interpreterResetting();
                MainJVM.this.quitSlave();
            } else {
                ((State)MainJVM.this._state.value()).restart(force);
            }
        }

        @Override
        public void dispose() {
            this.stop();
            ((State)MainJVM.this._state.value()).dispose();
        }

        @Override
        public void stopped(int status) {
            if (MainJVM.this._state.compareAndSet(this, new RestartingState())) {
                MainJVM.this._interactionsModel.replCalledSystemExit(status);
                MainJVM.this._interactionsModel.interpreterResetting();
            }
            ((State)MainJVM.this._state.value()).stopped(status);
        }
    }

    private class StartingState
    extends State {
        private final int _failures;

        public StartingState() {
            this._failures = 0;
        }

        private StartingState(int failures) {
            this._failures = failures;
        }

        @Override
        public InterpreterJVMRemoteI interpreter(boolean used) {
            try {
                return ((State)MainJVM.this._state.ensureNotState(this, 10000L)).interpreter(used);
            }
            catch (TimeoutException e) {
                return null;
            }
            catch (InterruptedException e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public void start() {
        }

        @Override
        public void restart(boolean force) {
            try {
                ((State)MainJVM.this._state.ensureNotState(this, 10000L)).restart(force);
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public void stop() {
            try {
                ((State)MainJVM.this._state.ensureNotState(this, 10000L)).stop();
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public void dispose() {
            this.stop();
            ((State)MainJVM.this._state.value()).dispose();
        }

        @Override
        public void started(InterpreterJVMRemoteI i) {
            if (MainJVM.this._state.compareAndSet(this, new FreshRunningState(i))) {
                boolean enforceAllAccess = DrJava.getConfig().getSetting(OptionConstants.DYNAMICJAVA_ACCESS_CONTROL).equals("private and package only");
                try {
                    i.setEnforceAllAccess(enforceAllAccess);
                }
                catch (RemoteException re) {
                    MainJVM.this._handleRemoteException(re);
                }
                boolean enforcePrivateAccess = !DrJava.getConfig().getSetting(OptionConstants.DYNAMICJAVA_ACCESS_CONTROL).equals("disabled");
                try {
                    i.setEnforcePrivateAccess(enforcePrivateAccess);
                }
                catch (RemoteException re) {
                    MainJVM.this._handleRemoteException(re);
                }
                Boolean requireSemicolon = DrJava.getConfig().getSetting(OptionConstants.DYNAMICJAVA_REQUIRE_SEMICOLON);
                try {
                    i.setRequireSemicolon(requireSemicolon);
                }
                catch (RemoteException re) {
                    MainJVM.this._handleRemoteException(re);
                }
                Boolean requireVariableType = DrJava.getConfig().getSetting(OptionConstants.DYNAMICJAVA_REQUIRE_VARIABLE_TYPE);
                try {
                    i.setRequireVariableType(requireVariableType);
                }
                catch (RemoteException re) {
                    MainJVM.this._handleRemoteException(re);
                }
                MainJVM.this._interactionsModel.interpreterReady(MainJVM.this._workingDir);
                MainJVM.this._junitModel.junitJVMReady();
            } else {
                ((State)MainJVM.this._state.value()).started(i);
            }
        }

        @Override
        public void startFailed(Exception e) {
            int count = this._failures + 1;
            if (count < 3) {
                if (MainJVM.this._state.compareAndSet(this, new StartingState(count))) {
                    MainJVM.this._doStartup();
                } else {
                    ((State)MainJVM.this._state.value()).startFailed(e);
                }
            } else if (MainJVM.this._state.compareAndSet(this, new FreshState())) {
                MainJVM.this._interactionsModel.interpreterWontStart(e);
            } else {
                ((State)MainJVM.this._state.value()).startFailed(e);
            }
        }
    }

    private class FreshState
    extends State {
        private FreshState() {
        }

        @Override
        public InterpreterJVMRemoteI interpreter(boolean used) {
            return null;
        }

        @Override
        public void start() {
            if (MainJVM.this._state.compareAndSet(this, new StartingState())) {
                MainJVM.this._doStartup();
            } else {
                ((State)MainJVM.this._state.value()).start();
            }
        }

        @Override
        public void stop() {
        }

        @Override
        public void restart(boolean force) {
            this.start();
        }

        @Override
        public void dispose() {
            if (MainJVM.this._state.compareAndSet(this, new DisposedState())) {
                MainJVM.super.dispose();
            } else {
                ((State)MainJVM.this._state.value()).dispose();
            }
        }
    }

    private abstract class State {
        private State() {
        }

        public abstract InterpreterJVMRemoteI interpreter(boolean var1);

        public abstract void start();

        public abstract void stop();

        public abstract void restart(boolean var1);

        public abstract void dispose();

        public void started(InterpreterJVMRemoteI i) {
            throw new IllegalStateException("Unexpected started() call");
        }

        public void startFailed(Exception e) {
            throw new IllegalStateException("Unexpected startFailed() call");
        }

        public void stopped(int status) {
            throw new IllegalStateException("Unexpected stopped() call");
        }
    }
}

