/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.FindReplacePanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsTreePanel;
import edu.rice.cs.plt.tuple.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.LayeredHighlighter;

public class FindResultsPanel
extends RegionsTreePanel<MovingDocumentRegion> {
    private final String _searchString;
    private final boolean _searchAll;
    private final boolean _searchSelectionOnly;
    private final boolean _matchCase;
    private final boolean _wholeWord;
    private final boolean _noComments;
    private final boolean _noTestCases;
    private final WeakReference<OpenDefinitionsDocument> _doc;
    private final FindReplacePanel _findReplace;
    private final MovingDocumentRegion _region;
    private volatile JButton _findAgainButton;
    private volatile JButton _goToButton;
    private volatile JButton _bookmarkButton;
    private volatile JButton _removeButton;
    private volatile JComboBox<Color> _colorBox;
    private volatile int _lastIndex;
    private final LinkedList<Pair<Option<Color>, OptionListener<Color>>> _colorOptionListeners = new LinkedList();

    public FindResultsPanel(MainFrame frame, RegionManager<MovingDocumentRegion> regionManager, MovingDocumentRegion region, String title, String searchString, boolean searchAll, boolean searchSelectionOnly, boolean matchCase, boolean wholeWord, boolean noComments, boolean noTestCases, WeakReference<OpenDefinitionsDocument> doc, FindReplacePanel findReplace) {
        super(frame, title, regionManager);
        this._region = region;
        this._searchString = searchString;
        this._searchAll = searchAll;
        this._searchSelectionOnly = searchSelectionOnly;
        this._matchCase = matchCase;
        this._wholeWord = wholeWord;
        this._noComments = noComments;
        this._noTestCases = noTestCases;
        this._doc = doc;
        this._findReplace = findReplace;
        StringBuilder sb = new StringBuilder();
        sb.append("<html>Find '").append(title);
        if (!title.equals(this._searchString)) {
            sb.append("...");
        }
        sb.append("'");
        if (this._searchAll) {
            sb.append(" in all files");
        } else if (this._searchSelectionOnly) {
            sb.append(" only in original selection.");
        }
        sb.append(".");
        if (this._matchCase) {
            sb.append("<br>Case must match.");
        }
        if (this._wholeWord) {
            sb.append("<br>Whole words only.");
        }
        if (this._noComments) {
            sb.append("<br>No comments or strings.");
        }
        if (this._noTestCases) {
            sb.append("<br>No test cases.");
        }
        sb.append("</html>");
        this._findAgainButton.setToolTipText(sb.toString());
        this.getRegionManager().addListener(new RegionManagerListener<MovingDocumentRegion>(){

            @Override
            public void regionAdded(MovingDocumentRegion r) {
                FindResultsPanel.this.addRegion(r);
            }

            @Override
            public void regionChanged(MovingDocumentRegion r) {
                this.regionRemoved(r);
                this.regionAdded(r);
            }

            @Override
            public void regionRemoved(MovingDocumentRegion r) {
                FindResultsPanel.this.removeRegion(r);
            }
        });
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            FindResultsColorOptionListener listener = new FindResultsColorOptionListener(i);
            Pair<ColorOption, FindResultsColorOptionListener> pair = new Pair<ColorOption, FindResultsColorOptionListener>(OptionConstants.FIND_RESULTS_COLORS[i], listener);
            this._colorOptionListeners.add(pair);
            DrJava.getConfig().addOptionListener(OptionConstants.FIND_RESULTS_COLORS[i], listener);
        }
    }

    @Override
    protected JComponent[] makeButtons() {
        AbstractAction findAgainAction = new AbstractAction("Find Again"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindResultsPanel.this._findAgain();
            }
        };
        this._findAgainButton = new JButton(findAgainAction);
        AbstractAction goToAction = new AbstractAction("Go to"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindResultsPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction bookmarkAction = new AbstractAction("Bookmark"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindResultsPanel.this._bookmark();
            }
        };
        this._bookmarkButton = new JButton(bookmarkAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindResultsPanel.this._remove();
            }
        };
        this._removeButton = new JButton(removeAction);
        final JPanel highlightPanel = new JPanel();
        final Color normalColor = highlightPanel.getBackground();
        highlightPanel.add(new JLabel("Highlight:"));
        int smallestIndex = 0;
        int smallestUsage = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[smallestIndex];
        this._lastIndex = 0;
        while (this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
            if (DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[this._lastIndex] < smallestUsage) {
                smallestIndex = this._lastIndex;
                smallestUsage = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[smallestIndex];
            }
            ++this._lastIndex;
        }
        int n = this._lastIndex = smallestIndex;
        DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] + 1;
        this._colorBox = new JComboBox();
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            this._colorBox.addItem(DrJava.getConfig().getSetting(OptionConstants.FIND_RESULTS_COLORS[i]));
        }
        this._colorBox.addItem(null);
        this._colorBox.setRenderer(new ColorComboRenderer());
        this._colorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FindResultsPanel.this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
                    int n = FindResultsPanel.this._lastIndex;
                    DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] - 1;
                }
                FindResultsPanel.this._lastIndex = FindResultsPanel.this._colorBox.getSelectedIndex();
                if (FindResultsPanel.this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
                    int n = FindResultsPanel.this._lastIndex;
                    DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] + 1;
                    highlightPanel.setBackground(DrJava.getConfig().getSetting(OptionConstants.FIND_RESULTS_COLORS[FindResultsPanel.this._lastIndex]));
                } else {
                    highlightPanel.setBackground(normalColor);
                }
                FindResultsPanel.this._frame.refreshFindResultsHighlightPainter(FindResultsPanel.this, DefinitionsPane.FIND_RESULTS_PAINTERS[FindResultsPanel.this._lastIndex]);
            }
        });
        this._colorBox.setMaximumRowCount(OptionConstants.FIND_RESULTS_COLORS.length + 1);
        this._colorBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                FindResultsPanel.this._colorBox.revalidate();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FindResultsPanel.this._colorBox.revalidate();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                FindResultsPanel.this._colorBox.revalidate();
            }
        });
        this._colorBox.setSelectedIndex(this._lastIndex);
        this._frame.refreshFindResultsHighlightPainter(this, DefinitionsPane.FIND_RESULTS_PAINTERS[this._lastIndex]);
        this.updateButtons();
        return new JComponent[]{this._findAgainButton, this._goToButton, this._bookmarkButton, this._removeButton, highlightPanel, this._colorBox};
    }

    public LayeredHighlighter.LayerPainter getSelectedPainter() {
        return DefinitionsPane.FIND_RESULTS_PAINTERS[this._lastIndex];
    }

    private void _findAgain() {
        this._updateButtons();
        OpenDefinitionsDocument odd = null;
        if (this._searchAll) {
            odd = this.getGlobalModel().getActiveDocument();
        } else if (this._doc != null) {
            odd = (OpenDefinitionsDocument)this._doc.get();
        }
        if (odd != null) {
            this.getRegionManager().clearRegions();
            assert (this.getRootNode() == this.getRegTreeModel().getRoot());
            this.getRootNode().removeAllChildren();
            this._docToTreeNode.clear();
            this._regionToTreeNode.clear();
            this.getRegTreeModel().nodeStructureChanged(this.getRootNode());
            this._lastSelectedRegion = null;
            this._findReplace.findAll(this._searchString, this._searchAll, this._searchSelectionOnly, this._matchCase, this._wholeWord, this._noComments, this._noTestCases, odd, this.getRegionManager(), this._region, this);
            this.getRegTree().scrollRowToVisible(0);
            this._requestFocusInWindow();
        }
    }

    private void _bookmark() {
        this.updateButtons();
        RegionManager<MovingDocumentRegion> bm = this.getGlobalModel().getBookmarkManager();
        for (MovingDocumentRegion r : this.getSelectedRegions()) {
            OpenDefinitionsDocument doc = r.getDocument();
            int start = r.getStartOffset();
            int end = r.getEndOffset();
            Collection<MovingDocumentRegion> conflictingRegions = bm.getRegionsOverlapping(doc, start, end);
            for (MovingDocumentRegion cr : conflictingRegions) {
                bm.removeRegion(cr);
            }
            int lineStart = r.getLineStartOffset();
            int lineEnd = r.getLineEndOffset();
            bm.addRegion(new MovingDocumentRegion(doc, start, end, lineStart, lineEnd));
        }
        this._frame.showBookmarks();
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    @Override
    protected void _updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        OpenDefinitionsDocument odd = null;
        if (this._doc != null) {
            odd = (OpenDefinitionsDocument)this._doc.get();
        }
        this._findAgainButton.setEnabled(odd != null || this._searchAll);
        this._goToButton.setEnabled(regs.size() == 1);
        this._bookmarkButton.setEnabled(regs.size() > 0);
        this._removeButton.setEnabled(regs.size() > 0);
    }

    @Override
    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this.goToRegion();
            }
        }, new AbstractAction("Bookmark"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this._bookmark();
            }
        }, new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this._remove();
            }
        }};
        return acts;
    }

    @Override
    protected void goToRegion() {
        ArrayList r = this.getSelectedRegions();
        if (r.size() == 1) {
            this._frame.removeCurrentLocationHighlight();
            this._frame.goToRegionAndHighlight((IDocumentRegion)r.get(0));
        }
    }

    @Override
    protected void _close() {
        this.getRegionManager().clearRegions();
        this.getGlobalModel().removeFindResultsManager(this.getRegionManager());
        this._frame.removeCurrentLocationHighlight();
        this.freeResources();
        super._close();
    }

    public void freeResources() {
        this._docToTreeNode.clear();
        this._regionToTreeNode.clear();
        this.getGlobalModel().removeFindResultsManager(this.getRegionManager());
        for (Pair pair : this._colorOptionListeners) {
            DrJava.getConfig().removeOptionListener((Option)pair.first(), (OptionListener)pair.second());
        }
        if (this._lastIndex < OptionConstants.FIND_RESULTS_COLORS.length) {
            int n = this._lastIndex;
            DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] = DefinitionsPane.FIND_RESULTS_PAINTERS_USAGE[n] - 1;
        }
    }

    public boolean isSearchAll() {
        return this._searchAll;
    }

    public OpenDefinitionsDocument getDocument() {
        return (OpenDefinitionsDocument)this._doc.get();
    }

    public void disableFindAgain() {
        this._doc.clear();
        this.updateButtons();
    }

    private class FindResultsColorOptionListener
    implements OptionListener<Color> {
        private int _index;

        public FindResultsColorOptionListener(int i) {
            this._index = i;
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            int pos = FindResultsPanel.this._colorBox.getSelectedIndex();
            FindResultsPanel.this._colorBox.removeItemAt(this._index);
            FindResultsPanel.this._colorBox.insertItemAt(oce.value, this._index);
            FindResultsPanel.this._colorBox.setSelectedIndex(pos);
            if (pos == this._index) {
                FindResultsPanel.this._frame.refreshFindResultsHighlightPainter(FindResultsPanel.this, DefinitionsPane.FIND_RESULTS_PAINTERS[this._index]);
            }
        }
    }

    class ColorComboRenderer
    extends JPanel
    implements ListCellRenderer<Color> {
        private volatile Color _color;
        private final DefaultListCellRenderer _defaultRenderer;
        private final Dimension _size;
        private final CompoundBorder _compoundBorder;

        public ColorComboRenderer() {
            this._color = DrJava.getConfig().getSetting(OptionConstants.FIND_RESULTS_COLORS[FindResultsPanel.this._colorBox.getSelectedIndex()]);
            this._defaultRenderer = new DefaultListCellRenderer();
            this._size = new Dimension(0, 20);
            this._compoundBorder = new CompoundBorder(new MatteBorder(2, 10, 2, 10, Color.white), new LineBorder(Color.black));
            this.setBackground(this._color);
            this.setBorder(this._compoundBorder);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Color> list, Color color, int row, boolean sel, boolean hasFocus) {
            JComponent renderer;
            if (color != null) {
                this._color = color;
                renderer = this;
            } else {
                JLabel l = (JLabel)this._defaultRenderer.getListCellRendererComponent(list, color, row, sel, hasFocus);
                l.setHorizontalAlignment(0);
                renderer = l;
            }
            renderer.setPreferredSize(this._size);
            return renderer;
        }

        @Override
        public void paint(Graphics g) {
            this.setBackground(this._color);
            this.setBorder(this._compoundBorder);
            super.paint(g);
        }
    }
}

