/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.util.DirectorySelector;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DirectorySelectorComponent;
import edu.rice.cs.util.swing.Utilities;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JavadocDialog
implements DirectorySelector {
    private final JFrame _frame;
    private final DirectorySelectorComponent _selector;
    private final JCheckBox _checkBox;
    private final JOptionPane _optionPane;
    private final JDialog _dialog;
    private boolean _useSuggestion;
    private File _suggestedDir;

    public JavadocDialog(JFrame frame) {
        this._frame = frame;
        this._useSuggestion = true;
        this._suggestedDir = null;
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText("Select");
        String msg = "Select a destination directory for the Javadoc files:";
        this._selector = new DirectorySelectorComponent(this._frame, chooser, 30, 10.0f, false);
        this._checkBox = new JCheckBox("Always Prompt For Destination");
        Object[] components = new Object[]{msg, this._selector, this._checkBox};
        this._optionPane = new JOptionPane(components, 3, 2);
        this._dialog = this._optionPane.createDialog(this._frame, "Select Javadoc Destination");
        chooser.setOwner(this._dialog);
    }

    @Override
    public boolean isRecursive() {
        return false;
    }

    @Override
    public File getDirectory(File start) throws OperationCanceledException {
        if (start != null) {
            this._selector.setFileField(start);
        } else if (this._useSuggestion && this._suggestedDir != null) {
            this._selector.setFileField(this._suggestedDir);
        }
        FileConfiguration config = DrJava.getConfig();
        boolean ask = config.getSetting(OptionConstants.JAVADOC_PROMPT_FOR_DESTINATION);
        if (ask) {
            this._checkBox.setSelected(true);
            Utilities.setPopupLoc(this._dialog, this._frame);
            this._dialog.setVisible(true);
            if (!this._isPositiveResult()) {
                throw new OperationCanceledException();
            }
            if (!this._checkBox.isSelected()) {
                config.setSetting(OptionConstants.JAVADOC_PROMPT_FOR_DESTINATION, Boolean.FALSE);
            }
            if (start == null && this._useSuggestion && this._suggestedDir != null && !this._selector.getFileFromField().equals(this._suggestedDir)) {
                this._useSuggestion = false;
            }
        }
        return this._selector.getFileFromField();
    }

    @Override
    public boolean askUser(String message, String title) {
        int choice = JOptionPane.showConfirmDialog(this._frame, message, title, 0);
        return choice == 0;
    }

    @Override
    public void warnUser(String message, String title) {
        JOptionPane.showMessageDialog(this._frame, message, title, 0);
    }

    public void setSuggestedDir(File dir) {
        this._suggestedDir = dir;
    }

    public void setUseSuggestion(boolean use) {
        this._useSuggestion = use;
    }

    private boolean _isPositiveResult() {
        Object result = this._optionPane.getValue();
        if (result != null && result instanceof Integer) {
            int rc = (Integer)result;
            return rc == 0;
        }
        return false;
    }
}

