/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public class MainFrameStatics {
    public static File proposeToChangeExtension(Component parent, File input, String title, String message, String changeButton, String keepButton, String newExt) {
        Object[] options = new Object[]{changeButton, keepButton};
        int rc = 1;
        if (!Utilities.TEST_MODE) {
            rc = JOptionPane.showOptionDialog(parent, message, title, 0, 3, null, options, options[0]);
        }
        if (rc == 0) {
            try {
                String fileName = DrJavaFileUtils.removeExtension(input.getCanonicalPath()) + newExt;
                File file = new File(fileName);
                return file;
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(parent, ioe);
            }
        }
        return input;
    }

    public static boolean verifyOverwrite(Component parent, File f) {
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(parent, "<html>This file already exists.  Do you wish to overwrite the file?<br>" + f.getPath() + "<html>", "Confirm Overwrite", 0, 3, null, options, options[1]);
        return n == 0;
    }

    public static void showProjectFileParseError(Component parent, MalformedProjectFileException mpfe) {
        MainFrameStatics.showError(parent, "Invalid Project File", "DrJava could not read the given project file.");
    }

    public static void showFileNotFoundError(Component parent, FileNotFoundException fnf) {
        MainFrameStatics.showErrorWithMessageIfAvailable(parent, fnf, "File Not Found", "The specified file was not found on disk.");
    }

    public static void showIOError(Component parent, IOException ioe) {
        MainFrameStatics.showErrorWithMessageIfAvailable(parent, ioe, "Input/output error", "An I/O exception occurred during the last operation.");
    }

    public static void showErrorWithMessageIfAvailable(Component parent, Throwable e, String title, String message) {
        if (null != e.getMessage() && e.getMessage().length() > 0) {
            MainFrameStatics.showError(parent, title, message + "\n" + e.getMessage());
        } else {
            MainFrameStatics.showError(parent, e, title, message);
        }
    }

    public static void showClassNotFoundError(Component parent, ClassNotFoundException cnfe) {
        MainFrameStatics.showError(parent, cnfe, "Class Not Found", "A ClassNotFound exception occurred during the last operation.\nPlease check that your classpath includes all relevant directories.\n\n");
    }

    public static void showNoClassDefError(Component parent, NoClassDefFoundError ncde) {
        MainFrameStatics.showError(parent, ncde, "No Class Def", "A NoClassDefFoundError occurred during the last operation.\nPlease check that your classpath includes all relevant paths.\n\n");
    }

    public static void showDebugError(Component parent, DebugException de) {
        MainFrameStatics.showError(parent, de, "Debug Error", "A Debugger error occurred in the last operation.\n\n");
    }

    public static void showJUnitInterrupted(Component parent, UnexpectedException e) {
        MainFrameStatics.showWarning(parent, e.getCause(), "JUnit Testing Interrupted", "The slave JVM has thrown a RemoteException probably indicating that it has been reset.\n\n");
    }

    public static void showJUnitInterrupted(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "JUnit Testing Interrupted", 2);
    }

    public static void showError(Component parent, Throwable e, String title, String message) {
        JOptionPane.showMessageDialog(parent, message + "\n" + e + "\n" + StringOps.getStackTrace(e), title, 0);
    }

    public static void showError(Component parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    public static void showWarning(Component parent, Throwable e, String title, String message) {
        JOptionPane.showMessageDialog(parent, message + "\n" + e, title, 2);
    }

    public static JMenuItem newCheckBoxMenuItem(Action action) {
        String RADIO_ICON_KEY = "RadioButtonMenuItem.checkIcon";
        String CHECK_ICON_KEY = "CheckBoxMenuItem.checkIcon";
        Object radioIcon = UIManager.get(RADIO_ICON_KEY);
        UIManager.put(RADIO_ICON_KEY, UIManager.get(CHECK_ICON_KEY));
        JRadioButtonMenuItem pseudoCheckBox = new JRadioButtonMenuItem(action);
        UIManager.put(RADIO_ICON_KEY, radioIcon);
        return pseudoCheckBox;
    }

    public static class JavaAPIListEntry
    extends AutoCompletePopupEntry {
        private final String str;
        private final String fullStr;
        private final URL url;

        public JavaAPIListEntry(String s, String full, URL u) {
            this.str = s;
            this.fullStr = full;
            this.url = u;
        }

        public String toString() {
            return this.str;
        }

        public String getFullString() {
            return this.fullStr;
        }

        public URL getURL() {
            return this.url;
        }

        @Override
        public String getClassName() {
            return this.str;
        }

        @Override
        public String getFullPackage() {
            int pos = this.fullStr.lastIndexOf(46);
            if (pos >= 0) {
                return this.fullStr.substring(0, pos + 1);
            }
            return "";
        }

        @Override
        public OpenDefinitionsDocument getOpenDefinitionsDocument() {
            return null;
        }
    }

    public static class GoToFileListEntry
    extends AutoCompletePopupEntry {
        private final OpenDefinitionsDocument doc;
        private String fullPackage = null;
        private final String str;

        public GoToFileListEntry(OpenDefinitionsDocument d, String s) {
            this.doc = d;
            this.str = s;
        }

        @Override
        public String getFullPackage() {
            if (this.fullPackage != null) {
                return this.fullPackage;
            }
            this.fullPackage = "";
            if (this.doc != null) {
                try {
                    this.fullPackage = this.doc.getPackageName();
                    if (this.fullPackage.length() > 0) {
                        this.fullPackage = this.fullPackage + '.';
                    }
                }
                catch (Exception e) {
                    this.fullPackage = "";
                }
            }
            return this.fullPackage;
        }

        @Override
        public String getClassName() {
            return this.str;
        }

        public String toString() {
            return this.str;
        }

        @Override
        public OpenDefinitionsDocument getOpenDefinitionsDocument() {
            return this.doc;
        }
    }

    public static abstract class AutoCompletePopupEntry
    implements Comparable<AutoCompletePopupEntry> {
        public abstract String getClassName();

        public abstract String getFullPackage();

        public abstract OpenDefinitionsDocument getOpenDefinitionsDocument();

        @Override
        public int compareTo(AutoCompletePopupEntry other) {
            int res = this.getClassName().toLowerCase().compareTo(other.getClassName().toLowerCase());
            if (res != 0) {
                return res;
            }
            return this.getFullPackage().toLowerCase().compareTo(other.getFullPackage().toLowerCase());
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof AutoCompletePopupEntry)) {
                return false;
            }
            AutoCompletePopupEntry o = (AutoCompletePopupEntry)other;
            return this.getClassName().equals(o.getClassName()) && this.getFullPackage().equals(o.getFullPackage());
        }

        public int hashCode() {
            return ObjectUtil.hash((Object)this.getClassName(), (Object)this.getFullPackage());
        }
    }
}

