/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class PreviewFrame
extends SwingFrame {
    protected final SingleDisplayModel _model;
    protected final MainFrame _mainFrame;
    protected final Pageable _print;
    protected volatile int _pageNumber;
    Dimension _screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    JSlider _zoomSlider = new JSlider(0, 100, 300, 100);
    private JScrollPane _previewScroll;
    private final PageChangerUpdater _pageChanger;
    private final int PREVIEW_WIDTH;
    private final int PREVIEW_HEIGHT;
    private final int PREVIEW_PAGE_WIDTH;
    private final int PREVIEW_PAGE_HEIGHT;
    private static final double PAGE_ZOOM = 0.7;
    private static final int PAGE_BORDER = 20;
    private static final int TOOLBAR_HEIGHT = 65;
    private static final String ICON_PATH = "/edu/rice/cs/drjava/ui/icons/";
    private JToolBar _toolBar;
    private PagePreview _pagePreview;
    private final ActionListener _printListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._print();
            PreviewFrame.this._close();
        }
    };
    private final Action _closeAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._close();
        }
    };
    private final Action _nextPageAction = new AbstractAction("Next Page"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._nextPage();
        }
    };
    private final Action _prevPageAction = new AbstractAction("Previous Page"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._previousPage();
        }
    };
    private final WindowListener _windowCloseListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent ev) {
            PreviewFrame.this._close();
        }
    };

    public PreviewFrame(SingleDisplayModel model, MainFrame mainFrame, boolean interactions) throws IllegalStateException {
        super("Print Preview");
        mainFrame.hourglassOn();
        this._model = model;
        this._mainFrame = mainFrame;
        this._toolBar = new JToolBar();
        this._print = this.setUpDocument(model, interactions);
        this._pageChanger = this.createPageChanger();
        PageFormat first = this._print.getPageFormat(0);
        this.PREVIEW_PAGE_WIDTH = (int)(0.7 * first.getWidth());
        this.PREVIEW_PAGE_HEIGHT = (int)(0.7 * first.getHeight());
        this.PREVIEW_WIDTH = this.PREVIEW_PAGE_WIDTH + 40;
        this.PREVIEW_HEIGHT = this.PREVIEW_PAGE_HEIGHT + 40 + 65;
        this._setUpActions();
        this._setUpToolBar();
        this._pagePreview = new PagePreview(this.PREVIEW_PAGE_WIDTH, this.PREVIEW_PAGE_HEIGHT);
        this._pageNumber = 0;
        JPanel previewHolder = new JPanel(new BorderLayout());
        JPanel tbCont = new JPanel(new BorderLayout());
        JPanel cp = new JPanel(new BorderLayout());
        this._previewScroll = new JScrollPane(previewHolder);
        this._previewScroll.setHorizontalScrollBarPolicy(30);
        this._previewScroll.setVerticalScrollBarPolicy(20);
        tbCont.add((Component)this._toolBar, "North");
        tbCont.add(Box.createVerticalStrut(10), "South");
        tbCont.setBorder(new EmptyBorder(0, 0, 5, 0));
        previewHolder.add((Component)this._pagePreview, "Center");
        cp.add(this._previewScroll);
        this.setContentPane(cp);
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        cp.add((Component)tbCont, "North");
        this.addWindowListener(this._windowCloseListener);
        this.showPage();
        this._updateActions();
        this.setSize(this.PREVIEW_WIDTH, this.PREVIEW_HEIGHT);
        this.setDefaultCloseOperation(2);
        this.initDone();
        this.setVisible(true);
    }

    public void setZoom(int percent, boolean fast) {
        int h = (int)((double)(this.PREVIEW_PAGE_HEIGHT * percent) / 100.0);
        int w = (int)((double)(this.PREVIEW_PAGE_WIDTH * percent) / 100.0);
        this._pagePreview.updateScaled(w, h, fast);
        this.repaint();
        if (!fast) {
            this.refreshScreen();
        }
    }

    public void refreshScreen() {
        int previewWidth = this._pagePreview.getPreferredSize().width + 40;
        int previewHeight = this._pagePreview.getPreferredSize().height + 40 + 65;
        if (previewWidth > this._screenSize.width - 65) {
            previewWidth = this._screenSize.width - 65;
        }
        if (previewHeight > this._screenSize.height - 65) {
            previewHeight = this._screenSize.height - 65;
        }
        this.setSize(previewWidth, previewHeight);
    }

    protected abstract void _print();

    protected abstract Pageable setUpDocument(SingleDisplayModel var1, boolean var2);

    private void _close() {
        this.dispose();
        this._mainFrame.hourglassOff();
    }

    private void _nextPage() {
        ++this._pageNumber;
        this._goToPage(this._pageNumber);
    }

    private void _previousPage() {
        --this._pageNumber;
        this._goToPage(this._pageNumber);
    }

    private void _goToPage(int pi) {
        this._pageNumber = pi;
        this.showPage();
        this._updateActions();
    }

    protected void _showError(Exception e, String title, String message) {
        JOptionPane.showMessageDialog(this, message + "\n" + e, title, 0);
    }

    private void _updateActions() {
        this._nextPageAction.setEnabled(this._print.getNumberOfPages() > this._pageNumber + 1);
        this._prevPageAction.setEnabled(this._pageNumber > 0);
        try {
            this._pageChanger.update(this._pageNumber + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setUpActions() {
        this._closeAction.putValue("ShortDescription", "Close");
        this._nextPageAction.putValue("SmallIcon", this._getIcon("Forward16.gif"));
        this._nextPageAction.putValue("ShortDescription", "Next Page");
        this._prevPageAction.putValue("SmallIcon", this._getIcon("Back16.gif"));
        this._prevPageAction.putValue("ShortDescription", "Previous Page");
    }

    private PageChangerUpdater createPageChanger() {
        try {
            Class<?> spinnerClass = Class.forName("javax.swing.JSpinner");
            final JComponent spinner = (JComponent)spinnerClass.newInstance();
            final Method getter = spinnerClass.getMethod("getValue", new Class[0]);
            Object model = PreviewFrame.callMethod(spinner, spinnerClass, "getModel", null, null);
            Class<?> modelClass = model.getClass();
            Class[] ca = new Class[]{Comparable.class};
            Object[] aa = new Object[]{1};
            PreviewFrame.callMethod(model, modelClass, "setMinimum", ca, aa);
            aa[0] = this._print.getNumberOfPages();
            PreviewFrame.callMethod(model, modelClass, "setMaximum", ca, aa);
            ca[0] = ChangeListener.class;
            aa[0] = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    int num = PreviewFrame.this._pageNumber;
                    try {
                        num = ((Number)getter.invoke((Object)spinner, new Object[0])).intValue() - 1;
                        if (num >= 0 && num < PreviewFrame.this._print.getNumberOfPages()) {
                            PreviewFrame.this._goToPage(num);
                        } else {
                            PreviewFrame.this._updateActions();
                        }
                    }
                    catch (IllegalAccessException ex) {
                        PreviewFrame.this._updateActions();
                    }
                    catch (InvocationTargetException ex) {
                        PreviewFrame.this._updateActions();
                    }
                }
            };
            PreviewFrame.callMethod(spinner, spinnerClass, "addChangeListener", ca, aa);
            return new JSpinnerChanger(spinnerClass, spinner);
        }
        catch (Exception e) {
            final JTextField tf = new JTextField();
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        int pageToGoTo = Integer.parseInt(tf.getText()) - 1;
                        if (pageToGoTo < 0 || pageToGoTo >= PreviewFrame.this._print.getNumberOfPages()) {
                            PreviewFrame.this._updateActions();
                        } else {
                            PreviewFrame.this._goToPage(pageToGoTo);
                        }
                    }
                    catch (NumberFormatException e) {
                        PreviewFrame.this._updateActions();
                    }
                }
            });
            return new JTextFieldChanger(tf);
        }
    }

    private static Object callMethod(Object rec, Class<?> c, String name, Class<?>[] ca, Object[] args) throws Exception {
        Method m = c.getMethod(name, ca);
        return m.invoke(rec, args);
    }

    private ImageIcon _getIcon(String name) {
        URL url = PreviewFrame.class.getResource(ICON_PATH + name);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    private void _setUpToolBar() {
        this._toolBar.setFloatable(false);
        JButton printButton = new JButton("Print...", this._getIcon("Print16.gif"));
        printButton.setToolTipText("Print this document");
        printButton.addActionListener(this._printListener);
        this._toolBar.add(printButton);
        this._toolBar.addSeparator();
        this._toolBar.add(this._closeAction);
        this._toolBar.add(Box.createHorizontalGlue());
        this._zoomSlider.setPaintLabels(true);
        this._zoomSlider.setLabelTable(this._zoomSlider.createStandardLabels(100));
        this._zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                PreviewFrame.this.setZoom(slider.getValue(), slider.getValueIsAdjusting());
            }
        });
        this._toolBar.add(this._zoomSlider);
        this._toolBar.add(this._prevPageAction);
        this._toolBar.add(this._nextPageAction);
        this._toolBar.addSeparator();
        JLabel gotop = new JLabel("Page");
        JLabel of = new JLabel(" of " + this._print.getNumberOfPages());
        this._toolBar.add(gotop);
        this._toolBar.addSeparator();
        JComponent c = this._pageChanger.getComponent();
        Dimension d = c.getPreferredSize();
        d = new Dimension(100, d.height);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setToolTipText("Goto Page");
        this._toolBar.add(c);
        this._toolBar.add(of);
    }

    private void showPage() {
        BufferedImage img = new BufferedImage((int)this._model.getPageFormat().getWidth(), (int)this._model.getPageFormat().getHeight(), 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)this._model.getPageFormat().getWidth(), (int)this._model.getPageFormat().getHeight());
        try {
            this._print.getPrintable(this._pageNumber).print(g, this._model.getPageFormat(), this._pageNumber);
            this._pagePreview.setImage(img);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    static class PagePreview
    extends JPanel {
        protected int _width;
        protected int _height;
        protected volatile Image _source;
        protected volatile Image _image;

        public PagePreview(int width, int height) {
            this._width = width;
            this._height = height;
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
            this.setBackground(Color.white);
        }

        protected void updateScaled() {
            this._image = this._source.getScaledInstance(this._width, this._height, 4);
            this._image.flush();
        }

        protected void updateScaled(int newWidth, int newHeight, boolean fast) {
            this._width = newWidth;
            this._height = newHeight;
            this._image = this._source.getScaledInstance(newWidth, newHeight, fast ? 2 : 4);
            this._image.flush();
        }

        public void setImage(Image i) {
            this._source = i;
            this.updateScaled();
            this.repaint();
        }

        @Override
        public int getHeight() {
            return this._height;
        }

        @Override
        public int getWidth() {
            return this._width;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this._width, this._height);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this._width, this._height);
            g.drawImage(this._image, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PagePreviewContainer
    extends JPanel {
        PagePreviewContainer() {
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getParent().getSize();
        }

        @Override
        public void doLayout() {
            Component cp = this.getComponent(0);
            Dimension dm = cp.getPreferredSize();
            int Hindent = (int)(this.getPreferredSize().getWidth() - dm.getWidth()) / 2;
            int Vindent = 65 + (int)((this.getPreferredSize().getHeight() - dm.getHeight() - 65.0) / 2.0);
            PreviewFrame.this._pagePreview.setBounds(Hindent, Vindent, (int)dm.getWidth(), (int)dm.getHeight());
        }
    }

    private class JSpinnerChanger
    extends PageChangerUpdater {
        private volatile JComponent spinner;
        private volatile Method setValueMethod;
        private final Object[] args;

        private JSpinnerChanger(Class<?> spinnerClass, JComponent spinnerObj) throws Exception {
            this.args = new Object[1];
            this.spinner = spinnerObj;
            this.setValueMethod = spinnerClass.getMethod("setValue", Object.class);
        }

        @Override
        void update(int pageNumber) throws Exception {
            this.args[0] = pageNumber;
            this.setValueMethod.invoke((Object)this.spinner, this.args);
        }

        @Override
        JComponent getComponent() {
            return this.spinner;
        }
    }

    private class JTextFieldChanger
    extends PageChangerUpdater {
        private final JTextField textfield;

        private JTextFieldChanger(JTextField tf) {
            this.textfield = tf;
        }

        @Override
        void update(int pageNumber) throws Exception {
            this.textfield.setText(String.valueOf(pageNumber));
        }

        @Override
        JComponent getComponent() {
            return this.textfield;
        }
    }

    private static abstract class PageChangerUpdater {
        private PageChangerUpdater() {
        }

        abstract void update(int var1) throws Exception;

        abstract JComponent getComponent();
    }
}

