/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.drjava.ui.config.VectorKeyStrokeOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorOptionComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ConfigPanel
extends JPanel {
    protected final String _title;
    protected final Vector<OptionComponent<?, ?>> _components;

    public ConfigPanel(String title) {
        this._title = title;
        this._components = new Vector();
    }

    public String getTitle() {
        return this._title;
    }

    public void addComponent(OptionComponent<?, ?> oc) {
        this._components.add(oc);
    }

    public void displayComponents() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel panel2 = new JPanel();
        panel.add((Component)panel2, "North");
        JScrollPane scroll = new JScrollPane(panel, 20, 30);
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this._title));
        JScrollBar bar = scroll.getVerticalScrollBar();
        bar.setUnitIncrement(25);
        bar.setBlockIncrement(400);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel2.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(0, 10, 0, 10);
        Insets compInsets = new Insets(0, 0, 0, 0);
        for (int i = 0; i < this._components.size(); ++i) {
            OptionComponent<?, ?> comp = this._components.get(i);
            if (!comp.useEntireColumn()) {
                c.anchor = 10;
                c.weightx = 0.0;
                c.gridwidth = 1;
                c.insets = labelInsets;
                JLabel label = comp.getLabel();
                gridbag.setConstraints(label, c);
                panel2.add(label);
                c.weightx = 1.0;
                c.gridwidth = 0;
                c.insets = compInsets;
                Object otherC = comp.getComponent();
                gridbag.setConstraints((Component)otherC, c);
                panel2.add((Component)otherC);
                continue;
            }
            c.anchor = 11;
            c.weightx = 0.0;
            c.gridwidth = 2;
            c.gridwidth = 0;
            c.insets = compInsets;
            Object otherC = comp.getComponent();
            gridbag.setConstraints((Component)otherC, c);
            panel2.add((Component)otherC);
        }
        JButton _resetToDefaultButton = new JButton("Reset to Defaults");
        _resetToDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.resetToDefault();
            }
        });
        JPanel resetPanel = new JPanel();
        resetPanel.setLayout(new FlowLayout());
        resetPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        resetPanel.add(_resetToDefaultButton);
        panel.add((Component)resetPanel, "South");
        this.add((Component)scroll, "Center");
    }

    public boolean update() {
        for (int i = 0; i < this._components.size(); ++i) {
            boolean isValidUpdate = this._components.get(i).updateConfig();
            if (isValidUpdate) continue;
            return false;
        }
        return true;
    }

    public void resetToCurrent() {
        for (int i = 0; i < this._components.size(); ++i) {
            this._components.get(i).resetToCurrent();
            if (!(this._components.get(i) instanceof VectorOptionComponent)) continue;
            ((VectorOptionComponent)this._components.get(i)).resizeTable();
        }
    }

    public void resetToDefault() {
        for (int i = 0; i < this._components.size(); ++i) {
            this._components.get(i).resetToDefault();
            if (!(this._components.get(i) instanceof VectorOptionComponent)) continue;
            ((VectorOptionComponent)this._components.get(i)).resizeTable();
        }
        VectorKeyStrokeOptionComponent.resetCurrentKeyStrokeMap();
    }
}

