/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.IntegerOption;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IntegerOptionComponent
extends OptionComponent<Integer, JTextField> {
    private volatile JTextField _jtf = new JTextField();

    public IntegerOptionComponent(IntegerOption opt, String text, SwingFrame parent) {
        super(opt, text, parent);
        this._jtf.setText(this._option.format(DrJava.getConfig().getSetting(this._option)));
        this._jtf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IntegerOptionComponent.this.notifyChangeListeners();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IntegerOptionComponent.this.notifyChangeListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IntegerOptionComponent.this.notifyChangeListeners();
            }
        });
        this.setComponent(this._jtf);
    }

    public IntegerOptionComponent(IntegerOption opt, String text, SwingFrame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._jtf.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        Integer enteredValue;
        Integer currentValue = (Integer)DrJava.getConfig().getSetting(this._option);
        String enteredString = this._jtf.getText().trim();
        if (currentValue.toString().equals(enteredString)) {
            return true;
        }
        try {
            enteredValue = (Integer)this._option.parse(enteredString);
        }
        catch (OptionParseException ope) {
            this.showErrorMessage("Invalid Integer!", ope);
            return false;
        }
        DrJava.getConfig().setSetting(this._option, enteredValue);
        return true;
    }

    @Override
    public void setValue(Integer value) {
        this._jtf.setText(this._option.format(value));
    }
}

