/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ToolbarOptionComponent
extends OptionComponent<Boolean, JComponent> {
    private JRadioButton _noneButton = new JRadioButton("none");
    private JRadioButton _textButton;
    private JRadioButton _iconsButton;
    private JRadioButton _textAndIconsButton;
    private ButtonGroup _group;
    private JPanel _buttonPanel;
    public static final String NONE = "none";
    public static final String TEXT_ONLY = "text only";
    public static final String ICONS_ONLY = "icons only";
    public static final String TEXT_AND_ICONS = "text and icons";

    public ToolbarOptionComponent(String title, SwingFrame parent) {
        super(title, parent);
        this._noneButton.setActionCommand(NONE);
        this._noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolbarOptionComponent.this.notifyChangeListeners();
            }
        });
        this._textButton = new JRadioButton(TEXT_ONLY);
        this._textButton.setActionCommand(TEXT_ONLY);
        this._textButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolbarOptionComponent.this.notifyChangeListeners();
            }
        });
        this._iconsButton = new JRadioButton(ICONS_ONLY);
        this._iconsButton.setActionCommand(ICONS_ONLY);
        this._iconsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolbarOptionComponent.this.notifyChangeListeners();
            }
        });
        this._textAndIconsButton = new JRadioButton(TEXT_AND_ICONS);
        this._textAndIconsButton.setActionCommand(TEXT_AND_ICONS);
        this._textAndIconsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolbarOptionComponent.this.notifyChangeListeners();
            }
        });
        this.resetToCurrent();
        this._group = new ButtonGroup();
        this._group.add(this._noneButton);
        this._group.add(this._textButton);
        this._group.add(this._iconsButton);
        this._group.add(this._textAndIconsButton);
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new GridLayout(0, 1));
        this._buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this._buttonPanel.add(this._noneButton);
        this._buttonPanel.add(this._textButton);
        this._buttonPanel.add(this._iconsButton);
        this._buttonPanel.add(this._textAndIconsButton);
        DrJava.getConfig().addOptionListener(OptionConstants.TOOLBAR_TEXT_ENABLED, new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oe) {
                ToolbarOptionComponent.this.resetToCurrent();
            }
        });
        DrJava.getConfig().addOptionListener(OptionConstants.TOOLBAR_ICONS_ENABLED, new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oe) {
                ToolbarOptionComponent.this.resetToCurrent();
            }
        });
        DrJava.getConfig().addOptionListener(OptionConstants.TOOLBAR_ENABLED, new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oe) {
                ToolbarOptionComponent.this.resetToCurrent();
            }
        });
        this.setComponent(this._buttonPanel);
    }

    public ToolbarOptionComponent(String title, SwingFrame parent, String description) {
        this(title, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._buttonPanel.setToolTipText(description);
        this._noneButton.setToolTipText(description);
        this._textButton.setToolTipText(description);
        this._iconsButton.setToolTipText(description);
        this._textAndIconsButton.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public void resetToCurrent() {
        this._setSelected(DrJava.getConfig().getSetting(OptionConstants.TOOLBAR_TEXT_ENABLED), DrJava.getConfig().getSetting(OptionConstants.TOOLBAR_ICONS_ENABLED), DrJava.getConfig().getSetting(OptionConstants.TOOLBAR_ENABLED));
    }

    @Override
    public void resetToDefault() {
        this._setSelected((Boolean)OptionConstants.TOOLBAR_TEXT_ENABLED.getDefault(), (Boolean)OptionConstants.TOOLBAR_ICONS_ENABLED.getDefault(), (Boolean)OptionConstants.TOOLBAR_ENABLED.getDefault());
    }

    private void _setSelected(boolean textEnabled, boolean iconsEnabled, boolean isEnabled) {
        if (!isEnabled) {
            this._noneButton.setSelected(true);
        } else if (textEnabled && iconsEnabled) {
            this._textAndIconsButton.setSelected(true);
        } else if (textEnabled) {
            this._textButton.setSelected(true);
        } else if (iconsEnabled) {
            this._iconsButton.setSelected(true);
        }
    }

    @Override
    public boolean updateConfig() {
        String btnIdent = this._group.getSelection().getActionCommand();
        boolean textWasEnabled = DrJava.getConfig().getSetting(OptionConstants.TOOLBAR_TEXT_ENABLED);
        boolean iconsWereEnabled = DrJava.getConfig().getSetting(OptionConstants.TOOLBAR_ICONS_ENABLED);
        boolean wasEnabled = DrJava.getConfig().getSetting(OptionConstants.TOOLBAR_ENABLED);
        if (btnIdent.equals(NONE) && wasEnabled) {
            DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_ENABLED, Boolean.FALSE);
        }
        if (btnIdent.equals(TEXT_ONLY)) {
            if (!textWasEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_TEXT_ENABLED, Boolean.TRUE);
            }
            if (iconsWereEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_ICONS_ENABLED, Boolean.FALSE);
            }
            if (!wasEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_ENABLED, Boolean.TRUE);
            }
        }
        if (btnIdent.equals(ICONS_ONLY)) {
            if (!iconsWereEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_ICONS_ENABLED, Boolean.TRUE);
            }
            if (textWasEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_TEXT_ENABLED, Boolean.FALSE);
            }
            if (!wasEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_ENABLED, Boolean.TRUE);
            }
        }
        if (btnIdent.equals(TEXT_AND_ICONS)) {
            if (!textWasEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_TEXT_ENABLED, Boolean.TRUE);
            }
            if (!iconsWereEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_ICONS_ENABLED, Boolean.TRUE);
            }
            if (!wasEnabled) {
                DrJava.getConfig().setSetting(OptionConstants.TOOLBAR_ENABLED, Boolean.TRUE);
            }
        }
        return true;
    }

    @Override
    public void setValue(Boolean value) {
        this.resetToCurrent();
    }

    @Override
    public void setComponent(JComponent component) {
        this._guiComponent = component;
        if (this._guiComponent != null) {
            boolean wasEditable = DrJava.getConfig().isEditable(OptionConstants.TOOLBAR_TEXT_ENABLED);
            wasEditable = wasEditable && DrJava.getConfig().isEditable(OptionConstants.TOOLBAR_ICONS_ENABLED);
            wasEditable = wasEditable && DrJava.getConfig().isEditable(OptionConstants.TOOLBAR_ENABLED);
            this._guiComponent.setEnabled(wasEditable);
            for (Component subComponent : this._guiComponent.getComponents()) {
                subComponent.setEnabled(wasEditable);
            }
        }
    }
}

