/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.ClassChecker;
import edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.TreeClassLoader;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.interpreter.TypeNameChecker;
import edu.rice.cs.dynamicjava.symbol.Access;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJField;
import edu.rice.cs.dynamicjava.symbol.Function;
import edu.rice.cs.dynamicjava.symbol.FunctionWrapperClass;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TreeClass;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.BooleanType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.IntType;
import edu.rice.cs.dynamicjava.symbol.type.IntegralType;
import edu.rice.cs.dynamicjava.symbol.type.NumericType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleArrayType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.ValidType;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.EmptyIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TypeUtil;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AmbiguousName;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.AnonymousInnerAllocation;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.NullLiteral;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.SimpleFieldAccess;
import koala.dynamicjava.tree.SimpleMethodCall;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.StringLiteral;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableAccess;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionChecker {
    private final TypeContext context;
    private final TypeSystem ts;
    private final Options opt;

    public ExpressionChecker(TypeContext ctx, Options options) {
        this.context = ctx;
        this.ts = options.typeSystem();
        this.opt = options;
    }

    public Type check(Expression e) {
        return e.acceptVisitor(new ExpressionVisitor(Option.<Type>none()));
    }

    public Type check(Expression e, Type expected) {
        return e.acceptVisitor(new ExpressionVisitor(Option.some(expected)));
    }

    public Type check(Expression e, Option<Type> expected) {
        return e.acceptVisitor(new ExpressionVisitor(expected));
    }

    public Iterable<Type> checkList(Iterable<? extends Expression> l) {
        return IterUtil.mapSnapshot(l, new ExpressionVisitor(Option.<Type>none()));
    }

    public Iterable<Type> checkList(Iterable<? extends Expression> l, Type expected) {
        return IterUtil.mapSnapshot(l, new ExpressionVisitor(Option.some(expected)));
    }

    public Iterable<Type> checkList(Iterable<? extends Expression> l, Option<Type> expected) {
        return IterUtil.mapSnapshot(l, new ExpressionVisitor(expected));
    }

    private Type checkTypeName(TypeName t) {
        return new TypeNameChecker(this.context, this.opt).check(t);
    }

    private Iterable<Type> checkTypeNameList(Iterable<? extends TypeName> l) {
        return new TypeNameChecker(this.context, this.opt).checkList(l);
    }

    public void checkConstructorCall(ConstructorCall node) {
        if (node.getExpression() != null) {
            throw new ExecutionError("not.implemented", node);
        }
        List<Expression> args = node.getArguments();
        this.checkList(args);
        EmptyIterable targs = IterUtil.empty();
        Type type = node.isSuper() ? this.context.getThis().immediateSuperclass() : SymbolUtil.thisType(this.context.getThis());
        if (type == null) {
            throw new IllegalArgumentException("Can't check a ConstructorCall in this context");
        }
        try {
            TypeSystem.ConstructorInvocation inv = this.ts.lookupConstructor(type, targs, args, Option.<Type>none(), this.context.accessModule());
            DJConstructor k = inv.constructor();
            if (k.accessibility().equals((Object)Access.PRIVATE) && !k.accessModule().equals(this.context.accessModule())) {
                NodeProperties.setErrorStrings(node, this.ts.typePrinter().print(type));
                throw new ExecutionError("inaccessible.super.call", node);
            }
            this.checkThrownExceptions(inv.thrown(), node);
            node.setArguments(CollectUtil.makeList(inv.args()));
            NodeProperties.setConstructor(node, k);
            NodeProperties.setType(node, type);
        }
        catch (TypeSystem.InvalidTypeArgumentException e) {
            throw new ExecutionError("type.argument", node);
        }
        catch (TypeSystem.UnmatchedLookupException e) {
            throw this.unmatchedFunctionError("constructor", e, node, type, "", targs, args, Option.<Type>none(), false);
        }
    }

    public DJField checkEnumSwitchCase(Expression exp, Type enumT) {
        if (!(exp instanceof AmbiguousName)) {
            throw new ExecutionError("invalid.enum.constant", exp);
        }
        List<IdentifierToken> ids = ((AmbiguousName)exp).getIdentifiers();
        if (ids.size() != 1) {
            throw new ExecutionError("invalid.enum.constant", exp);
        }
        String name = ids.get(0).image();
        SimpleFieldAccess translation = new SimpleFieldAccess(name);
        NodeProperties.setTranslation(exp, translation);
        try {
            TypeSystem.StaticFieldReference ref = this.ts.lookupStaticField(enumT, name, this.context.accessModule());
            NodeProperties.setField(translation, ref.field());
            Type t = this.ts.capture(ref.type());
            if (!this.ts.isSubtype(t, enumT)) {
                throw new ExecutionError("invalid.enum.constant", exp);
            }
            this.addRuntimeCheck(translation, t, ref.field().type());
            NodeProperties.setType(translation, t);
            NodeProperties.setType(exp, t);
            if (NodeProperties.hasValue(translation)) {
                NodeProperties.setValue(exp, NodeProperties.getValue(translation));
            }
            return ref.field();
        }
        catch (TypeSystem.UnmatchedLookupException e) {
            throw new ExecutionError("invalid.enum.constant", exp);
        }
    }

    private ExecutionError unmatchedFunctionError(String kind, TypeSystem.UnmatchedLookupException e, Node node, Type type, String name, Iterable<? extends Type> targs, Iterable<? extends Expression> args, Option<Type> expected, boolean onlyStatic) {
        String candidatesS;
        String expectedS;
        final TypeSystem.TypePrinter printer = this.ts.typePrinter();
        String error = (e.matches() > 1 ? "ambiguous." : "no.such.") + kind;
        Iterable<Object> candidates = IterUtil.empty();
        boolean noMatch = false;
        if (e instanceof TypeSystem.UnmatchedFunctionLookupException) {
            candidates = ((TypeSystem.UnmatchedFunctionLookupException)e).candidates();
            if (IterUtil.isEmpty(candidates)) {
                noMatch = true;
            }
        } else if (e instanceof TypeSystem.AmbiguousFunctionLookupException) {
            candidates = ((TypeSystem.AmbiguousFunctionLookupException)e).candidates();
        }
        if (error.equals("no.such.method") && noMatch) {
            error = error + ".name";
        } else {
            if (!IterUtil.isEmpty(targs)) {
                error = error + ".poly";
            }
            if (expected.isSome()) {
                error = error + ".expected";
            }
            if (!IterUtil.isEmpty(candidates)) {
                error = error + ".candidates";
            }
        }
        String typeS = (onlyStatic ? "static " : "") + printer.print(type);
        String string = expectedS = expected.isSome() ? printer.print(expected.unwrap()) : "";
        if (IterUtil.sizeOf(candidates, 2) == 1) {
            candidatesS = printer.print((Function)IterUtil.first(candidates));
        } else {
            String prefix = "\n        ";
            Lambda<Function, String> printSig = new Lambda<Function, String>(){

                @Override
                public String value(Function f) {
                    return printer.print(f);
                }
            };
            candidatesS = IterUtil.toString(IterUtil.map(candidates, printSig), prefix, prefix, "");
        }
        NodeProperties.setErrorStrings(node, typeS, name, printer.print(targs), this.nodeTypesString(args, printer), expectedS, candidatesS);
        throw new ExecutionError(error, node);
    }

    private void checkThrownExceptions(Iterable<? extends Type> thrownTypes, Node node) {
        ComposedIterable<Type> allowed = IterUtil.compose(TypeSystem.RUNTIME_EXCEPTION, this.context.getDeclaredThrownTypes());
        for (Type type : thrownTypes) {
            if (!this.ts.isAssignable(TypeSystem.EXCEPTION, type)) continue;
            boolean valid = false;
            for (Type t : allowed) {
                if (!this.ts.isAssignable(t, type)) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            NodeProperties.setErrorStrings(node, this.ts.typePrinter().print(type));
            throw new ExecutionError("uncaught.exception", node);
        }
    }

    private void addRuntimeCheck(Node node, Type expectedType, Type declaredActualType) {
        if (!this.ts.isSubtype(this.ts.erase(declaredActualType), this.ts.erase(expectedType))) {
            NodeProperties.setCheckedType(node, this.ts.erasedClass(expectedType));
        }
    }

    private String nodeTypesString(Iterable<? extends Node> nodes, TypeSystem.TypePrinter printer) {
        return printer.print(IterUtil.map(nodes, NodeProperties.NODE_TYPE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpressionVisitor
    extends AbstractVisitor<Type>
    implements Lambda<Expression, Type> {
        private final Option<Type> expected;

        public ExpressionVisitor(Option<Type> exp) {
            this.expected = exp;
        }

        @Override
        public Type value(Expression e) {
            return e.acceptVisitor(this);
        }

        @Override
        public Type visit(AmbiguousName node) {
            Node resolved = this.resolveAmbiguousName(node);
            if (resolved instanceof ReferenceTypeName) {
                NodeProperties.setErrorStrings(node, ((ReferenceTypeName)resolved).getRepresentation());
                throw new ExecutionError("undefined.name", node);
            }
            Expression resolvedExp = (Expression)resolved;
            NodeProperties.setTranslation(node, resolvedExp);
            resolvedExp.acceptVisitor(this);
            if (NodeProperties.hasVariableType(resolvedExp)) {
                NodeProperties.setVariableType(node, NodeProperties.getVariableType(resolvedExp));
            }
            if (NodeProperties.hasValue(resolvedExp)) {
                NodeProperties.setValue(node, NodeProperties.getValue(resolvedExp));
            }
            if (NodeProperties.hasField(resolvedExp)) {
                NodeProperties.setField(node, NodeProperties.getField(resolvedExp));
            }
            if (NodeProperties.hasVariable(resolvedExp)) {
                NodeProperties.setVariable(node, NodeProperties.getVariable(resolvedExp));
            }
            return NodeProperties.setType(node, NodeProperties.getType(resolvedExp));
        }

        private Node resolveAmbiguousName(AmbiguousName node) {
            Iterator<IdentifierToken> ids = node.getIdentifiers().iterator();
            IdentifierToken first = ids.next();
            PrimaryExpression resultExp = null;
            if (ExpressionChecker.this.context.localVariableExists(first.image(), ExpressionChecker.this.ts)) {
                resultExp = new VariableAccess(first.image(), first.getSourceInfo());
            } else if (ExpressionChecker.this.context.fieldExists(first.image(), ExpressionChecker.this.ts)) {
                resultExp = new SimpleFieldAccess(first.image(), first.getSourceInfo());
            } else {
                ValidType classType;
                IdentifierToken last = first;
                String className = first.image();
                LinkedList<IdentifierToken> classIds = new LinkedList<IdentifierToken>();
                classIds.add(first);
                while (!ExpressionChecker.this.context.typeExists(className, ExpressionChecker.this.ts)) {
                    if (!ids.hasNext()) {
                        NodeProperties.setErrorStrings(node, className);
                        throw new ExecutionError("undefined.name", node);
                    }
                    last = ids.next();
                    className = className + "." + last.image();
                    classIds.add(last);
                }
                try {
                    DJClass c = ExpressionChecker.this.context.getTopLevelClass(className, ExpressionChecker.this.ts);
                    if (c != null) {
                        classType = ExpressionChecker.this.ts.makeClassType(c);
                    } else {
                        classType = ExpressionChecker.this.context.getTypeVariable(className, ExpressionChecker.this.ts);
                        if (classType == null) {
                            ClassType outer = ExpressionChecker.this.context.typeContainingMemberClass(className, ExpressionChecker.this.ts);
                            classType = ExpressionChecker.this.ts.lookupStaticClass(outer, className, IterUtil.empty(), ExpressionChecker.this.context.accessModule());
                        }
                    }
                }
                catch (AmbiguousNameException e) {
                    NodeProperties.setErrorStrings(node, className);
                    throw new ExecutionError("ambiguous.name", node);
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument.arity", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    if (e.matches() == 0) {
                        throw new ExecutionError("undefined.name.noinfo", node);
                    }
                    NodeProperties.setErrorStrings(node, className);
                    throw new ExecutionError("ambiguous.name", node);
                }
                while (ids.hasNext() && resultExp == null) {
                    IdentifierToken memberName = ids.next();
                    if (ExpressionChecker.this.ts.containsField(classType, memberName.image(), ExpressionChecker.this.context.accessModule())) {
                        ReferenceTypeName rt = new ReferenceTypeName(classIds, SourceInfo.span((SourceInfo.Wrapper)first, (SourceInfo.Wrapper)last));
                        resultExp = new StaticFieldAccess(rt, memberName.image(), SourceInfo.span((SourceInfo.Wrapper)first, (SourceInfo.Wrapper)memberName));
                        continue;
                    }
                    if (ExpressionChecker.this.ts.containsClass(classType, memberName.image(), ExpressionChecker.this.context.accessModule())) {
                        last = memberName;
                        className = className + "." + last.image();
                        classIds.add(last);
                        try {
                            ClassType memberType;
                            classType = memberType = ExpressionChecker.this.ts.lookupStaticClass(classType, memberName.image(), IterUtil.empty(), ExpressionChecker.this.context.accessModule());
                            continue;
                        }
                        catch (TypeSystem.InvalidTypeArgumentException e) {
                            throw new ExecutionError("type.argument.arity", node);
                        }
                        catch (TypeSystem.UnmatchedLookupException e) {
                            if (e.matches() == 0) {
                                throw new ExecutionError("undefined.name.noinfo", node);
                            }
                            NodeProperties.setErrorStrings(node, memberName.image());
                            throw new ExecutionError("ambiguous.name", node);
                        }
                    }
                    NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(classType), memberName.image());
                    throw new ExecutionError("no.such.member", node);
                }
                if (resultExp == null) {
                    return new ReferenceTypeName(classIds, SourceInfo.span((SourceInfo.Wrapper)first, (SourceInfo.Wrapper)last));
                }
            }
            while (ids.hasNext()) {
                IdentifierToken field = ids.next();
                resultExp = new ObjectFieldAccess(resultExp, field.image(), SourceInfo.span((SourceInfo.Wrapper)first, (SourceInfo.Wrapper)field));
            }
            return resultExp;
        }

        @Override
        public Type visit(Literal node) {
            NodeProperties.setValue(node, node.getValue());
            if (node instanceof NullLiteral) {
                return NodeProperties.setType(node, TypeSystem.NULL);
            }
            if (node instanceof StringLiteral) {
                return NodeProperties.setType(node, TypeSystem.STRING);
            }
            return NodeProperties.setType(node, SymbolUtil.typeOfPrimitiveClass(node.getType()));
        }

        private DJClass resolveThis(Option<String> outerName, Node node) {
            DJClass result;
            if (outerName.isNone()) {
                result = ExpressionChecker.this.context.getThis();
                if (result == null) {
                    throw new ExecutionError("this.undefined", node);
                }
            } else {
                result = ExpressionChecker.this.context.getThis(outerName.unwrap());
                if (result == null) {
                    NodeProperties.setErrorStrings(node, outerName.unwrap());
                    throw new ExecutionError("undefined.class", node);
                }
            }
            return result;
        }

        @Override
        public Type visit(ThisExpression node) {
            DJClass thisC = this.resolveThis(node.getClassName(), node);
            NodeProperties.setDJClass(node, thisC);
            return NodeProperties.setType(node, SymbolUtil.thisType(thisC));
        }

        @Override
        public Type visit(VariableAccess node) {
            LocalVariable v = ExpressionChecker.this.context.getLocalVariable(node.getVariableName(), ExpressionChecker.this.ts);
            NodeProperties.setVariable(node, v);
            NodeProperties.setVariableType(node, v.type());
            return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(v.type()));
        }

        @Override
        public Type visit(SimpleFieldAccess node) {
            try {
                TypeSystem.FieldReference ref;
                boolean onlyStatic;
                ClassType t = ExpressionChecker.this.context.typeContainingField(node.getFieldName(), ExpressionChecker.this.ts);
                if (t == null) {
                    NodeProperties.setErrorStrings(node, node.getFieldName());
                    throw new ExecutionError("undefined.name", node);
                }
                DJClass enclosingThis = ExpressionChecker.this.context.getThis(t, ExpressionChecker.this.ts);
                boolean bl = onlyStatic = enclosingThis == null;
                if (onlyStatic) {
                    ref = ExpressionChecker.this.ts.lookupStaticField(t, node.getFieldName(), ExpressionChecker.this.context.accessModule());
                } else {
                    Expression obj = TypeUtil.makeEmptyExpression(node);
                    NodeProperties.setType(obj, t);
                    ref = ExpressionChecker.this.ts.lookupField(obj, node.getFieldName(), ExpressionChecker.this.context.accessModule());
                }
                NodeProperties.setField(node, ref.field());
                Option<Object> val = ref.field().constantValue();
                if (val.isSome()) {
                    NodeProperties.setValue(node, val.unwrap());
                }
                NodeProperties.setVariableType(node, ref.type());
                if (!onlyStatic) {
                    NodeProperties.setDJClass(node, enclosingThis);
                }
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                ExpressionChecker.this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (AmbiguousNameException e) {
                NodeProperties.setErrorStrings(node, node.getFieldName());
                throw new ExecutionError("ambiguous.name", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                if (e.matches() == 0) {
                    throw new ExecutionError("undefined.name.noinfo", node);
                }
                NodeProperties.setErrorStrings(node, node.getFieldName());
                throw new ExecutionError("ambiguous.name", node);
            }
        }

        @Override
        public Type visit(ObjectFieldAccess node) {
            Expression receiver = node.getExpression();
            Type receiverT = ExpressionChecker.this.check(receiver);
            try {
                TypeSystem.ObjectFieldReference ref = ExpressionChecker.this.ts.lookupField(receiver, node.getFieldName(), ExpressionChecker.this.context.accessModule());
                node.setExpression(ref.object());
                NodeProperties.setField(node, ref.field());
                NodeProperties.setVariableType(node, ref.type());
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                ExpressionChecker.this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(receiverT), node.getFieldName());
                if (e.matches() > 1) {
                    throw new ExecutionError("ambiguous.field", node);
                }
                throw new ExecutionError("no.such.field", node);
            }
        }

        @Override
        public Type visit(SuperFieldAccess node) {
            DJClass c = this.resolveThis(node.getClassName(), node);
            Type t = c.immediateSuperclass();
            if (t == null) {
                throw new ExecutionError("super.undefined", node);
            }
            Expression obj = TypeUtil.makeEmptyExpression(node);
            NodeProperties.setType(obj, t);
            try {
                TypeSystem.ObjectFieldReference ref = ExpressionChecker.this.ts.lookupField(obj, node.getFieldName(), ExpressionChecker.this.context.accessModule());
                NodeProperties.setField(node, ref.field());
                NodeProperties.setDJClass(node, c);
                NodeProperties.setVariableType(node, ref.type());
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                ExpressionChecker.this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(t), node.getFieldName());
                if (e.matches() > 1) {
                    throw new ExecutionError("ambiguous.field", node);
                }
                throw new ExecutionError("no.such.field", node);
            }
        }

        @Override
        public Type visit(StaticFieldAccess node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getFieldType());
            try {
                TypeSystem.StaticFieldReference ref = ExpressionChecker.this.ts.lookupStaticField(t, node.getFieldName(), ExpressionChecker.this.context.accessModule());
                NodeProperties.setField(node, ref.field());
                Option<Object> val = ref.field().constantValue();
                if (val.isSome()) {
                    NodeProperties.setValue(node, val.unwrap());
                }
                NodeProperties.setVariableType(node, ref.type());
                Type result = ExpressionChecker.this.ts.capture(ref.type());
                ExpressionChecker.this.addRuntimeCheck(node, result, ref.field().type());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(t), node.getFieldName());
                if (e.matches() > 1) {
                    throw new ExecutionError("ambiguous.field", node);
                }
                throw new ExecutionError("no.such.static.field", node);
            }
        }

        @Override
        public Type visit(SimpleMethodCall node) {
            Type t;
            List<Expression> args = node.getArguments();
            ExpressionChecker.this.checkList(args);
            Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
            if (ExpressionChecker.this.context.localFunctionExists(node.getMethodName(), ExpressionChecker.this.ts)) {
                Iterable<LocalFunction> matches = ExpressionChecker.this.context.getLocalFunctions(node.getMethodName(), ExpressionChecker.this.ts);
                t = ExpressionChecker.this.ts.makeClassType(new FunctionWrapperClass(ExpressionChecker.this.context.accessModule(), matches));
            } else {
                t = ExpressionChecker.this.context.typeContainingMethod(node.getMethodName(), ExpressionChecker.this.ts);
                if (t == null) {
                    NodeProperties.setErrorStrings(node, node.getMethodName());
                    throw new ExecutionError("undefined.name", node);
                }
            }
            DJClass enclosingThis = ExpressionChecker.this.context.getThis(t, ExpressionChecker.this.ts);
            boolean onlyStatic = enclosingThis == null;
            try {
                TypeSystem.MethodInvocation inv;
                if (onlyStatic) {
                    inv = ExpressionChecker.this.ts.lookupStaticMethod(t, node.getMethodName(), targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                } else {
                    Expression obj = TypeUtil.makeEmptyExpression(node);
                    NodeProperties.setType(obj, t);
                    inv = ExpressionChecker.this.ts.lookupMethod(obj, node.getMethodName(), targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                }
                ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                if (!onlyStatic) {
                    NodeProperties.setDJClass(node, enclosingThis);
                }
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                ExpressionChecker.this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                throw ExpressionChecker.this.unmatchedFunctionError("method", e, node, t, node.getMethodName(), targs, args, this.expected, onlyStatic);
            }
        }

        @Override
        public Type visit(ObjectMethodCall node) {
            Expression receiver = node.getExpression();
            if (receiver instanceof AmbiguousName) {
                Node resolved = this.resolveAmbiguousName((AmbiguousName)receiver);
                if (resolved instanceof ReferenceTypeName) {
                    StaticMethodCall translation = new StaticMethodCall((ReferenceTypeName)resolved, node.getTypeArgs(), node.getMethodName(), node.getArguments(), node.getSourceInfo());
                    NodeProperties.setTranslation(node, translation);
                    ((Node)translation).acceptVisitor(this);
                    return NodeProperties.setType(node, NodeProperties.getType(translation));
                }
                receiver = (Expression)resolved;
            }
            Type receiverT = ExpressionChecker.this.check(receiver);
            List<Expression> args = node.getArguments();
            ExpressionChecker.this.checkList(args);
            Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
            try {
                TypeSystem.ObjectMethodInvocation inv = ExpressionChecker.this.ts.lookupMethod(receiver, node.getMethodName(), targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                node.setExpression(inv.object());
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                ExpressionChecker.this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                throw ExpressionChecker.this.unmatchedFunctionError("method", e, node, receiverT, node.getMethodName(), targs, args, this.expected, false);
            }
        }

        @Override
        public Type visit(SuperMethodCall node) {
            DJClass c = this.resolveThis(node.getClassName(), node);
            Type t = c.immediateSuperclass();
            if (t == null) {
                throw new ExecutionError("super.undefined", node);
            }
            List<Expression> args = node.getArguments();
            ExpressionChecker.this.checkList(args);
            Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
            Expression obj = TypeUtil.makeEmptyExpression(node);
            NodeProperties.setType(obj, t);
            try {
                TypeSystem.ObjectMethodInvocation inv = ExpressionChecker.this.ts.lookupMethod(obj, node.getMethodName(), targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                NodeProperties.setDJClass(node, c);
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                ExpressionChecker.this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                throw ExpressionChecker.this.unmatchedFunctionError("method", e, node, t, node.getMethodName(), targs, args, this.expected, false);
            }
        }

        @Override
        public Type visit(StaticMethodCall node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getMethodType());
            List<Expression> args = node.getArguments();
            ExpressionChecker.this.checkList(args);
            Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
            try {
                TypeSystem.StaticMethodInvocation inv = ExpressionChecker.this.ts.lookupStaticMethod(t, node.getMethodName(), targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setMethod(node, inv.method());
                Type result = ExpressionChecker.this.ts.capture(inv.returnType());
                DebugUtil.debug.logValue("Type of method call " + node.getMethodName(), ExpressionChecker.this.ts.wrap(result));
                ExpressionChecker.this.addRuntimeCheck(node, result, inv.method().returnType());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                throw ExpressionChecker.this.unmatchedFunctionError("method", e, node, t, node.getMethodName(), targs, args, this.expected, true);
            }
        }

        @Override
        public Type visit(ArrayAllocation node) {
            Type elementType = ExpressionChecker.this.checkTypeName(node.getElementType());
            if (!ExpressionChecker.this.ts.isReifiable(elementType)) {
                throw new ExecutionError("reifiable.type", node);
            }
            Type result = elementType;
            for (int i = 0; i < node.getDimension(); ++i) {
                result = new SimpleArrayType(result);
            }
            ExpressionChecker.this.checkList(node.getSizes(), TypeSystem.INT);
            ArrayList<Expression> newSizes = new ArrayList<Expression>(node.getSizes().size());
            for (Expression exp : node.getSizes()) {
                try {
                    Expression newExp = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(exp));
                    if (!(NodeProperties.getType(newExp) instanceof IntType)) {
                        throw new ExecutionError("array.dimension.type", node);
                    }
                    newSizes.add(newExp);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("array.dimension.type", node);
                }
            }
            node.setSizes(newSizes);
            if (node.getInitialization() != null) {
                ExpressionChecker.this.check((Expression)node.getInitialization(), result);
            }
            NodeProperties.setErasedType(node, ExpressionChecker.this.ts.erasedClass(result));
            return NodeProperties.setType(node, result);
        }

        @Override
        public Type visit(ArrayInitializer node) {
            TypeName elementTypeName = node.getElementType();
            if (elementTypeName == null) {
                throw new ExecutionError("array.initializer.type", node);
            }
            Type elementType = ExpressionChecker.this.checkTypeName(elementTypeName);
            if (this.expected.isSome() && ExpressionChecker.this.ts.isArray(this.expected.unwrap())) {
                ExpressionChecker.this.checkList(node.getCells(), ExpressionChecker.this.ts.arrayElementType(this.expected.unwrap()));
            } else {
                ExpressionChecker.this.checkList(node.getCells());
            }
            ArrayList<Expression> newCells = new ArrayList<Expression>(node.getCells().size());
            for (Expression exp : node.getCells()) {
                try {
                    newCells.add(ExpressionChecker.this.ts.assign(elementType, exp));
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    Type expT = NodeProperties.getType(exp);
                    TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                    NodeProperties.setErrorStrings(exp, printer.print(expT), printer.print(elementType));
                    throw new ExecutionError("assignment.types", exp);
                }
            }
            node.setCells(newCells);
            SimpleArrayType result = new SimpleArrayType(elementType);
            NodeProperties.setErasedType(node, ExpressionChecker.this.ts.erasedClass(result));
            return NodeProperties.setType(node, result);
        }

        @Override
        public Type visit(SimpleAllocation node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getCreationType());
            if (!ExpressionChecker.this.ts.isConcrete(t)) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(t));
                throw new ExecutionError("allocation.type", node);
            }
            Option<Type> dynamicOuter = ExpressionChecker.this.ts.dynamicallyEnclosingType(t);
            if (dynamicOuter.isSome()) {
                DJClass enclosingThis = ExpressionChecker.this.context.getThis(dynamicOuter.unwrap(), ExpressionChecker.this.ts);
                if (enclosingThis == null) {
                    TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                    NodeProperties.setErrorStrings(node, printer.print(t), printer.print(dynamicOuter.unwrap()));
                    throw new ExecutionError("inner.allocation", node);
                }
                NodeProperties.setEnclosingThis(node, enclosingThis);
            }
            List<Expression> args = node.getArguments();
            ExpressionChecker.this.checkList(args);
            Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
            try {
                TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                node.setArguments(CollectUtil.makeList(inv.args()));
                NodeProperties.setConstructor(node, inv.constructor());
                return NodeProperties.setType(node, t);
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                throw ExpressionChecker.this.unmatchedFunctionError("constructor", e, node, t, "", targs, args, this.expected, false);
            }
        }

        @Override
        public Type visit(AnonymousAllocation node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getCreationType());
            if (!ExpressionChecker.this.ts.isExtendable(t) && !ExpressionChecker.this.ts.isImplementable(t)) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(t));
                throw new ExecutionError("invalid.supertype", node);
            }
            Option<Type> dynamicOuter = ExpressionChecker.this.ts.dynamicallyEnclosingType(t);
            if (dynamicOuter.isSome()) {
                DJClass enclosingThis = ExpressionChecker.this.context.getThis(dynamicOuter.unwrap(), ExpressionChecker.this.ts);
                if (enclosingThis == null) {
                    TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                    NodeProperties.setErrorStrings(node, printer.print(t), printer.print(dynamicOuter.unwrap()));
                    throw new ExecutionError("inner.allocation", node);
                }
                NodeProperties.setEnclosingThis(node, enclosingThis);
            }
            List<Expression> args = node.getArguments();
            ExpressionChecker.this.checkList(args);
            Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
            if (!(IterUtil.isEmpty(args) && IterUtil.isEmpty(targs) && ExpressionChecker.this.ts.isImplementable(t))) {
                try {
                    TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                    ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                    node.setArguments(CollectUtil.makeList(inv.args()));
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    throw ExpressionChecker.this.unmatchedFunctionError("constructor", e, node, t, "", targs, args, this.expected, false);
                }
            }
            TreeClassLoader loader = new TreeClassLoader(ExpressionChecker.this.context.getClassLoader(), ExpressionChecker.this.opt);
            TreeClass c = new TreeClass(ExpressionChecker.this.context.makeAnonymousClassName(), null, ExpressionChecker.this.context.accessModule(), node, loader, ExpressionChecker.this.opt);
            NodeProperties.setDJClass(node, c);
            ClassChecker checker = new ClassChecker(c, loader, ExpressionChecker.this.context, ExpressionChecker.this.opt);
            checker.initializeClassSignatures(node);
            checker.checkSignatures(node);
            checker.checkBodies(node);
            NodeProperties.setConstructor(node, IterUtil.first(c.declaredConstructors()));
            return NodeProperties.setType(node, ExpressionChecker.this.ts.makeClassType(c));
        }

        @Override
        public Type visit(InnerAllocation node) {
            Type enclosing = ExpressionChecker.this.check(node.getExpression());
            Iterable classTargs = ExpressionChecker.this.checkTypeNameList(node.getClassTypeArgs().unwrap(Collections.emptyList()));
            try {
                ClassType t = ExpressionChecker.this.ts.lookupClass(node.getExpression(), node.getClassName(), (Iterable<? extends Type>)classTargs, ExpressionChecker.this.context.accessModule());
                if (t.ofClass().isStatic()) {
                    NodeProperties.setErrorStrings(node, node.getClassName(), ExpressionChecker.this.ts.typePrinter().print(NodeProperties.getType(node.getExpression())));
                    throw new ExecutionError("static.inner.allocation", node);
                }
                if (!ExpressionChecker.this.ts.isConcrete(t)) {
                    NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(t));
                    throw new ExecutionError("allocation.type", node);
                }
                List<Expression> args = node.getArguments();
                ExpressionChecker.this.checkList(args);
                Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
                try {
                    TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                    ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                    node.setArguments(CollectUtil.makeList(inv.args()));
                    NodeProperties.setConstructor(node, inv.constructor());
                    return NodeProperties.setType(node, t);
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    throw ExpressionChecker.this.unmatchedFunctionError("constructor", e, node, t, "", targs, args, this.expected, false);
                }
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(enclosing), node.getClassName());
                if (e.matches() > 1) {
                    throw new ExecutionError("ambiguous.inner.class", node);
                }
                throw new ExecutionError("no.such.inner.class", node);
            }
        }

        @Override
        public Type visit(AnonymousInnerAllocation node) {
            Type enclosing = ExpressionChecker.this.check(node.getExpression());
            Iterable classTargs = ExpressionChecker.this.checkTypeNameList(node.getClassTypeArgs().unwrap(Collections.emptyList()));
            try {
                ClassType t = ExpressionChecker.this.ts.lookupClass(node.getExpression(), node.getClassName(), (Iterable<? extends Type>)classTargs, ExpressionChecker.this.context.accessModule());
                if (t.ofClass().isStatic()) {
                    NodeProperties.setErrorStrings(node, node.getClassName(), ExpressionChecker.this.ts.typePrinter().print(NodeProperties.getType(node.getExpression())));
                    throw new ExecutionError("static.inner.allocation", node);
                }
                if (!ExpressionChecker.this.ts.isExtendable(t)) {
                    NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(t));
                    throw new ExecutionError("invalid.supertype", node);
                }
                NodeProperties.setSuperType(node, t);
                List<Expression> args = node.getArguments();
                ExpressionChecker.this.checkList(args);
                Iterable targs = ExpressionChecker.this.checkTypeNameList(node.getTypeArgs().unwrap(Collections.emptyList()));
                try {
                    TypeSystem.ConstructorInvocation inv = ExpressionChecker.this.ts.lookupConstructor(t, targs, args, this.expected, ExpressionChecker.this.context.accessModule());
                    ExpressionChecker.this.checkThrownExceptions(inv.thrown(), node);
                    node.setArguments(CollectUtil.makeList(inv.args()));
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    throw ExpressionChecker.this.unmatchedFunctionError("constructor", e, node, t, "", targs, args, this.expected, false);
                }
            }
            catch (TypeSystem.InvalidTypeArgumentException e) {
                throw new ExecutionError("type.argument", node);
            }
            catch (TypeSystem.UnmatchedLookupException e) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(enclosing), node.getClassName());
                if (e.matches() > 1) {
                    throw new ExecutionError("ambiguous.inner.class", node);
                }
                throw new ExecutionError("no.such.inner.class", node);
            }
            TreeClassLoader loader = new TreeClassLoader(ExpressionChecker.this.context.getClassLoader(), ExpressionChecker.this.opt);
            TreeClass c = new TreeClass(ExpressionChecker.this.context.makeAnonymousClassName(), null, ExpressionChecker.this.context.accessModule(), node, loader, ExpressionChecker.this.opt);
            NodeProperties.setDJClass(node, c);
            ClassChecker checker = new ClassChecker(c, loader, ExpressionChecker.this.context, ExpressionChecker.this.opt);
            checker.initializeClassSignatures(node);
            checker.checkSignatures(node);
            checker.checkBodies(node);
            NodeProperties.setConstructor(node, IterUtil.first(c.declaredConstructors()));
            return NodeProperties.setType(node, ExpressionChecker.this.ts.makeClassType(c));
        }

        @Override
        public Type visit(ConstructorCall node) {
            throw new ExecutionError("constructor.call", node);
        }

        @Override
        public Type visit(ArrayAccess node) {
            Type arrayType = ExpressionChecker.this.check(node.getExpression());
            if (!ExpressionChecker.this.ts.isArray(arrayType)) {
                NodeProperties.setErrorStrings(node, ExpressionChecker.this.ts.typePrinter().print(arrayType));
                throw new ExecutionError("array.required", node);
            }
            Type elementType = ExpressionChecker.this.ts.arrayElementType(arrayType);
            ExpressionChecker.this.check(node.getCellNumber(), TypeSystem.INT);
            try {
                Expression cell = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getCellNumber()));
                if (!(NodeProperties.getType(cell) instanceof IntType)) {
                    throw new ExecutionError("array.index.type", node);
                }
                node.setCellNumber(cell);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("array.index.type", node);
            }
            NodeProperties.setVariableType(node, elementType);
            return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(elementType));
        }

        @Override
        public Type visit(TypeExpression node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getType());
            NodeProperties.setErasedType(node.getType(), ExpressionChecker.this.ts.erasedClass(t));
            Type targ = t;
            if (ExpressionChecker.this.ts.isEqual(t, TypeSystem.VOID)) {
                targ = TypeSystem.VOID_CLASS;
            } else if (!ExpressionChecker.this.ts.isReference(t)) {
                Expression pseudoExp = TypeUtil.makeEmptyExpression(node.getType());
                NodeProperties.setType(pseudoExp, t);
                try {
                    Expression boxedPseudoExp = ExpressionChecker.this.ts.makeReference(pseudoExp);
                    targ = NodeProperties.getType(boxedPseudoExp);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("reference.type", node);
                }
            }
            return NodeProperties.setType(node, ExpressionChecker.this.ts.reflectionClassOf(targ));
        }

        @Override
        public Type visit(NotExpression node) {
            ExpressionChecker.this.check(node.getExpression(), TypeSystem.BOOLEAN);
            try {
                Expression exp = ExpressionChecker.this.ts.makePrimitive(node.getExpression());
                if (!(NodeProperties.getType(exp) instanceof BooleanType)) {
                    throw new ExecutionError("not.expression.type", node);
                }
                node.setExpression(exp);
                return NodeProperties.setType(node, NodeProperties.getType(exp));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("not.expression.type", node);
            }
        }

        @Override
        public Type visit(ComplementExpression node) {
            ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getExpression()));
                if (!(NodeProperties.getType(exp) instanceof IntegralType)) {
                    throw new ExecutionError("complement.expression.type", node);
                }
                node.setExpression(exp);
                return NodeProperties.setType(node, NodeProperties.getType(exp));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("complement.expression.type", node);
            }
        }

        @Override
        public Type visit(PlusExpression node) {
            return this.handleNumericUnaryExpression(node);
        }

        @Override
        public Type visit(MinusExpression node) {
            return this.handleNumericUnaryExpression(node);
        }

        private Type handleNumericUnaryExpression(UnaryExpression node) {
            ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getExpression()));
                node.setExpression(exp);
                Type result = NodeProperties.setType(node, NodeProperties.getType(exp));
                this.evaluateConstantExpression(node);
                return result;
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("numeric.expression.type", node);
            }
        }

        @Override
        public Type visit(AddExpression node) {
            Type leftT = ExpressionChecker.this.check(node.getLeftExpression());
            Type rightT = ExpressionChecker.this.check(node.getRightExpression());
            if (ExpressionChecker.this.ts.isSubtype(leftT, TypeSystem.STRING) || ExpressionChecker.this.ts.isSubtype(rightT, TypeSystem.STRING)) {
                try {
                    Expression left = ExpressionChecker.this.ts.makeReference(node.getLeftExpression());
                    Expression right = ExpressionChecker.this.ts.makeReference(node.getRightExpression());
                    node.setLeftExpression(left);
                    node.setRightExpression(right);
                    NodeProperties.setOperation(node, ExpressionEvaluator.CONCATENATE);
                    NodeProperties.setType(node, TypeSystem.STRING);
                    this.evaluateConstantExpression(node);
                    return TypeSystem.STRING;
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("addition.type", node);
                }
            }
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                node.setLeftExpression(promoted.first());
                node.setRightExpression(promoted.second());
                NodeProperties.setOperation(node, ExpressionEvaluator.ADD);
                Type result = NodeProperties.setType(node, NodeProperties.getType(promoted.first()));
                this.evaluateConstantExpression(node);
                return result;
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("addition.type", node);
            }
        }

        @Override
        public Type visit(AddAssignExpression node) {
            Type leftT = ExpressionChecker.this.check(node.getLeftExpression());
            Type rightT = ExpressionChecker.this.check(node.getRightExpression());
            if (ExpressionChecker.this.ts.isEqual(leftT, TypeSystem.STRING)) {
                try {
                    Expression right = ExpressionChecker.this.ts.makeReference(node.getRightExpression());
                    NodeProperties.setLeftExpression(node, node.getLeftExpression());
                    node.setRightExpression(right);
                    NodeProperties.setOperation(node, ExpressionEvaluator.CONCATENATE);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    throw new ExecutionError("addition.type", node);
                }
            }
            if (ExpressionChecker.this.ts.isSubtype(leftT, TypeSystem.STRING) || ExpressionChecker.this.ts.isSubtype(rightT, TypeSystem.STRING)) {
                throw new ExecutionError("addition.type", node);
            }
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                NodeProperties.setLeftExpression(node, promoted.first());
                node.setRightExpression(promoted.second());
                NodeProperties.setOperation(node, ExpressionEvaluator.ADD);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("addition.type", node);
            }
            if (!NodeProperties.hasVariableType(node.getLeftExpression())) {
                throw new ExecutionError("addition.type", node);
            }
            return NodeProperties.setType(node, leftT);
        }

        @Override
        public Type visit(SubtractExpression node) {
            return this.handleNumericExpression(node);
        }

        @Override
        public Type visit(MultiplyExpression node) {
            return this.handleNumericExpression(node);
        }

        @Override
        public Type visit(DivideExpression node) {
            return this.handleNumericExpression(node);
        }

        @Override
        public Type visit(RemainderExpression node) {
            return this.handleNumericExpression(node);
        }

        private Type handleNumericExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                node.setLeftExpression(promoted.first());
                node.setRightExpression(promoted.second());
                Type result = NodeProperties.setType(node, NodeProperties.getType(promoted.first()));
                this.evaluateConstantExpression(node);
                return result;
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("numeric.expression.type", node);
            }
        }

        @Override
        public Type visit(SubtractAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        @Override
        public Type visit(MultiplyAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        @Override
        public Type visit(DivideAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        @Override
        public Type visit(RemainderAssignExpression node) {
            return this.handleNumericAssignmentExpression(node);
        }

        private Type handleNumericAssignmentExpression(BinaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                if (!NodeProperties.hasVariableType(node.getLeftExpression())) {
                    throw new ExecutionError("numeric.expression.type", node);
                }
                NodeProperties.setLeftExpression(node, promoted.first());
                node.setRightExpression(promoted.second());
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("numeric.expression.type", node);
            }
        }

        @Override
        public Type visit(EqualExpression node) {
            return this.handleEqualityExpression(node, ExpressionEvaluator.OBJECT_EQUAL, ExpressionEvaluator.PRIMITIVE_EQUAL);
        }

        @Override
        public Type visit(NotEqualExpression node) {
            return this.handleEqualityExpression(node, ExpressionEvaluator.OBJECT_NOT_EQUAL, ExpressionEvaluator.PRIMITIVE_NOT_EQUAL);
        }

        private Type handleEqualityExpression(BinaryExpression node, Lambda2<Object, Object, Object> objectCase, Lambda2<Object, Object, Object> primitiveCase) {
            Type leftT = ExpressionChecker.this.check(node.getLeftExpression());
            Type rightT = ExpressionChecker.this.check(node.getRightExpression());
            if (ExpressionChecker.this.ts.isReference(leftT) && ExpressionChecker.this.ts.isReference(rightT)) {
                if (ExpressionChecker.this.ts.isDisjoint(leftT, rightT)) {
                    TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                    NodeProperties.setErrorStrings(node, printer.print(leftT), printer.print(rightT));
                    throw new ExecutionError("compare.type", node);
                }
                NodeProperties.setOperation(node, objectCase);
            } else {
                try {
                    Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                    Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                    if (NodeProperties.getType(left) instanceof BooleanType && NodeProperties.getType(right) instanceof BooleanType) {
                        node.setLeftExpression(left);
                        node.setRightExpression(right);
                    } else if (NodeProperties.getType(left) instanceof NumericType && NodeProperties.getType(right) instanceof NumericType) {
                        Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                        left = promoted.first();
                        right = promoted.second();
                        node.setLeftExpression(promoted.first());
                        node.setRightExpression(promoted.second());
                    } else {
                        TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                        NodeProperties.setErrorStrings(node, printer.print(leftT), printer.print(rightT));
                        throw new ExecutionError("compare.type", node);
                    }
                    NodeProperties.setOperation(node, primitiveCase);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                    NodeProperties.setErrorStrings(node, printer.print(leftT), printer.print(rightT));
                    throw new ExecutionError("compare.type", node);
                }
            }
            NodeProperties.setType(node, TypeSystem.BOOLEAN);
            this.evaluateConstantExpression(node);
            return TypeSystem.BOOLEAN;
        }

        @Override
        public Type visit(LessExpression node) {
            return this.handleRelationalExpression(node);
        }

        @Override
        public Type visit(LessOrEqualExpression node) {
            return this.handleRelationalExpression(node);
        }

        @Override
        public Type visit(GreaterExpression node) {
            return this.handleRelationalExpression(node);
        }

        @Override
        public Type visit(GreaterOrEqualExpression node) {
            return this.handleRelationalExpression(node);
        }

        private Type handleRelationalExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                node.setLeftExpression(promoted.first());
                node.setRightExpression(promoted.second());
                NodeProperties.setType(node, TypeSystem.BOOLEAN);
                this.evaluateConstantExpression(node);
                return TypeSystem.BOOLEAN;
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                NodeProperties.setErrorStrings(node, printer.print(NodeProperties.getType(node.getLeftExpression())), printer.print(NodeProperties.getType(node.getRightExpression())));
                throw new ExecutionError("compare.type", node);
            }
        }

        @Override
        public Type visit(BitAndExpression node) {
            return this.handleBitwiseExpression(node);
        }

        @Override
        public Type visit(BitOrExpression node) {
            return this.handleBitwiseExpression(node);
        }

        @Override
        public Type visit(ExclusiveOrExpression node) {
            return this.handleBitwiseExpression(node);
        }

        private Type handleBitwiseExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                if (!(NodeProperties.getType(left) instanceof BooleanType) || !(NodeProperties.getType(right) instanceof BooleanType)) {
                    if (NodeProperties.getType(left) instanceof IntegralType && NodeProperties.getType(right) instanceof IntegralType) {
                        Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                        left = promoted.first();
                        right = promoted.second();
                    } else {
                        throw new ExecutionError("bitwise.expression.type", node);
                    }
                }
                node.setLeftExpression(left);
                node.setRightExpression(right);
                Type result = NodeProperties.setType(node, NodeProperties.getType(left));
                this.evaluateConstantExpression(node);
                return result;
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("bitwise.expression.type", node);
            }
        }

        @Override
        public Type visit(BitAndAssignExpression node) {
            return this.handleBitwiseAssignmentExpression(node);
        }

        @Override
        public Type visit(BitOrAssignExpression node) {
            return this.handleBitwiseAssignmentExpression(node);
        }

        @Override
        public Type visit(ExclusiveOrAssignExpression node) {
            return this.handleBitwiseAssignmentExpression(node);
        }

        private Type handleBitwiseAssignmentExpression(BinaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                if (!(NodeProperties.getType(left) instanceof BooleanType) || !(NodeProperties.getType(right) instanceof BooleanType)) {
                    if (NodeProperties.getType(left) instanceof IntegralType && NodeProperties.getType(right) instanceof IntegralType) {
                        Pair<Expression, Expression> promoted = ExpressionChecker.this.ts.binaryPromote(left, right);
                        left = promoted.first();
                        right = promoted.second();
                    } else {
                        throw new ExecutionError("bitwise.expression.type", node);
                    }
                }
                if (!NodeProperties.hasVariableType(node.getLeftExpression())) {
                    throw new ExecutionError("bitwise.expression.type", node);
                }
                NodeProperties.setLeftExpression(node, left);
                node.setRightExpression(right);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("bitwise.expression.type", node);
            }
        }

        @Override
        public Type visit(ShiftLeftExpression node) {
            return this.handleShiftExpression(node);
        }

        @Override
        public Type visit(ShiftRightExpression node) {
            return this.handleShiftExpression(node);
        }

        @Override
        public Type visit(UnsignedShiftRightExpression node) {
            return this.handleShiftExpression(node);
        }

        private Type handleShiftExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression()));
                Expression right = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getRightExpression()));
                node.setLeftExpression(left);
                node.setRightExpression(right);
                if (!(NodeProperties.getType(left) instanceof IntegralType) || !(NodeProperties.getType(right) instanceof IntegralType)) {
                    throw new ExecutionError("shift.expression.type", node);
                }
                Type result = NodeProperties.setType(node, NodeProperties.getType(left));
                this.evaluateConstantExpression(node);
                return result;
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("shift.expression.type", node);
            }
        }

        @Override
        public Type visit(ShiftLeftAssignExpression node) {
            return this.handleShiftAssignmentExpression(node);
        }

        @Override
        public Type visit(ShiftRightAssignExpression node) {
            return this.handleShiftAssignmentExpression(node);
        }

        @Override
        public Type visit(UnsignedShiftRightAssignExpression node) {
            return this.handleShiftAssignmentExpression(node);
        }

        private Type handleShiftAssignmentExpression(BinaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getLeftExpression());
            ExpressionChecker.this.check(node.getRightExpression());
            try {
                Expression left = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression()));
                Expression right = ExpressionChecker.this.ts.unaryPromote(ExpressionChecker.this.ts.makePrimitive(node.getRightExpression()));
                if (!(NodeProperties.getType(left) instanceof IntegralType && NodeProperties.getType(right) instanceof IntegralType && NodeProperties.hasVariableType(node.getLeftExpression()))) {
                    throw new ExecutionError("shift.expression.type", node);
                }
                NodeProperties.setLeftExpression(node, left);
                node.setRightExpression(right);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("shift.expression.type", node);
            }
        }

        @Override
        public Type visit(AndExpression node) {
            return this.handleBooleanExpression(node);
        }

        @Override
        public Type visit(OrExpression node) {
            return this.handleBooleanExpression(node);
        }

        private Type handleBooleanExpression(BinaryExpression node) {
            ExpressionChecker.this.check(node.getLeftExpression(), TypeSystem.BOOLEAN);
            ExpressionChecker.this.check(node.getRightExpression(), TypeSystem.BOOLEAN);
            try {
                Expression left = ExpressionChecker.this.ts.makePrimitive(node.getLeftExpression());
                Expression right = ExpressionChecker.this.ts.makePrimitive(node.getRightExpression());
                if (!(NodeProperties.getType(left) instanceof BooleanType) || !(NodeProperties.getType(right) instanceof BooleanType)) {
                    throw new ExecutionError("boolean.expression.type", node);
                }
                node.setLeftExpression(left);
                node.setRightExpression(right);
                NodeProperties.setType(node, TypeSystem.BOOLEAN);
                this.evaluateConstantExpression(node);
                return TypeSystem.BOOLEAN;
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("boolean.expression.type", node);
            }
        }

        private void evaluateConstantExpression(BinaryExpression node) {
            if (NodeProperties.hasValue(node.getLeftExpression()) && NodeProperties.hasValue(node.getRightExpression())) {
                try {
                    Object val = new ExpressionEvaluator(RuntimeBindings.EMPTY, ExpressionChecker.this.opt).value(node);
                    NodeProperties.setValue(node, val);
                }
                catch (WrappedException wrappedException) {
                    // empty catch block
                }
            }
        }

        private void evaluateConstantExpression(UnaryExpression node) {
            if (NodeProperties.hasValue(node.getExpression())) {
                try {
                    Object val = new ExpressionEvaluator(RuntimeBindings.EMPTY, ExpressionChecker.this.opt).value(node);
                    NodeProperties.setValue(node, val);
                }
                catch (WrappedException wrappedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Type visit(InstanceOfExpression node) {
            Type expT = ExpressionChecker.this.check(node.getExpression());
            Type targetT = ExpressionChecker.this.checkTypeName(node.getReferenceType());
            if (!ExpressionChecker.this.ts.isReference(expT) || !ExpressionChecker.this.ts.isReference(targetT) || ExpressionChecker.this.ts.isDisjoint(targetT, expT)) {
                throw new ExecutionError("instanceof.type", node);
            }
            if (!ExpressionChecker.this.ts.isReifiable(targetT)) {
                throw new ExecutionError("reifiable.type", node);
            }
            NodeProperties.setErasedType(node.getReferenceType(), ExpressionChecker.this.ts.erasedClass(targetT));
            return NodeProperties.setType(node, TypeSystem.BOOLEAN);
        }

        @Override
        public Type visit(ConditionalExpression node) {
            ExpressionChecker.this.check(node.getConditionExpression(), TypeSystem.BOOLEAN);
            ExpressionChecker.this.check(node.getIfTrueExpression(), this.expected);
            ExpressionChecker.this.check(node.getIfFalseExpression(), this.expected);
            try {
                Expression cond = ExpressionChecker.this.ts.makePrimitive(node.getConditionExpression());
                if (!(NodeProperties.getType(cond) instanceof BooleanType)) {
                    throw new ExecutionError("condition.type", node);
                }
                node.setConditionExpression(cond);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("condition.type", node);
            }
            try {
                Pair<Expression, Expression> joined = ExpressionChecker.this.ts.mergeConditional(node.getIfTrueExpression(), node.getIfFalseExpression());
                node.setIfTrueExpression(joined.first());
                node.setIfFalseExpression(joined.second());
                return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(NodeProperties.getType(joined.first())));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("conditional.type", node);
            }
        }

        @Override
        public Type visit(SimpleAssignExpression node) {
            DJClass initializing;
            Expression left = node.getLeftExpression();
            Type result = ExpressionChecker.this.check(left);
            if (!NodeProperties.hasVariableType(left)) {
                throw new ExecutionError("left.expression", node);
            }
            if (NodeProperties.hasVariable(left) && NodeProperties.getVariable(left).isFinal()) {
                NodeProperties.setErrorStrings(node, NodeProperties.getVariable(left).declaredName());
                throw new ExecutionError("cannot.modify", node);
            }
            if (NodeProperties.hasField(left) && NodeProperties.getField(left).isFinal() && ((initializing = ExpressionChecker.this.context.initializingClass()) == null || !initializing.equals(NodeProperties.getField(left).declaringClass()))) {
                NodeProperties.setErrorStrings(node, NodeProperties.getField(left).declaredName());
                throw new ExecutionError("cannot.modify", node);
            }
            Type target = NodeProperties.getVariableType(left);
            Type rightT = ExpressionChecker.this.check(node.getRightExpression(), target);
            try {
                Expression newRight = ExpressionChecker.this.ts.assign(target, node.getRightExpression());
                node.setRightExpression(newRight);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                NodeProperties.setErrorStrings(node, printer.print(rightT), printer.print(target));
                throw new ExecutionError("assignment.types", node);
            }
        }

        @Override
        public Type visit(PostIncrement node) {
            return this.handleIncrementExpression(node);
        }

        @Override
        public Type visit(PreIncrement node) {
            return this.handleIncrementExpression(node);
        }

        @Override
        public Type visit(PostDecrement node) {
            return this.handleIncrementExpression(node);
        }

        @Override
        public Type visit(PreDecrement node) {
            return this.handleIncrementExpression(node);
        }

        private Type handleIncrementExpression(UnaryExpression node) {
            Type result = ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.makePrimitive(node.getExpression());
                if (!(NodeProperties.getType(exp) instanceof NumericType) || !NodeProperties.hasVariableType(node.getExpression())) {
                    throw new ExecutionError("increment.type", node);
                }
                NodeProperties.setLeftExpression(node, exp);
                return NodeProperties.setType(node, result);
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                throw new ExecutionError("increment.type", node);
            }
        }

        @Override
        public Type visit(CastExpression node) {
            Type t = ExpressionChecker.this.checkTypeName(node.getTargetType());
            Type fromT = ExpressionChecker.this.check(node.getExpression());
            try {
                Expression exp = ExpressionChecker.this.ts.cast(t, node.getExpression());
                node.setExpression(exp);
                return NodeProperties.setType(node, ExpressionChecker.this.ts.capture(t));
            }
            catch (TypeSystem.UnsupportedConversionException e) {
                TypeSystem.TypePrinter printer = ExpressionChecker.this.ts.typePrinter();
                NodeProperties.setErrorStrings(node, printer.print(fromT), printer.print(t));
                throw new ExecutionError("cast.types", node);
            }
        }
    }
}

