/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.ClassBodyTypeChecker;
import edu.rice.cs.javalanglevels.Command;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.InterfaceBodyTypeChecker;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.PackageData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.Triple;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Block;
import edu.rice.cs.javalanglevels.tree.BreakStatement;
import edu.rice.cs.javalanglevels.tree.CastExpression;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ClassImportStatement;
import edu.rice.cs.javalanglevels.tree.CompoundWord;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ContinueStatement;
import edu.rice.cs.javalanglevels.tree.ExpressionStatement;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFDepthFirstVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.LabeledStatement;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.PackageStatement;
import edu.rice.cs.javalanglevels.tree.PrimitiveType;
import edu.rice.cs.javalanglevels.tree.ReturnStatement;
import edu.rice.cs.javalanglevels.tree.StaticInitializer;
import edu.rice.cs.javalanglevels.tree.SwitchStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.Word;
import edu.rice.cs.javalanglevels.util.Log;
import edu.rice.cs.javalanglevels.util.Utilities;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeChecker
extends JExpressionIFDepthFirstVisitor<TypeData>
implements JExpressionIFVisitor<TypeData> {
    public static final SourceInfo NONE = SourceInfo.NONE;
    public static final NullLiteral NULL_LITERAL = new NullLiteral(NONE);
    public static final ModifiersAndVisibility _packageMav = new ModifiersAndVisibility(NONE, new String[0]);
    public static final ModifiersAndVisibility _publicMav = new ModifiersAndVisibility(NONE, new String[]{"public"});
    public static final ModifiersAndVisibility _protectedMav = new ModifiersAndVisibility(NONE, new String[]{"protected"});
    public static final ModifiersAndVisibility _privateMav = new ModifiersAndVisibility(NONE, new String[]{"private"});
    public static final ModifiersAndVisibility _abstractMav = new ModifiersAndVisibility(NONE, new String[]{"abstract"});
    public static final ModifiersAndVisibility _finalMav = new ModifiersAndVisibility(NONE, new String[]{"final"});
    public static final ModifiersAndVisibility _finalPublicMav = new ModifiersAndVisibility(NONE, new String[]{"final", "public"});
    public static final ModifiersAndVisibility _publicAbstractMav = new ModifiersAndVisibility(NONE, new String[]{"public", "abstract"});
    public static final ModifiersAndVisibility _publicStaticMav = new ModifiersAndVisibility(NONE, new String[]{"public", "static"});
    protected static final Log _log = new Log("LLConverter.txt", false);
    static LinkedList<Pair<String, JExpressionIF>> errors;
    static final Symboltable symbolTable;
    static boolean _errorAdded;
    File _file;
    String _package;
    LinkedList<String> _importedFiles;
    LinkedList<String> _importedPackages;

    public TypeChecker(File file, String packageName, LinkedList<Pair<String, JExpressionIF>> errors, Symboltable symbolTable, LinkedList<String> importedFiles, LinkedList<String> importedPackages) {
        this._file = file;
        this._package = packageName;
        TypeChecker.errors = errors;
        this._importedFiles = importedFiles;
        this._importedPackages = importedPackages;
    }

    public TypeChecker(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages) {
        this._file = file;
        this._package = packageName;
        this._importedFiles = importedFiles;
        this._importedPackages = importedPackages;
    }

    protected Data _getData() {
        throw new RuntimeException("Internal Program Error: _getData() shouldn't get called from TypeChecker.  Please report this bug.");
    }

    protected static SymbolData defineTestCaseClass() {
        SymbolData testCase = new SymbolData("junit.framework.TestCase");
        testCase.setIsContinuation(false);
        testCase.setMav(_publicMav);
        testCase.setPackage("junit.framework");
        LanguageLevelConverter.symbolTable.put("junit.framework.TestCase", testCase);
        return testCase;
    }

    public SymbolData getSymbolData(String className, Data enclosingData, JExpression jexpr) {
        return this.getSymbolData(className, enclosingData, jexpr, true);
    }

    public SymbolData getSymbolData(String className, Data enclosingData, JExpression jexpr, boolean giveException) {
        return this.getSymbolData(giveException, className, enclosingData, jexpr, giveException);
    }

    public SymbolData getSymbolData(boolean giveAmbigException, String className, Data enclosingData, JExpression jexpr, boolean giveException) {
        SymbolData result = null;
        for (Data d = enclosingData; d != null && result == null; d = d.getOuterData()) {
            result = enclosingData.getInnerClassOrInterface(className);
        }
        if (result == null) {
            result = this.getSymbolData(className, jexpr, giveException, true);
        } else if (result == SymbolData.AMBIGUOUS_REFERENCE) {
            if (giveAmbigException) {
                TypeChecker._addError("Ambiguous reference to class or interface " + className, jexpr);
                return SymbolData.AMBIGUOUS_REFERENCE;
            }
            return null;
        }
        if (result == null || !giveException) {
            return result;
        }
        if (TypeChecker.checkAccess(jexpr, result.getMav(), className, result, enclosingData.getSymbolData(), "class or interface")) {
            return result;
        }
        return result;
    }

    public SymbolData getSymbolData(String className, JExpression jexpr, boolean giveException, boolean runnableNotOkay) {
        SourceInfo si = jexpr.getSourceInfo();
        LanguageLevelVisitor llv = new LanguageLevelVisitor(this._file, this._package, null, this._importedFiles, this._importedPackages, new HashSet<String>(), new Hashtable<String, Triple<SourceInfo, LanguageLevelVisitor, SymbolData>>(), new LinkedList<Command>(), new HashMap<String, SymbolData>());
        LanguageLevelConverter._newSDs.clear();
        assert (LanguageLevelConverter.symbolTable.containsKey("java.lang.Object"));
        SymbolData sd = llv.getSymbolData(className, si, false, true);
        if (sd == null || sd.isContinuation()) {
            if (giveException) {
                TypeChecker._addError("Class or variable " + className + " not found.", jexpr);
            }
            return null;
        }
        if (this.notRightPackage(sd)) {
            TypeChecker._addError("The class " + sd.getName() + " is not in the right package. Perhaps you meant to package it?", jexpr);
        }
        if (runnableNotOkay && sd.implementsRunnable()) {
            TypeChecker._addError(sd.getName() + " implements the Runnable interface, which is not allowed at any language level", jexpr);
            return null;
        }
        return sd;
    }

    protected boolean notRightPackage(SymbolData sd) {
        if (sd.getOuterData() != null) {
            return this.notRightPackage(sd.getOuterData().getSymbolData());
        }
        return sd.getPackage().equals("") && sd.getName().lastIndexOf(46) != -1 || !sd.getName().startsWith(sd.getPackage());
    }

    public LinkedList<VariableData> cloneVariableDataList(LinkedList<VariableData> vars) {
        LinkedList<VariableData> nv = new LinkedList<VariableData>();
        for (int i = 0; i < vars.size(); ++i) {
            VariableData old = vars.get(i);
            nv.addLast(old);
        }
        return nv;
    }

    protected String getQualifiedClassName(String className) {
        if (!this._package.equals("") && !className.startsWith(this._package)) {
            return this._package + '.' + className;
        }
        return className;
    }

    private static boolean _areInSamePackage(SymbolData enclosingSD, SymbolData thisSD) {
        String enclosingSDName = enclosingSD.getName();
        int lastIndexOfDot = enclosingSDName.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            if (enclosingSD.getOuterData() != null) {
                return TypeChecker._areInSamePackage(enclosingSD.getOuterData().getSymbolData(), thisSD);
            }
            enclosingSDName = enclosingSDName.substring(0, lastIndexOfDot);
        } else {
            enclosingSDName = "";
        }
        String thisSDName = thisSD.getName();
        lastIndexOfDot = thisSDName.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            if (thisSD.getOuterData() != null) {
                return TypeChecker._areInSamePackage(enclosingSD, thisSD.getOuterData().getSymbolData());
            }
            thisSDName = thisSDName.substring(0, lastIndexOfDot);
        } else {
            thisSDName = "";
        }
        return enclosingSDName.equals(thisSDName);
    }

    protected MethodData _lookupMethodHelper(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, boolean isConstructor, SymbolData thisSD) {
        return this._lookupMethodHelper(methodName, enclosingSD, arguments, jexpr, isConstructor, thisSD, new LinkedList<MethodData>());
    }

    protected Pair<LinkedList<MethodData>, LinkedList<MethodData>> _getMatchingMethods(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, boolean isConstructor, SymbolData thisSD) {
        LinkedList<MethodData> mds = enclosingSD.getMethods();
        Iterator iter2 = mds.iterator();
        LinkedList<MethodData> matching = new LinkedList<MethodData>();
        LinkedList<MethodData> matchingWithAutoBoxing = new LinkedList<MethodData>();
        while (iter2.hasNext()) {
            int i;
            MethodData md = (MethodData)iter2.next();
            if (!md.getName().equals(methodName) || md.getParams().length != arguments.length) continue;
            VariableData[] vds = md.getParams();
            boolean matches = true;
            for (i = 0; i < vds.length && i < arguments.length; ++i) {
                boolean bl = matches = matches && this._isAssignableFromWithoutAutoboxing(vds[i].getType().getSymbolData(), arguments[i].getSymbolData());
                if (!matches) break;
            }
            if (matches && TypeChecker.checkAccess(jexpr, md.getMav(), md.getName(), enclosingSD, thisSD, "method")) {
                matching.addLast(md);
            }
            if (matches) continue;
            matches = true;
            for (i = 0; i < vds.length && i < arguments.length; ++i) {
                if (enclosingSD.getName().equals("NonEmpty")) {
                    SymbolData parmSD = vds[i].getType().getSymbolData();
                    SymbolData argSD = arguments[i].getSymbolData();
                    if (argSD.equals(SymbolData.INT_TYPE) && parmSD.equals(symbolTable.get("java.lang.Object"))) assert (TypeChecker._isAssignableFrom(parmSD, argSD));
                }
                boolean bl = matches = matches && TypeChecker._isAssignableFrom(vds[i].getType().getSymbolData(), arguments[i].getSymbolData());
                if (!matches && enclosingSD.getName().equals("NonEmpty")) break;
            }
            if (!matches || !TypeChecker.checkAccess(jexpr, md.getMav(), md.getName(), enclosingSD, thisSD, "method")) continue;
            matchingWithAutoBoxing.addLast(md);
        }
        if (!isConstructor) {
            for (SymbolData sup : enclosingSD.getInterfaces()) {
                Pair<LinkedList<MethodData>, LinkedList<MethodData>> p = this._getMatchingMethods(methodName, sup, arguments, jexpr, isConstructor, thisSD);
                matching.addAll((Collection)p.getFirst());
                matchingWithAutoBoxing.addAll((Collection)p.getSecond());
            }
            if (enclosingSD.getSuperClass() != null) {
                Pair<LinkedList<MethodData>, LinkedList<MethodData>> p = this._getMatchingMethods(methodName, enclosingSD.getSuperClass(), arguments, jexpr, isConstructor, thisSD);
                matching.addAll((Collection)p.getFirst());
                matchingWithAutoBoxing.addAll((Collection)p.getSecond());
            }
        }
        return new Pair<LinkedList<MethodData>, LinkedList<MethodData>>(matching, matchingWithAutoBoxing);
    }

    protected MethodData _lookupMethodHelper(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, boolean isConstructor, SymbolData thisSD, LinkedList<MethodData> matchingMethods) {
        Pair<LinkedList<MethodData>, LinkedList<MethodData>> p = this._getMatchingMethods(methodName, enclosingSD, arguments, jexpr, isConstructor, thisSD);
        LinkedList<MethodData> matching = p.getFirst();
        LinkedList<MethodData> matchingWithAutoBoxing = p.getSecond();
        SymbolData currData = enclosingSD;
        while (!isConstructor && matching.isEmpty() && matchingWithAutoBoxing.isEmpty() && currData.getOuterData() != null) {
            currData = currData.getOuterData().getSymbolData();
            p = this._getMatchingMethods(methodName, currData, arguments, jexpr, isConstructor, thisSD);
            matching = p.getFirst();
            matchingWithAutoBoxing = p.getSecond();
        }
        if (matching.size() == 1) {
            return matching.getFirst();
        }
        if (matching.size() > 1) {
            return TypeChecker.selectMostSpecificMethod(matching, arguments, jexpr);
        }
        if (matchingWithAutoBoxing.size() == 1) {
            return matchingWithAutoBoxing.getFirst();
        }
        if (matchingWithAutoBoxing.size() > 1) {
            return TypeChecker.selectMostSpecificMethod(matchingWithAutoBoxing, arguments, jexpr);
        }
        return null;
    }

    protected MethodData _lookupMethod(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, String errorMsg, boolean isConstructor, SymbolData thisSD) {
        MethodData md;
        if (!isConstructor && methodName.equals(LanguageLevelVisitor.getUnqualifiedClassName(enclosingSD.getName()))) {
            TypeChecker._addError("The keyword 'new' is required to invoke a constructor", jexpr);
        }
        if ((md = this._lookupMethodHelper(methodName, enclosingSD, arguments, jexpr, isConstructor, thisSD)) != null) {
            return md;
        }
        StringBuffer message = new StringBuffer(errorMsg + methodName);
        message.append("(");
        if (arguments.length > 0) {
            message.append(arguments[0].getName());
            for (int i = 1; i < arguments.length; ++i) {
                message.append(", " + arguments[i].getName());
            }
        }
        message.append(").");
        TypeChecker._addError(message.toString(), jexpr);
        return null;
    }

    private static MethodData selectMostSpecificMethod(List<MethodData> list, InstanceData[] arguments, JExpression jexpr) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<MethodData> it = list.iterator();
        MethodData best = it.next();
        MethodData ambiguous = null;
        while (it.hasNext()) {
            MethodData curr = it.next();
            Object[] bestParams = new SymbolData[best.getParams().length];
            Object[] currParams = new SymbolData[curr.getParams().length];
            boolean better1 = false;
            boolean better2 = false;
            for (int i = 0; i < bestParams.length; ++i) {
                SymbolData bp = best.getParams()[i].getType().getSymbolData();
                SymbolData cp = curr.getParams()[i].getType().getSymbolData();
                boolean fromCurrToBest = cp.isAssignableTo(bp, LanguageLevelConverter.OPT.javaVersion());
                boolean fromBestToCurr = bp.isAssignableTo(cp, LanguageLevelConverter.OPT.javaVersion());
                bestParams[i] = bp;
                currParams[i] = cp;
                if (fromBestToCurr && !fromCurrToBest) {
                    better1 = true;
                }
                if (!fromCurrToBest || fromBestToCurr) continue;
                better2 = true;
            }
            if (better1 == better2) {
                if (Arrays.equals(bestParams, currParams)) {
                    SymbolData c1 = best.getSymbolData();
                    SymbolData c2 = curr.getSymbolData();
                    boolean c1IsSuperOrSame = c2.isAssignableTo(c1, LanguageLevelConverter.OPT.javaVersion());
                    boolean c2IsSuperOrSame = c1.isAssignableTo(c2, LanguageLevelConverter.OPT.javaVersion());
                    if (c1IsSuperOrSame && !c2IsSuperOrSame) {
                        best = curr;
                        continue;
                    }
                    if (c2IsSuperOrSame && !c1IsSuperOrSame) continue;
                }
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            StringBuffer invokeArgs = new StringBuffer("(");
            StringBuffer ambigArgs = new StringBuffer("(");
            StringBuffer bestArgs = new StringBuffer("(");
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    invokeArgs.append(", ");
                    ambigArgs.append(", ");
                    bestArgs.append(", ");
                }
                invokeArgs.append(arguments[i].getSymbolData().getName());
                ambigArgs.append(ambiguous.getParams()[i].getType().getSymbolData().getName());
                bestArgs.append(best.getParams()[i].getType().getSymbolData().getName());
            }
            invokeArgs.append(")");
            ambigArgs.append(")");
            bestArgs.append(")");
            TypeChecker._addError(best.getName() + invokeArgs.toString() + " is an ambiguous invocation.  It matches both " + best.getName() + bestArgs.toString() + " and " + ambiguous.getName() + ambigArgs.toString(), jexpr);
        }
        return best;
    }

    public static boolean checkAccess(JExpression piece, ModifiersAndVisibility mav, String name, SymbolData enclosingSD, SymbolData thisSD, String dataType) {
        return TypeChecker.checkAccess(piece, mav, name, enclosingSD, thisSD, dataType, true);
    }

    public static boolean checkAccess(ModifiersAndVisibility mav, SymbolData enclosingSD, SymbolData thisSD) {
        return TypeChecker.checkAccess(NULL_LITERAL, mav, "", enclosingSD, thisSD, "", false);
    }

    public static boolean checkAccess(JExpression piece, ModifiersAndVisibility mav, String name, SymbolData enclosingSD, SymbolData thisSD, String dataType, boolean addError) {
        if (thisSD.isOuterData(enclosingSD) || enclosingSD.isOuterData(thisSD) || thisSD.equals(enclosingSD)) {
            return true;
        }
        if (Utilities.isPublic(mav)) {
            Data enclosingOuter = enclosingSD.getOuterData();
            if (enclosingOuter == null) {
                return true;
            }
            if (enclosingOuter instanceof SymbolData) {
                return TypeChecker.checkAccess(piece, mav, name, enclosingSD.getOuterData().getSymbolData(), thisSD, dataType, addError);
            }
            throw new RuntimeException("Internal Program Error: Trying to reference " + name + "which is a member of something other than a class from outside of that thing.  " + "Please report this bug.");
        }
        if (Utilities.isPrivate(mav)) {
            String enclosingWithDots;
            String nameWithDots = Data.dollarSignsToDots(name);
            if (nameWithDots.equals(enclosingWithDots = Data.dollarSignsToDots(enclosingSD.getName())) && enclosingSD.isPrimitiveType()) {
                return true;
            }
            String siteName = Data.dollarSignsToDots(thisSD.getName());
            if (addError) {
                TypeChecker._addError("The " + dataType + " " + nameWithDots + " in " + enclosingWithDots + " is private and cannot be accessed from " + siteName, piece);
            }
            return false;
        }
        if (Utilities.isProtected(mav)) {
            if (TypeChecker._areInSamePackage(enclosingSD, thisSD)) {
                return true;
            }
            if (thisSD.isSubClassOf(enclosingSD)) {
                return true;
            }
            if (addError) {
                TypeChecker._addError("The " + dataType + " " + Data.dollarSignsToDots(name) + " is protected and cannot be accessed from " + Data.dollarSignsToDots(thisSD.getName()), piece);
            }
            return false;
        }
        if (TypeChecker._areInSamePackage(enclosingSD, thisSD)) {
            return true;
        }
        if (addError) {
            TypeChecker._addError("The " + dataType + " " + Data.dollarSignsToDots(name) + " is package protected because there is no access specifier and cannot be accessed from " + Data.dollarSignsToDots(thisSD.getName()), piece);
        }
        return false;
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece) {
        if (data == null) {
            return null;
        }
        return TypeChecker.getFieldOrVariable(text, data, thisSD, piece, data.getVars(), true, true);
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece, LinkedList<VariableData> vars) {
        return TypeChecker.getFieldOrVariable(text, data, thisSD, piece, vars, false, true);
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece, LinkedList<VariableData> vars, boolean shouldRecur) {
        return TypeChecker.getFieldOrVariable(text, data, thisSD, piece, vars, shouldRecur, true);
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece, LinkedList<VariableData> vars, boolean shouldRecur, boolean addError) {
        VariableData vd2 = null;
        if (data == null) {
            return null;
        }
        for (VariableData vd2 : vars) {
            if (vd2 == null || !vd2.getName().equals(text)) continue;
            if (vd2.getEnclosingData() instanceof MethodData && addError && thisSD.isOuterData(vd2.getEnclosingData()) && !vd2.isFinal() && addError) {
                TypeChecker._addError("Local variable " + vd2.getName() + " is accessed from within an inner class; must be declared final", piece);
            }
            if (addError) {
                TypeChecker.checkAccess(piece, vd2.getMav(), vd2.getName(), vd2.getEnclosingData().getSymbolData(), thisSD, "field or variable");
            }
            return vd2;
        }
        if (shouldRecur) {
            for (Data outerData : data.getEnclosingData()) {
                if (outerData == null) {
                    return null;
                }
                vd2 = TypeChecker.getFieldOrVariable(text, outerData, thisSD, piece, outerData.getVars(), true, addError);
                if (vd2 == null) continue;
                return vd2;
            }
        }
        return null;
    }

    public boolean assertInstanceType(TypeData type, String errorMsg, JExpression expression) {
        if (!type.isInstanceType()) {
            TypeChecker._addError(errorMsg + ".  Perhaps you meant to create a new instance of " + type.getName(), expression);
            return false;
        }
        return true;
    }

    public boolean assertFound(TypeData type, JExpressionIF expression) {
        if (type instanceof PackageData) {
            TypeChecker._addError("Could not resolve symbol " + type.getName(), expression);
            return false;
        }
        return true;
    }

    protected static void _addError(String message, JExpressionIF that) {
        _errorAdded = true;
        Pair<String, JExpressionIF> p = new Pair<String, JExpressionIF>(message, that);
        if (!errors.contains(p)) {
            errors.addLast(p);
        }
    }

    protected TypeData[] makeArrayOfRetType(int len) {
        return new TypeData[len];
    }

    @Override
    protected TypeData defaultCase(JExpressionIF that) {
        return null;
    }

    public TypeData forClassDefOnly(ClassDef that, TypeData mavRes, TypeData nameRes, TypeData[] typeParametersRes, TypeData superRes, TypeData[] interfacesRes, TypeData bodyRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forInnerClassDefOnly(InnerClassDef that, TypeData mavRes, TypeData nameRes, TypeData[] typeParamRes, TypeData superClassRes, TypeData[] interfacesRes, TypeData bodyRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forInterfaceDefOnly(InterfaceDef that, TypeData mavRes, TypeData nameRes, TypeData[] typeParamRes, TypeData[] superinterfacesRes, TypeData bodyRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forInnerInterfaceDefOnly(InnerInterfaceDef that, TypeData mavRes, TypeData nameRes, TypeData[] typeParamRes, TypeData[] superinterfacesRes, TypeData bodyRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forInstanceInitializerOnly(InstanceInitializer that, TypeData codeRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forStaticInitializerOnly(StaticInitializer that, TypeData codeRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forLabeledStatementOnly(LabeledStatement that, TypeData statementRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forBlockOnly(Block that, TypeData[] statementsRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forExpressionStatementOnly(ExpressionStatement that, TypeData exprRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forSwitchStatementOnly(SwitchStatement that, TypeData testRes, TypeData[] casesRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forBreakStatementOnly(BreakStatement that) {
        return SymbolData.NOT_FOUND;
    }

    @Override
    public TypeData forContinueStatementOnly(ContinueStatement that) {
        return SymbolData.NOT_FOUND;
    }

    @Override
    public TypeData forReturnStatementOnly(ReturnStatement that) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forTryCatchStatementOnly(TryCatchStatement that, TypeData tryBlockRes, TypeData[] catchBlocksRes) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forMethodDefOnly(MethodDef that, TypeData mavRes, TypeData[] typeParamsRes, TypeData resRes, TypeData nameRes, TypeData paramsRes, TypeData[] throwsRes) {
        return resRes;
    }

    public TypeData forConcreteMethodDefOnly(ConcreteMethodDef that, TypeData mavRes, TypeData[] typeParamsRes, TypeData resRes, TypeData nameRes, TypeData paramsRes, TypeData[] throwsRes, TypeData bodyRes) {
        return this.forMethodDefOnly((MethodDef)that, mavRes, typeParamsRes, resRes, nameRes, paramsRes, throwsRes);
    }

    protected SymbolData getCommonSuperTypeBaseCase(SymbolData sdLeft, SymbolData sdRight) {
        if (sdLeft == SymbolData.EXCEPTION) {
            return sdRight;
        }
        if (sdRight == SymbolData.EXCEPTION) {
            return sdLeft;
        }
        if (TypeChecker._isAssignableFrom(sdLeft, sdRight)) {
            return sdLeft;
        }
        if (TypeChecker._isAssignableFrom(sdRight, sdLeft)) {
            return sdRight;
        }
        return null;
    }

    protected static boolean _isAssignableFrom(SymbolData sdLeft, SymbolData sdRight) {
        if (sdRight == null) {
            return false;
        }
        assert (LanguageLevelConverter.versionSupportsAutoboxing(LanguageLevelConverter.OPT.javaVersion()));
        return sdRight.isAssignableTo(sdLeft, LanguageLevelConverter.OPT.javaVersion());
    }

    protected boolean _isAssignableFromWithoutAutoboxing(SymbolData sdLeft, SymbolData sdRight) {
        if (sdRight == null) {
            return false;
        }
        return sdRight.isAssignableTo(sdLeft, JavaVersion.JAVA_1_4);
    }

    protected void _checkAbstractMethods(SymbolData sd, JExpression classDef) {
        if (sd.hasModifier("abstract") || sd.isInterface()) {
            return;
        }
        LinkedList<MethodData> mds = sd.getMethods();
        LinkedList<MethodData> cmds = this._cloneMethodDataList(mds);
        for (SymbolData superD = sd.getSuperClass(); superD != null && !superD.getName().equals("java.lang.Object"); superD = superD.getSuperClass()) {
            LinkedList<MethodData> smds = superD.getMethods();
            for (MethodData md : smds) {
                if (md.hasModifier("abstract")) continue;
                cmds.addLast(md);
            }
        }
        this._checkAbstractMethodsHelper(sd, sd.getSuperClass(), cmds, classDef);
        for (SymbolData iSD : sd.getInterfaces()) {
            this._checkAbstractMethodsHelper(sd, iSD, cmds, classDef);
        }
    }

    private void _checkAbstractMethodsHelper(SymbolData origSd, SymbolData sd, LinkedList<MethodData> concreteMds, JExpression classDef) {
        if (sd == null || !sd.hasModifier("abstract") && !sd.isInterface()) {
            return;
        }
        LinkedList<MethodData> mds = sd.getMethods();
        for (MethodData md : mds) {
            if (md.hasModifier("abstract")) {
                int i;
                MethodData matchingMd = SymbolData.repeatedSignature(concreteMds, md);
                if (matchingMd != null) continue;
                StringBuffer message = classDef instanceof AnonymousClassInstantiation ? new StringBuffer("This anonymous inner class must override the abstract method: " + md.getName()) : new StringBuffer(origSd.getName() + " must be declared abstract or must override the abstract method: " + md.getName());
                VariableData[] params = md.getParams();
                InstanceData[] arguments = new InstanceData[params.length];
                for (i = 0; i < params.length; ++i) {
                    arguments[i] = params[i].getType().getInstanceData();
                }
                message.append("(");
                if (arguments.length > 0) {
                    message.append(arguments[0].getName());
                    for (i = 1; i < arguments.length; ++i) {
                        message.append(", " + arguments[i].getName());
                    }
                }
                message.append(") in " + sd.getName());
                TypeChecker._addError(message.toString(), classDef);
                continue;
            }
            concreteMds.addLast(md);
        }
        this._checkAbstractMethodsHelper(origSd, sd.getSuperClass(), this._cloneMethodDataList(concreteMds), classDef);
        for (SymbolData iSD : sd.getInterfaces()) {
            this._checkAbstractMethodsHelper(origSd, iSD, this._cloneMethodDataList(concreteMds), classDef);
        }
    }

    private LinkedList<MethodData> _cloneMethodDataList(LinkedList<MethodData> mds) {
        LinkedList<MethodData> toReturn = new LinkedList<MethodData>();
        for (int i = 0; i < mds.size(); ++i) {
            toReturn.addLast(mds.get(i));
        }
        return toReturn;
    }

    private LinkedList<SymbolData> cloneSDList(LinkedList<SymbolData> l) {
        LinkedList<SymbolData> l2 = new LinkedList<SymbolData>();
        for (int i = 0; i < l.size(); ++i) {
            l2.addLast(l.get(i));
        }
        return l2;
    }

    protected boolean checkForCyclicInheritance(SymbolData sd, LinkedList<SymbolData> hierarchy, TypeDefBase tdb) {
        if (sd == null || LanguageLevelVisitor.isJavaLibraryClass(sd.getName())) {
            return false;
        }
        if (hierarchy.contains(sd)) {
            TypeChecker._addError("Cyclic inheritance involving " + sd.getName(), tdb);
            return true;
        }
        hierarchy.addLast(sd);
        LinkedList<SymbolData> innerClasses = sd.getInnerClasses();
        for (int i = 0; i < innerClasses.size(); ++i) {
            hierarchy.addLast(innerClasses.get(i));
        }
        LinkedList<SymbolData> clonedHierarchy = this.cloneSDList(hierarchy);
        boolean doReturn = this.checkForCyclicInheritance(sd.getSuperClass(), clonedHierarchy, tdb);
        for (SymbolData iSD : sd.getInterfaces()) {
            doReturn |= this.checkForCyclicInheritance(iSD, clonedHierarchy, tdb);
        }
        return doReturn;
    }

    @Override
    public TypeData forClassDef(ClassDef that) {
        SymbolData superClass;
        SymbolData objectSD = this.getSymbolData("java.lang.Object", that, true, false);
        assert (SymbolData.INT_TYPE.isAssignableTo(objectSD, LanguageLevelConverter.OPT.javaVersion()));
        String className = this.getQualifiedClassName(that.getName().getText());
        SymbolData sd = this.getSymbolData(className, that, true, false);
        if (sd == null) {
            TypeChecker._addError("The class " + className + " was never defined", that);
            _log.log("*********DISASTER****  sd is null for ClassDef " + className);
            return null;
        }
        if (this.checkForCyclicInheritance(sd, new LinkedList<SymbolData>(), that)) {
            return null;
        }
        if (sd.hasModifier("public")) {
            String fileName = className.replace('.', System.getProperty("file.separator").charAt(0));
            if (!(this._file.getAbsolutePath().endsWith(fileName + ".dj") || this._file.getAbsolutePath().endsWith(fileName + ".dj0") || this._file.getAbsolutePath().endsWith(fileName + ".dj1") || this._file.getAbsolutePath().endsWith(fileName + ".dj2"))) {
                TypeChecker._addError(className + " is public thus must be defined in a file with the same name.", that.getName());
            }
        }
        sd.setAnonymousInnerClassNum(0);
        if (sd.hasInterface(this.getSymbolData("java.lang.Runnable", that, false, false))) {
            TypeChecker._addError(sd.getName() + " implements the Runnable interface, which is not allowed at any language level", that);
        }
        if ((superClass = sd.getSuperClass()) != null) {
            TypeChecker.checkAccess(that.getSuperclass(), superClass.getMav(), superClass.getName(), superClass, sd, "class");
            if (superClass.isInterface()) {
                TypeChecker._addError(superClass.getName() + " is an interface and thus cannot appear after the keyword 'extends' here.  " + "Perhaps you meant to say 'implements'?", that);
            }
        }
        if (superClass != null && superClass.hasModifier("final")) {
            TypeChecker._addError("Class " + sd.getName() + " cannot extend the final class " + superClass.getName(), that);
            return sd;
        }
        TypeData mavRes = that.getMav().visit(this);
        TypeData nameRes = that.getName().visit(this);
        TypeData[] typeParamRes = this.makeArrayOfRetType(that.getTypeParameters().length);
        for (int i = 0; i < that.getTypeParameters().length; ++i) {
            typeParamRes[i] = that.getTypeParameters()[i].visit(this);
        }
        TypeData superClassRes = that.getSuperclass().visit(this);
        TypeData[] interfacesRes = new SymbolData[that.getInterfaces().length];
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            interfacesRes[i] = this.getSymbolData(that.getInterfaces()[i].getName(), that.getInterfaces()[i], true, true);
            if (interfacesRes[i] != null) {
                TypeChecker.checkAccess(that.getInterfaces()[i], interfacesRes[i].getMav(), interfacesRes[i].getName(), interfacesRes[i], sd, "interface");
                if (interfacesRes[i].isInterface()) continue;
                TypeChecker._addError(interfacesRes[i].getName() + " is not an interface and thus cannot appear after the keyword 'implements' here.  " + "Perhaps you meant to say 'extends'?", that);
                continue;
            }
            throw new RuntimeException("Internal Program Error: getSymbolData( " + that.getInterfaces()[i].getName() + ") returned null.  Please report this bug.");
        }
        SymbolData testSd = this.getSymbolData("junit.framework.TestCase", NULL_LITERAL, false, true);
        if (testSd != null && sd.isSubClassOf(testSd)) {
            if (!sd.hasModifier("public")) {
                TypeChecker._addError(sd.getName() + " extends TestCase and thus must be explicitly declared public", that);
            }
            boolean foundOne = false;
            for (int i = 0; i < sd.getMethods().size(); ++i) {
                MethodData myMd = sd.getMethods().get(i);
                if (!myMd.getName().startsWith("test") || myMd.getReturnType() != SymbolData.VOID_TYPE || !myMd.hasModifier("public")) continue;
                foundOne = true;
                break;
            }
            if (!foundOne) {
                TypeChecker._addError("Class " + sd.getName() + " does not have any valid test methods.  " + "Test methods must be declared public, must return void, and must start with the word \"test\"", that);
            }
        }
        ClassBodyTypeChecker cbtc = new ClassBodyTypeChecker(sd, this._file, this._package, this._importedFiles, this._importedPackages, new LinkedList<VariableData>(), new LinkedList<Pair<SymbolData, JExpression>>());
        TypeData bodyRes = that.getBody().visit(cbtc);
        this._checkAbstractMethods(sd, that);
        if (!cbtc.hasConstructor) {
            LinkedList<VariableData> sdVars = sd.getVars();
            for (int i = 0; i < sdVars.size(); ++i) {
                if (sdVars.get(i).hasValue()) continue;
                TypeChecker._addError("The final field " + sdVars.get(i).getName() + " has not been initialized", that);
                return null;
            }
        }
        this.unassignVariableDatas(cbtc.thingsThatHaveBeenAssigned);
        return this.forClassDefOnly(that, mavRes, nameRes, typeParamRes, superClassRes, interfacesRes, bodyRes);
    }

    @Override
    public TypeData forInterfaceDef(InterfaceDef that) {
        String interfaceName = this.getQualifiedClassName(that.getName().getText());
        SymbolData sd = this.getSymbolData(interfaceName, that, true, false);
        if (sd.hasModifier("public")) {
            String fileName = interfaceName.replace('.', System.getProperty("file.separator").charAt(0));
            if (!(this._file.getAbsolutePath().endsWith(fileName + ".dj") || this._file.getAbsolutePath().endsWith(fileName + ".dj0") || this._file.getAbsolutePath().endsWith(fileName + ".dj1") || this._file.getAbsolutePath().endsWith(fileName + ".dj2"))) {
                TypeChecker._addError(interfaceName + " is public thus must be defined in a file with the same name.", that.getName());
            }
        }
        if (this.checkForCyclicInheritance(sd, new LinkedList<SymbolData>(), that)) {
            return null;
        }
        TypeData mavRes = that.getMav().visit(this);
        TypeData nameRes = that.getName().visit(this);
        TypeData[] typeParamRes = this.makeArrayOfRetType(that.getTypeParameters().length);
        for (int i = 0; i < that.getTypeParameters().length; ++i) {
            typeParamRes[i] = that.getTypeParameters()[i].visit(this);
        }
        TypeData[] interfacesRes = new SymbolData[that.getInterfaces().length];
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            interfacesRes[i] = this.getSymbolData(that.getInterfaces()[i].getName(), that.getInterfaces()[i], true, true);
            if (interfacesRes[i] != null) {
                TypeChecker.checkAccess(that.getInterfaces()[i], interfacesRes[i].getMav(), interfacesRes[i].getName(), (SymbolData)interfacesRes[i], sd, "interface");
                if (((SymbolData)interfacesRes[i]).isInterface()) continue;
                TypeChecker._addError(interfacesRes[i].getName() + " is not an interface and thus cannot appear after the keyword 'extends' here", that);
                continue;
            }
            throw new RuntimeException("Internal Program Error: getSymbolData( " + that.getInterfaces()[i].getName() + ") returned null.  Please report this bug.");
        }
        InterfaceBodyTypeChecker ibtc = new InterfaceBodyTypeChecker(sd, this._file, this._package, this._importedFiles, this._importedPackages, new LinkedList<VariableData>(), new LinkedList<Pair<SymbolData, JExpression>>());
        TypeData bodyRes = that.getBody().visit(ibtc);
        return this.forInterfaceDefOnly(that, mavRes, nameRes, typeParamRes, interfacesRes, bodyRes);
    }

    @Override
    public TypeData forClassImportStatement(ClassImportStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        StringBuffer name = new StringBuffer(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            name.append('.' + words[i].getText());
        }
        SymbolData cWordRes = this.getSymbolData(name.toString(), that, true, true);
        if (cWordRes != null && !cWordRes.hasModifier("public")) {
            TypeChecker._addError(cWordRes.getName() + " is not public, and thus cannot be seen here", that);
        }
        return this.forClassImportStatementOnly(that, cWordRes);
    }

    @Override
    public TypeData forPackageStatement(PackageStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        StringBuffer nameBuff = new StringBuffer(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            nameBuff.append('.' + words[i].getText());
        }
        String name = nameBuff.toString();
        if (symbolTable.get(name) != null) {
            TypeChecker._addError(name + " is not a allowable package name, because it conflicts with a class you have already defined", that);
        }
        return null;
    }

    @Override
    public TypeData forPrimitiveType(PrimitiveType that) {
        String text = that.getName();
        if (text.equals("boolean")) {
            return SymbolData.BOOLEAN_TYPE;
        }
        if (text.equals("char")) {
            return SymbolData.CHAR_TYPE;
        }
        if (text.equals("byte")) {
            return SymbolData.BYTE_TYPE;
        }
        if (text.equals("short")) {
            return SymbolData.SHORT_TYPE;
        }
        if (text.equals("int")) {
            return SymbolData.INT_TYPE;
        }
        if (text.equals("long")) {
            return SymbolData.LONG_TYPE;
        }
        if (text.equals("float")) {
            return SymbolData.FLOAT_TYPE;
        }
        if (text.equals("double")) {
            return SymbolData.DOUBLE_TYPE;
        }
        throw new RuntimeException("Internal Program Error: Not a legal primitive type: " + text + ".  Please report this bug");
    }

    @Override
    public TypeData forCastExpression(CastExpression that) {
        TypeData typeRes = that.getType().visit(this);
        TypeData valueRes = that.getValue().visit(this);
        if (valueRes == null) {
            return typeRes;
        }
        return this.forCastExpressionOnly(that, typeRes, valueRes);
    }

    void unassignVariableDatas(LinkedList<VariableData> toUnassign) {
        for (int i = 0; i < toUnassign.size(); ++i) {
            toUnassign.get(i).lostValue();
        }
    }

    static /* synthetic */ boolean access$000(SymbolData x0, SymbolData x1) {
        return TypeChecker._areInSamePackage(x0, x1);
    }

    static /* synthetic */ void access$100(TypeChecker x0, SymbolData x1, SymbolData x2, LinkedList x3, JExpression x4) {
        x0._checkAbstractMethodsHelper(x1, x2, x3, x4);
    }

    static {
        symbolTable = LanguageLevelConverter.symbolTable;
    }
}

