/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.collect.AbstractRelation;
import edu.rice.cs.plt.collect.FunctionalRelation;
import edu.rice.cs.plt.collect.InjectiveRelation;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.MappedIterator;
import edu.rice.cs.plt.iter.MutableSingletonIterator;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectiveRelation<T1, T2>
extends AbstractRelation<T1, T2>
implements InjectiveRelation<T1, T2> {
    @Override
    public abstract boolean isStatic();

    @Override
    public abstract LambdaMap<T2, T1> injectionMap();

    @Override
    public abstract PredicateSet<T1> firstSet();

    @Override
    public abstract PredicateSet<T2> matchFirst(T1 var1);

    @Override
    public boolean isEmpty() {
        return this.injectionMap().isEmpty();
    }

    @Override
    public int size() {
        return this.injectionMap().size();
    }

    @Override
    public int size(int bound) {
        return this.injectionMap().keySet().size(bound);
    }

    @Override
    public boolean isInfinite() {
        return this.injectionMap().keySet().isInfinite();
    }

    @Override
    public boolean hasFixedSize() {
        return this.injectionMap().keySet().hasFixedSize();
    }

    @Override
    public boolean contains(T1 first, T2 second) {
        LambdaMap<T2, T1> map = this.injectionMap();
        return map.containsKey(second) && ObjectUtil.equal(map.get(second), first);
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof Pair) {
            Pair p = (Pair)obj;
            LambdaMap<T2, T1> map = this.injectionMap();
            return map.containsKey(p.second()) && ObjectUtil.equal(map.get(p.second()), p.first());
        }
        return false;
    }

    @Override
    public Iterator<Pair<T1, T2>> iterator() {
        return MappedIterator.make(this.injectionMap().entrySet().iterator(), new Lambda<Map.Entry<T2, T1>, Pair<T1, T2>>(){

            @Override
            public Pair<T1, T2> value(Map.Entry<T2, T1> entry) {
                return new Pair(entry.getValue(), entry.getKey());
            }
        });
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return this.injectionMap().keySet();
    }

    @Override
    public boolean containsSecond(T2 second) {
        return this.injectionMap().containsKey(second);
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 second) {
        return new MatchSecondSet(second);
    }

    @Override
    public T1 antecedent(T2 second) {
        return (T1)this.injectionMap().get(second);
    }

    @Override
    public FunctionalRelation<T2, T1> inverse() {
        return new InverseInjectiveRelation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InverseInjectiveRelation
    extends AbstractRelation.InverseRelation
    implements FunctionalRelation<T2, T1> {
        protected InverseInjectiveRelation() {
            super(AbstractInjectiveRelation.this);
        }

        @Override
        public T1 value(T2 first) {
            return AbstractInjectiveRelation.this.antecedent(first);
        }

        @Override
        public LambdaMap<T2, T1> functionMap() {
            return AbstractInjectiveRelation.this.injectionMap();
        }

        @Override
        public Relation<T1, T2> inverse() {
            return AbstractInjectiveRelation.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MatchSecondSet
    extends AbstractPredicateSet<T1>
    implements Serializable {
        private final T2 _key;

        public MatchSecondSet(T2 second) {
            this._key = second;
        }

        @Override
        public boolean isEmpty() {
            return !AbstractInjectiveRelation.this.injectionMap().containsKey(this._key);
        }

        @Override
        public int size() {
            return AbstractInjectiveRelation.this.injectionMap().containsKey(this._key) ? 1 : 0;
        }

        @Override
        public int size(int bound) {
            return bound == 0 ? 0 : this.size();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean hasFixedSize() {
            return AbstractInjectiveRelation.this.isStatic();
        }

        @Override
        public boolean isStatic() {
            return AbstractInjectiveRelation.this.isStatic();
        }

        @Override
        public boolean contains(Object val) {
            return AbstractInjectiveRelation.this.contains(Pair.make(val, this._key));
        }

        @Override
        public Iterator<T1> iterator() {
            final LambdaMap map = AbstractInjectiveRelation.this.injectionMap();
            if (map.containsKey(this._key)) {
                return new MutableSingletonIterator(map.get(this._key), new Runnable1<T1>(){

                    @Override
                    public void run(T1 val) {
                        map.remove(MatchSecondSet.this._key);
                    }
                });
            }
            return EmptyIterator.make();
        }

        @Override
        public boolean add(T1 val) {
            boolean result;
            boolean bl = result = !AbstractInjectiveRelation.this.contains(val, this._key);
            if (result) {
                AbstractInjectiveRelation.this.injectionMap().put(this._key, val);
            }
            return result;
        }

        @Override
        public boolean remove(Object val) {
            boolean result = AbstractInjectiveRelation.this.contains(Pair.make(val, this._key));
            if (result) {
                AbstractInjectiveRelation.this.injectionMap().remove(this._key);
            }
            return result;
        }

        @Override
        public void clear() {
            AbstractInjectiveRelation.this.injectionMap().remove(this._key);
        }
    }
}

