/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.collect.TotalMap;
import edu.rice.cs.plt.concurrent.LockMap;
import edu.rice.cs.plt.debug.Indenter;
import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.debug.TextLogSink;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndentedTextLogSink
extends TextLogSink {
    private static final String HANGING_INDENT = "    ";
    private static final Lambda<Long, Indenter> MAKE_INDENTER = new Lambda<Long, Indenter>(){

        @Override
        public Indenter value(Long l) {
            return new Indenter();
        }
    };
    private final TotalMap<Long, Indenter> _indenters = new TotalMap<Long, Indenter>(MAKE_INDENTER, true);
    private final LockMap<BufferedWriter> _locks = new LockMap(5);
    private final WeakHashMap<BufferedWriter, Long> _lastThreads = new WeakHashMap(5);

    protected IndentedTextLogSink() {
    }

    protected IndentedTextLogSink(int idealLineWidth) {
        super(idealLineWidth);
    }

    protected abstract BufferedWriter writer(LogSink.Message var1);

    @Override
    protected void write(LogSink.Message m, SizedIterable<String> text) {
        BufferedWriter w = this.writer(m);
        this.doWrite(w, m, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeStart(LogSink.StartMessage m, SizedIterable<String> text) {
        this.write(m, text);
        TotalMap<Long, Indenter> totalMap = this._indenters;
        synchronized (totalMap) {
            this._indenters.get(m.thread().getId()).push();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeEnd(LogSink.EndMessage m, SizedIterable<String> text) {
        TotalMap<Long, Indenter> totalMap = this._indenters;
        synchronized (totalMap) {
            this._indenters.get(m.thread().getId()).pop();
        }
        this.write(m, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(BufferedWriter w, LogSink.Message m, SizedIterable<String> text) {
        String indentString;
        Long threadId = m.thread().getId();
        TotalMap<Long, Indenter> totalMap = this._indenters;
        synchronized (totalMap) {
            indentString = this._indenters.get(threadId).indentString();
        }
        Runnable unlock = this._locks.lock(w);
        try {
            if (this._lastThreads.containsKey(w)) {
                Long prevId = this._lastThreads.get(w);
                if (!prevId.equals(threadId)) {
                    w.newLine();
                    this._lastThreads.put(w, threadId);
                }
            } else {
                this._lastThreads.put(w, threadId);
            }
            w.write(indentString);
            w.write("[" + IndentedTextLogSink.formatLocation(m.caller()) + " - " + IndentedTextLogSink.formatThread(m.thread()) + " - " + IndentedTextLogSink.formatTime(m.time()) + "]");
            w.newLine();
            for (String s : text) {
                w.write(indentString);
                w.write(HANGING_INDENT);
                w.write(s);
                w.newLine();
            }
            w.flush();
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        finally {
            unlock.run();
        }
    }
}

