/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.debug.ThreadSnapshot;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.recur.RecurUtil;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextLogSink
implements LogSink {
    private static final SizedIterable<String> EMPTY_MESSAGE = IterUtil.singleton("");
    private static final SizedIterable<String> START_MESSAGE = IterUtil.singleton("Starting");
    private static final SizedIterable<String> END_MESSAGE = IterUtil.singleton("Ending");
    private static final SizedIterable<String> NO_STACK_MESSAGE = IterUtil.singleton("[No stack trace available]");
    private static final DateFormat TIME_FORMATTER = new SimpleDateFormat("H:mm:ss.SSS");
    private final int _idealLineWidth;
    private final Lambda<Pair<String, Object>, SizedIterable<String>> _processValue = new Lambda<Pair<String, Object>, SizedIterable<String>>(){

        @Override
        public SizedIterable<String> value(Pair<String, Object> p) {
            return TextLogSink.this.processValue(p.first(), p.second());
        }
    };

    protected TextLogSink() {
        this._idealLineWidth = 120;
    }

    protected TextLogSink(int idealLineWidth) {
        if (idealLineWidth < 1) {
            throw new IllegalArgumentException("idealLineWidth < 1");
        }
        this._idealLineWidth = idealLineWidth;
    }

    protected abstract void write(LogSink.Message var1, SizedIterable<String> var2);

    protected abstract void writeStart(LogSink.StartMessage var1, SizedIterable<String> var2);

    protected abstract void writeEnd(LogSink.EndMessage var1, SizedIterable<String> var2);

    protected static String formatTime(Date time) {
        return TIME_FORMATTER.format(time);
    }

    protected static String formatThread(ThreadSnapshot thread) {
        return "\"" + thread.getName() + "\" " + thread.getId();
    }

    protected static String formatLocation(Option<StackTraceElement> location) {
        if (location.isSome()) {
            return TextLogSink.formatLocation(location.unwrap());
        }
        return "[Unknown location]";
    }

    protected static String formatLocation(StackTraceElement location) {
        StringBuilder result = new StringBuilder();
        result.append(location.getClassName());
        result.append(".");
        result.append(location.getMethodName());
        result.append("(");
        int line = location.getLineNumber();
        if (line >= 0) {
            result.append(line);
        } else if (location.isNativeMethod()) {
            result.append("native");
        } else {
            result.append("unknown");
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public void log(LogSink.StandardMessage m) {
        SizedIterable<String> text = IterUtil.compose(this.processText(m.text()), this.processValues(m.values()));
        if (IterUtil.isEmpty(text)) {
            text = EMPTY_MESSAGE;
        }
        this.write(m, text);
    }

    @Override
    public void logStart(LogSink.StartMessage m) {
        SizedIterable<String> text = m.text().isNone() ? START_MESSAGE : TextLogSink.processString("Start " + m.text().unwrap());
        text = IterUtil.compose(text, this.processValues(m.values()));
        this.writeStart(m, text);
    }

    @Override
    public void logEnd(LogSink.EndMessage m) {
        SizedIterable<String> text = m.text().isNone() ? END_MESSAGE : TextLogSink.processString("End " + m.text().unwrap());
        text = IterUtil.compose(text, this.processValues(m.values()));
        this.writeEnd(m, text);
    }

    @Override
    public void logError(LogSink.ErrorMessage m) {
        ComposedIterable<String> text = IterUtil.compose(this.processText(m.text()), this.processThrowable(m.error()));
        this.write(m, text);
    }

    @Override
    public void logStack(LogSink.StackMessage m) {
        SizedIterable<String> text = IterUtil.compose(this.processText(m.text()), this.processStack(m.stack()));
        if (IterUtil.isEmpty(text)) {
            text = NO_STACK_MESSAGE;
        }
        this.write(m, text);
    }

    private SizedIterable<String> processText(Option<String> text) {
        if (text.isSome()) {
            return TextLogSink.processString(text.unwrap());
        }
        return IterUtil.empty();
    }

    private SizedIterable<String> processThrowable(Throwable t) {
        return this.processThrowable(t, false);
    }

    private SizedIterable<String> processThrowable(Throwable t, boolean asCause) {
        if (t == null) {
            return IterUtil.singleton("null");
        }
        SizedIterable<String> result = asCause ? IterUtil.make("", "Caused by " + t, "at") : IterUtil.make(t.toString(), "at");
        result = IterUtil.compose(result, this.processStack(IterUtil.asIterable(t.getStackTrace())));
        if (t.getCause() != null) {
            result = IterUtil.compose(result, this.processThrowable(t.getCause()));
        }
        return result;
    }

    private SizedIterable<String> processStack(Iterable<StackTraceElement> stack) {
        AbstractIterable result = IterUtil.empty();
        for (StackTraceElement e : stack) {
            result = IterUtil.compose(result, e.toString());
        }
        return result;
    }

    private SizedIterable<String> processValues(Iterable<Pair<String, Object>> vals) {
        return IterUtil.collapse(IterUtil.mapSnapshot(vals, this._processValue));
    }

    private SizedIterable<String> processValue(String name, Object value) {
        SizedIterable<String> valStrings = TextLogSink.processString(RecurUtil.safeToString(value));
        if (valStrings.size() > 1 || IterUtil.first(valStrings).length() > this._idealLineWidth) {
            if (value instanceof Iterable) {
                valStrings = TextLogSink.processString(IterUtil.multilineToString((Iterable)value));
            } else if (value instanceof Object[]) {
                valStrings = TextLogSink.processString(RecurUtil.arrayToString((Object[])value, RecurUtil.ArrayStringMode.SHALLOW_MULTILINE));
            }
        }
        if (valStrings.size() == 1) {
            return IterUtil.singleton(name + ": " + IterUtil.first(valStrings));
        }
        return IterUtil.compose(name + ":", valStrings);
    }

    private static SizedIterable<String> processString(String s) {
        SizedIterable<String> result = TextUtil.getLines(s);
        if (result.size() == 0) {
            return EMPTY_MESSAGE;
        }
        return result;
    }
}

