/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    UNRECOGNIZED{

        public String versionString() {
            return "?";
        }
    }
    ,
    JAVA_1_1{

        public String versionString() {
            return "1.1";
        }
    }
    ,
    JAVA_1_2{

        public String versionString() {
            return "1.2";
        }
    }
    ,
    JAVA_1_3{

        public String versionString() {
            return "1.3";
        }
    }
    ,
    JAVA_1_4{

        public String versionString() {
            return "1.4";
        }
    }
    ,
    JAVA_5{

        public String versionString() {
            return "5";
        }
    }
    ,
    JAVA_6{

        public String versionString() {
            return "6";
        }
    }
    ,
    JAVA_7{

        public String versionString() {
            return "7";
        }
    }
    ,
    JAVA_8{

        public String versionString() {
            return "8";
        }
    }
    ,
    FUTURE{

        public String versionString() {
            return ">8";
        }
    };

    public static final JavaVersion CURRENT;
    public static final FullVersion CURRENT_FULL;

    public boolean supports(JavaVersion v) {
        return this.compareTo(v) >= 0;
    }

    public abstract String versionString();

    public String toString() {
        return "Java " + this.versionString();
    }

    public FullVersion fullVersion() {
        return new FullVersion(this, 0, 0, ReleaseType.STABLE, null, VendorType.UNKNOWN, "", null);
    }

    public static JavaVersion parseClassVersion(String text) {
        int dot = text.indexOf(46);
        if (dot == -1) {
            return UNRECOGNIZED;
        }
        try {
            int major = Integer.parseInt(text.substring(0, dot));
            int minor = Integer.parseInt(text.substring(dot + 1));
            return JavaVersion.parseClassVersion(major, minor);
        }
        catch (NumberFormatException e) {
            return UNRECOGNIZED;
        }
    }

    public static JavaVersion parseClassVersion(int major, int minor) {
        switch (major) {
            case 45: {
                if (minor >= 3) {
                    return JAVA_1_1;
                }
                return UNRECOGNIZED;
            }
            case 46: {
                return JAVA_1_2;
            }
            case 47: {
                return JAVA_1_3;
            }
            case 48: {
                return JAVA_1_4;
            }
            case 49: {
                return JAVA_5;
            }
            case 50: {
                return JAVA_6;
            }
            case 51: {
                return JAVA_7;
            }
            case 52: {
                return JAVA_8;
            }
        }
        return major > 51 ? FUTURE : UNRECOGNIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaVersion parseClassVersion(File classFile) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(classFile);
            JavaVersion javaVersion = JavaVersion.parseClassVersion(fis);
            return javaVersion;
        }
        catch (IOException ioe) {
            JavaVersion javaVersion = UNRECOGNIZED;
            return javaVersion;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaVersion parseClassVersion(InputStream is) {
        JavaVersion javaVersion;
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(is);
            int magic = dis.readInt();
            if (magic != -889275714) {
                JavaVersion javaVersion2 = UNRECOGNIZED;
                return javaVersion2;
            }
            int minor = dis.readUnsignedShort();
            int major = dis.readUnsignedShort();
            javaVersion = JavaVersion.parseClassVersion(major, minor);
        }
        catch (IOException ioe) {
            JavaVersion javaVersion3 = UNRECOGNIZED;
            return javaVersion3;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return javaVersion;
    }

    public static FullVersion parseFullVersion(String java_version, String java_runtime_name, String java_vm_vendor, File location) {
        String typeString;
        String number;
        int dash;
        VendorType vendor = VendorType.UNKNOWN;
        String vendorString = null;
        if (java_version.endsWith(".jdk")) {
            java_version = java_version.substring(0, java_version.length() - 4);
        }
        if (vendor == VendorType.UNKNOWN) {
            if (java_runtime_name.toLowerCase().contains("openjdk")) {
                vendor = VendorType.OPENJDK;
                vendorString = "OpenJDK";
            } else if (java_vm_vendor.toLowerCase().contains("apple")) {
                vendor = VendorType.APPLE;
                vendorString = "Apple";
            } else if (java_vm_vendor.toLowerCase().contains("sun") || java_vm_vendor.toLowerCase().contains("oracle")) {
                vendor = VendorType.ORACLE;
                vendorString = "Sun";
            }
        }
        if (!java_version.startsWith("1.") && java_version.replaceAll("[^\\.]", "").length() == 1) {
            java_version = "1." + java_version;
        }
        if ((dash = java_version.indexOf(45)) == -1) {
            number = java_version;
            typeString = null;
        } else {
            number = java_version.substring(0, dash);
            typeString = java_version.substring(dash + 1);
        }
        int dot1 = number.indexOf(46);
        if (dot1 == -1) {
            try {
                int feature = Integer.parseInt(number);
                ReleaseType type = typeString == null ? ReleaseType.STABLE : (typeString.startsWith("ea") ? ReleaseType.EARLY_ACCESS : (typeString.startsWith("beta") ? ReleaseType.BETA : (typeString.startsWith("rc") ? ReleaseType.RELEASE_CANDIDATE : ReleaseType.UNRECOGNIZED)));
                JavaVersion version = UNRECOGNIZED;
                switch (feature) {
                    case 1: {
                        version = JAVA_1_1;
                        break;
                    }
                    case 2: {
                        version = JAVA_1_2;
                        break;
                    }
                    case 3: {
                        version = JAVA_1_3;
                        break;
                    }
                    case 4: {
                        version = JAVA_1_4;
                        break;
                    }
                    case 5: {
                        version = JAVA_5;
                        break;
                    }
                    case 6: {
                        version = JAVA_6;
                        break;
                    }
                    case 7: {
                        version = JAVA_7;
                        break;
                    }
                    case 8: {
                        version = JAVA_8;
                        break;
                    }
                    default: {
                        if (feature <= 8) break;
                        version = FUTURE;
                    }
                }
                return new FullVersion(version, 0, 0, type, typeString, vendor, vendorString, location);
            }
            catch (NumberFormatException nfe) {
                return new FullVersion(UNRECOGNIZED, 0, 0, ReleaseType.STABLE, null, vendor, vendorString, location);
            }
        }
        int dot2 = number.indexOf(46, dot1 + 1);
        if (dot2 == -1) {
            return new FullVersion(UNRECOGNIZED, 0, 0, ReleaseType.STABLE, null, vendor, vendorString, location);
        }
        int underscore = number.indexOf(95, dot2 + 1);
        if (underscore == -1) {
            underscore = number.indexOf(46, dot2 + 1);
        }
        if (underscore == -1) {
            underscore = number.length();
        }
        try {
            int update;
            int major = Integer.parseInt(number.substring(0, dot1));
            int feature = Integer.parseInt(number.substring(dot1 + 1, dot2));
            int maintenance = Integer.parseInt(number.substring(dot2 + 1, underscore));
            int n = update = underscore >= number.length() ? 0 : Integer.parseInt(number.substring(underscore + 1));
            ReleaseType type = typeString == null ? ReleaseType.STABLE : (typeString.startsWith("ea") ? ReleaseType.EARLY_ACCESS : (typeString.startsWith("beta") ? ReleaseType.BETA : (typeString.startsWith("rc") ? ReleaseType.RELEASE_CANDIDATE : ReleaseType.UNRECOGNIZED)));
            JavaVersion version = UNRECOGNIZED;
            if (major == 1) {
                switch (feature) {
                    case 1: {
                        version = JAVA_1_1;
                        break;
                    }
                    case 2: {
                        version = JAVA_1_2;
                        break;
                    }
                    case 3: {
                        version = JAVA_1_3;
                        break;
                    }
                    case 4: {
                        version = JAVA_1_4;
                        break;
                    }
                    case 5: {
                        version = JAVA_5;
                        break;
                    }
                    case 6: {
                        version = JAVA_6;
                        break;
                    }
                    case 7: {
                        version = JAVA_7;
                        break;
                    }
                    case 8: {
                        version = JAVA_8;
                        break;
                    }
                    default: {
                        if (feature <= 8) break;
                        version = FUTURE;
                    }
                }
            }
            return new FullVersion(version, maintenance, update, type, typeString, vendor, vendorString, location);
        }
        catch (NumberFormatException e) {
            return new FullVersion(UNRECOGNIZED, 0, 0, ReleaseType.STABLE, null, vendor, vendorString, location);
        }
    }

    public static FullVersion parseFullVersion(String java_version, String java_runtime_name, String java_vm_vendor) {
        return JavaVersion.parseFullVersion(java_version, java_runtime_name, java_vm_vendor, null);
    }

    public static FullVersion parseFullVersion(String text) {
        return JavaVersion.parseFullVersion(text, "", "", null);
    }

    static {
        CURRENT = JavaVersion.parseClassVersion(System.getProperty("java.class.version", ""));
        CURRENT_FULL = JavaVersion.parseFullVersion(System.getProperty("java.version", ""), System.getProperty("java.runtime.name", ""), System.getProperty("java.vm.vendor", ""), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VendorType {
        UNKNOWN,
        OPENJDK,
        APPLE,
        ORACLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReleaseType {
        UNRECOGNIZED,
        EARLY_ACCESS,
        BETA,
        RELEASE_CANDIDATE,
        STABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FullVersion
    implements Comparable<FullVersion>,
    Serializable {
        private JavaVersion _majorVersion;
        private int _maintenance;
        private int _update;
        private ReleaseType _type;
        private String _typeString;
        private VendorType _vendor;
        private String _vendorString;
        private File _location;

        private FullVersion(JavaVersion majorVersion, int maintenance, int update, ReleaseType type, String typeString, VendorType vendor, String vendorString, File location) {
            this._majorVersion = majorVersion;
            this._maintenance = maintenance;
            this._update = update;
            this._type = type;
            this._typeString = typeString;
            this._vendor = vendor;
            this._vendorString = vendorString;
            this._location = location;
        }

        public JavaVersion majorVersion() {
            return this._majorVersion;
        }

        public FullVersion onlyMajorVersionAndVendor() {
            return new FullVersion(this._majorVersion, 0, 0, ReleaseType.STABLE, null, this._vendor, this._vendorString, this._location);
        }

        public int maintenance() {
            return this._maintenance;
        }

        public int update() {
            return this._update;
        }

        public ReleaseType release() {
            return this._type;
        }

        public VendorType vendor() {
            return this._vendor;
        }

        public File location() {
            return this._location;
        }

        public boolean supports(JavaVersion v) {
            return this._majorVersion.supports(v);
        }

        @Override
        public int compareTo(FullVersion v) {
            int result = this._majorVersion.compareTo(v._majorVersion);
            if (result == 0 && (result = this._maintenance - v._maintenance) == 0 && (result = this._update - v._update) == 0 && (result = this._type.compareTo(v._type)) == 0) {
                result = this._vendor.compareTo(v._vendor);
                if (result == 0 && !this._type.equals((Object)ReleaseType.STABLE)) {
                    result = this._typeString.compareTo(v._typeString);
                    if (result == 0 && this._vendor.equals((Object)VendorType.UNKNOWN)) {
                        if (this._location == null) {
                            if (v._location == null) {
                                return 0;
                            }
                            return -1;
                        }
                        if (v._location == null) {
                            return 1;
                        }
                        return this._location.compareTo(v._location);
                    }
                } else if (result == 0 && this._vendor.equals((Object)VendorType.UNKNOWN)) {
                    if (this._location == null) {
                        if (v._location == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (v._location == null) {
                        return 1;
                    }
                    return this._location.compareTo(v._location);
                }
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FullVersion)) {
                return false;
            }
            FullVersion v = (FullVersion)o;
            return this._majorVersion.equals((Object)v._majorVersion) && this._maintenance == v._maintenance && this._update == v._update && this._type.equals((Object)v._type) && this._vendor.equals((Object)v._vendor) && (this._type.equals((Object)ReleaseType.STABLE) || this._typeString.equals(v._typeString)) && (!this._vendor.equals((Object)VendorType.UNKNOWN) || this._location == null && v._location == null || this._location.equals(v._location));
        }

        public int hashCode() {
            int stringHash = this._typeString == null ? 0 : this._typeString.hashCode();
            int fileHash = this._location == null ? 0 : this._location.hashCode();
            return this._majorVersion.hashCode() ^ this._maintenance << 1 ^ this._update << 2 ^ this._type.hashCode() << 3 ^ this._vendor.hashCode() << 4 ^ stringHash << 5 ^ fileHash;
        }

        private String stringSuffix() {
            StringBuilder result = new StringBuilder();
            result.append("." + this._maintenance);
            if (this._update != 0) {
                result.append("_" + this._update);
            }
            if (!this._type.equals((Object)ReleaseType.STABLE)) {
                result.append('-').append(this._typeString);
            }
            return result.toString();
        }

        private String stringSuffixWithVendor() {
            StringBuilder result = new StringBuilder(this.stringSuffix());
            if (!(this._vendor.equals((Object)VendorType.ORACLE) || this._vendor.equals((Object)VendorType.APPLE) || this._vendor.equals((Object)VendorType.UNKNOWN))) {
                result.append('-').append(this._vendorString);
            }
            return result.toString();
        }

        public String versionString() {
            return this._majorVersion.versionString() + this.stringSuffixWithVendor();
        }

        public String toString() {
            return (Object)((Object)this._majorVersion) + this.stringSuffix();
        }
    }
}

