/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.ProcessChain;
import edu.rice.cs.util.ProcessCreator;
import edu.rice.cs.util.ProcessSequence;
import edu.rice.cs.util.StringOps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeneralProcessCreator
extends ProcessCreator {
    protected volatile List<List<List<String>>> _seqs;
    public static final Log LOG = new Log("process.txt", false);

    public GeneralProcessCreator(String cmdline, String workdir, PropertyMaps pm) {
        this._cmdline = cmdline;
        this._workdir = workdir;
        this._props = pm;
    }

    public GeneralProcessCreator(List<List<List<String>>> seqs, String workdir, PropertyMaps pm) {
        this._seqs = seqs;
        this._workdir = workdir;
        this._props = pm;
    }

    protected static String getProcessCmdLine(List<String> cmds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cmds.size(); ++i) {
            sb.append(" ");
            sb.append(StringOps.unescapeFileName(cmds.get(i)));
        }
        String s = sb.toString();
        if (s.length() > 0) {
            s = s.substring(1);
        }
        return s;
    }

    protected static String getProcessChainCmdLine(List<List<String>> pipe) {
        StringBuilder sb = new StringBuilder();
        String sep = " " + ProcessChain.PIPE_SEPARATOR + " ";
        for (int i = 0; i < pipe.size(); ++i) {
            sb.append(sep);
            sb.append(GeneralProcessCreator.getProcessCmdLine(pipe.get(i)));
        }
        String s = sb.toString();
        if (s.length() > 0) {
            s = s.substring(sep.length());
        }
        return s;
    }

    protected static String getProcessSequenceCmdLine(List<List<List<String>>> seqs) {
        StringBuilder sb = new StringBuilder();
        String sep = " " + ProcessChain.PROCESS_SEPARATOR + " ";
        for (int i = 0; i < seqs.size(); ++i) {
            sb.append(sep);
            sb.append(GeneralProcessCreator.getProcessChainCmdLine(seqs.get(i)));
        }
        String s = sb.toString();
        if (s.length() > 0) {
            s = s.substring(sep.length());
        }
        return s;
    }

    @Override
    public String cmdline() {
        if (this._cmdline == null) {
            if (this._cachedCmdLine == null) {
                if (this._seqs.size() == 1) {
                    List<List<String>> pipe = this._seqs.get(0);
                    if (pipe.size() == 1) {
                        List<String> cmds = pipe.get(0);
                        this._cachedCmdLine = GeneralProcessCreator.getProcessCmdLine(cmds);
                    } else {
                        this._cachedCmdLine = GeneralProcessCreator.getProcessChainCmdLine(pipe);
                    }
                } else {
                    this._cachedCmdLine = GeneralProcessCreator.getProcessSequenceCmdLine(this._seqs);
                }
            }
            return this._cachedCmdLine;
        }
        return this._cmdline;
    }

    @Override
    public Map<String, String> environment() {
        return this._env;
    }

    @Override
    public String workDir() {
        return this._workdir;
    }

    @Override
    public Process start() throws IOException {
        this._evaluatedWorkDir = StringOps.replaceVariables(this._workdir, this._props, PropertyMaps.GET_CURRENT);
        this._evaluatedWorkDir = StringOps.unescapeFileName(this._evaluatedWorkDir);
        File dir = null;
        if (!this._evaluatedWorkDir.trim().equals("")) {
            dir = new File(this._evaluatedWorkDir);
        }
        String[] env = null;
        if (this._env != null && this._env.size() > 0) {
            env = new String[this._env.size()];
            int i = 0;
            for (String key : this._env.keySet()) {
                String value = (String)this._env.get(key);
                env[i] = key + "=" + value;
            }
        }
        if (this._cmdline != null) {
            this._evaluatedCmdLine = StringOps.replaceVariables(this._cmdline, this._props, PropertyMaps.GET_CURRENT);
            this._seqs = StringOps.commandLineToLists(this._evaluatedCmdLine);
        }
        LOG.log("\t" + IterUtil.toString(this._seqs));
        if (this._seqs.size() < 1) {
            throw new IOException("No process to start.");
        }
        if (this._seqs.size() == 1) {
            List<List<String>> pipe = this._seqs.get(0);
            if (pipe.size() < 1) {
                throw new IOException("No process to start.");
            }
            if (pipe.size() == 1) {
                List<String> cmds = pipe.get(0);
                if (cmds.size() < 1) {
                    throw new IOException("No process to start.");
                }
                String[] cmdarray = new String[cmds.size()];
                for (int i = 0; i < cmds.size(); ++i) {
                    cmdarray[i] = StringOps.unescapeFileName(cmds.get(i));
                }
                return Runtime.getRuntime().exec(cmdarray, env, dir);
            }
            ProcessCreator[] creators = new ProcessCreator[pipe.size()];
            for (int i = 0; i < pipe.size(); ++i) {
                List<String> cmds = pipe.get(i);
                if (cmds.size() < 1) {
                    throw new IOException("No process to start.");
                }
                String[] cmdarray = new String[cmds.size()];
                for (int j = 0; j < cmds.size(); ++j) {
                    cmdarray[j] = StringOps.unescapeFileName(cmds.get(j));
                }
                creators[i] = new ProcessCreator(cmdarray, this._workdir);
            }
            return new ProcessChain(creators);
        }
        ProcessCreator[] creators = new ProcessCreator[this._seqs.size()];
        for (int i = 0; i < this._seqs.size(); ++i) {
            ArrayList<List<List<String>>> l = new ArrayList<List<List<String>>>();
            l.add(this._seqs.get(i));
            creators[i] = new GeneralProcessCreator(l, this._workdir, this._props);
        }
        return new ProcessSequence(creators);
    }
}

