/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLConfig {
    public static final String NL = System.getProperty("line.separator");
    private Document _document;
    private XMLConfig _parent = null;
    private Node _startNode = null;

    public XMLConfig() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public XMLConfig(InputStream is) {
        this.init(new InputSource(is));
    }

    public XMLConfig(Reader r) {
        this.init(new InputSource(r));
    }

    public XMLConfig(XMLConfig parent, Node node) {
        if (parent == null || node == null) {
            throw new XMLConfigException("Error in ctor: parent or node is null");
        }
        this._parent = parent;
        this._startNode = node;
        this._document = null;
    }

    private void init(InputSource is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            this._document = builder.parse(is);
        }
        catch (Exception e) {
            throw new XMLConfigException("Error in ctor", e);
        }
        this._document.normalize();
    }

    public XMLConfig(File f) {
        try {
            this.init(new InputSource(new FileInputStream(f)));
        }
        catch (FileNotFoundException e) {
            throw new XMLConfigException("Error in ctor", e);
        }
    }

    public XMLConfig(String filename) {
        try {
            this.init(new InputSource(new FileInputStream(filename)));
        }
        catch (FileNotFoundException e) {
            throw new XMLConfigException("Error in ctor", e);
        }
    }

    public boolean isDelegated() {
        return this._parent != null;
    }

    public void save(OutputStream os) {
        if (this.isDelegated()) {
            this._parent.save(os);
            return;
        }
        DOMSource source = new DOMSource(this._document);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 2);
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(source, new StreamResult(new OutputStreamWriter(os, "utf-8")));
        }
        catch (TransformerException e) {
            throw new XMLConfigException("Error in save", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLConfigException("Error in save", e);
        }
    }

    public void save(File f) {
        if (this.isDelegated()) {
            this._parent.save(f);
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            this.save(fos);
        }
        catch (FileNotFoundException e) {
            throw new XMLConfigException("Error in save", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public void save(String filename) {
        this.save(new File(filename));
    }

    public String get(String path) {
        List<String> r = this.getMultiple(path);
        if (r.size() != 1) {
            throw new XMLConfigException("Number of results != 1");
        }
        return r.get(0);
    }

    public String get(String path, Node root) {
        List<String> r = this.getMultiple(path, root);
        if (r.size() != 1) {
            throw new XMLConfigException("Number of results != 1");
        }
        return r.get(0);
    }

    public String get(String path, String defaultVal) {
        try {
            return this.get(path);
        }
        catch (XMLConfigException e) {
            return defaultVal;
        }
    }

    public String get(String path, Node root, String defaultVal) {
        try {
            return this.get(path, root);
        }
        catch (XMLConfigException e) {
            return defaultVal;
        }
    }

    public int getInt(String path) {
        List<String> r = this.getMultiple(path);
        if (r.size() != 1) {
            throw new XMLConfigException("Number of results != 1");
        }
        try {
            return Integer.valueOf(r.get(0));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Not an integer value.", nfe);
        }
    }

    public int getInt(String path, Node root) {
        List<String> r = this.getMultiple(path, root);
        if (r.size() != 1) {
            throw new XMLConfigException("Number of results != 1");
        }
        try {
            return Integer.valueOf(r.get(0));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Not an integer value.", nfe);
        }
    }

    public int getInt(String path, int defaultVal) {
        try {
            return this.getInt(path);
        }
        catch (XMLConfigException e) {
            return defaultVal;
        }
    }

    public int getInt(String path, Node root, int defaultVal) {
        try {
            return this.getInt(path, root);
        }
        catch (XMLConfigException e) {
            return defaultVal;
        }
    }

    public boolean getBool(String path) {
        List<String> r = this.getMultiple(path);
        if (r.size() != 1) {
            throw new XMLConfigException("Number of results != 1");
        }
        String s = r.get(0).toLowerCase().trim();
        if (s.equals("true") || s.equals("yes") || s.equals("on")) {
            return true;
        }
        if (s.equals("false") || s.equals("no") || s.equals("off")) {
            return false;
        }
        throw new IllegalArgumentException("Not a Boolean vlaue.");
    }

    public boolean getBool(String path, Node root) {
        List<String> r = this.getMultiple(path, root);
        if (r.size() != 1) {
            throw new XMLConfigException("Number of results != 1");
        }
        String s = r.get(0).toLowerCase().trim();
        if (s.equals("true") || s.equals("yes") || s.equals("on")) {
            return true;
        }
        if (s.equals("false") || s.equals("no") || s.equals("off")) {
            return false;
        }
        throw new IllegalArgumentException("Not a Boolean vlaue.");
    }

    public boolean getBool(String path, boolean defaultVal) {
        try {
            return this.getBool(path);
        }
        catch (XMLConfigException e) {
            return defaultVal;
        }
    }

    public boolean getBool(String path, Node root, boolean defaultVal) {
        try {
            return this.getBool(path, root);
        }
        catch (XMLConfigException e) {
            return defaultVal;
        }
    }

    public List<String> getMultiple(String path) {
        if (this.isDelegated()) {
            return this.getMultiple(path, this._startNode);
        }
        return this.getMultiple(path, this._document);
    }

    public List<String> getMultiple(String path, Node root) {
        List<Node> accum = this.getNodes(path, root);
        LinkedList<String> strings = new LinkedList<String>();
        for (Node n : accum) {
            if (n instanceof Attr) {
                strings.add(n.getNodeValue());
                continue;
            }
            String acc = "";
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeName().equals("#text")) {
                    acc = acc + " " + child.getNodeValue();
                    continue;
                }
                if (child.getNodeName().equals("#comment")) continue;
                throw new XMLConfigException("Node " + n.getNodeName() + " contained node " + child.getNodeName() + ", but should only contain #text and #comment.");
            }
            strings.add(acc.trim());
        }
        return strings;
    }

    public List<Node> getNodes(String path) {
        if (this.isDelegated()) {
            return this.getNodes(path, this._startNode);
        }
        return this.getNodes(path, this._document);
    }

    public List<Node> getNodes(String path, Node root) {
        LinkedList<Node> accum = new LinkedList<Node>();
        this.getMultipleHelper(path, root, accum, false);
        return accum;
    }

    private void getMultipleHelper(String path, Node n, List<Node> accum, boolean dotRead) {
        boolean initialDot;
        int dotPos = path.indexOf(46);
        boolean bl = initialDot = dotPos == 0;
        if (path.length() > 0 && dotPos == -1 && !path.endsWith("/")) {
            path = path + "/";
        }
        int slashPos = path.indexOf(47);
        if (dotPos != -1 && path.indexOf(46, dotPos + 1) != -1) {
            throw new XMLConfigException("An attribute cannot have subparts (foo.bar.fum and foo.bar/fum not allowed)");
        }
        if (dotPos != -1 && path.indexOf(47, dotPos + 1) != -1) {
            throw new XMLConfigException("An attribute cannot have subparts (foo.bar.fum and foo.bar/fum not allowed)");
        }
        if ((slashPos > -1 || dotPos > -1) && !dotRead || initialDot) {
            Node child;
            String nodeName;
            if (slashPos > -1 && (dotPos == -1 || slashPos < dotPos)) {
                nodeName = path.substring(0, slashPos);
                path = path.substring(slashPos + 1);
            } else {
                if (slashPos > -1) {
                    throw new XMLConfigException("An attribute cannot have subparts (foo.bar.fum and foo.bar/fum not allowed)");
                }
                if (!initialDot) {
                    nodeName = path.substring(0, dotPos);
                    path = path.substring(dotPos + 1);
                    dotRead = true;
                } else {
                    path = path.substring(1);
                    this.getMultipleAddAttributesHelper(path, n, accum);
                    return;
                }
            }
            if (nodeName.equals("*")) {
                for (child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeName().equals("#text") || child.getNodeName().equals("#comment")) continue;
                    if (dotRead) {
                        this.getMultipleAddAttributesHelper(path, child, accum);
                        continue;
                    }
                    this.getMultipleHelper(path, child, accum, false);
                }
                return;
            }
            while (child != null) {
                if (child.getNodeName().equals(nodeName)) {
                    if (dotRead) {
                        this.getMultipleAddAttributesHelper(path, child, accum);
                    } else {
                        this.getMultipleHelper(path, child, accum, false);
                    }
                }
                child = child.getNextSibling();
            }
            return;
        }
        accum.add(n);
    }

    private void getMultipleAddAttributesHelper(String path, Node n, List<Node> accum) {
        if (path.indexOf(46) > -1 || path.indexOf(47) > -1) {
            throw new XMLConfigException("An attribute cannot have subparts (foo.bar.fum and foo.bar/fum not allowed)");
        }
        NamedNodeMap attrMap = n.getAttributes();
        if (path.equals("*")) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Node attr = attrMap.item(i);
                accum.add(attr);
            }
        } else {
            Node attr = attrMap.getNamedItem(path);
            if (attr != null) {
                accum.add(attr);
            }
        }
    }

    public Node set(String path, String value) {
        if (this.isDelegated()) {
            return this.set(path, value, this._startNode, true);
        }
        return this.set(path, value, this._document, true);
    }

    public Node set(String path, String value, boolean overwrite) {
        if (this.isDelegated()) {
            return this.set(path, value, this._startNode, overwrite);
        }
        return this.set(path, value, this._document, overwrite);
    }

    public Node set(String path, String value, Node n, boolean overwrite) {
        if (this.isDelegated()) {
            return this._parent.set(path, value, n, overwrite);
        }
        int dotPos = path.lastIndexOf(46);
        Node node = dotPos == 0 ? n : this.createNode(path, n, overwrite);
        if (dotPos >= 0) {
            Element e = (Element)node;
            e.setAttribute(path.substring(dotPos + 1), value);
        } else {
            node.appendChild(this._document.createTextNode(value));
        }
        return node;
    }

    public Node createNode(String path) {
        if (this.isDelegated()) {
            return this.createNode(path, this._startNode, true);
        }
        return this.createNode(path, this._document, true);
    }

    public Node createNode(String path, Node n) {
        return this.createNode(path, n, true);
    }

    public Node createNode(String path, Node n, boolean overwrite) {
        String nodeName;
        if (this.isDelegated()) {
            return this._parent.createNode(path, n, overwrite);
        }
        if (n == null) {
            n = this._document;
        }
        while (path.indexOf(47) > -1) {
            Node child = null;
            String nodeName2 = path.substring(0, path.indexOf(47));
            path = path.substring(path.indexOf(47) + 1);
            for (child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals(nodeName2)) continue;
                n = child;
                break;
            }
            if (child != null) continue;
            child = this._document.createElement(nodeName2);
            n.appendChild(child);
            n = child;
        }
        if (path.indexOf(46) > -1) {
            nodeName = path.substring(0, path.indexOf(46));
        } else {
            if (path.length() == 0) {
                throw new XMLConfigException("Cannot set node with empty name");
            }
            nodeName = path;
        }
        Node child = null;
        if (nodeName.length() > 0) {
            if (overwrite) {
                for (child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!child.getNodeName().equals(nodeName)) continue;
                    n = child;
                    break;
                }
                if (child == null) {
                    child = this._document.createElement(nodeName);
                    n.appendChild(child);
                    n = child;
                }
            } else {
                child = this._document.createElement(nodeName);
                n.appendChild(child);
                n = child;
            }
        }
        if (path.indexOf(46) > -1) {
            if (!(n instanceof Element)) {
                throw new XMLConfigException("Node " + n.getNodeName() + " should be an element so it can contain attributes");
            }
            return n;
        }
        if (overwrite) {
            child = n.getFirstChild();
            while (child != null) {
                Node temp = child.getNextSibling();
                n.removeChild(child);
                child = temp;
            }
            return n;
        }
        return child;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.save(os);
        return os.toString();
    }

    public static String getNodePath(Node n) {
        if (n == null) {
            return "";
        }
        String path = "";
        while (n.getParentNode() != null) {
            path = n.getNodeName() + "/" + path;
            n = n.getParentNode();
        }
        return path.substring(0, path.length() - 1);
    }

    public static class XMLConfigException
    extends RuntimeException {
        public XMLConfigException() {
        }

        public XMLConfigException(String message) {
            super(message);
        }

        public XMLConfigException(String message, Throwable cause) {
            super(message, cause);
        }

        public XMLConfigException(Throwable cause) {
            super(cause);
        }
    }
}

