/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class LayeredIcon
implements Icon {
    private Icon[] _layers;
    private int[] _xoffs;
    private int[] _yoffs;
    private int _w = 0;
    private int _h = 0;

    public LayeredIcon(Icon[] layers, int[] x, int[] y) {
        this._layers = layers;
        this._xoffs = x;
        this._yoffs = y;
        if (layers.length != x.length || x.length != y.length) {
            throw new IllegalArgumentException("Array lengths don't match");
        }
        this._w = 0;
        this._h = 0;
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] == null) continue;
            this._w = Math.max(this._w, layers[i].getIconWidth() + x[i]);
            this._h = Math.max(this._h, layers[i].getIconHeight() + x[i]);
        }
    }

    @Override
    public int getIconHeight() {
        return this._h;
    }

    @Override
    public int getIconWidth() {
        return this._w;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        for (int i = 0; i < this._layers.length; ++i) {
            Icon ico = this._layers[i];
            if (ico == null) continue;
            this._layers[i].paintIcon(c, g, x + this._xoffs[i], y + this._yoffs[i]);
        }
    }

    public Icon[] getLayers() {
        return this._layers;
    }

    public int[] getXOffsets() {
        return this._xoffs;
    }

    public int[] getYOffsets() {
        return this._xoffs;
    }
}

