/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.FocusBorderListener;

public class SubstanceBorder
implements Border,
UIResource {
    protected Insets myInsets;

    public SubstanceBorder(int insetSize) {
        this.myInsets = new Insets(insetSize, insetSize, insetSize, insetSize);
    }

    public SubstanceBorder() {
        this(2);
    }

    private static void paintBorder(Component c, Graphics g, int x, int y, int width, int height, boolean isEnabled, boolean hasFocus) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        boolean isFocused = FocusBorderListener.isFocused(c);
        if (isEnabled && isFocused) {
            SubstanceImageCreator.paintBorder(g, x, y, width, height, SubstanceLookAndFeel.getColorScheme(), SubstanceLookAndFeel.getTheme());
        } else if (isEnabled) {
            SubstanceImageCreator.paintBorder(g, x, y, width, height, SubstanceLookAndFeel.getMetallicColorScheme(), SubstanceLookAndFeel.getTheme());
        } else {
            SubstanceImageCreator.paintBorder(g, x, y, width, height, SubstanceLookAndFeel.getGrayColorScheme(), SubstanceLookAndFeel.getTheme());
        }
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        SubstanceBorder.paintBorder(c, g, x, y, width, height, c.isEnabled(), c.hasFocus());
    }

    public Insets getBorderInsets(Component c) {
        JTextComponent textComp;
        Insets margin;
        if (c instanceof JTextComponent && (margin = (textComp = (JTextComponent)c).getMargin()) != null) {
            return new Insets(this.myInsets.top + margin.top, this.myInsets.left + margin.left, this.myInsets.bottom + margin.bottom, this.myInsets.right + margin.right);
        }
        return this.myInsets;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

