/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.jvnet.substance.SubstanceComboBoxButton;
import org.jvnet.substance.SubstanceComboBoxRenderer;
import org.jvnet.substance.SubstanceComboPopup;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    public static final Map<String, Icon> COMBO_ARROWS = new HashMap<String, Icon>();
    protected ComboBoxPropertyChangeHandler changeHandler;
    protected ComboBoxModel model;
    protected Component editor;
    protected boolean selecting = false;
    protected boolean hidePopupOnFocusLoss;
    protected boolean hitBackspace = false;
    protected boolean hitBackspaceOnSelection;
    protected ActionListener completionActionListener;
    protected PropertyChangeListener completionPropertyListener;
    protected KeyListener editorKeyListener;
    protected FocusListener editorFocusListener;
    protected CompletionPlainDocument completionDocument;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();

    public static synchronized void reset() {
        COMBO_ARROWS.clear();
    }

    public static synchronized Icon getArrowIcon(ColorScheme colorScheme, int orientation) {
        String key = SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + orientation;
        Icon result = COMBO_ARROWS.get(key);
        if (result != null) {
            return result;
        }
        result = SubstanceImageCreator.getArrowIcon(9, orientation == 0 ? 12 : 6, orientation, colorScheme);
        COMBO_ARROWS.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent b) {
        SubstanceComboBoxUI ui = new SubstanceComboBoxUI((JComboBox)b);
        return ui;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        ComboBoxEditor cbe = this.comboBox.getEditor();
        Component cbc = cbe.getEditorComponent();
        if (cbc instanceof JTextComponent) {
            this.installTextEditor((JTextComponent)cbc);
        } else {
            this.installEditor(cbc);
        }
    }

    public SubstanceComboBoxUI(JComboBox combo) {
    }

    protected JButton createArrowButton() {
        ColorScheme colorScheme = this.comboBox.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getMetallicColorScheme();
        return new SubstanceComboBoxButton(this.comboBox, SubstanceComboBoxUI.getArrowIcon(colorScheme, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox)));
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    protected void installListeners() {
        super.installListeners();
        this.changeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.changeHandler);
    }

    protected void installTextEditor(JTextComponent c) {
        if (this.comboBox.isEditable()) {
            this.completionDocument = new CompletionPlainDocument(this.comboBox);
            c.setDocument(this.completionDocument);
            this.model = this.comboBox.getModel();
            this.completionActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!SubstanceComboBoxUI.this.selecting && SubstanceComboBoxUI.this.completionDocument != null) {
                        SubstanceComboBoxUI.this.completionDocument.highlightCompletedText(0);
                    }
                }
            };
            this.comboBox.addActionListener(this.completionActionListener);
            this.completionPropertyListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("model")) {
                        SubstanceComboBoxUI.this.model = (ComboBoxModel)e.getNewValue();
                    }
                }
            };
            this.comboBox.addPropertyChangeListener(this.completionPropertyListener);
            this.editorKeyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (SubstanceComboBoxUI.this.comboBox.isDisplayable()) {
                        SubstanceComboBoxUI.this.comboBox.setPopupVisible(true);
                    }
                    SubstanceComboBoxUI.this.hitBackspace = false;
                    switch (e.getKeyCode()) {
                        case 8: {
                            SubstanceComboBoxUI.this.hitBackspace = true;
                            SubstanceComboBoxUI.this.hitBackspaceOnSelection = ((JTextField)SubstanceComboBoxUI.this.editor).getSelectionStart() != ((JTextField)SubstanceComboBoxUI.this.editor).getSelectionEnd();
                            break;
                        }
                        case 127: {
                            if (SubstanceCoreUtilities.hasUseModelOnlyProperty(SubstanceComboBoxUI.this.comboBox)) {
                                e.consume();
                                SubstanceComboBoxUI.this.comboBox.getToolkit().beep();
                                break;
                            }
                            ((JTextField)SubstanceComboBoxUI.this.editor).replaceSelection("");
                            break;
                        }
                        case 27: {
                            SubstanceComboBoxUI.this.comboBox.getParent().dispatchEvent(e);
                        }
                    }
                }
            };
            this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
            this.editorFocusListener = new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (SubstanceComboBoxUI.this.completionDocument != null) {
                        SubstanceComboBoxUI.this.completionDocument.highlightCompletedText(0);
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (SubstanceComboBoxUI.this.hidePopupOnFocusLoss && SubstanceComboBoxUI.this.comboBox != null) {
                        SubstanceComboBoxUI.this.comboBox.setPopupVisible(false);
                    }
                }
            };
            this.installEditor(c);
            Object selected = this.comboBox.getSelectedItem();
            if (this.completionDocument != null) {
                if (selected != null) {
                    this.completionDocument.setText(selected.toString());
                }
                this.completionDocument.highlightCompletedText(0);
            }
        }
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.changeHandler);
        this.changeHandler = null;
        if (this.comboBox.isEditable()) {
            this.uninstallTextEditor(null);
        }
        super.uninstallListeners();
    }

    protected void uninstallTextEditor(JTextComponent e) {
        this.completionDocument = null;
        this.comboBox.removeActionListener(this.completionActionListener);
        this.completionActionListener = null;
        this.comboBox.removePropertyChangeListener(this.completionPropertyListener);
        this.completionPropertyListener = null;
        if (e == null) {
            return;
        }
        if (this.editorKeyListener != null) {
            e.removeKeyListener(this.editorKeyListener);
            this.editorKeyListener = null;
        }
        if (this.editorFocusListener != null) {
            e.removeFocusListener(this.editorFocusListener);
            this.editorFocusListener = null;
        }
    }

    protected void installEditor(Component c) {
        if (c == null || this.editor == c) {
            return;
        }
        Component last = this.editor;
        if (last != null) {
            last.removeKeyListener(this.editorKeyListener);
            last.removeFocusListener(this.editorFocusListener);
        }
        this.editor = c;
        this.editor.addKeyListener(this.editorKeyListener);
        this.editor.addFocusListener(this.editorFocusListener);
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension superRes = super.getPreferredSize(c);
        Dimension res = new Dimension((int)superRes.getWidth() + 4, (int)superRes.getHeight() + 4);
        return res;
    }

    protected ComboPopup createPopup() {
        final SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        final ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComboBoxEditor editor;
                ListCellRenderer cellRenderer;
                if (SubstanceComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (sPopup instanceof Component) {
                    Component cPopup = (Component)((Object)sPopup);
                    cPopup.applyComponentOrientation(currOrientation);
                    cPopup.doLayout();
                }
                if ((cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
                }
                if ((editor = SubstanceComboBoxUI.this.comboBox.getEditor()) != null && editor.getEditorComponent() instanceof Component) {
                    editor.getEditorComponent().applyComponentOrientation(currOrientation);
                }
                SubstanceComboBoxUI.this.comboBox.repaint();
            }
        });
        return sPopup;
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        ColorScheme scheme = hasFocus ? SubstanceLookAndFeel.getColorScheme() : (this.comboBox.isEnabled() ? SubstanceLookAndFeel.getMetallicColorScheme() : SubstanceLookAndFeel.getGrayColorScheme());
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
        backgroundDelegate.update(graphics, this.comboBox, bounds, scheme, true);
        graphics.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceComboBoxUI: \n");
        sb.append("\t" + COMBO_ARROWS.size() + " arrows");
        return sb.toString();
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            ColorScheme colorScheme;
            String propertyName = e.getPropertyName();
            if (propertyName.equals("enabled") && SubstanceComboBoxUI.this.arrowButton != null) {
                colorScheme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getMetallicColorScheme();
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(colorScheme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
            if (propertyName.equals("editable")) {
                boolean oldValue = (Boolean)e.getOldValue();
                boolean newValue = (Boolean)e.getNewValue();
                if (!oldValue && newValue) {
                    ComboBoxEditor cbe = SubstanceComboBoxUI.this.comboBox.getEditor();
                    Component cbc = cbe.getEditorComponent();
                    if (cbc instanceof JTextComponent) {
                        SubstanceComboBoxUI.this.installTextEditor((JTextComponent)cbc);
                    } else {
                        SubstanceComboBoxUI.this.installEditor(cbc);
                    }
                } else if (oldValue && !newValue) {
                    SubstanceComboBoxUI.this.uninstallTextEditor(null);
                }
            }
            if (propertyName.equals("editor")) {
                ComboBoxEditor oldValue = (ComboBoxEditor)e.getOldValue();
                ComboBoxEditor newValue = (ComboBoxEditor)e.getNewValue();
                if (newValue != null && newValue != oldValue) {
                    Component pending;
                    Component old;
                    Component component = old = oldValue != null ? oldValue.getEditorComponent() : null;
                    if (old instanceof JTextComponent) {
                        SubstanceComboBoxUI.this.uninstallTextEditor((JTextComponent)old);
                    }
                    if ((pending = newValue.getEditorComponent()) instanceof JTextComponent) {
                        SubstanceComboBoxUI.this.installTextEditor((JTextComponent)pending);
                    } else {
                        SubstanceComboBoxUI.this.installEditor(pending);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceComboBoxUI.this.comboBox.doLayout();
                        }
                    });
                }
            }
            if (propertyName.equals("componentOrientation")) {
                final ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                SubstanceComboBoxUI.this.arrowButton.putClientProperty("substancelaf.buttonside", newOrientation.isLeftToRight() ? SubstanceConstants.Side.LEFT.name() : SubstanceConstants.Side.RIGHT.name());
                final ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                final ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubstanceComboBoxUI.this.popup instanceof Component) {
                            Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                            cPopup.applyComponentOrientation(newOrientation);
                            cPopup.doLayout();
                        }
                        if (cellRenderer instanceof Component) {
                            ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                        }
                        if (editor != null && editor.getEditorComponent() instanceof Component) {
                            editor.getEditorComponent().applyComponentOrientation(newOrientation);
                        }
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.repaint();
                        }
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(propertyName)) {
                colorScheme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getMetallicColorScheme();
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(colorScheme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width") - 1;
            int buttonHeight = height - (insets.top + insets.bottom);
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }

    protected class CompletionPlainDocument
    extends PlainDocument {
        protected JComboBox comboBox;
        protected ComboBoxModel model;

        public CompletionPlainDocument(JComboBox combo) {
            this.comboBox = combo;
            this.model = this.comboBox.getModel();
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (SubstanceComboBoxUI.this.selecting) {
                return;
            }
            if (SubstanceComboBoxUI.this.hitBackspace) {
                if (offs > 0) {
                    if (SubstanceComboBoxUI.this.hitBackspaceOnSelection) {
                        --offs;
                    }
                } else {
                    this.comboBox.getToolkit().beep();
                }
                this.highlightCompletedText(offs);
            } else {
                super.remove(offs, len);
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (SubstanceComboBoxUI.this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (SubstanceCoreUtilities.hasUseModelOnlyProperty(this.comboBox)) {
                if (item != null) {
                    this.setSelectedItem(item);
                } else {
                    item = this.comboBox.getSelectedItem();
                    offs -= str.length();
                    this.comboBox.getToolkit().beep();
                }
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            } else if (item != null) {
                this.setSelectedItem(item);
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            } else {
                offs -= str.length();
            }
        }

        private void setText(String text) {
            try {
                super.remove(0, this.getLength());
                super.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e.toString());
            }
        }

        private void highlightCompletedText(int start) {
            if (SubstanceComboBoxUI.this.editor instanceof JTextComponent) {
                ((JTextField)SubstanceComboBoxUI.this.editor).setCaretPosition(this.getLength());
                ((JTextField)SubstanceComboBoxUI.this.editor).moveCaretPosition(start);
            }
        }

        private void setSelectedItem(Object item) {
            SubstanceComboBoxUI.this.selecting = true;
            this.model.setSelectedItem(item);
            SubstanceComboBoxUI.this.selecting = false;
        }

        private Object lookupItem(String pattern) {
            Object selectedItem = this.model.getSelectedItem();
            if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
                return selectedItem;
            }
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                Object currentItem = this.model.getElementAt(i);
                if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
                return currentItem;
            }
            return null;
        }

        private boolean startsWithIgnoreCase(String str1, String str2) {
            return str1.toUpperCase().startsWith(str2.toUpperCase());
        }
    }
}

