/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.tabbed;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.tabbed.TabPreviewPainter;
import org.jvnet.substance.tabbed.TabPreviewThread;
import org.jvnet.substance.utils.FadeTracker;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class TabOverviewDialog
extends JDialog {
    protected JTabbedPane tabPane;
    protected JPanel overviewPanel;
    protected TabPreviewCallback previewCallback;

    private TabOverviewDialog(JTabbedPane tabPane, Frame owner, boolean modal, int dialogWidth, int dialogHeight) throws HeadlessException {
        super(owner, modal);
        this.tabPane = tabPane;
        this.setLayout(new BorderLayout());
        this.overviewPanel = new TabOverviewPanel(dialogWidth, dialogHeight);
        this.add((Component)this.overviewPanel, "Center");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
    }

    public static TabOverviewDialog getOverviewDialog(JTabbedPane tabPane) {
        String title = SubstanceLookAndFeel.getLabelBundle().getString("TabbedPane.overviewDialogTitle");
        TabPreviewPainter previewPainter = SubstanceCoreUtilities.getTabPreviewPainter(tabPane);
        JFrame frameForModality = previewPainter.getModalOwner(tabPane);
        boolean isModal = frameForModality != null;
        Rectangle dialogScreenBounds = previewPainter.getPreviewDialogScreenBounds(tabPane);
        TabOverviewDialog overviewDialog = new TabOverviewDialog(tabPane, frameForModality, isModal, dialogScreenBounds.width, dialogScreenBounds.height);
        overviewDialog.setTitle(title);
        overviewDialog.setLocation(dialogScreenBounds.x, dialogScreenBounds.y);
        overviewDialog.setSize(dialogScreenBounds.width, dialogScreenBounds.height);
        return overviewDialog;
    }

    protected class TabOverviewPanel
    extends JPanel {
        protected TabPreviewWidget[] previewWidgets;
        protected int pWidth;
        protected int pHeight;
        protected int colCount;

        public TabOverviewPanel(int dialogWidth, int dialogHeight) {
            int tabCount = TabOverviewDialog.this.tabPane.getTabCount();
            this.previewWidgets = new TabPreviewWidget[tabCount];
            for (int i = 0; i < tabCount; ++i) {
                TabPreviewWidget previewWidget;
                this.previewWidgets[i] = previewWidget = new TabPreviewWidget(TabOverviewDialog.this.tabPane, i);
                this.add(previewWidget);
            }
            TabPreviewCallback previewCallback = new TabPreviewCallback(){

                public void offer(JTabbedPane tabPane, int tabIndex, BufferedImage componentSnap) {
                    TabOverviewPanel.this.previewWidgets[tabIndex].setPreviewImage(componentSnap);
                }
            };
            this.colCount = (int)Math.sqrt(tabCount);
            if (this.colCount * this.colCount < tabCount) {
                ++this.colCount;
            }
            this.setLayout(new TabOverviewPanelLayout());
            this.pWidth = (dialogWidth - 8) / this.colCount;
            this.pHeight = (dialogHeight - 32) / this.colCount;
            TabPreviewThread.TabPreviewInfo previewInfo = new TabPreviewThread.TabPreviewInfo();
            previewInfo.tabPane = TabOverviewDialog.this.tabPane;
            previewInfo.previewCallback = previewCallback;
            previewInfo.previewWidth = this.pWidth - 4;
            previewInfo.previewHeight = this.pHeight - 20;
            previewInfo.toPreviewAllTabs = true;
            TabPreviewThread.getInstance().queueTabPreviewRequest(TabOverviewDialog.this.tabPane, previewInfo);
        }

        private class TabOverviewPanelLayout
        implements LayoutManager {
            private TabOverviewPanelLayout() {
            }

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public void layoutContainer(Container parent) {
                for (int i = 0; i < TabOverviewPanel.this.previewWidgets.length; ++i) {
                    TabPreviewWidget previewWidget = TabOverviewPanel.this.previewWidgets[i];
                    if (previewWidget == null) continue;
                    int rowIndex = i / TabOverviewPanel.this.colCount;
                    int colIndex = i % TabOverviewPanel.this.colCount;
                    previewWidget.setBounds(colIndex * TabOverviewPanel.this.pWidth, rowIndex * TabOverviewPanel.this.pHeight, TabOverviewPanel.this.pWidth, TabOverviewPanel.this.pHeight);
                }
            }

            public Dimension minimumLayoutSize(Container parent) {
                return parent.getSize();
            }

            public Dimension preferredLayoutSize(Container parent) {
                return this.minimumLayoutSize(parent);
            }
        }
    }

    protected class TabPreviewWidget
    extends JPanel {
        protected JLabel iconLabel;
        protected JLabel titleLabel;
        protected JPanel previewImagePanel;
        protected BufferedImage previewImage;

        public TabPreviewWidget(final JTabbedPane tabPane, final int tabIndex) {
            boolean isSelected;
            this.setLayout(new TabPreviewWidgetLayout());
            this.iconLabel = new JLabel(tabPane.getIconAt(tabIndex));
            this.titleLabel = new JLabel(tabPane.getTitleAt(tabIndex));
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
            this.previewImagePanel = new JPanel(){

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (TabPreviewWidget.this.previewImage != null) {
                        int pw = TabPreviewWidget.this.previewImage.getWidth();
                        int ph = TabPreviewWidget.this.previewImage.getHeight();
                        int w = this.getWidth();
                        int h = this.getHeight();
                        Graphics2D g2 = (Graphics2D)g.create();
                        FadeTracker fadeTracker = FadeTracker.getInstance();
                        if (fadeTracker.isTracked(this, FadeTracker.FadeKind.ENABLE)) {
                            int fadeFactor = fadeTracker.getFade(this, FadeTracker.FadeKind.ENABLE);
                            g2.setComposite(AlphaComposite.getInstance(3, (float)fadeFactor / 10.0f));
                        }
                        g2.drawImage((Image)TabPreviewWidget.this.previewImage, (w - pw) / 2, (h - ph) / 2, null);
                        g2.dispose();
                    }
                }
            };
            this.add(this.iconLabel);
            this.add(this.titleLabel);
            this.add(this.previewImagePanel);
            boolean bl = isSelected = tabPane.getSelectedIndex() == tabIndex;
            if (isSelected) {
                this.setBorder(new LineBorder(Color.black, 2));
            } else {
                this.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.black, 1)));
            }
            this.setToolTipText(SubstanceLookAndFeel.getLabelBundle().getString("TabbedPane.overviewWidgetTooltip"));
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TabOverviewDialog.this.dispose();
                            tabPane.setSelectedIndex(tabIndex);
                        }
                    });
                }

                public void mouseEntered(MouseEvent e) {
                    if (isSelected) {
                        TabPreviewWidget.this.setBorder(new LineBorder(SubstanceLookAndFeel.getColorScheme().getMidColor(), 2));
                    } else {
                        TabPreviewWidget.this.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(SubstanceLookAndFeel.getColorScheme().getMidColor(), 1)));
                    }
                }

                public void mouseExited(MouseEvent e) {
                    if (isSelected) {
                        TabPreviewWidget.this.setBorder(new LineBorder(Color.black, 2));
                    } else {
                        TabPreviewWidget.this.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(Color.black, 1)));
                    }
                }
            });
        }

        public void setPreviewImage(BufferedImage previewImage) {
            this.previewImage = previewImage;
            this.previewImagePanel.putClientProperty("substancelaf.animationKind", (Object)SubstanceConstants.AnimationKind.SLOW);
            FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.ENABLE, this.previewImagePanel, false, null);
        }

        protected class TabPreviewWidgetLayout
        implements LayoutManager {
            protected TabPreviewWidgetLayout() {
            }

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public void layoutContainer(Container parent) {
                int width = parent.getWidth();
                int height = parent.getHeight();
                Insets insets = TabPreviewWidget.this.getInsets();
                TabPreviewWidget.this.iconLabel.setBounds(insets.left + 1, insets.top + 1, 16, 16);
                TabPreviewWidget.this.titleLabel.setBounds(insets.left + 18, insets.top + 1, width - 18 - insets.left - insets.right, 16);
                TabPreviewWidget.this.previewImagePanel.setBounds(insets.left + 1, insets.top + 17, width - insets.left - insets.right - 2, height - 17 - insets.top - insets.bottom);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return parent.getSize();
            }

            public Dimension preferredLayoutSize(Container parent) {
                return this.minimumLayoutSize(parent);
            }
        }
    }

    protected static interface TabPreviewCallback {
        public void offer(JTabbedPane var1, int var2, BufferedImage var3);
    }
}

