/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.tabbed;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.Timer;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.tabbed.TabOverviewDialog;
import org.jvnet.substance.tabbed.TabPreviewPainter;
import org.jvnet.substance.tabbed.TabPreviewThread;
import org.jvnet.substance.utils.FadeTracker;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class TabPreviewWindow
extends JWindow
implements ActionListener {
    protected static TabPreviewWindow instance;
    protected TabPreviewThread.TabPreviewInfo currTabPreviewInfo;
    protected Timer currTabPreviewTimer;

    public static synchronized TabPreviewWindow getInstance() {
        if (instance == null) {
            instance = new TabPreviewWindow();
            instance.setLayout(new BorderLayout());
        }
        return instance;
    }

    public synchronized void postPreviewRequest(JTabbedPane tabPane, int tabIndex) {
        TabPreviewPainter previewPainter = SubstanceCoreUtilities.getTabPreviewPainter(tabPane);
        if (previewPainter == null || !previewPainter.hasPreviewWindow(tabPane, tabIndex)) {
            return;
        }
        if (this.currTabPreviewInfo != null && this.currTabPreviewInfo.tabPane == tabPane && this.currTabPreviewInfo.tabIndexToPreview == tabIndex) {
            return;
        }
        if (this.currTabPreviewTimer != null && this.currTabPreviewTimer.isRunning()) {
            this.currTabPreviewTimer.stop();
        }
        Dimension previewDim = previewPainter.getPreviewWindowDimension(tabPane, tabIndex);
        int pWidth = previewDim.width;
        int pHeight = previewDim.height;
        Component tabComponent = tabPane.getComponentAt(tabIndex);
        if (tabComponent != null) {
            int height;
            double pRatio = (double)previewDim.width / (double)previewDim.height;
            int width = tabComponent.getWidth();
            double ratio = (double)width / (double)(height = tabComponent.getHeight());
            if (pRatio > ratio) {
                pWidth = (int)((double)pHeight * ratio);
            } else {
                pHeight = (int)((double)pWidth / ratio);
            }
        }
        this.currTabPreviewInfo = new TabPreviewThread.TabPreviewInfo();
        this.currTabPreviewInfo.tabPane = tabPane;
        this.currTabPreviewInfo.tabIndexToPreview = tabIndex;
        this.currTabPreviewInfo.previewWidth = pWidth;
        this.currTabPreviewInfo.previewHeight = pHeight;
        this.currTabPreviewInfo.previewCallback = new TabOverviewDialog.TabPreviewCallback(){

            public void offer(JTabbedPane tabPane, int tabIndex, BufferedImage componentSnap) {
                if (TabPreviewWindow.this.currTabPreviewInfo == null) {
                    return;
                }
                if (tabPane != TabPreviewWindow.this.currTabPreviewInfo.tabPane || tabIndex != TabPreviewWindow.this.currTabPreviewInfo.tabIndexToPreview) {
                    return;
                }
                Rectangle previewScreenRectangle = ((SubstanceTabbedPaneUI)tabPane.getUI()).getPreviewWindowScreenRect(tabIndex, TabPreviewWindow.this.currTabPreviewInfo.previewWidth, TabPreviewWindow.this.currTabPreviewInfo.previewHeight);
                TabPreviewWindow.this.getContentPane().removeAll();
                final JLabel previewLabel = new JLabel(new ImageIcon(componentSnap)){

                    protected void paintComponent(Graphics g) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        FadeTracker fadeTracker = FadeTracker.getInstance();
                        if (fadeTracker.isTracked(this, FadeTracker.FadeKind.ENABLE)) {
                            int fadeFactor = fadeTracker.getFade(this, FadeTracker.FadeKind.ENABLE);
                            g2.setComposite(AlphaComposite.getInstance(3, (float)fadeFactor / 10.0f));
                        }
                        super.paintComponent(g2);
                        g2.dispose();
                    }
                };
                TabPreviewWindow.this.addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent e) {
                        previewLabel.setVisible(true);
                        FadeTracker.getInstance().trackFadeIn(FadeTracker.FadeKind.ENABLE, previewLabel, false, null);
                    }
                });
                previewLabel.setBorder(new SubstanceBorder());
                previewLabel.putClientProperty("substancelaf.animationKind", (Object)SubstanceConstants.AnimationKind.SLOW);
                TabPreviewWindow.this.getContentPane().add((Component)previewLabel, "Center");
                TabPreviewWindow.this.setSize(previewScreenRectangle.width, previewScreenRectangle.height);
                TabPreviewWindow.this.setLocation(previewScreenRectangle.x, previewScreenRectangle.y);
                previewLabel.setVisible(false);
                TabPreviewWindow.this.setVisible(true);
            }
        };
        int extraDelay = previewPainter.getPreviewWindowExtraDelay(tabPane, tabIndex);
        if (extraDelay < 0) {
            throw new IllegalArgumentException("Extra delay for tab preview must be non-negative");
        }
        this.currTabPreviewTimer = new Timer(2000 + extraDelay, this);
        this.currTabPreviewTimer.setRepeats(false);
        this.currTabPreviewTimer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.currTabPreviewInfo == null) {
            return;
        }
        TabPreviewPainter previewPainter = SubstanceCoreUtilities.getTabPreviewPainter(this.currTabPreviewInfo.tabPane);
        if (previewPainter == null || !previewPainter.hasPreviewWindow(this.currTabPreviewInfo.tabPane, this.currTabPreviewInfo.tabIndexToPreview)) {
            return;
        }
        TabPreviewThread.getInstance().queueTabPreviewRequest(this.currTabPreviewInfo.tabPane, this.currTabPreviewInfo);
    }

    public synchronized void cancelPreviewRequest() {
        this.currTabPreviewInfo = null;
        if (this.currTabPreviewTimer != null && this.currTabPreviewTimer.isRunning()) {
            this.currTabPreviewTimer.stop();
            this.currTabPreviewTimer = null;
        }
        this.dispose();
    }
}

