/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.windows.WindowsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;

final class WindowsBorders {
    private static Border menuBorder;
    private static Border xpMenuBorder;
    private static Border menuItemBorder;
    private static Border popupMenuBorder;
    private static Border noMarginPopupMenuBorder;
    private static Border separatorBorder;
    private static Border etchedBorder;
    private static Border menuBarHeaderBorder;
    private static Border toolBarHeaderBorder;
    private static Border rolloverButtonBorder;

    private WindowsBorders() {
    }

    public static Border getButtonBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        ButtonBorder outerBorder = new ButtonBorder(table.getColor("Button.shadow"), table.getColor("Button.darkShadow"), table.getColor("Button.light"), table.getColor("Button.highlight"), table.getColor("controlText"));
        BorderUIResource.CompoundBorderUIResource buttonBorder = new BorderUIResource.CompoundBorderUIResource(outerBorder, new BasicBorders.MarginBorder());
        return buttonBorder;
    }

    static Border getMenuBorder() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBorder(), new BasicBorders.MarginBorder());
        }
        return menuBorder;
    }

    static Border getXPMenuBorder() {
        if (xpMenuBorder == null) {
            xpMenuBorder = new BasicBorders.MarginBorder();
        }
        return xpMenuBorder;
    }

    static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new BorderUIResource(new BasicBorders.MarginBorder());
        }
        return menuItemBorder;
    }

    static Border getSeparatorBorder() {
        if (separatorBorder == null) {
            separatorBorder = new BorderUIResource.CompoundBorderUIResource(new SeparatorBorder(), new BasicBorders.MarginBorder());
        }
        return separatorBorder;
    }

    static Border getEtchedBorder() {
        if (etchedBorder == null) {
            etchedBorder = new BorderUIResource.CompoundBorderUIResource(new EtchedBorder(), new BasicBorders.MarginBorder());
        }
        return etchedBorder;
    }

    static Border getMenuBarHeaderBorder() {
        if (menuBarHeaderBorder == null) {
            menuBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return menuBarHeaderBorder;
    }

    static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    static Border getNoMarginPopupMenuBorder() {
        if (noMarginPopupMenuBorder == null) {
            noMarginPopupMenuBorder = new NoMarginPopupMenuBorder();
        }
        return noMarginPopupMenuBorder;
    }

    static Border getToolBarHeaderBorder() {
        if (toolBarHeaderBorder == null) {
            toolBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new ToolBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return toolBarHeaderBorder;
    }

    static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new BorderUIResource.CompoundBorderUIResource(new RolloverButtonBorder(), new RolloverMarginBorder());
        }
        return rolloverButtonBorder;
    }

    private static void drawBezel(Graphics g2, int x, int y, int w2, int h2, boolean isPressed, boolean isDefault, Color shadow, Color darkShadow, Color highlight, Color lightHighlight, Color defaultColor) {
        Color oldColor = g2.getColor();
        g2.translate(x, y);
        if (isPressed && isDefault) {
            g2.setColor(darkShadow);
            g2.drawRect(0, 0, w2 - 1, h2 - 1);
            g2.setColor(shadow);
            g2.drawRect(1, 1, w2 - 3, h2 - 3);
        } else if (isPressed) {
            BasicGraphicsUtils.drawLoweredBezel(g2, x, y, w2, h2, shadow, darkShadow, highlight, lightHighlight);
        } else if (isDefault) {
            g2.setColor(defaultColor);
            g2.drawRect(0, 0, w2 - 1, h2 - 1);
            g2.setColor(lightHighlight);
            g2.drawLine(1, 1, 1, h2 - 3);
            g2.drawLine(2, 1, w2 - 3, 1);
            g2.setColor(highlight);
            g2.drawLine(2, 2, 2, h2 - 4);
            g2.drawLine(3, 2, w2 - 4, 2);
            g2.setColor(shadow);
            g2.drawLine(2, h2 - 3, w2 - 3, h2 - 3);
            g2.drawLine(w2 - 3, 2, w2 - 3, h2 - 4);
            g2.setColor(darkShadow);
            g2.drawLine(1, h2 - 2, w2 - 2, h2 - 2);
            g2.drawLine(w2 - 2, h2 - 2, w2 - 2, 1);
        } else {
            g2.setColor(lightHighlight);
            g2.drawLine(0, 0, 0, h2 - 1);
            g2.drawLine(1, 0, w2 - 2, 0);
            g2.setColor(highlight);
            g2.drawLine(1, 1, 1, h2 - 3);
            g2.drawLine(2, 1, w2 - 3, 1);
            g2.setColor(shadow);
            g2.drawLine(1, h2 - 2, w2 - 2, h2 - 2);
            g2.drawLine(w2 - 2, 1, w2 - 2, h2 - 3);
            g2.setColor(darkShadow);
            g2.drawLine(0, h2 - 1, w2 - 1, h2 - 1);
            g2.drawLine(w2 - 1, h2 - 1, w2 - 1, 0);
        }
        g2.translate(-x, -y);
        g2.setColor(oldColor);
    }

    private static class MenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private MenuBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            AbstractButton b2 = (AbstractButton)c2;
            ButtonModel model = b2.getModel();
            if (model.isSelected()) {
                WindowsUtils.drawPressed3DBorder(g2, x, y, w2, h2);
            } else if (model.isRollover()) {
                WindowsUtils.drawFlush3DBorder(g2, x, y, w2, h2);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class ToolBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 2, 2, 2);

        private ToolBarHeaderBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            WindowsUtils.drawPressed3DBorder(g2, x, y - 1, w2, h2 + 1);
            WindowsUtils.drawFlush3DBorder(g2, x + 1, y, w2 - 2, h2 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class NoMarginPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private NoMarginPopupMenuBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            g2.translate(x, y);
            g2.setColor(UIManager.getColor("controlShadow"));
            g2.drawRect(0, 0, w2 - 1, h2 - 1);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(3, 3, 3, 3);

        private PopupMenuBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            g2.translate(x, y);
            g2.setColor(UIManager.getColor("controlShadow"));
            g2.drawRect(0, 0, w2 - 1, h2 - 1);
            g2.setColor(UIManager.getColor("MenuItem.background"));
            g2.drawRect(1, 1, w2 - 3, h2 - 3);
            g2.drawRect(2, 2, w2 - 5, h2 - 5);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class MenuBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 1, 2);

        private MenuBarHeaderBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            WindowsUtils.drawPressed3DBorder(g2, x, y, w2, h2 + 1);
            WindowsUtils.drawFlush3DBorder(g2, x + 1, y + 1, w2 - 2, h2 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class EtchedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private EtchedBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            WindowsUtils.drawPressed3DBorder(g2, x, y, w2, h2);
            WindowsUtils.drawFlush3DBorder(g2, x + 1, y + 1, w2 - 2, h2 - 2);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    static class ThinLoweredBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ThinLoweredBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            WindowsUtils.drawPressed3DBorder(g2, x, y, w2, h2);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    static class ThinRaisedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ThinRaisedBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            WindowsUtils.drawFlush3DBorder(g2, x, y, w2, h2);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class SeparatorBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(0, 3, 2, 1);

        private SeparatorBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            g2.translate(x, y);
            g2.setColor(UIManager.getColor("Separator.foreground"));
            g2.drawLine(0, h2 - 2, w2 - 1, h2 - 2);
            g2.setColor(UIManager.getColor("Separator.background"));
            g2.drawLine(0, h2 - 1, w2 - 1, h2 - 1);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class RolloverMarginBorder
    extends EmptyBorder {
        private RolloverMarginBorder() {
            super(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c2) {
            return this.getBorderInsets(c2, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c2, Insets insets) {
            Insets margin = null;
            if (c2 instanceof AbstractButton) {
                margin = ((AbstractButton)c2).getMargin();
            }
            if (margin == null || margin instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = margin.left;
                insets.top = margin.top;
                insets.right = margin.right;
                insets.bottom = margin.bottom;
            }
            return insets;
        }
    }

    private static class RolloverButtonBorder
    extends AbstractButtonBorder {
        private RolloverButtonBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            AbstractButton b2 = (AbstractButton)c2;
            ButtonModel model = b2.getModel();
            if (!model.isEnabled()) {
                return;
            }
            if (!(c2 instanceof JToggleButton)) {
                if (model.isRollover()) {
                    super.paintBorder(c2, g2, x, y, w2, h2);
                }
                return;
            }
            if (model.isSelected()) {
                WindowsUtils.drawPressed3DBorder(g2, x, y, w2, h2);
            } else if (model.isRollover()) {
                super.paintBorder(c2, g2, x, y, w2, h2);
            }
        }
    }

    private static abstract class AbstractButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private AbstractButtonBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            if (model.isPressed()) {
                WindowsUtils.drawPressed3DBorder(g2, x, y, w2, h2);
            } else {
                WindowsUtils.drawFlush3DBorder(g2, x, y, w2, h2);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        private final Color shadow;
        private final Color darkShadow;
        private final Color highlight;
        private final Color lightHighlight;
        private final Color defaultColor;

        public ButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight, Color defaultColor) {
            this.shadow = shadow;
            this.darkShadow = darkShadow;
            this.highlight = highlight;
            this.lightHighlight = lightHighlight;
            this.defaultColor = defaultColor;
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int width, int height) {
            boolean isPressed = false;
            boolean isDefault = false;
            if (c2 instanceof AbstractButton) {
                AbstractButton b2 = (AbstractButton)c2;
                ButtonModel model = b2.getModel();
                boolean bl = isPressed = model.isPressed() && model.isArmed();
                if (c2 instanceof JButton) {
                    isDefault = ((JButton)c2).isDefaultButton();
                }
            }
            WindowsBorders.drawBezel(g2, x, y, width, height, isPressed, isDefault, this.shadow, this.darkShadow, this.highlight, this.lightHighlight, this.defaultColor);
        }

        public Insets getBorderInsets(Component c2) {
            return this.getBorderInsets(c2, EMPTY_INSETS);
        }

        public Insets getBorderInsets(Component c2, Insets insets) {
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            insets.left = 3;
            return insets;
        }
    }
}

