/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CBannerLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CBanner
extends Composite {
    Control left;
    Control right;
    Control bottom;
    boolean simple = true;
    int[] curve;
    int curveStart = 0;
    Rectangle curveRect = new Rectangle(0, 0, 0, 0);
    int curve_width = 5;
    int curve_indent = -2;
    int rightWidth = -1;
    int rightMinWidth = 0;
    int rightMinHeight = 0;
    Cursor resizeCursor;
    boolean dragging = false;
    int rightDragDisplacement = 0;
    static final int OFFSCREEN = -200;
    static final int BORDER_BOTTOM = 2;
    static final int BORDER_TOP = 3;
    static final int BORDER_STRIPE = 1;
    static final int CURVE_TAIL = 200;
    static final int BEZIER_RIGHT = 30;
    static final int BEZIER_LEFT = 30;
    static final int MIN_LEFT = 10;
    static int BORDER1 = 20;

    public CBanner(Composite composite, int n2) {
        super(composite, CBanner.checkStyle(n2));
        super.setLayout(new CBannerLayout());
        this.resizeCursor = new Cursor(this.getDisplay(), 9);
        Listener listener = new Listener(){

            public void handleEvent(Event e2) {
                switch (e2.type) {
                    case 12: {
                        CBanner.this.onDispose();
                        break;
                    }
                    case 3: {
                        CBanner.this.onMouseDown(e2.x, e2.y);
                        break;
                    }
                    case 7: {
                        CBanner.this.onMouseExit();
                        break;
                    }
                    case 5: {
                        CBanner.this.onMouseMove(e2.x, e2.y);
                        break;
                    }
                    case 4: {
                        CBanner.this.onMouseUp();
                        break;
                    }
                    case 9: {
                        CBanner.this.onPaint(e2.gc);
                        break;
                    }
                    case 11: {
                        CBanner.this.onResize();
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 3, 7, 5, 4, 9, 11};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.addListener(nArray[i2], listener);
        }
    }

    static int[] bezier(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        double d2 = n2;
        double d3 = 3 * (n4 - n2);
        double d4 = 3 * (n2 + n6 - 2 * n4);
        double d5 = n8 - n2 + 3 * n4 - 3 * n6;
        double d6 = n3;
        double d7 = 3 * (n5 - n3);
        double d8 = 3 * (n3 + n7 - 2 * n5);
        double d9 = n9 - n3 + 3 * n5 - 3 * n7;
        int[] nArray = new int[2 * n10 + 2];
        for (int i2 = 0; i2 <= n10; ++i2) {
            double d10 = (double)i2 / (double)n10;
            nArray[2 * i2] = (int)(d2 + d3 * d10 + d4 * d10 * d10 + d5 * d10 * d10 * d10);
            nArray[2 * i2 + 1] = (int)(d6 + d7 * d10 + d8 * d10 * d10 + d9 * d10 * d10 * d10);
        }
        return nArray;
    }

    static int checkStyle(int n2) {
        return 0;
    }

    public Control getBottom() {
        this.checkWidget();
        return this.bottom;
    }

    public Rectangle getClientArea() {
        return new Rectangle(0, 0, 0, 0);
    }

    public Control getLeft() {
        this.checkWidget();
        return this.left;
    }

    public Control getRight() {
        this.checkWidget();
        return this.right;
    }

    public Point getRightMinimumSize() {
        this.checkWidget();
        return new Point(this.rightMinWidth, this.rightMinHeight);
    }

    public int getRightWidth() {
        this.checkWidget();
        if (this.right == null) {
            return 0;
        }
        if (this.rightWidth == -1) {
            Point point = this.right.computeSize(-1, -1, false);
            return point.x;
        }
        return this.rightWidth;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    void onDispose() {
        if (this.resizeCursor != null) {
            this.resizeCursor.dispose();
        }
        this.resizeCursor = null;
        this.left = null;
        this.right = null;
        this.bottom = null;
    }

    void onMouseDown(int n2, int n3) {
        if (this.curveRect.contains(n2, n3)) {
            this.dragging = true;
            this.rightDragDisplacement = this.curveStart - n2 + this.curve_width - this.curve_indent;
        }
    }

    void onMouseExit() {
        if (!this.dragging) {
            this.setCursor(null);
        }
    }

    void onMouseMove(int n2, int n3) {
        if (this.dragging) {
            Point point = this.getSize();
            if (0 >= n2 || n2 >= point.x) {
                return;
            }
            this.rightWidth = Math.max(0, point.x - n2 - this.rightDragDisplacement);
            if (this.rightMinWidth == -1) {
                Point point2 = this.right.computeSize(this.rightMinWidth, this.rightMinHeight);
                this.rightWidth = Math.max(point2.x, this.rightWidth);
            } else {
                this.rightWidth = Math.max(this.rightMinWidth, this.rightWidth);
            }
            this.layout(false);
            return;
        }
        if (this.curveRect.contains(n2, n3)) {
            this.setCursor(this.resizeCursor);
        } else {
            this.setCursor(null);
        }
    }

    void onMouseUp() {
        this.dragging = false;
    }

    void onPaint(GC gC) {
        if (this.left == null && this.right == null) {
            return;
        }
        Point point = this.getSize();
        Color color = this.getDisplay().getSystemColor(BORDER1);
        if (this.bottom != null) {
            int n2 = this.bottom.getBounds().y - 1 - 1;
            gC.setForeground(color);
            gC.drawLine(0, n2, point.x, n2);
        }
        if (this.left == null || this.right == null) {
            return;
        }
        int[] nArray = new int[this.curve.length + 6];
        int n3 = 0;
        int n4 = this.curveStart;
        nArray[n3++] = n4 + 1;
        nArray[n3++] = point.y - 1;
        for (int i2 = 0; i2 < this.curve.length / 2; ++i2) {
            nArray[n3++] = n4 + this.curve[2 * i2];
            nArray[n3++] = this.curve[2 * i2 + 1];
        }
        nArray[n3++] = n4 + this.curve_width;
        nArray[n3++] = 0;
        nArray[n3++] = point.x;
        nArray[n3++] = 0;
        Color color2 = this.getBackground();
        if (this.getDisplay().getDepth() >= 15) {
            int[] nArray2 = new int[nArray.length];
            n3 = 0;
            for (int i3 = 0; i3 < nArray.length / 2; ++i3) {
                nArray2[n3] = nArray[n3++] - 1;
                nArray2[n3] = nArray[n3++];
            }
            int[] nArray3 = new int[nArray.length];
            n3 = 0;
            for (int i4 = 0; i4 < nArray.length / 2; ++i4) {
                nArray3[n3] = nArray[n3++] + 1;
                nArray3[n3] = nArray[n3++];
            }
            RGB rGB = color.getRGB();
            RGB rGB2 = color2.getRGB();
            int n5 = rGB.red + 3 * (rGB2.red - rGB.red) / 4;
            int n6 = rGB.green + 3 * (rGB2.green - rGB.green) / 4;
            int n7 = rGB.blue + 3 * (rGB2.blue - rGB.blue) / 4;
            Color color3 = new Color(this.getDisplay(), n5, n6, n7);
            gC.setForeground(color3);
            gC.drawPolyline(nArray2);
            gC.drawPolyline(nArray3);
            color3.dispose();
            int n8 = Math.max(0, this.curveStart - 200);
            gC.setForeground(color2);
            gC.setBackground(color);
            gC.fillGradientRectangle(n8, point.y - 1, this.curveStart - n8 + 1, 1, false);
        } else {
            int n9 = Math.max(0, this.curveStart - 200);
            gC.setForeground(color);
            gC.drawLine(n9, point.y - 1, this.curveStart + 1, point.y - 1);
        }
        gC.setForeground(color);
        gC.drawPolyline(nArray);
    }

    void onResize() {
        this.updateCurve(this.getSize().y);
    }

    public void setBottom(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.bottom != null && !this.bottom.isDisposed()) {
            Point point = this.bottom.getSize();
            this.bottom.setLocation(-200 - point.x, -200 - point.y);
        }
        this.bottom = control;
        this.layout(false);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setLeft(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.left != null && !this.left.isDisposed()) {
            Point point = this.left.getSize();
            this.left.setLocation(-200 - point.x, -200 - point.y);
        }
        this.left = control;
        this.layout(false);
    }

    public void setRight(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.right != null && !this.right.isDisposed()) {
            Point point = this.right.getSize();
            this.right.setLocation(-200 - point.x, -200 - point.y);
        }
        this.right = control;
        this.layout(false);
    }

    public void setRightMinimumSize(Point point) {
        this.checkWidget();
        if (point == null || point.x < -1 || point.y < -1) {
            SWT.error(5);
        }
        this.rightMinWidth = point.x;
        this.rightMinHeight = point.y;
        this.layout(false);
    }

    public void setRightWidth(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            SWT.error(5);
        }
        this.rightWidth = n2;
        this.layout(false);
    }

    public void setSimple(boolean bl) {
        this.checkWidget();
        if (this.simple != bl) {
            this.simple = bl;
            if (bl) {
                this.curve_width = 5;
                this.curve_indent = -2;
            } else {
                this.curve_width = 50;
                this.curve_indent = 5;
            }
            this.updateCurve(this.getSize().y);
            this.layout(false);
            this.redraw();
        }
    }

    void updateCurve(int n2) {
        int n3 = n2 - 1;
        this.curve = this.simple ? new int[]{0, n3, 1, n3, 2, n3 - 1, 3, n3 - 2, 3, 2, 4, 1, 5, 0} : CBanner.bezier(0, n3 + 1, 30, n3 + 1, this.curve_width - 30, 0, this.curve_width, 0, this.curve_width);
    }
}

