/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ScrolledCompositeLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrolledComposite
extends Composite {
    Control content;
    Listener contentListener;
    int minHeight = 0;
    int minWidth = 0;
    boolean expandHorizontal = false;
    boolean expandVertical = false;
    boolean alwaysShowScroll = false;

    public ScrolledComposite(Composite composite, int n2) {
        super(composite, ScrolledComposite.checkStyle(n2));
        ScrollBar scrollBar;
        super.setLayout(new ScrolledCompositeLayout());
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.setVisible(false);
            scrollBar2.addListener(13, new Listener(){

                public void handleEvent(Event e2) {
                    ScrolledComposite.this.hScroll();
                }
            });
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            scrollBar.setVisible(false);
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event e2) {
                    ScrolledComposite.this.vScroll();
                }
            });
        }
        this.contentListener = new Listener(){

            public void handleEvent(Event e2) {
                if (e2.type != 11) {
                    return;
                }
                ScrolledComposite.this.layout(false);
            }
        };
    }

    static int checkStyle(int n2) {
        int n3 = 0x6000B00;
        return n2 & n3;
    }

    public boolean getAlwaysShowScrollBars() {
        return this.alwaysShowScroll;
    }

    public boolean getExpandHorizontal() {
        this.checkWidget();
        return this.expandHorizontal;
    }

    public boolean getExpandVertical() {
        this.checkWidget();
        return this.expandVertical;
    }

    public int getMinWidth() {
        this.checkWidget();
        return this.minWidth;
    }

    public int getMinHeight() {
        this.checkWidget();
        return this.minHeight;
    }

    public Control getContent() {
        return this.content;
    }

    void hScroll() {
        if (this.content == null) {
            return;
        }
        Point point = this.content.getLocation();
        ScrollBar scrollBar = this.getHorizontalBar();
        int n2 = scrollBar.getSelection();
        this.content.setLocation(-n2, point.y);
    }

    boolean needHScroll(Rectangle rectangle, boolean bl) {
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar == null) {
            return false;
        }
        Rectangle rectangle2 = this.getBounds();
        int n2 = this.getBorderWidth();
        rectangle2.width -= 2 * n2;
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (bl && scrollBar2 != null) {
            rectangle2.width -= scrollBar2.getSize().x;
        }
        if (!this.expandHorizontal && rectangle.width > rectangle2.width) {
            return true;
        }
        return this.expandHorizontal && this.minWidth > rectangle2.width;
    }

    boolean needVScroll(Rectangle rectangle, boolean bl) {
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return false;
        }
        Rectangle rectangle2 = this.getBounds();
        int n2 = this.getBorderWidth();
        rectangle2.height -= 2 * n2;
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (bl && scrollBar2 != null) {
            rectangle2.height -= scrollBar2.getSize().y;
        }
        if (!this.expandVertical && rectangle.height > rectangle2.height) {
            return true;
        }
        return this.expandVertical && this.minHeight > rectangle2.height;
    }

    public Point getOrigin() {
        this.checkWidget();
        if (this.content == null) {
            return new Point(0, 0);
        }
        Point point = this.content.getLocation();
        return new Point(-point.x, -point.y);
    }

    public void setOrigin(Point point) {
        this.setOrigin(point.x, point.y);
    }

    public void setOrigin(int n2, int n3) {
        this.checkWidget();
        if (this.content == null) {
            return;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(n2);
            n2 = -scrollBar.getSelection();
        } else {
            n2 = 0;
        }
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (scrollBar2 != null) {
            scrollBar2.setSelection(n3);
            n3 = -scrollBar2.getSelection();
        } else {
            n3 = 0;
        }
        this.content.setLocation(n2, n3);
    }

    public void setAlwaysShowScrollBars(boolean bl) {
        ScrollBar scrollBar;
        this.checkWidget();
        if (bl == this.alwaysShowScroll) {
            return;
        }
        this.alwaysShowScroll = bl;
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null && this.alwaysShowScroll) {
            scrollBar2.setVisible(true);
        }
        if ((scrollBar = this.getVerticalBar()) != null && this.alwaysShowScroll) {
            scrollBar.setVisible(true);
        }
        this.layout(false);
    }

    public void setContent(Control control) {
        this.checkWidget();
        if (this.content != null && !this.content.isDisposed()) {
            this.content.removeListener(11, this.contentListener);
            this.content.setBounds(new Rectangle(-200, -200, 0, 0));
        }
        this.content = control;
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (this.content != null) {
            if (scrollBar != null) {
                scrollBar.setMaximum(0);
                scrollBar.setThumb(0);
                scrollBar.setSelection(0);
            }
            if (scrollBar2 != null) {
                scrollBar2.setMaximum(0);
                scrollBar2.setThumb(0);
                scrollBar2.setSelection(0);
            }
            control.setLocation(0, 0);
            this.layout(false);
            this.content.addListener(11, this.contentListener);
        } else {
            if (scrollBar2 != null) {
                scrollBar2.setVisible(this.alwaysShowScroll);
            }
            if (scrollBar != null) {
                scrollBar.setVisible(this.alwaysShowScroll);
            }
        }
    }

    public void setExpandHorizontal(boolean bl) {
        this.checkWidget();
        if (bl == this.expandHorizontal) {
            return;
        }
        this.expandHorizontal = bl;
        this.layout(false);
    }

    public void setExpandVertical(boolean bl) {
        this.checkWidget();
        if (bl == this.expandVertical) {
            return;
        }
        this.expandVertical = bl;
        this.layout(false);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMinHeight(int n2) {
        this.setMinSize(this.minWidth, n2);
    }

    public void setMinSize(Point point) {
        if (point == null) {
            this.setMinSize(0, 0);
        } else {
            this.setMinSize(point.x, point.y);
        }
    }

    public void setMinSize(int n2, int n3) {
        this.checkWidget();
        if (n2 == this.minWidth && n3 == this.minHeight) {
            return;
        }
        this.minWidth = Math.max(0, n2);
        this.minHeight = Math.max(0, n3);
        this.layout(false);
    }

    public void setMinWidth(int n2) {
        this.setMinSize(n2, this.minHeight);
    }

    void vScroll() {
        if (this.content == null) {
            return;
        }
        Point point = this.content.getLocation();
        ScrollBar scrollBar = this.getVerticalBar();
        int n2 = scrollBar.getSelection();
        this.content.setLocation(point.x, -n2);
    }
}

