/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int V_SCROLL_RATE = 50;
    static final int H_SCROLL_RATE = 10;
    static final int ExtendedModify = 3000;
    static final int LineGetBackground = 3001;
    static final int LineGetStyle = 3002;
    static final int TextChanging = 3003;
    static final int TextSet = 3004;
    static final int VerifyKey = 3005;
    static final int TextChanged = 3006;
    static final int LineGetSegments = 3007;
    static final int PaintObject = 3008;
    static final int PREVIOUS_OFFSET_TRAILING = 0;
    static final int OFFSET_LEADING = 1;
    Color selectionBackground;
    Color selectionForeground;
    StyledTextContent content;
    StyledTextRenderer renderer;
    Listener listener;
    TextChangeListener textChangeListener;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    int topIndex = 0;
    int topIndexY;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int tabLength = 4;
    int leftMargin;
    int topMargin;
    int rightMargin;
    int bottomMargin;
    int columnX;
    int caretOffset = 0;
    int caretAlignment;
    Point selection = new Point(0, 0);
    Point clipboardSelection;
    int selectionAnchor;
    Point doubleClickSelection;
    boolean editable = true;
    boolean wordWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Hashtable keyActionMap = new Hashtable();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    boolean mouseDown = false;
    boolean mouseDoubleClick = false;
    int autoScrollDirection = 0;
    int autoScrollDistance = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    int lastLineBottom;
    boolean isMirrored;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    Caret defaultCaret = null;
    boolean updateCaretDirection = true;
    boolean fixedLineHeight;
    boolean dragDetect;
    boolean dragging;
    int alignment;
    boolean justify;
    int indent;
    int lineSpacing;
    static final boolean IS_CARBON;
    static final boolean IS_GTK;
    static final boolean IS_MOTIF;

    public StyledText(Composite composite, int n2) {
        super(composite, StyledText.checkStyle(n2));
        super.setForeground(this.getForeground());
        Display display = this.getDisplay();
        this.isMirrored = (super.getStyle() & 0x8000000) != 0;
        this.fixedLineHeight = true;
        if ((n2 & 8) != 0) {
            this.setEditable(false);
        }
        this.rightMargin = this.isBidiCaret() ? 2 : 0;
        this.leftMargin = this.rightMargin;
        if ((n2 & 4) != 0 && (n2 & 0x800) != 0) {
            this.bottomMargin = 2;
            this.rightMargin = 2;
            this.topMargin = 2;
            this.leftMargin = 2;
        }
        this.alignment = n2 & 0x1024000;
        if (this.alignment == 0) {
            this.alignment = 16384;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.renderer = new StyledTextRenderer(this.getDisplay(), this);
        this.renderer.setContent(this.content);
        this.renderer.setFont(this.getFont(), this.tabLength);
        this.defaultCaret = new Caret(this, 0);
        if ((n2 & 0x40) != 0) {
            this.setWordWrap(true);
        }
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
            Runnable runnable = new Runnable(){

                public void run() {
                    int direction;
                    int n2 = direction = BidiUtil.getKeyboardLanguage() == 1 ? 131072 : 16384;
                    if (direction == StyledText.this.caretDirection) {
                        return;
                    }
                    if (StyledText.this.getCaret() != StyledText.this.defaultCaret) {
                        return;
                    }
                    Point newCaretPos = StyledText.this.getPointAtOffset(StyledText.this.caretOffset);
                    StyledText.this.setCaretLocation(newCaretPos, direction);
                }
            };
            BidiUtil.addLanguageListener(this.handle, runnable);
        }
        this.setCaret(this.defaultCaret);
        this.calculateScrollBars();
        this.createKeyBindings();
        this.setCursor(display.getSystemCursor(19));
        this.installListeners();
        this.initializeAccessible();
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(extendedModifyListener);
        this.addListener(3000, styledTextListener);
    }

    public void addBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.addListener(3007, new StyledTextListener(bidiSegmentListener));
    }

    public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3001)) {
            this.renderer.clearLineBackground(0, this.content.getLineCount());
        }
        this.addListener(3001, new StyledTextListener(lineBackgroundListener));
    }

    public void addLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3002)) {
            this.setStyleRanges(0, 0, null, null, true);
            this.renderer.clearLineStyle(0, this.content.getLineCount());
        }
        this.addListener(3002, new StyledTextListener(lineStyleListener));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.addListener(24, new TypedListener(modifyListener));
    }

    public void addPaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.addListener(3008, new StyledTextListener(paintObjectListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.addListener(13, new TypedListener(selectionListener));
    }

    public void addVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.checkWidget();
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.addListener(3005, new StyledTextListener(verifyKeyListener));
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.addListener(25, new TypedListener(verifyListener));
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n2 = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(n2, 0, string);
    }

    void calculateScrollBars() {
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        this.setScrollBars(true);
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(this.getVerticalIncrement());
        }
        if (scrollBar != null) {
            scrollBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    void calculateTopIndex(int n2) {
        int n3 = this.topIndex;
        int n4 = this.topIndexY;
        if (this.isFixedLineHeight()) {
            int n5 = this.getVerticalIncrement();
            if (n5 == 0) {
                return;
            }
            this.topIndex = Compatibility.ceil(this.getVerticalScrollOffset(), n5);
            if (this.topIndex > 0) {
                if (this.clientAreaHeight > 0) {
                    int n6;
                    int n7 = this.getVerticalScrollOffset() + this.clientAreaHeight;
                    int n8 = n7 - (n6 = this.topIndex * n5);
                    if (n8 < n5) {
                        --this.topIndex;
                    }
                } else if (this.topIndex >= this.content.getLineCount()) {
                    this.topIndex = this.content.getLineCount() - 1;
                }
            }
        } else if (n2 >= 0) {
            n2 -= this.topIndexY;
            int n9 = this.topIndex;
            int n10 = this.content.getLineCount();
            while (n9 < n10 && n2 > 0) {
                n2 -= this.renderer.getLineHeight(n9++);
            }
            if (n9 < n10 && -n2 + this.renderer.getLineHeight(n9) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n9;
                this.topIndexY = -n2;
            } else {
                this.topIndex = n9 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n2;
            }
        } else {
            int n11;
            int n12;
            n2 -= this.topIndexY;
            for (n12 = this.topIndex; n12 > 0 && n2 + (n11 = this.renderer.getLineHeight(n12 - 1)) <= 0; --n12) {
                n2 += n11;
            }
            if (n12 == 0 || -n2 + this.renderer.getLineHeight(n12) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n12;
                this.topIndexY = -n2;
            } else {
                this.topIndex = n12 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n2;
            }
        }
        if (this.topIndex != n3 || n4 != this.topIndexY) {
            this.renderer.calculateClientArea();
            this.setScrollBars(false);
        }
    }

    static int checkStyle(int n2) {
        if ((n2 & 4) != 0) {
            n2 &= 0xFFFFFCBD;
        } else if (((n2 |= 2) & 0x40) != 0) {
            n2 &= 0xFFFFFEFF;
        }
        return n2 |= 0x20140000;
    }

    void claimBottomFreeSpace() {
        int n2 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (this.isFixedLineHeight()) {
            int n3 = this.renderer.getLineHeight();
            int n4 = Math.max(0, this.content.getLineCount() * n3 - n2);
            if (n4 < this.getVerticalScrollOffset()) {
                this.scrollVertical(n4 - this.getVerticalScrollOffset(), true);
            }
        } else {
            int n5 = this.getPartialBottomIndex();
            int n6 = this.getLinePixel(n5 + 1);
            if (n2 > n6) {
                this.scrollVertical(-this.getAvailableHeightAbove(n2 - n6), true);
            }
        }
    }

    void claimRightFreeSpace() {
        int n2 = Math.max(0, this.renderer.getWidth() - (this.clientAreaWidth - this.leftMargin - this.rightMargin));
        if (n2 < this.horizontalScrollOffset) {
            this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
        }
    }

    void clearSelection(boolean bl) {
        int n2 = this.selection.x;
        int n3 = this.selection.y;
        this.resetSelection();
        if (n3 - n2 > 0) {
            int n4 = this.content.getCharCount();
            int n5 = Math.min(n2, n4);
            int n6 = Math.min(n3, n4);
            if (n6 - n5 > 0) {
                this.internalRedrawRange(n5, n6 - n5);
            }
            if (bl) {
                this.sendSelectionEvent();
            }
        }
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        int n4;
        this.checkWidget();
        int n5 = (this.getStyle() & 4) != 0 ? 1 : this.content.getLineCount();
        int n6 = 0;
        int n7 = 0;
        if (n2 == -1 || n3 == -1) {
            Display display = this.getDisplay();
            n4 = display.getClientArea().height;
            for (int i2 = 0; i2 < n5; ++i2) {
                TextLayout textLayout = this.renderer.getTextLayout(i2);
                if (this.wordWrap) {
                    textLayout.setWidth(n2 == 0 ? 1 : n2);
                }
                Rectangle rectangle = textLayout.getBounds();
                n6 = Math.max(n6, rectangle.width);
                this.renderer.disposeTextLayout(textLayout);
                if (this.isFixedLineHeight() && (n7 += rectangle.height) > n4) break;
            }
            if (this.isFixedLineHeight()) {
                n7 = n5 * this.renderer.getLineHeight();
            }
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        int n8 = this.leftMargin + this.rightMargin + this.getCaretWidth();
        n4 = this.topMargin + this.bottomMargin;
        Rectangle rectangle = this.computeTrim(0, 0, n6 + n8, n7 + n4);
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        this.copy(1);
    }

    public void copy(int n2) {
        block4: {
            this.checkWidget();
            if (n2 != 1 && n2 != 2) {
                return;
            }
            int n3 = this.selection.y - this.selection.x;
            if (n3 > 0) {
                try {
                    this.setClipboardContent(this.selection.x, n3, n2);
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    int getAvailableHeightAbove(int n2) {
        int n3 = this.verticalScrollOffset;
        if (n3 == -1) {
            int n4 = this.topIndex - 1;
            n3 = -this.topIndexY;
            if (this.topIndexY > 0) {
                n3 += this.renderer.getLineHeight(n4--);
            }
            while (n2 > n3 && n4 >= 0) {
                n3 += this.renderer.getLineHeight(n4--);
            }
        }
        return Math.min(n2, n3);
    }

    int getAvailableHeightBellow(int n2) {
        int n3 = this.getPartialBottomIndex();
        int n4 = this.getLinePixel(n3);
        int n5 = this.renderer.getLineHeight(n3);
        int n6 = 0;
        int n7 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n4 + n5 > n7) {
            n6 = n5 - (n7 - n4);
        }
        int n8 = n3 + 1;
        int n9 = this.content.getLineCount();
        while (n2 > n6 && n8 < n9) {
            n6 += this.renderer.getLineHeight(n8++);
        }
        return Math.min(n2, n6);
    }

    String getModelDelimitedText(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        String string2 = this.getLineDelimiter();
        while (n5 < n2) {
            if (n3 != -1) {
                n3 = string.indexOf(13, n5);
            }
            if (n4 != -1) {
                n4 = string.indexOf(10, n5);
            }
            if (n4 == -1 && n3 == -1) break;
            if (n3 < n4 && n3 != -1 || n4 == -1) {
                stringBuffer.append(string.substring(n5, n3));
                n5 = n4 == n3 + 1 ? n4 + 1 : n3 + 1;
            } else {
                stringBuffer.append(string.substring(n5, n4));
                n5 = n4 + 1;
            }
            if (this.isSingleLine()) break;
            stringBuffer.append(string2);
        }
        if (!(n5 >= n2 || this.isSingleLine() && stringBuffer.length() != 0)) {
            stringBuffer.append(string.substring(n5));
        }
        return stringBuffer.toString();
    }

    void createKeyBindings() {
        int n2 = this.isMirrored() ? 0x1000003 : 0x1000004;
        int n3 = this.isMirrored() ? 0x1000004 : 0x1000003;
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        if (IS_CARBON) {
            this.setKeyBinding(n3 | SWT.MOD1, 0x1000007);
            this.setKeyBinding(n2 | SWT.MOD1, 0x1000008);
            this.setKeyBinding(0x1000007, 17039367);
            this.setKeyBinding(0x1000008, 17039368);
            this.setKeyBinding(0x1000001 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000002 | SWT.MOD1, 17039368);
            this.setKeyBinding(n2 | SWT.MOD3, 0x1040004);
            this.setKeyBinding(n3 | SWT.MOD3, 17039363);
        } else {
            this.setKeyBinding(0x1000007, 0x1000007);
            this.setKeyBinding(0x1000008, 0x1000008);
            this.setKeyBinding(0x1000007 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000008 | SWT.MOD1, 17039368);
            this.setKeyBinding(n2 | SWT.MOD1, 0x1040004);
            this.setKeyBinding(n3 | SWT.MOD1, 17039363);
        }
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x1000005 | SWT.MOD1, 17039365);
        this.setKeyBinding(0x1000006 | SWT.MOD1, 17039366);
        this.setKeyBinding(n2, 0x1000004);
        this.setKeyBinding(n3, 0x1000003);
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        if (IS_CARBON) {
            this.setKeyBinding(n3 | SWT.MOD1 | SWT.MOD2, 16908295);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 17170440);
            this.setKeyBinding(0x1000001 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000002 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n2 | SWT.MOD2 | SWT.MOD3, 17170436);
            this.setKeyBinding(n3 | SWT.MOD2 | SWT.MOD3, 17170435);
        } else {
            this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 17170436);
            this.setKeyBinding(n3 | SWT.MOD1 | SWT.MOD2, 17170435);
        }
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x1000005 | SWT.MOD1 | SWT.MOD2, 17170437);
        this.setKeyBinding(0x1000006 | SWT.MOD1 | SWT.MOD2, 0x1060006);
        this.setKeyBinding(n2 | SWT.MOD2, 16908292);
        this.setKeyBinding(n3 | SWT.MOD2, 16908291);
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        if (IS_CARBON) {
            this.setKeyBinding(0x7F | SWT.MOD2, 127);
            this.setKeyBinding(8 | SWT.MOD3, 262152);
            this.setKeyBinding(0x7F | SWT.MOD3, 262271);
        } else {
            this.setKeyBinding(0x7F | SWT.MOD2, 131199);
            this.setKeyBinding(0x1000009 | SWT.MOD1, 17039369);
            this.setKeyBinding(0x1000009 | SWT.MOD2, 16908297);
        }
        this.setKeyBinding(8 | SWT.MOD2, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(8 | SWT.MOD1, 262152);
        this.setKeyBinding(0x7F | SWT.MOD1, 262271);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createCaretBitmaps() {
        int n2 = 3;
        Display display = this.getDisplay();
        if (this.leftCaretBitmap != null) {
            if (this.defaultCaret != null && this.leftCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.leftCaretBitmap.dispose();
        }
        int n3 = this.renderer.getLineHeight();
        this.leftCaretBitmap = new Image((Device)display, n2, n3);
        GC gC = new GC(this.leftCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n2, n3);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(0, 0, 0, n3);
        gC.drawLine(0, 0, n2 - 1, 0);
        gC.drawLine(0, 1, 1, 1);
        gC.dispose();
        if (this.rightCaretBitmap != null) {
            if (this.defaultCaret != null && this.rightCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, n2, n3);
        gC = new GC(this.rightCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n2, n3);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(n2 - 1, 0, n2 - 1, n3);
        gC.drawLine(0, 0, n2 - 1, 0);
        gC.drawLine(n2 - 1, 1, 1, 1);
        gC.dispose();
    }

    public void cut() {
        this.checkWidget();
        int n2 = this.selection.y - this.selection.x;
        if (n2 > 0) {
            try {
                this.setClipboardContent(this.selection.x, n2, 1);
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                return;
            }
            this.doDelete();
        }
    }

    boolean detectDrag(int n2, int n3, int n4) {
        if (!this.isListening(29)) {
            return false;
        }
        if (IS_MOTIF ? n4 != 2 : n4 != 1) {
            return false;
        }
        if (this.selection.x == this.selection.y) {
            return false;
        }
        int n5 = this.getOffsetAtPoint(n2, n3);
        return n5 > this.selection.x && n5 < this.selection.y;
    }

    void doAutoScroll(Event event) {
        if (event.y > this.clientAreaHeight) {
            this.doAutoScroll(1024, event.y - this.clientAreaHeight);
        } else if (event.y < 0) {
            this.doAutoScroll(128, -event.y);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000003, this.leftMargin - event.x);
        } else if (event.x > this.clientAreaWidth - this.leftMargin - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000004, event.x - (this.clientAreaWidth - this.leftMargin - this.rightMargin));
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int n2, int n3) {
        this.autoScrollDistance = n3;
        if (this.autoScrollDirection == n2) {
            return;
        }
        Runnable runnable = null;
        Display display = this.getDisplay();
        if (n2 == 128) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 128) {
                        StyledText.this.doSelectionPageUp(StyledText.this.autoScrollDistance);
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(50, runnable);
        } else if (n2 == 1024) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 1024) {
                        StyledText.this.doSelectionPageDown(StyledText.this.autoScrollDistance);
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(50, runnable);
        } else if (n2 == 0x1000004) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000004) {
                        StyledText.this.doVisualNext();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(10, runnable);
        } else if (n2 == 0x1000003) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000003) {
                        StyledText.this.doVisualPrevious();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n2;
            display.timerExec(10, runnable);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int n2 = this.content.getLineAtOffset(this.caretOffset);
            int n3 = this.content.getOffsetAtLine(n2);
            if (this.caretOffset == n3) {
                n3 = this.content.getOffsetAtLine(n2 - 1);
                event.start = n3 + this.content.getLine(n2 - 1).length();
                event.end = this.caretOffset;
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n2);
                int n4 = textLayout.getPreviousOffset(this.caretOffset - n3, 1);
                this.renderer.disposeTextLayout(textLayout);
                event.start = n4 + n3;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doContent(char c2) {
        if (this.textLimit > 0 && this.content.getCharCount() - (this.selection.y - this.selection.x) >= this.textLimit) {
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (c2 == '\r' || c2 == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && c2 != '\t') {
            String string;
            int n2 = this.content.getLineAtOffset(event.end);
            int n3 = this.content.getOffsetAtLine(n2);
            if (event.end < n3 + (string = this.content.getLine(n2)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{c2});
        } else {
            event.text = new String(new char[]{c2});
        }
        if (event.text != null) {
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n2 = this.content.getCharCount();
            if (this.caretOffset < n2) {
                this.caretOffset = n2;
                this.showCaret();
            }
        }
    }

    void doContentStart() {
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
        }
    }

    void doCursorPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.caretAlignment = 1;
            this.showCaret();
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.caretAlignment = 0;
            this.showCaret();
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int n2;
            int n3 = this.content.getLineAtOffset(this.caretOffset);
            int n4 = this.content.getOffsetAtLine(n3);
            if (this.caretOffset == n4 + (n2 = this.content.getLine(n3).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(n3 + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.getClusterNext(this.caretOffset, n3);
            }
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordNext() {
        if (this.selection.x != this.selection.y) {
            this.doDelete();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.caretOffset;
            event.end = this.getWordEnd(this.caretOffset);
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordPrevious() {
        if (this.selection.x != this.selection.y) {
            this.doBackspace();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.getWordStart(this.caretOffset);
            event.end = this.caretOffset;
            this.sendKeyEvent(event);
        }
    }

    void doLineDown(boolean bl) {
        int n2;
        int n3;
        int n4 = this.getCaretLine();
        int n5 = this.content.getLineCount();
        int n6 = 0;
        boolean bl2 = false;
        if (this.wordWrap) {
            int n7;
            n3 = this.content.getOffsetAtLine(n4);
            n2 = this.caretOffset - n3;
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n8 = this.getVisualLineIndex(textLayout, n2);
            if (n8 == (n7 = textLayout.getLineCount()) - 1) {
                bl2 = n4 == n5 - 1;
                ++n4;
            } else {
                n6 = textLayout.getLineBounds((int)(n8 + 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl2 = n4 == n5 - 1;
            ++n4;
        }
        if (bl2) {
            if (bl) {
                this.caretOffset = this.content.getCharCount();
            }
        } else {
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n6, n4);
        }
        n3 = this.columnX;
        n2 = this.horizontalScrollOffset;
        if (bl) {
            this.setMouseWordSelectionAnchor();
            this.doSelection(0x1000004);
        }
        this.showCaret();
        int n9 = n2 - this.horizontalScrollOffset;
        this.columnX = n3 + n9;
    }

    void doLineEnd() {
        int n2;
        int n3 = this.getCaretLine();
        int n4 = this.content.getOffsetAtLine(n3);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n5 = this.caretOffset - n4;
            int n6 = this.getVisualLineIndex(textLayout, n5);
            int[] nArray = textLayout.getLineOffsets();
            n2 = n4 + nArray[n6 + 1];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            int n7 = this.content.getLine(n3).length();
            n2 = n4 + n7;
        }
        if (this.caretOffset < n2) {
            this.caretOffset = n2;
            this.caretAlignment = 0;
            this.showCaret();
        }
    }

    void doLineStart() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            int n4 = this.caretOffset - n3;
            int n5 = this.getVisualLineIndex(textLayout, n4);
            int[] nArray = textLayout.getLineOffsets();
            n3 += nArray[n5];
            this.renderer.disposeTextLayout(textLayout);
        }
        if (this.caretOffset > n3) {
            this.caretOffset = n3;
            this.caretAlignment = 1;
            this.showCaret();
        }
    }

    void doLineUp(boolean bl) {
        int n2;
        int n3;
        int n4 = this.getCaretLine();
        int n5 = 0;
        boolean bl2 = false;
        if (this.wordWrap) {
            n3 = this.content.getOffsetAtLine(n4);
            n2 = this.caretOffset - n3;
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n6 = this.getVisualLineIndex(textLayout, n2);
            if (n6 == 0) {
                boolean bl3 = bl2 = n4 == 0;
                if (!bl2) {
                    n5 = this.renderer.getLineHeight(--n4) - 1;
                }
            } else {
                n5 = textLayout.getLineBounds((int)(n6 - 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl2 = n4 == 0;
            --n4;
        }
        if (bl2) {
            if (bl) {
                this.caretOffset = 0;
            }
        } else {
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n5, n4);
        }
        n3 = this.columnX;
        n2 = this.horizontalScrollOffset;
        if (bl) {
            this.setMouseWordSelectionAnchor();
        }
        this.showCaret();
        if (bl) {
            this.doSelection(0x1000003);
        }
        int n7 = n2 - this.horizontalScrollOffset;
        this.columnX = n3 + n7;
    }

    void doMouseLocationChange(int n2, int n3, boolean bl) {
        int n4 = this.getLineIndex(n3);
        this.updateCaretDirection = true;
        if (n4 < 0 || this.isSingleLine() && n4 > 0) {
            return;
        }
        int n5 = this.caretAlignment;
        int n6 = this.getOffsetAtPoint(n2, n3);
        if (this.mouseDoubleClick) {
            n6 = this.doMouseWordSelect(n2, n6, n4);
        }
        int n7 = this.content.getLineAtOffset(n6);
        if (0 <= n3 && n3 < this.clientAreaHeight && (0 <= n2 && n2 < this.clientAreaWidth || this.wordWrap || n7 != this.content.getLineAtOffset(this.caretOffset)) && (n6 != this.caretOffset || this.caretAlignment != n5)) {
            this.caretOffset = n6;
            if (bl) {
                this.doMouseSelection();
            }
            this.showCaret();
        }
        if (!bl) {
            this.caretOffset = n6;
            this.clearSelection(true);
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(0x1000003);
        } else {
            this.doSelection(0x1000004);
        }
    }

    int doMouseWordSelect(int n2, int n3, int n4) {
        int n5;
        if (n3 < this.selectionAnchor && this.selectionAnchor == this.selection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (n3 > this.selectionAnchor && this.selectionAnchor == this.selection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
        if (0 <= n2 && n2 < this.clientAreaWidth && this.content.getLineAtOffset(n5 = this.caretOffset == this.selection.x ? this.getWordStart(n3) : this.getWordEndNoSpaces(n3)) == n4) {
            n3 = n5;
        }
        return n3;
    }

    void doPageDown(boolean bl, int n2) {
        int n3;
        if (this.isSingleLine()) {
            return;
        }
        int n4 = this.columnX;
        int n5 = this.horizontalScrollOffset;
        if (this.isFixedLineHeight()) {
            n3 = this.content.getLineCount();
            int n6 = this.getCaretLine();
            if (n6 < n3 - 1) {
                int n7 = this.renderer.getLineHeight();
                int n8 = (n2 == -1 ? this.clientAreaHeight : n2) / n7;
                int n9 = Math.min(n3 - n6 - 1, n8);
                n9 = Math.max(1, n9);
                this.caretOffset = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n6 + n9));
                if (bl) {
                    this.doSelection(0x1000004);
                }
                int n10 = n3 * this.getVerticalIncrement();
                int n11 = this.clientAreaHeight;
                int n12 = this.getVerticalScrollOffset();
                int n13 = n12 + n9 * this.getVerticalIncrement();
                if (n13 + n11 > n10) {
                    n13 = n10 - n11;
                }
                if (n13 > n12) {
                    this.scrollVertical(n13 - n12, true);
                }
            }
        } else {
            Rectangle rectangle;
            int n14;
            int n15;
            TextLayout textLayout;
            int n16;
            int n17;
            int n18;
            n3 = this.content.getLineCount();
            int n19 = this.getCaretLine();
            if (n2 == -1) {
                n18 = this.getPartialBottomIndex();
                n17 = this.getLinePixel(n18);
                n16 = this.renderer.getLineHeight(n18);
                n2 = n17;
                if (n17 + n16 <= this.clientAreaHeight) {
                    n2 += n16;
                } else if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n18);
                    n15 = this.clientAreaHeight - n17;
                    for (n14 = 0; n14 < textLayout.getLineCount(); ++n14) {
                        rectangle = textLayout.getLineBounds(n14);
                        if (!rectangle.contains(rectangle.x, n15)) continue;
                        n2 += rectangle.y;
                        break;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                }
            } else {
                n18 = this.getLineIndex(n2);
                n17 = this.getLinePixel(n18);
                if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n18);
                    n15 = n2 - n17;
                    for (n14 = 0; n14 < textLayout.getLineCount(); ++n14) {
                        rectangle = textLayout.getLineBounds(n14);
                        if (!rectangle.contains(rectangle.x, n15)) continue;
                        n2 = n17 + rectangle.y + rectangle.height;
                        break;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                } else {
                    n2 = n17 + this.renderer.getLineHeight(n18);
                }
            }
            n17 = n2;
            if (this.wordWrap) {
                textLayout = this.renderer.getTextLayout(n19);
                n15 = this.caretOffset - this.content.getOffsetAtLine(n19);
                n18 = this.getVisualLineIndex(textLayout, n15);
                n17 += textLayout.getLineBounds((int)n18).y;
                this.renderer.disposeTextLayout(textLayout);
            }
            n18 = n19;
            n16 = this.renderer.getLineHeight(n18);
            while (n17 - n16 >= 0 && n18 < n3 - 1) {
                n17 -= n16;
                n16 = this.renderer.getLineHeight(++n18);
            }
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n17, n18);
            if (bl) {
                this.doSelection(0x1000004);
            }
            n2 = this.getAvailableHeightBellow(n2);
            this.scrollVertical(n2, true);
            if (n2 == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n3 = n5 - this.horizontalScrollOffset;
        this.columnX = n4 + n3;
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n2;
            if (this.wordWrap) {
                int n3;
                int n4 = this.getPartialBottomIndex();
                TextLayout textLayout = this.renderer.getTextLayout(n4);
                int n5 = this.clientAreaHeight - this.bottomMargin - this.getLinePixel(n4);
                for (n3 = textLayout.getLineCount() - 1; n3 >= 0; --n3) {
                    Rectangle rectangle = textLayout.getLineBounds(n3);
                    if (n5 >= rectangle.y + rectangle.height) break;
                }
                n2 = n3 == -1 && n4 > 0 ? this.content.getOffsetAtLine(n4 - 1) + this.content.getLine(n4 - 1).length() : this.content.getOffsetAtLine(n4) + Math.max(0, textLayout.getLineOffsets()[n3 + 1] - 1);
                this.renderer.disposeTextLayout(textLayout);
            } else {
                int n6 = this.getBottomIndex();
                n2 = this.content.getOffsetAtLine(n6) + this.content.getLine(n6).length();
            }
            if (this.caretOffset < n2) {
                this.caretOffset = n2;
                this.caretAlignment = 1;
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int n2;
        if (this.wordWrap) {
            int n3;
            int n4;
            int n5;
            if (this.topIndexY > 0) {
                n5 = this.topIndex - 1;
                n4 = this.renderer.getLineHeight(n5) - this.topIndexY;
            } else {
                n5 = this.topIndex;
                n4 = -this.topIndexY;
            }
            TextLayout textLayout = this.renderer.getTextLayout(n5);
            int n6 = textLayout.getLineCount();
            for (n3 = 0; n3 < n6; ++n3) {
                Rectangle rectangle = textLayout.getLineBounds(n3);
                if (n4 <= rectangle.y) break;
            }
            n2 = n3 == n6 ? this.content.getOffsetAtLine(n5 + 1) : this.content.getOffsetAtLine(n5) + textLayout.getLineOffsets()[n3];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            n2 = this.content.getOffsetAtLine(this.topIndex);
        }
        if (this.caretOffset > n2) {
            this.caretOffset = n2;
            this.caretAlignment = 1;
            this.showCaret();
        }
    }

    void doPageUp(boolean bl, int n2) {
        int n3;
        if (this.isSingleLine()) {
            return;
        }
        int n4 = this.horizontalScrollOffset;
        int n5 = this.columnX;
        if (this.isFixedLineHeight()) {
            n3 = this.getCaretLine();
            if (n3 > 0) {
                int n6;
                int n7;
                int n8 = this.renderer.getLineHeight();
                int n9 = (n2 == -1 ? this.clientAreaHeight : n2) / n8;
                int n10 = Math.max(1, Math.min(n3, n9));
                this.caretOffset = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n3 -= n10));
                if (bl) {
                    this.doSelection(0x1000003);
                }
                if ((n7 = Math.max(0, (n6 = this.getVerticalScrollOffset()) - n10 * this.getVerticalIncrement())) < n6) {
                    this.scrollVertical(n7 - n6, true);
                }
            }
        } else {
            int n11;
            TextLayout textLayout;
            int n12;
            int n13;
            int n14;
            n3 = this.getCaretLine();
            if (n2 == -1) {
                if (this.topIndexY == 0) {
                    n2 = this.clientAreaHeight;
                } else {
                    if (this.topIndex > 0) {
                        n14 = this.topIndex - 1;
                        n13 = this.renderer.getLineHeight(n14);
                        n2 = this.clientAreaHeight - this.topIndexY;
                        n12 = n13 - this.topIndexY;
                    } else {
                        n14 = this.topIndex;
                        n13 = this.renderer.getLineHeight(n14);
                        n2 = this.clientAreaHeight - (n13 + this.topIndexY);
                        n12 = -this.topIndexY;
                    }
                    if (this.wordWrap) {
                        textLayout = this.renderer.getTextLayout(n14);
                        for (n11 = 0; n11 < textLayout.getLineCount(); ++n11) {
                            Rectangle rectangle = textLayout.getLineBounds(n11);
                            if (!rectangle.contains(rectangle.x, n12)) continue;
                            n2 += n13 - (rectangle.y + rectangle.height);
                            break;
                        }
                        this.renderer.disposeTextLayout(textLayout);
                    }
                }
            } else {
                n14 = this.getLineIndex(this.clientAreaHeight - n2);
                n12 = this.getLinePixel(n14);
                if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n14);
                    n11 = n12;
                    for (int i2 = 0; i2 < textLayout.getLineCount(); ++i2) {
                        Rectangle rectangle = textLayout.getLineBounds(i2);
                        if (!rectangle.contains(rectangle.x, n11)) continue;
                        n2 = this.clientAreaHeight - (n12 + rectangle.y);
                        break;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                } else {
                    n2 = this.clientAreaHeight - n12;
                }
            }
            n12 = n2;
            if (this.wordWrap) {
                textLayout = this.renderer.getTextLayout(n3);
                n11 = this.caretOffset - this.content.getOffsetAtLine(n3);
                n14 = this.getVisualLineIndex(textLayout, n11);
                n12 += textLayout.getBounds().height - textLayout.getLineBounds((int)n14).y;
                this.renderer.disposeTextLayout(textLayout);
            }
            n14 = n3;
            n13 = this.renderer.getLineHeight(n14);
            while (n12 - n13 >= 0 && n14 > 0) {
                n12 -= n13;
                n13 = this.renderer.getLineHeight(--n14);
            }
            n13 = this.renderer.getLineHeight(n14);
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n13 - n12, n14);
            if (bl) {
                this.doSelection(0x1000003);
            }
            n2 = this.getAvailableHeightAbove(n2);
            this.scrollVertical(-n2, true);
            if (n2 == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n3 = n4 - this.horizontalScrollOffset;
        this.columnX = n5 + n3;
    }

    void doSelection(int n2) {
        int n3 = -1;
        int n4 = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (n2 == 0x1000003) {
            if (this.caretOffset < this.selection.x) {
                n4 = this.selection.x;
                n3 = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    n4 = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                n4 = this.selection.y;
                n3 = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            n3 = this.selection.y;
            n4 = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                n3 = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            n3 = this.selection.x;
            n4 = this.selection.x = this.caretOffset;
        }
        if (n3 != -1 && n4 != -1) {
            this.internalRedrawRange(n3, n4 - n3);
            this.sendSelectionEvent();
        }
    }

    void doSelectionCursorNext() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = this.caretOffset - n3;
        if (n4 < this.content.getLine(n2).length()) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            n4 = textLayout.getNextOffset(n4, 2);
            int n5 = textLayout.getLineOffsets()[textLayout.getLineIndex(n4)];
            this.renderer.disposeTextLayout(textLayout);
            this.caretOffset = n4 + n3;
            this.caretAlignment = n4 == n5 ? 1 : 0;
            this.showCaret();
        } else if (n2 < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            this.caretOffset = this.content.getOffsetAtLine(++n2);
            this.caretAlignment = 0;
            this.showCaret();
        }
    }

    void doSelectionCursorPrevious() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = this.caretOffset - n3;
        this.caretAlignment = 1;
        if (n4 > 0) {
            this.caretOffset = this.getClusterPrevious(this.caretOffset, n2);
            this.showCaret();
        } else if (n2 > 0) {
            n3 = this.content.getOffsetAtLine(--n2);
            this.caretOffset = n3 + this.content.getLine(n2).length();
            this.showCaret();
        }
    }

    void doSelectionLineDown() {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineDown(true);
        this.columnX = n2;
    }

    void doSelectionLineUp() {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineUp(true);
        this.columnX = n2;
    }

    void doSelectionPageDown(int n2) {
        int n3 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageDown(true, n2);
        this.columnX = n3;
    }

    void doSelectionPageUp(int n2) {
        int n3 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageUp(true, n2);
        this.columnX = n3;
    }

    void doSelectionWordNext() {
        int n2 = this.getWordEnd(this.caretOffset);
        this.caretAlignment = 1;
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(n2)) {
            this.caretOffset = n2;
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        this.caretAlignment = 1;
        this.caretOffset = this.getWordStart(this.caretOffset);
        int n2 = this.content.getLineAtOffset(this.caretOffset);
        if (this.wordWrap && n2 < this.content.getLineCount() - 1 && this.caretOffset == this.content.getOffsetAtLine(n2 + 1)) {
            ++n2;
        }
        this.showCaret();
    }

    void doVisualPrevious() {
        this.caretOffset = this.getClusterPrevious(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doVisualNext() {
        this.caretOffset = this.getClusterNext(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.showCaret();
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.showCaret();
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public int getBaseline() {
        this.checkWidget();
        return this.renderer.getBaseline();
    }

    public int getBaseline(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getBaseline();
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int n5 = textLayout.getLineIndex(Math.min(n2 - n4, textLayout.getText().length()));
        FontMetrics fontMetrics = textLayout.getLineMetrics(n5);
        this.renderer.disposeTextLayout(textLayout);
        return fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    int getBottomIndex() {
        int n2;
        if (this.isFixedLineHeight()) {
            int n3 = 1;
            int n4 = this.renderer.getLineHeight();
            if (n4 != 0) {
                int n5 = this.topIndex * n4 - this.getVerticalScrollOffset();
                n3 = (this.clientAreaHeight - n5) / n4;
            }
            n2 = Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, n3 - 1));
        } else {
            int n6;
            int n7;
            int n8 = this.clientAreaHeight - this.bottomMargin;
            n2 = this.getLineIndex(n8);
            if (n2 > 0 && (n7 = this.getLinePixel(n2)) + (n6 = this.renderer.getLineHeight(n2)) > n8 && this.getLinePixel(n2 - 1) >= this.topMargin) {
                --n2;
            }
        }
        return n2;
    }

    Rectangle getBoundsAtOffset(int n2) {
        Rectangle rectangle;
        int n3 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n3);
        if (string.length() != 0) {
            int n4 = n2 - this.content.getOffsetAtLine(n3);
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            rectangle = textLayout.getBounds(n4, n4);
            this.renderer.disposeTextLayout(textLayout);
        } else {
            rectangle = new Rectangle(0, 0, 0, this.renderer.getLineHeight());
        }
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        rectangle.y += this.getLinePixel(n3);
        return rectangle;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    Object getClipboardContent(int n2) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents(textTransfer, n2);
    }

    int getClusterNext(int n2, int n3) {
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        n2 -= n4;
        n2 = textLayout.getNextOffset(n2, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n2 += n4;
    }

    int getClusterPrevious(int n2, int n3) {
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        n2 -= n4;
        n2 = textLayout.getPreviousOffset(n2, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n2 += n4;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.content;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    int getHorizontalIncrement() {
        GC gC = new GC(this);
        int n2 = gC.getFontMetrics().getAverageCharWidth();
        gC.dispose();
        return n2;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getIndent() {
        this.checkWidget();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkWidget();
        return this.justify;
    }

    public int getKeyBinding(int n2) {
        this.checkWidget();
        Integer n3 = (Integer)this.keyActionMap.get(new Integer(n2));
        return n3 == null ? 0 : n3;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public int getLineAlignment(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.renderer.getLineAlignment(n2, this.alignment);
    }

    public int getLineAtOffset(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.getCharCount()) {
            SWT.error(6);
        }
        return this.content.getLineAtOffset(n2);
    }

    public Color getLineBackground(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3001) ? null : this.renderer.getLineBackground(n2, null);
    }

    public Bullet getLineBullet(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? null : this.renderer.getLineBullet(n2, null);
    }

    StyledTextEvent getLineBackgroundData(int n2, String string) {
        return this.sendLineEvent(3001, n2, string);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.content.getLineCount();
    }

    int getLineCountWhole() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            return n2 != 0 ? this.clientAreaHeight / n2 : 1;
        }
        return this.getBottomIndex() - this.topIndex + 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.renderer.getLineHeight();
    }

    public int getLineHeight(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getLineHeight();
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int n5 = textLayout.getLineIndex(Math.min(n2 - n4, textLayout.getText().length()));
        int n6 = textLayout.getLineBounds((int)n5).height;
        this.renderer.disposeTextLayout(textLayout);
        return n6;
    }

    public int getLineIndent(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? 0 : this.renderer.getLineIndent(n2, this.indent);
    }

    public boolean getLineJustify(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? false : this.renderer.getLineJustify(n2, this.justify);
    }

    public int getLineSpacing() {
        this.checkWidget();
        return this.lineSpacing;
    }

    StyledTextEvent getLineStyleData(int n2, String string) {
        return this.sendLineEvent(3002, n2, string);
    }

    public int getLinePixel(int n2) {
        this.checkWidget();
        int n3 = this.content.getLineCount();
        n2 = Math.max(0, Math.min(n3, n2));
        if (this.isFixedLineHeight()) {
            int n4 = this.renderer.getLineHeight();
            return n2 * n4 - this.getVerticalScrollOffset() + this.topMargin;
        }
        if (n2 == this.topIndex) {
            return this.topIndexY + this.topMargin;
        }
        int n5 = this.topIndexY;
        if (n2 > this.topIndex) {
            for (int i2 = this.topIndex; i2 < n2; ++i2) {
                n5 += this.renderer.getLineHeight(i2);
            }
        } else {
            for (int i3 = this.topIndex - 1; i3 >= n2; --i3) {
                n5 -= this.renderer.getLineHeight(i3);
            }
        }
        return n5 + this.topMargin;
    }

    public int getLineIndex(int n2) {
        this.checkWidget();
        n2 -= this.topMargin;
        if (this.isFixedLineHeight()) {
            int n3 = this.renderer.getLineHeight();
            int n4 = (n2 + this.getVerticalScrollOffset()) / n3;
            int n5 = this.content.getLineCount();
            n4 = Math.max(0, Math.min(n5 - 1, n4));
            return n4;
        }
        if (n2 == this.topIndexY) {
            return this.topIndex;
        }
        int n6 = this.topIndex;
        if (n2 < this.topIndexY) {
            while (n2 < this.topIndexY && n6 > 0) {
                n2 += this.renderer.getLineHeight(--n6);
            }
        } else {
            int n7 = this.content.getLineCount();
            int n8 = this.renderer.getLineHeight(n6);
            while (n2 - n8 >= this.topIndexY && n6 < n7 - 1) {
                n2 -= n8;
                n8 = this.renderer.getLineHeight(++n6);
            }
        }
        return n6;
    }

    public Point getLocationAtOffset(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.getCharCount()) {
            SWT.error(6);
        }
        return this.getPointAtOffset(n2);
    }

    public int getOffsetAtLine(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > 0 && n2 >= this.content.getLineCount()) {
            SWT.error(6);
        }
        return this.content.getOffsetAtLine(n2);
    }

    public int getOffsetAtLocation(Point point) {
        String string;
        int n2;
        int n3;
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        if (point.y + this.getVerticalScrollOffset() < 0 || point.x + this.horizontalScrollOffset < 0) {
            SWT.error(5);
        }
        if (point.y > (n3 = this.getLinePixel(n2 = this.getLineIndex(this.clientAreaHeight)) + this.renderer.getLineHeight(n2))) {
            SWT.error(5);
        }
        int n4 = this.getLineIndex(point.y);
        int n5 = this.content.getOffsetAtLine(n4);
        TextLayout textLayout = this.renderer.getTextLayout(n4);
        int[] nArray = new int[1];
        int n6 = point.x + this.horizontalScrollOffset - this.leftMargin;
        int n7 = point.y - this.getLinePixel(n4);
        int n8 = textLayout.getOffset(n6, n7, nArray);
        if (n8 != (string = this.content.getLine(n4)).length() - 1) {
            n8 = Math.min(string.length(), n8 + nArray[0]);
        }
        Rectangle rectangle = textLayout.getLineBounds(textLayout.getLineIndex(n8));
        this.renderer.disposeTextLayout(textLayout);
        if (n6 > rectangle.x + rectangle.width) {
            SWT.error(5);
        }
        return n5 + n8;
    }

    int getOffsetAtPoint(int n2, int n3) {
        int n4 = this.getLineIndex(n3);
        return this.getOffsetAtPoint(n2, n3 -= this.getLinePixel(n4), n4);
    }

    int getOffsetAtPoint(int n2, int n3, int n4) {
        TextLayout textLayout = this.renderer.getTextLayout(n4);
        int[] nArray = new int[1];
        int n5 = textLayout.getOffset(n2 += this.horizontalScrollOffset - this.leftMargin, n3, nArray);
        this.caretAlignment = 1;
        if (nArray[0] != 0) {
            int n6 = textLayout.getLineIndex(n5 + nArray[0]);
            int n7 = textLayout.getLineOffsets()[n6];
            if (n5 + nArray[0] == n7) {
                n5 += nArray[0];
                this.caretAlignment = 0;
            } else {
                int n8;
                String string = this.content.getLine(n4);
                for (n8 = n5; n8 > 0 && Character.isDigit(string.charAt(n8)); --n8) {
                }
                int n9 = n8 == 0 && Character.isDigit(string.charAt(n8)) ? (this.isMirrored() ? 1 : 0) : textLayout.getLevel(n8) & 1;
                int n10 = textLayout.getLevel(n5 += nArray[0]) & 1;
                this.caretAlignment = (n9 ^ n10) != 0 ? 0 : 1;
            }
        }
        this.renderer.disposeTextLayout(textLayout);
        return n5 + this.content.getOffsetAtLine(n4);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.isMirrored() ? 0x4000000 : 0x2000000;
    }

    int getPartialBottomIndex() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            int n3 = Compatibility.ceil(this.clientAreaHeight, n2);
            return Math.min(this.content.getLineCount(), this.topIndex + n3) - 1;
        }
        return this.getLineIndex(this.clientAreaHeight - this.bottomMargin);
    }

    int getPartialTopIndex() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            return this.getVerticalScrollOffset() / n2;
        }
        return this.topIndexY <= 0 ? this.topIndex : this.topIndex - 1;
    }

    String getPlatformDelimitedText(TextWriter textWriter) {
        int n2 = textWriter.getStart() + textWriter.getCharCount();
        int n3 = this.content.getLineAtOffset(textWriter.getStart());
        int n4 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n4);
        int n5 = this.content.getOffsetAtLine(n4);
        for (int i2 = n3; i2 <= n4; ++i2) {
            textWriter.writeLine(this.content.getLine(i2), this.content.getOffsetAtLine(i2));
            if (i2 >= n4) continue;
            textWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        if (n2 > n5 + string.length()) {
            textWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        textWriter.close();
        return textWriter.toString();
    }

    public int[] getRanges() {
        int[] nArray;
        this.checkWidget();
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(0, this.content.getCharCount())) != null) {
            return nArray;
        }
        return new int[0];
    }

    public int[] getRanges(int n2, int n3) {
        int[] nArray;
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(n2, n3)) != null) {
            return nArray;
        }
        return new int[0];
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        if (this.selectionBackground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.selectionBackground;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionRange().y;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        if (this.selectionForeground == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.selectionForeground;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    public int getStyle() {
        int n2 = super.getStyle();
        n2 &= 0xF1FFFFFF;
        n2 = this.isMirrored() ? (n2 |= 0xC000000) : (n2 |= 0x2000000);
        return n2;
    }

    int[] getBidiSegments(int n2, String string) {
        int[] nArray;
        if (!this.isBidi()) {
            return null;
        }
        if (!this.isListening(3007)) {
            return this.getBidiSegmentsCompatibility(string, n2);
        }
        StyledTextEvent styledTextEvent = this.sendLineEvent(3007, n2, string);
        int n3 = string.length();
        if (styledTextEvent == null || styledTextEvent.segments == null || styledTextEvent.segments.length == 0) {
            nArray = new int[]{0, n3};
        } else {
            int n4 = styledTextEvent.segments.length;
            if (styledTextEvent.segments[0] != 0) {
                SWT.error(5);
            }
            for (int i2 = 1; i2 < n4; ++i2) {
                if (styledTextEvent.segments[i2] > styledTextEvent.segments[i2 - 1] && styledTextEvent.segments[i2] <= n3) continue;
                SWT.error(5);
            }
            if (styledTextEvent.segments[n4 - 1] != n3) {
                nArray = new int[n4 + 1];
                System.arraycopy(styledTextEvent.segments, 0, nArray, 0, n4);
                nArray[n4] = n3;
            } else {
                nArray = styledTextEvent.segments;
            }
        }
        return nArray;
    }

    int[] getBidiSegmentsCompatibility(String string, int n2) {
        int n3;
        int n4 = string.length();
        if (!this.bidiColoring) {
            return new int[]{0, n4};
        }
        StyleRange[] styleRangeArray = null;
        StyledTextEvent styledTextEvent = this.getLineStyleData(n2, string);
        styleRangeArray = styledTextEvent != null ? styledTextEvent.styles : this.renderer.getStyleRanges(n2, n4, true);
        if (styleRangeArray == null || styleRangeArray.length == 0) {
            return new int[]{0, n4};
        }
        int n5 = 1;
        for (n3 = 0; n3 < styleRangeArray.length && styleRangeArray[n3].start == 0 && styleRangeArray[n3].length == n4; ++n3) {
        }
        int[] nArray = new int[(styleRangeArray.length - n3) * 2 + 2];
        for (int i2 = n3; i2 < styleRangeArray.length; ++i2) {
            StyleRange styleRange = styleRangeArray[i2];
            int n6 = Math.max(styleRange.start - n2, 0);
            int n7 = Math.max(styleRange.start + styleRange.length - n2, n6);
            n7 = Math.min(n7, string.length());
            if (i2 > 0 && n5 > 1 && (n6 >= nArray[n5 - 2] && n6 <= nArray[n5 - 1] || n7 >= nArray[n5 - 2] && n7 <= nArray[n5 - 1]) && styleRange.similarTo(styleRangeArray[i2 - 1])) {
                nArray[n5 - 2] = Math.min(nArray[n5 - 2], n6);
                nArray[n5 - 1] = Math.max(nArray[n5 - 1], n7);
                continue;
            }
            if (n6 > nArray[n5 - 1]) {
                nArray[n5] = n6;
                ++n5;
            }
            nArray[n5] = n7;
            ++n5;
        }
        if (n4 > nArray[n5 - 1]) {
            nArray[n5] = n4;
            ++n5;
        }
        if (n5 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n5];
        System.arraycopy(nArray, 0, nArray2, 0, n5);
        return nArray2;
    }

    public StyleRange getStyleRangeAtOffset(int n2) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        if (n2 < 0 || n2 >= this.getCharCount()) {
            SWT.error(5);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n2, 1, true)) != null) {
            return styleRangeArray[0];
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), true);
    }

    public StyleRange[] getStyleRanges(boolean bl) {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), bl);
    }

    public StyleRange[] getStyleRanges(int n2, int n3) {
        this.checkWidget();
        return this.getStyleRanges(n2, n3, true);
    }

    public StyleRange[] getStyleRanges(int n2, int n3, boolean bl) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n2, n3, bl)) != null) {
            return styleRangeArray;
        }
        return new StyleRange[0];
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        if (n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n2 > n3) {
            SWT.error(6);
        }
        return this.content.getTextRange(n2, n3 - n2 + 1);
    }

    public Rectangle getTextBounds(int n2, int n3) {
        Rectangle rectangle;
        this.checkWidget();
        int n4 = this.getCharCount();
        if (n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n2 > n3) {
            SWT.error(6);
        }
        int n5 = this.content.getLineAtOffset(n2);
        int n6 = this.content.getLineAtOffset(n3);
        int n7 = this.getLinePixel(n5);
        int n8 = 0;
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        for (int i2 = n5; i2 <= n6; ++i2) {
            int n11 = this.content.getOffsetAtLine(i2);
            TextLayout textLayout = this.renderer.getTextLayout(i2);
            if (i2 == n5 && i2 == n6) {
                rectangle = textLayout.getBounds(n2 - n11, n3 - n11);
            } else if (i2 == n5) {
                String string = this.content.getLine(i2);
                rectangle = textLayout.getBounds(n2 - n11, string.length());
            } else {
                rectangle = i2 == n6 ? textLayout.getBounds(0, n3 - n11) : textLayout.getBounds();
            }
            n9 = Math.min(n9, rectangle.x);
            n10 = Math.max(n10, rectangle.x + rectangle.width);
            n8 += rectangle.height;
            this.renderer.disposeTextLayout(textLayout);
        }
        rectangle = new Rectangle(n9, n7, n10 - n9, n8);
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        return rectangle;
    }

    public String getTextRange(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        return this.content.getTextRange(n2, n3);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.getVerticalScrollOffset();
    }

    int getVerticalIncrement() {
        return this.renderer.getLineHeight();
    }

    int getVerticalScrollOffset() {
        if (this.verticalScrollOffset == -1) {
            this.renderer.calculate(0, this.topIndex);
            int n2 = 0;
            for (int i2 = 0; i2 < this.topIndex; ++i2) {
                n2 += this.renderer.getLineHeight(i2);
            }
            this.verticalScrollOffset = n2 -= this.topIndexY;
        }
        return this.verticalScrollOffset;
    }

    int getVisualLineIndex(TextLayout textLayout, int n2) {
        int n3 = textLayout.getLineIndex(n2);
        int[] nArray = textLayout.getLineOffsets();
        if (n3 != 0 && n2 == nArray[n3] && this.caretAlignment == 0) {
            --n3;
        }
        return n3;
    }

    int getCaretDirection() {
        if (!this.isBidiCaret()) {
            return -1;
        }
        if (!this.updateCaretDirection && this.caretDirection != 0) {
            return this.caretDirection;
        }
        this.updateCaretDirection = false;
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        String string = this.content.getLine(n2);
        int n4 = this.caretOffset - n3;
        int n5 = string.length();
        if (n5 == 0) {
            return this.isMirrored() ? 131072 : 16384;
        }
        if (this.caretAlignment == 0 && n4 > 0) {
            --n4;
        }
        if (n4 == n5 && n4 > 0) {
            --n4;
        }
        while (n4 > 0 && Character.isDigit(string.charAt(n4))) {
            --n4;
        }
        if (n4 == 0 && Character.isDigit(string.charAt(n4))) {
            return this.isMirrored() ? 131072 : 16384;
        }
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        int n6 = textLayout.getLevel(n4);
        this.renderer.disposeTextLayout(textLayout);
        return (n6 & 1) != 0 ? 131072 : 16384;
    }

    int getCaretLine() {
        return this.content.getLineAtOffset(this.caretOffset);
    }

    int getWrapWidth() {
        if (this.wordWrap && !this.isSingleLine()) {
            int n2 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            return n2 > 0 ? n2 : 1;
        }
        return -1;
    }

    int getWordEnd(int n2) {
        int n3;
        if (n2 >= this.getCharCount()) {
            return n2;
        }
        int n4 = this.content.getLineAtOffset(n2);
        int n5 = this.content.getOffsetAtLine(n4);
        if (n2 == n5 + (n3 = this.content.getLine(n4).length())) {
            n2 = this.content.getOffsetAtLine(n4 + 1);
        } else {
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            n2 -= n5;
            n2 = textLayout.getNextOffset(n2, 4);
            n2 += n5;
            this.renderer.disposeTextLayout(textLayout);
        }
        return n2;
    }

    int getWordEndNoSpaces(int n2) {
        String string;
        int n3;
        if (n2 >= this.getCharCount()) {
            return n2;
        }
        int n4 = this.content.getLineAtOffset(n2);
        int n5 = this.content.getOffsetAtLine(n4);
        if (n2 == n5 + (n3 = (string = this.content.getLine(n4)).length())) {
            n2 = this.content.getOffsetAtLine(++n4);
        } else {
            char c2 = string.charAt(n2 -= n5);
            boolean bl = Compatibility.isLetterOrDigit(c2);
            while (n2 < n3 - 1 && Compatibility.isLetterOrDigit(c2) == bl && !Compatibility.isSpaceChar(c2)) {
                c2 = string.charAt(++n2);
            }
            if (n2 == n3 - 1 && Compatibility.isLetterOrDigit(c2) == bl && !Compatibility.isSpaceChar(c2)) {
                ++n2;
            }
            n2 += n5;
        }
        return n2;
    }

    int getWordStart(int n2) {
        if (n2 <= 0) {
            return n2;
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        if (n2 == n4) {
            String string = this.content.getLine(--n3);
            n2 = this.content.getOffsetAtLine(n3) + string.length();
        } else {
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            n2 -= n4;
            n2 = textLayout.getPreviousOffset(n2, 4);
            n2 += n4;
            this.renderer.disposeTextLayout(textLayout);
        }
        return n2;
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    Point getPointAtOffset(int n2) {
        Point point;
        int n3 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n3);
        int n4 = this.content.getOffsetAtLine(n3);
        int n5 = n2 - n4;
        int n6 = string.length();
        if (n3 < this.content.getLineCount() - 1) {
            int n7 = this.content.getOffsetAtLine(n3 + 1) - 1;
            if (n6 < n5 && n5 <= n7) {
                n5 = n6;
            }
        }
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        if (n6 != 0 && n5 <= n6) {
            if (n5 == n6) {
                point = textLayout.getLocation(n5 - 1, true);
            } else {
                switch (this.caretAlignment) {
                    case 1: {
                        point = textLayout.getLocation(n5, false);
                        break;
                    }
                    default: {
                        if (n5 == 0) {
                            point = textLayout.getLocation(n5, false);
                            break;
                        }
                        point = textLayout.getLocation(n5 - 1, true);
                        break;
                    }
                }
            }
        } else {
            point = new Point(textLayout.getIndent(), 0);
        }
        this.renderer.disposeTextLayout(textLayout);
        point.x += this.leftMargin - this.horizontalScrollOffset;
        point.y += this.getLinePixel(n3);
        return point;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Point point = this.getSelectionRange();
        this.replaceTextRange(point.x, point.y, string);
    }

    void installDefaultContent() {
        this.textChangeListener = new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
                StyledText.this.handleTextChanging(event);
            }

            public void textChanged(TextChangedEvent event) {
                StyledText.this.handleTextChanged(event);
            }

            public void textSet(TextChangedEvent event) {
                StyledText.this.handleTextSet(event);
            }
        };
        this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installListeners() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        StyledText.this.handleDispose(event);
                        break;
                    }
                    case 29: {
                        StyledText.this.handleDragDetect(event);
                        break;
                    }
                    case 1: {
                        StyledText.this.handleKeyDown(event);
                        break;
                    }
                    case 2: {
                        StyledText.this.handleKeyUp(event);
                        break;
                    }
                    case 3: {
                        StyledText.this.handleMouseDown(event);
                        break;
                    }
                    case 4: {
                        StyledText.this.handleMouseUp(event);
                        break;
                    }
                    case 8: {
                        StyledText.this.handleMouseDoubleClick(event);
                        break;
                    }
                    case 5: {
                        StyledText.this.handleMouseMove(event);
                        break;
                    }
                    case 9: {
                        StyledText.this.handlePaint(event);
                        break;
                    }
                    case 11: {
                        StyledText.this.handleResize(event);
                        break;
                    }
                    case 31: {
                        StyledText.this.handleTraverse(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(1, this.listener);
        this.addListener(2, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(8, this.listener);
        this.addListener(5, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(31, this.listener);
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleVerticalScroll(event);
                }
            });
        }
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleHorizontalScroll(event);
                }
            });
        }
    }

    void internalRedrawRange(int n2, int n3) {
        int n4;
        Rectangle rectangle;
        if (n3 <= 0) {
            return;
        }
        int n5 = n2 + n3;
        int n6 = this.content.getLineAtOffset(n2);
        int n7 = this.content.getLineAtOffset(n5);
        int n8 = this.getPartialBottomIndex();
        int n9 = this.getPartialTopIndex();
        if (n6 > n8 || n7 < n9) {
            return;
        }
        if (n9 > n6) {
            n6 = n9;
            n2 = 0;
        } else {
            n2 -= this.content.getOffsetAtLine(n6);
        }
        if (n8 < n7) {
            n7 = n8 + 1;
            n5 = 0;
        } else {
            n5 -= this.content.getOffsetAtLine(n7);
        }
        TextLayout textLayout = this.renderer.getTextLayout(n6);
        int n10 = this.leftMargin - this.horizontalScrollOffset;
        int n11 = this.getLinePixel(n6);
        int[] nArray = textLayout.getLineOffsets();
        int n12 = textLayout.getLineIndex(Math.min(n2, textLayout.getText().length()));
        if (this.wordWrap && n12 > 0 && nArray[n12] == n2) {
            rectangle = textLayout.getLineBounds(n12 - 1);
            rectangle.x = rectangle.width;
            rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
            rectangle.x += n10;
            rectangle.y += n11;
            super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
        if (n6 == n7 && n12 == (n4 = textLayout.getLineIndex(Math.min(n5, textLayout.getText().length())))) {
            Rectangle rectangle2 = textLayout.getBounds(n2, n5 - 1);
            rectangle2.x += n10;
            rectangle2.y += n11;
            super.redraw(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
            this.renderer.disposeTextLayout(textLayout);
            return;
        }
        rectangle = textLayout.getBounds(n2, nArray[n12 + 1] - 1);
        if (rectangle.height == 0) {
            Rectangle rectangle3 = textLayout.getLineBounds(n12);
            rectangle.x = rectangle3.width;
            rectangle.y = rectangle3.y;
            rectangle.height = rectangle3.height;
        }
        rectangle.x += n10;
        rectangle.y += n11;
        rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
        super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        if (n6 != n7) {
            this.renderer.disposeTextLayout(textLayout);
            textLayout = this.renderer.getTextLayout(n7);
            nArray = textLayout.getLineOffsets();
        }
        int n13 = textLayout.getLineIndex(Math.min(n5, textLayout.getText().length()));
        Rectangle rectangle4 = textLayout.getBounds(nArray[n13], n5 - 1);
        if (rectangle4.height == 0) {
            Rectangle rectangle5 = textLayout.getLineBounds(n13);
            rectangle4.y = rectangle5.y;
            rectangle4.height = rectangle5.height;
        }
        rectangle4.x += n10;
        rectangle4.y += this.getLinePixel(n7);
        super.redraw(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, false);
        this.renderer.disposeTextLayout(textLayout);
        int n14 = rectangle.y + rectangle.height;
        if (rectangle4.y > n14) {
            super.redraw(this.leftMargin, n14, this.clientAreaWidth - this.rightMargin - this.leftMargin, rectangle4.y - n14, false);
        }
    }

    void handleDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.clipboard.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
            this.content = null;
        }
        if (this.defaultCaret != null) {
            this.defaultCaret.dispose();
            this.defaultCaret = null;
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.isBidiCaret()) {
            BidiUtil.removeLanguageListener(this.handle);
        }
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.textChangeListener = null;
        this.selection = null;
        this.doubleClickSelection = null;
        this.keyActionMap = null;
        this.background = null;
        this.foreground = null;
        this.clipboard = null;
    }

    void handleDragDetect(Event event) {
        this.dragging = true;
    }

    void handleHorizontalScroll(Event event) {
        int n2 = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(n2, false);
    }

    void handleKey(Event event) {
        int n2;
        int n3;
        this.caretAlignment = 0;
        if (event.keyCode != 0) {
            n3 = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            n3 = this.getKeyBinding(event.character | event.stateMask);
            if (n3 == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                n2 = event.character + 64;
                n3 = this.getKeyBinding(n2 | event.stateMask);
            }
        }
        if (n3 == 0) {
            n2 = 0;
            if (IS_CARBON) {
                n2 = (event.stateMask ^ 0x400000) == 0 || (event.stateMask ^ 0x420000) == 0 ? 1 : 0;
            } else if (IS_MOTIF) {
                n2 = (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x60000) == 0 ? 1 : 0;
            } else {
                int n4 = n2 = (event.stateMask ^ 0x10000) == 0 || (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x30000) == 0 || (event.stateMask ^ 0x60000) == 0 ? 1 : 0;
            }
            if (n2 == 0 && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
                this.update();
            }
        } else {
            this.invokeAction(n3);
        }
    }

    void handleKeyDown(Event event) {
        if (this.clipboardSelection == null) {
            this.clipboardSelection = new Point(this.selection.x, this.selection.y);
        }
        Event event2 = new Event();
        event2.character = event.character;
        event2.keyCode = event.keyCode;
        event2.stateMask = event.stateMask;
        event2.doit = true;
        this.notifyListeners(3005, event2);
        if (event2.doit) {
            this.handleKey(event);
        }
    }

    void handleKeyUp(Event event) {
        block4: {
            if (this.clipboardSelection != null && (this.clipboardSelection.x != this.selection.x || this.clipboardSelection.y != this.selection.y)) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
        this.clipboardSelection = null;
    }

    void handleMouseDoubleClick(Event event) {
        if (event.button != 1 || !this.doubleClickEnabled) {
            return;
        }
        this.mouseDoubleClick = true;
        this.caretOffset = this.getWordStart(this.caretOffset);
        this.resetSelection();
        this.caretOffset = this.getWordEndNoSpaces(this.caretOffset);
        this.showCaret();
        this.doMouseSelection();
        this.doubleClickSelection = new Point(this.selection.x, this.selection.y);
    }

    void handleMouseDown(Event event) {
        String string;
        this.mouseDoubleClick = false;
        this.forceFocus();
        this.dragging = false;
        this.removeListener(29, this.listener);
        this.dragDetect = this.detectDrag(event.x, event.y, event.button);
        if (this.dragDetect) {
            this.addListener(29, this.listener);
            return;
        }
        this.mouseDown = true;
        if (event.button == 2 && (string = (String)this.getClipboardContent(2)) != null && string.length() > 0) {
            this.doMouseLocationChange(event.x, event.y, false);
            Event event2 = new Event();
            event2.start = this.selection.x;
            event2.end = this.selection.y;
            event2.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event2);
        }
        if (event.button != 1 || IS_CARBON && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        boolean bl = (event.stateMask & SWT.MOD2) != 0;
        this.doMouseLocationChange(event.x, event.y, bl);
    }

    void handleMouseMove(Event event) {
        if (!this.mouseDown) {
            return;
        }
        if ((event.stateMask & 0x80000) == 0) {
            return;
        }
        this.doMouseLocationChange(event.x, event.y, true);
        this.update();
        this.doAutoScroll(event);
    }

    void handleMouseUp(Event event) {
        block6: {
            this.mouseDown = false;
            this.mouseDoubleClick = false;
            this.endAutoScroll();
            if (this.dragDetect) {
                this.removeListener(29, this.listener);
                if (!this.dragging) {
                    boolean bl = (event.stateMask & SWT.MOD2) != 0;
                    this.doMouseLocationChange(event.x, event.y, bl);
                }
            }
            this.dragging = false;
            this.dragDetect = false;
            if (event.button == 1) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block6;
                    throw sWTError;
                }
            }
        }
    }

    void handlePaint(Event event) {
        if (event.width == 0 || event.height == 0) {
            return;
        }
        if (this.clientAreaWidth == 0 || this.clientAreaHeight == 0) {
            return;
        }
        int n2 = this.getLineIndex(event.y);
        int n3 = this.getLinePixel(n2);
        int n4 = event.y + event.height;
        GC gC = event.gc;
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (n4 > 0) {
            int n5 = this.isSingleLine() ? 1 : this.content.getLineCount();
            int n6 = this.leftMargin - this.horizontalScrollOffset;
            for (int i2 = n2; n3 < n4 && i2 < n5; n3 += this.renderer.drawLine(i2, n6, n3, gC, color, color2), ++i2) {
            }
            if (n3 < n4) {
                gC.setBackground(color);
                this.drawBackground(gC, 0, n3, this.clientAreaWidth, n4 - n3);
            }
        }
        gC.setBackground(color);
        if (this.topMargin > 0) {
            this.drawBackground(gC, 0, 0, this.clientAreaWidth, this.topMargin);
        }
        if (this.bottomMargin > 0) {
            this.drawBackground(gC, 0, this.clientAreaHeight - this.bottomMargin, this.clientAreaWidth, this.bottomMargin);
        }
        if (this.leftMargin > 0) {
            this.drawBackground(gC, 0, 0, this.leftMargin, this.clientAreaHeight);
        }
        if (this.rightMargin > 0) {
            this.drawBackground(gC, this.clientAreaWidth - this.rightMargin, 0, this.rightMargin, this.clientAreaHeight);
        }
    }

    void handleResize(Event event) {
        int n2;
        int n3 = this.clientAreaHeight;
        int n4 = this.clientAreaWidth;
        Rectangle rectangle = this.getClientArea();
        this.clientAreaHeight = rectangle.height;
        this.clientAreaWidth = rectangle.width;
        if (n4 != this.clientAreaWidth && this.rightMargin > 0) {
            n2 = (n4 < this.clientAreaWidth ? n4 : this.clientAreaWidth) - this.rightMargin;
            super.redraw(n2, 0, this.rightMargin, n3, false);
        }
        if (n3 != this.clientAreaHeight && this.bottomMargin > 0) {
            n2 = (n3 < this.clientAreaHeight ? n3 : this.clientAreaHeight) - this.bottomMargin;
            super.redraw(0, n2, n4, this.bottomMargin, false);
        }
        if (this.wordWrap) {
            if (n4 != this.clientAreaWidth) {
                this.renderer.reset(0, this.content.getLineCount());
                this.verticalScrollOffset = -1;
                this.renderer.calculateIdle();
                super.redraw();
            }
            if (n3 != this.clientAreaHeight) {
                if (n3 == 0) {
                    this.topIndexY = 0;
                }
                this.setScrollBars(true);
            }
            this.setCaretLocation();
        } else {
            this.renderer.calculateClientArea();
            this.setScrollBars(true);
            this.claimRightFreeSpace();
        }
        this.claimBottomFreeSpace();
    }

    void handleTextChanged(TextChangedEvent textChangedEvent) {
        int n2 = this.content.getLineAtOffset(this.lastTextChangeStart);
        this.resetCache(n2, 0);
        if (!this.isFixedLineHeight() && this.topIndex > n2) {
            this.topIndex = n2;
            this.topIndexY = 0;
            super.redraw();
        } else {
            int n3 = n2 + this.lastTextChangeNewLineCount;
            int n4 = this.getLinePixel(n2);
            int n5 = this.getLinePixel(n3 + 1);
            if (this.lastLineBottom != n5) {
                this.scrollText(this.lastLineBottom, n5);
                if (this.wordWrap) {
                    this.setCaretLocation();
                }
            }
            super.redraw(0, n4, this.clientAreaWidth, n5 - n4, false);
            this.redrawLinesBullet(this.renderer.redrawLines);
        }
        this.renderer.redrawLines = null;
        this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        if (this.lastTextChangeReplaceLineCount > 0 || this.wordWrap) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
    }

    void handleTextChanging(TextChangingEvent textChangingEvent) {
        int n2;
        if (textChangingEvent.replaceCharCount < 0) {
            textChangingEvent.start += textChangingEvent.replaceCharCount;
            textChangingEvent.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = textChangingEvent.start;
        this.lastTextChangeNewLineCount = textChangingEvent.newLineCount;
        this.lastTextChangeNewCharCount = textChangingEvent.newCharCount;
        this.lastTextChangeReplaceLineCount = textChangingEvent.replaceLineCount;
        this.lastTextChangeReplaceCharCount = textChangingEvent.replaceCharCount;
        int n3 = this.content.getLineAtOffset(textChangingEvent.start);
        int n4 = this.getLinePixel(n3 + textChangingEvent.replaceLineCount + 1);
        this.lastLineBottom = n2 = this.getLinePixel(n3 + 1) + textChangingEvent.newLineCount * this.renderer.getLineHeight();
        this.scrollText(n4, n2);
        this.renderer.textChanging(textChangingEvent);
        int n5 = this.content.getCharCount() - textChangingEvent.replaceCharCount + textChangingEvent.newCharCount;
        if (this.caretOffset > n5) {
            this.caretOffset = n5;
        }
    }

    void handleTextSet(TextChangedEvent textChangedEvent) {
        this.reset();
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                if ((this.getStyle() & 4) != 0) {
                    event.doit = true;
                    break;
                }
                if (this.editable && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                event.doit = true;
            }
        }
    }

    void handleVerticalScroll(Event event) {
        int n2 = this.getVerticalBar().getSelection() - this.getVerticalScrollOffset();
        this.scrollVertical(n2, false);
    }

    void initializeAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e2) {
                String name = null;
                Label label = StyledText.this.getAssociatedLabel();
                if (label != null) {
                    name = StyledText.this.stripMnemonic(label.getText());
                }
                e2.result = name;
            }

            public void getHelp(AccessibleEvent e2) {
                e2.result = StyledText.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent e2) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = StyledText.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = StyledText.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e2.result = shortcut;
            }
        });
        accessible.addAccessibleTextListener(new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e2) {
                e2.offset = StyledText.this.getCaretOffset();
            }

            public void getSelectionRange(AccessibleTextEvent e2) {
                Point selection = StyledText.this.getSelectionRange();
                e2.offset = selection.x;
                e2.length = selection.y;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e2) {
                e2.detail = 42;
            }

            public void getState(AccessibleControlEvent e2) {
                int state = 0;
                if (StyledText.this.isEnabled()) {
                    state |= 0x100000;
                }
                if (StyledText.this.isFocusControl()) {
                    state |= 4;
                }
                if (!StyledText.this.isVisible()) {
                    state |= 0x8000;
                }
                if (!StyledText.this.getEditable()) {
                    state |= 0x40;
                }
                e2.detail = state;
            }

            public void getValue(AccessibleControlEvent e2) {
                e2.result = StyledText.this.getText();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    Label getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if (controlArray[i2] != this || i2 <= 0 || !(controlArray[i2 - 1] instanceof Label)) continue;
            return (Label)controlArray[i2 - 1];
        }
        return null;
    }

    String stripMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return string;
            }
            if (string.charAt(n2) != '&') {
                return string.substring(0, n2 - 1) + string.substring(n2, n3);
            }
            if (++n2 >= n3) break;
        }
        return string;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    public void invokeAction(int n2) {
        this.checkWidget();
        this.updateCaretDirection = true;
        switch (n2) {
            case 0x1000001: {
                this.doLineUp(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                this.doLineDown(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp(false, -1);
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false, -1);
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doSelectionLineUp();
                break;
            }
            case 262209: {
                this.selectAll();
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(0x1000003);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(0x1000004);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp(-1);
                break;
            }
            case 16908294: {
                this.doSelectionPageDown(-1);
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(0x1000004);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(0x1000003);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(0x1000003);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 262152: {
                this.doDeleteWordPrevious();
                break;
            }
            case 262271: {
                this.doDeleteWordNext();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
            }
        }
    }

    boolean isBidi() {
        return IS_GTK || BidiUtil.isBidiPlatform() || this.isMirrored;
    }

    boolean isBidiCaret() {
        return BidiUtil.isBidiPlatform();
    }

    boolean isFixedLineHeight() {
        return this.fixedLineHeight;
    }

    boolean isLineDelimiter(int n2) {
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        int n5 = n2 - n4;
        return n5 > this.content.getLine(n3).length();
    }

    boolean isMirrored() {
        return this.isMirrored;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    void modifyContent(Event event, boolean bl) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int n2 = event.end - event.start;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, n2);
            }
            if (bl && event.text.length() == 0) {
                int n3 = this.content.getLineAtOffset(event.start);
                int n4 = this.content.getOffsetAtLine(n3);
                TextLayout textLayout = this.renderer.getTextLayout(n3);
                int n5 = textLayout.getLevel(event.start - n4);
                int n6 = this.content.getLineAtOffset(event.end);
                if (n3 != n6) {
                    this.renderer.disposeTextLayout(textLayout);
                    n4 = this.content.getOffsetAtLine(n6);
                    textLayout = this.renderer.getTextLayout(n6);
                }
                int n7 = textLayout.getLevel(event.end - n4);
                this.renderer.disposeTextLayout(textLayout);
                this.caretAlignment = n5 != n7 ? 0 : 1;
            }
            this.content.replaceTextRange(event.start, n2, event.text);
            if (bl) {
                this.setSelection(event.start + event.text.length(), 0, true);
                this.showCaret();
            }
            this.sendModifyEvent(event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    void paintObject(GC gC, int n2, int n3, int n4, int n5, StyleRange styleRange, Bullet bullet, int n6) {
        if (this.isListening(3008)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.gc = gC;
            styledTextEvent.x = n2;
            styledTextEvent.y = n3;
            styledTextEvent.ascent = n4;
            styledTextEvent.descent = n5;
            styledTextEvent.style = styleRange;
            styledTextEvent.bullet = bullet;
            styledTextEvent.bulletIndex = n6;
            this.notifyListeners(3008, styledTextEvent);
        }
    }

    public void paste() {
        this.checkWidget();
        String string = (String)this.getClipboardContent(1);
        if (string != null && string.length() > 0) {
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event);
        }
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        new Printing(this, printer, styledTextPrintOptions).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        this.checkWidget();
        if (printer == null) {
            SWT.error(4);
        }
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        return this.print(printer, styledTextPrintOptions);
    }

    public Runnable print(Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
        this.checkWidget();
        if (printer == null || styledTextPrintOptions == null) {
            SWT.error(4);
        }
        return new Printing(this, printer, styledTextPrintOptions);
    }

    public void redraw() {
        super.redraw();
        int n2 = this.getPartialBottomIndex() - this.topIndex + 1;
        this.renderer.reset(this.topIndex, n2);
        this.renderer.calculate(this.topIndex, n2);
        this.setScrollBars(false);
    }

    public void redraw(int n2, int n3, int n4, int n5, boolean bl) {
        super.redraw(n2, n3, n4, n5, bl);
        if (n5 > 0) {
            int n6 = this.getLineIndex(n3);
            int n7 = this.getLineIndex(n3 + n5);
            this.resetCache(n6, n7 - n6 + 1);
        }
    }

    void redrawLines(int n2, int n3) {
        int n4 = this.getPartialBottomIndex();
        if (n2 > n4 || n2 + n3 - 1 < this.topIndex) {
            return;
        }
        if (n2 < this.topIndex) {
            n3 -= this.topIndex - n2;
            n2 = this.topIndex;
        }
        if (n2 + n3 - 1 > n4) {
            n3 = n4 - n2 + 1;
        }
        int n5 = this.getLinePixel(n2 -= this.topIndex);
        int n6 = this.getLinePixel(n2 + n3);
        int n7 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        super.redraw(this.leftMargin, n5, n7, n6 - n5, true);
    }

    void redrawLinesBullet(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n2 = this.getPartialTopIndex();
        int n3 = this.getPartialBottomIndex();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n4 = nArray[i2];
            if (n2 > n4 || n4 > n3) continue;
            int n5 = -1;
            Bullet bullet = this.renderer.getLineBullet(n4, null);
            if (bullet != null) {
                StyleRange styleRange = bullet.style;
                GlyphMetrics glyphMetrics = styleRange.metrics;
                n5 = glyphMetrics.width;
            }
            if (n5 == -1) {
                n5 = this.getClientArea().width;
            }
            int n6 = this.renderer.getLineHeight(n4);
            int n7 = this.getLinePixel(n4);
            super.redraw(0, n7, n5, n6, false);
        }
    }

    public void redrawRange(int n2, int n3, boolean bl) {
        this.checkWidget();
        int n4 = n2 + n3;
        int n5 = this.content.getCharCount();
        if (n2 > n4 || n2 < 0 || n4 > n5) {
            SWT.error(6);
        }
        int n6 = this.content.getLineAtOffset(n2);
        int n7 = this.content.getLineAtOffset(n4);
        this.resetCache(n6, n7 - n6 + 1);
        this.internalRedrawRange(n2, n3);
    }

    public void removeBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.removeListener(3007, bidiSegmentListener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3000, extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        this.removeListener(3001, lineBackgroundListener);
    }

    public void removeLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        this.removeListener(3002, lineStyleListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removePaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.removeListener(3008, paintObjectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3005, verifyKeyListener);
    }

    public void replaceStyleRanges(int n2, int n3, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(n2, n3, null, styleRangeArray, false);
    }

    public void replaceTextRange(int n2, int n3, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        Event event = new Event();
        event.start = n2;
        event.end = n5;
        event.text = string;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.caretOffset = 0;
        this.topIndex = 0;
        this.topIndexY = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        this.renderer.setContent(this.content);
        if (scrollBar != null) {
            scrollBar.setSelection(0);
        }
        if (scrollBar2 != null) {
            scrollBar2.setSelection(0);
        }
        this.resetCache(0, 0);
        this.setCaretLocation();
        super.redraw();
    }

    void resetCache(int n2, int n3) {
        this.renderer.reset(n2, n3);
        this.renderer.calculateClientArea();
        this.setScrollBars(true);
        if (!this.isFixedLineHeight()) {
            if (this.topIndex > n2) {
                this.verticalScrollOffset = -1;
            }
            this.renderer.calculateIdle();
        }
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
    }

    public void scroll(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        super.scroll(n2, n3, n4, n5, n6, n7, false);
        if (bl) {
            int n8 = n2 - n4;
            int n9 = n3 - n5;
            Control[] controlArray = this.getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control = controlArray[i2];
                Rectangle rectangle = control.getBounds();
                control.setLocation(rectangle.x + n8, rectangle.y + n9);
            }
        }
    }

    boolean scrollHorizontal(int n2, boolean bl) {
        int n3;
        if (n2 == 0) {
            return false;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null && bl) {
            scrollBar.setSelection(this.horizontalScrollOffset + n2);
        }
        int n4 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n2 > 0) {
            n3 = this.leftMargin + n2;
            int n5 = this.clientAreaWidth - n3 - this.rightMargin;
            if (n5 > 0) {
                this.scroll(this.leftMargin, this.topMargin, n3, this.topMargin, n5, n4, true);
            }
            if (n3 > n5) {
                super.redraw(this.leftMargin + n5, this.topMargin, n2 - n5, n4, true);
            }
        } else {
            n3 = this.leftMargin - n2;
            int n6 = this.clientAreaWidth - n3 - this.rightMargin;
            if (n6 > 0) {
                this.scroll(n3, this.topMargin, this.leftMargin, this.topMargin, n6, n4, true);
            }
            if (n3 > n6) {
                super.redraw(this.leftMargin + n6, this.topMargin, -n2 - n6, n4, true);
            }
        }
        this.horizontalScrollOffset += n2;
        n3 = this.columnX;
        this.setCaretLocation();
        this.columnX = n3;
        return true;
    }

    boolean scrollVertical(int n2, boolean bl) {
        if (n2 == 0) {
            return false;
        }
        if (this.verticalScrollOffset != -1) {
            ScrollBar scrollBar = this.getVerticalBar();
            if (scrollBar != null && bl) {
                scrollBar.setSelection(this.verticalScrollOffset + n2);
            }
            int n3 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            if (n2 > 0) {
                int n4 = this.topMargin + n2;
                int n5 = this.clientAreaHeight - n4 - this.bottomMargin;
                if (n5 > 0) {
                    this.scroll(this.leftMargin, this.topMargin, this.leftMargin, n4, n3, n5, true);
                }
                if (n4 > n5) {
                    int n6 = Math.max(0, this.topMargin + n5);
                    int n7 = Math.min(this.clientAreaHeight, n2 - n5);
                    super.redraw(this.leftMargin, n6, n3, n7, true);
                }
            } else {
                int n8 = this.topMargin - n2;
                int n9 = this.clientAreaHeight - n8 - this.bottomMargin;
                if (n9 > 0) {
                    this.scroll(this.leftMargin, n8, this.leftMargin, this.topMargin, n3, n9, true);
                }
                if (n8 > n9) {
                    int n10 = Math.max(0, this.topMargin + n9);
                    int n11 = Math.min(this.clientAreaHeight, -n2 - n9);
                    super.redraw(this.leftMargin, n10, n3, n11, true);
                }
            }
            this.verticalScrollOffset += n2;
            this.calculateTopIndex(n2);
        } else {
            this.calculateTopIndex(n2);
            super.redraw();
        }
        int n12 = this.columnX;
        this.setCaretLocation();
        this.columnX = n12;
        return true;
    }

    void scrollText(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = n3 - n2;
        int n5 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n6 = n4 > 0 ? this.clientAreaHeight - n2 - this.bottomMargin : this.clientAreaHeight - n3 - this.bottomMargin;
        this.scroll(this.leftMargin, n3, this.leftMargin, n2, n5, n6, true);
        if (0 < n2 + n6 && this.topMargin > n2) {
            super.redraw(this.leftMargin, n4, n5, this.topMargin, false);
        }
        if (0 < n3 + n6 && this.topMargin > n3) {
            super.redraw(this.leftMargin, 0, n5, this.topMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n2 + n6 && this.clientAreaHeight > n2) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin + n4, n5, this.bottomMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n3 + n6 && this.clientAreaHeight > n3) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin, n5, this.bottomMargin, false);
        }
    }

    public void selectAll() {
        this.checkWidget();
        this.setSelection(0, Math.max(this.getCharCount(), 0));
    }

    void sendKeyEvent(Event event) {
        if (this.editable) {
            this.modifyContent(event, true);
        }
    }

    StyledTextEvent sendLineEvent(int n2, int n3, String string) {
        StyledTextEvent styledTextEvent = null;
        if (this.isListening(n2)) {
            styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n3;
            styledTextEvent.text = string;
            styledTextEvent.alignment = this.alignment;
            styledTextEvent.indent = this.indent;
            styledTextEvent.justify = this.justify;
            this.notifyListeners(n2, styledTextEvent);
        }
        return styledTextEvent;
    }

    void sendModifyEvent(Event event) {
        Accessible accessible = this.getAccessible();
        if (event.text.length() == 0) {
            accessible.textChanged(1, event.start, event.end - event.start);
        } else if (event.start == event.end) {
            accessible.textChanged(0, event.start, event.text.length());
        } else {
            accessible.textChanged(1, event.start, event.end - event.start);
            accessible.textChanged(0, event.start, event.text.length());
        }
        this.notifyListeners(24, event);
    }

    void sendSelectionEvent() {
        this.getAccessible().textSelectionChanged();
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((n2 &= 0x1024000) == 0 || this.alignment == n2) {
            return;
        }
        this.alignment = n2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        super.redraw();
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        this.caretDirection = 0;
        if (caret != null) {
            this.setCaretLocation();
        }
    }

    public void setBidiColoring(boolean bl) {
        this.checkWidget();
        this.bidiColoring = bl;
    }

    void setCaretLocation() {
        Point point = this.getPointAtOffset(this.caretOffset);
        this.setCaretLocation(point, this.getCaretDirection());
    }

    void setCaretLocation(Point point, int n2) {
        Caret caret = this.getCaret();
        if (caret != null) {
            int n3;
            boolean bl = caret == this.defaultCaret;
            int n4 = n3 = this.renderer.getLineHeight();
            if (!this.isFixedLineHeight() && bl && (n4 = this.getBoundsAtOffset((int)this.caretOffset).height) != n3) {
                n2 = -1;
            }
            int n5 = n2;
            if (this.isMirrored()) {
                if (n5 == 16384) {
                    n5 = 131072;
                } else if (n5 == 131072) {
                    n5 = 16384;
                }
            }
            if (bl && n5 == 131072) {
                point.x -= caret.getSize().x - 1;
            }
            if (bl) {
                caret.setBounds(point.x, point.y, 0, n4);
            } else {
                caret.setLocation(point);
            }
            this.getAccessible().textCaretMoved(this.getCaretOffset());
            if (n2 != this.caretDirection) {
                this.caretDirection = n2;
                if (bl) {
                    if (n5 == -1) {
                        this.defaultCaret.setImage(null);
                    } else if (n5 == 16384) {
                        this.defaultCaret.setImage(this.leftCaretBitmap);
                    } else if (n5 == 131072) {
                        this.defaultCaret.setImage(this.rightCaretBitmap);
                    }
                }
                if (this.caretDirection == 16384) {
                    BidiUtil.setKeyboardLanguage(0);
                } else if (this.caretDirection == 131072) {
                    BidiUtil.setKeyboardLanguage(1);
                }
            }
        }
        this.columnX = point.x;
    }

    public void setCaretOffset(int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n3 > 0 && n2 != this.caretOffset) {
            if (n2 < 0) {
                this.caretOffset = 0;
            } else if (n2 > n3) {
                this.caretOffset = n3;
            } else {
                if (this.isLineDelimiter(n2)) {
                    SWT.error(5);
                }
                this.caretOffset = n2;
            }
            this.clearSelection(false);
        }
        this.setCaretLocation();
    }

    void setClipboardContent(int n2, int n3, int n4) throws SWTError {
        Transfer[] transferArray;
        Object[] objectArray;
        if (n4 == 2 && !IS_MOTIF && !IS_GTK) {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        TextWriter textWriter = new TextWriter(n2, n3);
        String string = this.getPlatformDelimitedText(textWriter);
        if (n4 == 2) {
            objectArray = new Object[]{string};
            transferArray = new Transfer[]{textTransfer};
        } else {
            RTFTransfer rTFTransfer = RTFTransfer.getInstance();
            RTFWriter rTFWriter = new RTFWriter(n2, n3);
            String string2 = this.getPlatformDelimitedText(rTFWriter);
            objectArray = new Object[]{string2, string};
            transferArray = new Transfer[]{rTFTransfer, textTransfer};
        }
        this.clipboard.setContents(objectArray, transferArray, n4);
    }

    public void setContent(StyledTextContent styledTextContent) {
        this.checkWidget();
        if (styledTextContent == null) {
            SWT.error(4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.content = styledTextContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            Display display = this.getDisplay();
            super.setCursor(display.getSystemCursor(19));
        } else {
            super.setCursor(cursor);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClickEnabled = bl;
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.editable = bl;
    }

    public void setFont(Font font) {
        int n2;
        this.checkWidget();
        int n3 = this.renderer.getLineHeight();
        super.setFont(font);
        this.renderer.setFont(this.getFont(), this.tabLength);
        if (this.isFixedLineHeight() && (n2 = this.renderer.getLineHeight()) != n3) {
            int n4 = this.getVerticalScrollOffset() * n2 / n3 - this.getVerticalScrollOffset();
            this.scrollVertical(n4, true);
        }
        this.resetCache(0, this.content.getLineCount());
        this.claimBottomFreeSpace();
        this.calculateScrollBars();
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
        }
        this.caretDirection = 0;
        this.setCaretLocation();
        super.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        super.setForeground(this.getForeground());
        super.redraw();
    }

    public void setHorizontalIndex(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.clientAreaWidth > 0 && (n2 *= this.getHorizontalIncrement()) > (n3 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n2 = Math.max(0, n3 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
    }

    public void setHorizontalPixel(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.clientAreaWidth > 0 && n2 > (n3 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n2 = Math.max(0, n3 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
    }

    public void setIndent(int n2) {
        this.checkWidget();
        if (this.indent == n2 || n2 < 0) {
            return;
        }
        this.indent = n2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setJustify(boolean bl) {
        this.checkWidget();
        if (this.justify == bl) {
            return;
        }
        this.justify = bl;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setKeyBinding(int n2, int n3) {
        this.checkWidget();
        int n4 = n2 & SWT.MODIFIER_MASK;
        char c2 = (char)(n2 & 0x100FFFF);
        if (Compatibility.isLetter(c2)) {
            char c3 = Character.toUpperCase(c2);
            int n5 = c3 | n4;
            if (n3 == 0) {
                this.keyActionMap.remove(new Integer(n5));
            } else {
                this.keyActionMap.put(new Integer(n5), new Integer(n3));
            }
            c3 = Character.toLowerCase(c2);
            n5 = c3 | n4;
            if (n3 == 0) {
                this.keyActionMap.remove(new Integer(n5));
            } else {
                this.keyActionMap.put(new Integer(n5), new Integer(n3));
            }
        } else if (n3 == 0) {
            this.keyActionMap.remove(new Integer(n2));
        } else {
            this.keyActionMap.put(new Integer(n2), new Integer(n3));
        }
    }

    public void setLineAlignment(int n2, int n3, int n4) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineAlignment(n2, n3, n4);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n5 = this.getCaretLine();
        if (n2 <= n5 && n5 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineBackground(int n2, int n3, Color color) {
        this.checkWidget();
        if (this.isListening(3001)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (color != null) {
            this.renderer.setLineBackground(n2, n3, color);
        } else {
            this.renderer.clearLineBackground(n2, n3);
        }
        this.redrawLines(n2, n3);
    }

    public void setLineBullet(int n2, int n3, Bullet bullet) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineBullet(n2, n3, bullet);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n4 = this.getCaretLine();
        if (n2 <= n4 && n4 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    void setVariableLineHeight() {
        if (!this.fixedLineHeight) {
            return;
        }
        this.fixedLineHeight = false;
        this.renderer.calculateIdle();
    }

    public void setLineIndent(int n2, int n3, int n4) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineIndent(n2, n3, n4);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n5 = this.getCaretLine();
        if (n2 <= n5 && n5 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineJustify(int n2, int n3, boolean bl) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineJustify(n2, n3, bl);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3);
        int n4 = this.getCaretLine();
        if (n2 <= n4 && n4 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineSpacing(int n2) {
        this.checkWidget();
        if (this.lineSpacing == n2 || n2 < 0) {
            return;
        }
        this.lineSpacing = n2;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    void setMargins(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        this.leftMargin = n2;
        this.topMargin = n3;
        this.rightMargin = n4;
        this.bottomMargin = n5;
        this.setCaretLocation();
    }

    void setMouseWordSelectionAnchor() {
        if (this.mouseDoubleClick) {
            if (this.caretOffset < this.doubleClickSelection.x) {
                this.selectionAnchor = this.doubleClickSelection.y;
            } else if (this.caretOffset > this.doubleClickSelection.y) {
                this.selectionAnchor = this.doubleClickSelection.x;
            }
        }
    }

    public void setOrientation(int n2) {
        if ((n2 & 0x6000000) == 0) {
            return;
        }
        if ((n2 & 0x4000000) != 0 && (n2 & 0x2000000) != 0) {
            return;
        }
        if ((n2 & 0x4000000) != 0 && this.isMirrored()) {
            return;
        }
        if ((n2 & 0x2000000) != 0 && !this.isMirrored()) {
            return;
        }
        if (!BidiUtil.setOrientation(this.handle, n2)) {
            return;
        }
        this.isMirrored = (n2 & 0x4000000) != 0;
        this.caretDirection = 0;
        this.setCaretLocation();
        this.keyActionMap.clear();
        this.createKeyBindings();
        super.redraw();
    }

    void setScrollBars(boolean bl) {
        int n2;
        ScrollBar scrollBar;
        int n3 = 1;
        if ((bl || !this.isFixedLineHeight()) && (scrollBar = this.getVerticalBar()) != null) {
            n2 = this.renderer.getHeight();
            if (this.clientAreaHeight < n2) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n2, this.clientAreaHeight, scrollBar.getIncrement(), this.clientAreaHeight);
            } else if (scrollBar.getThumb() != n3 || scrollBar.getMaximum() != n3) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n3, n3, scrollBar.getIncrement(), n3);
            }
        }
        if ((scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible()) {
            n2 = this.renderer.getWidth();
            if (this.clientAreaWidth < n2) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n2, this.clientAreaWidth - this.leftMargin - this.rightMargin, scrollBar.getIncrement(), this.clientAreaWidth - this.leftMargin - this.rightMargin);
            } else if (scrollBar.getThumb() != n3 || scrollBar.getMaximum() != n3) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n3, n3, scrollBar.getIncrement(), n3);
            }
        }
    }

    public void setSelection(int n2) {
        this.setSelection(n2, n2);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionBackground = color;
        super.redraw();
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionForeground = color;
        super.redraw();
    }

    public void setSelection(int n2, int n3) {
        this.setSelectionRange(n2, n3 - n2);
        this.showSelection();
    }

    void setSelection(int n2, int n3, boolean bl) {
        int n4 = n2 + n3;
        if (n2 > n4) {
            int n5 = n4;
            n4 = n2;
            n2 = n5;
        }
        if (this.selection.x != n2 || this.selection.y != n4 || n3 > 0 && this.selectionAnchor != this.selection.x || n3 < 0 && this.selectionAnchor != this.selection.y) {
            this.clearSelection(bl);
            if (n3 < 0) {
                this.selectionAnchor = this.selection.y = n4;
                this.caretOffset = this.selection.x = n2;
            } else {
                this.selectionAnchor = this.selection.x = n2;
                this.caretOffset = this.selection.y = n4;
            }
            this.internalRedrawRange(this.selection.x, this.selection.y - this.selection.x);
        }
    }

    public void setSelectionRange(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        n2 = Math.max(0, Math.min(n2, n4));
        int n5 = n2 + n3;
        if (n5 < 0) {
            n3 = -n2;
        } else if (n5 > n4) {
            n3 = n4 - n2;
        }
        if (this.isLineDelimiter(n2) || this.isLineDelimiter(n2 + n3)) {
            SWT.error(5);
        }
        this.setSelection(n2, n3, false);
        this.setCaretLocation();
    }

    public void setStyleRange(StyleRange styleRange) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRange != null) {
            if (styleRange.isUnstyled()) {
                this.setStyleRanges(styleRange.start, styleRange.length, null, null, false);
            } else {
                this.setStyleRanges(styleRange.start, 0, null, new StyleRange[]{styleRange}, false);
            }
        } else {
            this.setStyleRanges(0, 0, null, null, true);
        }
    }

    public void setStyleRanges(int n2, int n3, int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(n2, n3, null, null, false);
        } else {
            this.setStyleRanges(n2, n3, nArray, styleRangeArray, false);
        }
    }

    public void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(0, 0, null, null, true);
        } else {
            this.setStyleRanges(0, 0, nArray, styleRangeArray, true);
        }
    }

    void setStyleRanges(int n2, int n3, int[] nArray, StyleRange[] styleRangeArray, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.content.getCharCount();
        int n11 = n2 + n3;
        if (n2 > n11 || n2 < 0) {
            SWT.error(6);
        }
        if (styleRangeArray != null) {
            if (n11 > n10) {
                SWT.error(6);
            }
            if (nArray != null && nArray.length != styleRangeArray.length << 1) {
                SWT.error(5);
            }
            n9 = 0;
            n8 = 0;
            for (n7 = 0; n7 < styleRangeArray.length; ++n7) {
                if (styleRangeArray[n7] == null) {
                    SWT.error(5);
                }
                if (nArray != null) {
                    n6 = nArray[n7 << 1];
                    n5 = nArray[(n7 << 1) + 1];
                } else {
                    n6 = styleRangeArray[n7].start;
                    n5 = styleRangeArray[n7].length;
                }
                if (n5 < 0) {
                    SWT.error(5);
                }
                if (0 > n6 || n6 + n5 > n10) {
                    SWT.error(5);
                }
                if (n9 > n6) {
                    SWT.error(5);
                }
                n8 |= styleRangeArray[n7].isVariableHeight();
                n9 = n6 + n5;
            }
            if (n8 != 0) {
                this.setVariableLineHeight();
            }
        }
        n9 = n2;
        n8 = n11;
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            if (nArray != null) {
                n9 = nArray[0];
                n8 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
            } else {
                n9 = styleRangeArray[0].start;
                n8 = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
            }
        }
        n7 = 0;
        if (!this.isFixedLineHeight() && !bl) {
            n6 = this.content.getLineAtOffset(Math.max(n11, n8));
            n5 = this.getPartialTopIndex();
            n4 = this.getPartialBottomIndex();
            if (n5 <= n6 && n6 <= n4) {
                n7 = this.getLinePixel(n6 + 1);
            }
        }
        if (bl) {
            this.renderer.setStyleRanges(null, null);
        } else {
            this.renderer.updateRanges(n2, n3, n3);
        }
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            this.renderer.setStyleRanges(nArray, styleRangeArray);
        }
        if (bl) {
            this.resetCache(0, this.content.getLineCount());
            super.redraw();
        } else {
            n6 = this.content.getLineAtOffset(Math.min(n2, n9));
            n5 = this.content.getLineAtOffset(Math.max(n11, n8));
            this.resetCache(n6, n5 - n6 + 1);
            n4 = this.getPartialTopIndex();
            int n12 = this.getPartialBottomIndex();
            if (n6 <= n12 && n5 >= n4) {
                int n13;
                int n14 = 0;
                int n15 = this.clientAreaHeight;
                if (n4 <= n6 && n6 <= n12) {
                    n14 = n13 = Math.max(n14, this.getLinePixel(n6));
                    n15 -= n13;
                }
                if (n4 <= n5 && n5 <= n12) {
                    n13 = this.getLinePixel(n5 + 1);
                    if (!this.isFixedLineHeight()) {
                        this.scrollText(n7, n13);
                    }
                    n15 = n13 - n14;
                }
                super.redraw(0, n14, this.clientAreaWidth, n15, false);
            }
        }
        this.setCaretLocation();
    }

    public void setStyleRanges(StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(0, 0, null, styleRangeArray, true);
    }

    public void setTabs(int n2) {
        this.checkWidget();
        this.tabLength = n2;
        this.renderer.setFont(null, n2);
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
            this.clearSelection(false);
        }
        this.resetCache(0, this.content.getLineCount());
        super.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Event event = new Event();
        event.start = 0;
        event.end = this.getCharCount();
        event.text = string;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.sendModifyEvent(event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            SWT.error(7);
        }
        this.textLimit = n2;
    }

    public void setTopIndex(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        int n4 = this.content.getLineCount();
        if (this.isFixedLineHeight()) {
            int n5 = Math.max(1, Math.min(n4, this.getLineCountWhole()));
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n4 - n5) {
                n2 = n4 - n5;
            }
            n3 = this.getLinePixel(n2);
        } else {
            n3 = this.getLinePixel(n2 = Math.max(0, Math.min(n4 - 1, n2)));
            n3 = n3 > 0 ? this.getAvailableHeightBellow(n3) : this.getAvailableHeightAbove(n3);
        }
        this.scrollVertical(n3, true);
    }

    public void setTopPixel(int n2) {
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = this.content.getLineCount();
        int n4 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        int n5 = this.getVerticalScrollOffset();
        if (this.isFixedLineHeight()) {
            int n6 = Math.max(0, n3 * this.getVerticalIncrement() - n4);
            if (n2 > n6) {
                n2 = n6;
            }
            n2 -= n5;
        } else if ((n2 -= n5) > 0) {
            n2 = this.getAvailableHeightBellow(n2);
        }
        this.scrollVertical(n2, true);
    }

    public void setWordWrap(boolean bl) {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (this.wordWrap == bl) {
            return;
        }
        this.wordWrap = bl;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.horizontalScrollOffset = 0;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(!this.wordWrap);
        }
        this.setScrollBars(true);
        this.setCaretLocation();
        super.redraw();
    }

    boolean showLocation(Rectangle rectangle) {
        int n2 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n3 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        boolean bl = false;
        if (rectangle.y <= this.topMargin) {
            bl = this.scrollVertical(rectangle.y - this.topMargin, true);
        } else if (rectangle.y + rectangle.height > n3) {
            bl = this.scrollVertical(rectangle.y + rectangle.height - n3, true);
        }
        if (n2 > 0) {
            if (rectangle.x < this.leftMargin) {
                int n4 = Math.max(this.leftMargin - rectangle.x, n2 / 4);
                int n5 = this.horizontalScrollOffset;
                bl = this.scrollHorizontal(-Math.min(n5, n4), true);
            } else if (rectangle.x + rectangle.width > n2) {
                int n6 = Math.max(rectangle.x + rectangle.width - n2, n2 / 4);
                int n7 = this.renderer.getWidth() - this.horizontalScrollOffset - this.clientAreaWidth;
                bl = this.scrollHorizontal(Math.min(n7, n6), true);
            }
        }
        return bl;
    }

    void showCaret() {
        Rectangle rectangle = this.getBoundsAtOffset(this.caretOffset);
        if (!this.showLocation(rectangle)) {
            this.setCaretLocation();
        }
    }

    public void showSelection() {
        boolean bl;
        int n2;
        int n3;
        boolean bl2;
        this.checkWidget();
        boolean bl3 = bl2 = this.caretOffset == this.selection.x;
        if (bl2) {
            n3 = this.selection.y;
            n2 = this.selection.x;
        } else {
            n3 = this.selection.x;
            n2 = this.selection.y;
        }
        Rectangle rectangle = this.getBoundsAtOffset(n3);
        Rectangle rectangle2 = this.getBoundsAtOffset(n2);
        int n4 = this.clientAreaWidth;
        boolean bl4 = bl2 ? rectangle.x - rectangle2.x <= n4 : (bl = rectangle2.x - rectangle.x <= n4);
        if (bl) {
            if (this.showLocation(rectangle)) {
                rectangle2 = this.getBoundsAtOffset(n2);
            }
            this.showLocation(rectangle2);
        } else {
            this.showLocation(rectangle2);
        }
    }

    void updateSelection(int n2, int n3, int n4) {
        if (this.selection.y <= n2) {
            return;
        }
        if (this.selection.x < n2) {
            this.internalRedrawRange(this.selection.x, n2 - this.selection.x);
        }
        if (this.selection.y > n2 + n3 && this.selection.x < n2 + n3) {
            int n5 = n4 - n3;
            int n6 = n2 + n4;
            this.internalRedrawRange(n6, this.selection.y + n5 - n6);
        }
        if (this.selection.y > n2 && this.selection.x < n2 + n3) {
            this.setSelection(n2 + n4, 0, true);
        } else {
            this.setSelection(this.selection.x + n4 - n3, this.selection.y - this.selection.x, true);
        }
        this.setCaretLocation();
    }

    static {
        String string = SWT.getPlatform();
        IS_CARBON = "carbon".equals(string);
        IS_GTK = "gtk".equals(string);
        IS_MOTIF = "motif".equals(string);
    }

    class TextWriter {
        private StringBuffer buffer;
        private int startOffset;
        private int endOffset;
        private boolean isClosed = false;

        public TextWriter(int start, int length) {
            this.buffer = new StringBuffer(length);
            this.startOffset = start;
            this.endOffset = start + length;
        }

        public void close() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        public int getCharCount() {
            return this.endOffset - this.startOffset;
        }

        public int getStart() {
            return this.startOffset;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.buffer.toString();
        }

        void write(String string) {
            this.buffer.append(string);
        }

        void write(String string, int offset) {
            if (offset < 0 || offset > this.buffer.length()) {
                return;
            }
            this.buffer.insert(offset, string);
        }

        void write(int i2) {
            this.buffer.append(i2);
        }

        void write(char i2) {
            this.buffer.append(i2);
        }

        public void writeLine(String line, int lineOffset) {
            int copyEnd;
            int lineLength;
            int writeOffset;
            if (this.isClosed) {
                SWT.error(39);
            }
            if ((writeOffset = this.startOffset - lineOffset) >= (lineLength = line.length())) {
                return;
            }
            int lineIndex = writeOffset > 0 ? writeOffset : 0;
            if (lineIndex < (copyEnd = Math.min(lineLength, this.endOffset - lineOffset))) {
                this.write(line.substring(lineIndex, copyEnd));
            }
        }

        public void writeLineDelimiter(String lineDelimiter) {
            if (this.isClosed) {
                SWT.error(39);
            }
            this.write(lineDelimiter);
        }
    }

    class RTFWriter
    extends TextWriter {
        static final int DEFAULT_FOREGROUND = 0;
        static final int DEFAULT_BACKGROUND = 1;
        Vector colorTable = new Vector();
        Vector fontTable = new Vector();
        boolean WriteUnicode;

        public RTFWriter(int start, int length) {
            super(start, length);
            this.colorTable.addElement(StyledText.this.getForeground());
            this.colorTable.addElement(StyledText.this.getBackground());
            this.fontTable.addElement(StyledText.this.getFont());
            this.setUnicode();
        }

        public void close() {
            if (!this.isClosed()) {
                this.writeHeader();
                this.write("\n}}\u0000");
                super.close();
            }
        }

        int getColorIndex(Color color, int defaultIndex) {
            if (color == null) {
                return defaultIndex;
            }
            int index = this.colorTable.indexOf(color);
            if (index == -1) {
                index = this.colorTable.size();
                this.colorTable.addElement(color);
            }
            return index;
        }

        int getFontIndex(Font font) {
            int index = this.fontTable.indexOf(font);
            if (index == -1) {
                index = this.fontTable.size();
                this.fontTable.addElement(font);
            }
            return index;
        }

        void setUnicode() {
            int majorIndex;
            String string = "windows 95";
            String string2 = "windows 98";
            String string3 = "windows me";
            String string4 = "windows nt";
            String osName = System.getProperty("os.name").toLowerCase();
            String osVersion = System.getProperty("os.version");
            int majorVersion = 0;
            if (osName.startsWith("windows nt") && osVersion != null && (majorIndex = osVersion.indexOf(46)) != -1) {
                osVersion = osVersion.substring(0, majorIndex);
                try {
                    majorVersion = Integer.parseInt(osVersion);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.WriteUnicode = !osName.startsWith("windows 95") && !osName.startsWith("windows 98") && !osName.startsWith("windows me") && (!osName.startsWith("windows nt") || majorVersion > 4);
        }

        void write(String string, int start, int end) {
            int index = start;
            while (index < end) {
                char ch = string.charAt(index);
                if (ch > '\u00ff' && this.WriteUnicode) {
                    if (index > start) {
                        this.write(string.substring(start, index));
                    }
                    this.write("\\u");
                    this.write(Integer.toString((short)ch));
                    this.write(' ');
                    start = index + 1;
                } else if (ch == '}' || ch == '{' || ch == '\\') {
                    if (index > start) {
                        this.write(string.substring(start, index));
                    }
                    this.write('\\');
                    this.write(ch);
                    start = index + 1;
                }
                ++index;
            }
            if (start < end) {
                this.write(string.substring(start, end));
            }
        }

        void writeHeader() {
            StringBuffer header = new StringBuffer();
            FontData fontData = StyledText.this.getFont().getFontData()[0];
            header.append("{\\rtf1\\ansi");
            String cpg = System.getProperty("file.encoding").toLowerCase();
            if (cpg.startsWith("cp") || cpg.startsWith("ms")) {
                cpg = cpg.substring(2, cpg.length());
                header.append("\\ansicpg");
                header.append(cpg);
            }
            header.append("\\uc0\\deff0{\\fonttbl{\\f0\\fnil ");
            header.append(fontData.getName());
            header.append(";");
            int i2 = 1;
            while (i2 < this.fontTable.size()) {
                header.append("\\f");
                header.append(i2);
                header.append(" ");
                FontData fd = ((Font)this.fontTable.elementAt(i2)).getFontData()[0];
                header.append(fd.getName());
                header.append(";");
                ++i2;
            }
            header.append("}}\n{\\colortbl");
            i2 = 0;
            while (i2 < this.colorTable.size()) {
                Color color = (Color)this.colorTable.elementAt(i2);
                header.append("\\red");
                header.append(color.getRed());
                header.append("\\green");
                header.append(color.getGreen());
                header.append("\\blue");
                header.append(color.getBlue());
                header.append(";");
                ++i2;
            }
            header.append("}\n{\\f0\\fs");
            header.append(fontData.getHeight() * 2);
            header.append(" ");
            this.write(header.toString(), 0);
        }

        public void writeLine(String line, int lineOffset) {
            StyleRange[] styles;
            int[] ranges;
            boolean lineJustify;
            int lineIndent;
            int lineAlignment;
            if (this.isClosed()) {
                SWT.error(39);
            }
            int lineIndex = StyledText.this.content.getLineAtOffset(lineOffset);
            StyledTextEvent event = StyledText.this.getLineStyleData(lineOffset, line);
            if (event != null) {
                lineAlignment = event.alignment;
                lineIndent = event.indent;
                lineJustify = event.justify;
                ranges = event.ranges;
                styles = event.styles;
            } else {
                lineAlignment = StyledText.this.renderer.getLineAlignment(lineIndex, StyledText.this.alignment);
                lineIndent = StyledText.this.renderer.getLineIndent(lineIndex, StyledText.this.indent);
                lineJustify = StyledText.this.renderer.getLineJustify(lineIndex, StyledText.this.justify);
                ranges = StyledText.this.renderer.getRanges(lineOffset, line.length());
                styles = StyledText.this.renderer.getStyleRanges(lineOffset, line.length(), false);
            }
            if (styles == null) {
                styles = new StyleRange[]{};
            }
            Color lineBackground = StyledText.this.renderer.getLineBackground(lineIndex, null);
            event = StyledText.this.getLineBackgroundData(lineOffset, line);
            if (event != null && event.lineBackground != null) {
                lineBackground = event.lineBackground;
            }
            this.writeStyledLine(line, lineOffset, ranges, styles, lineBackground, lineIndent, lineAlignment, lineJustify);
        }

        public void writeLineDelimiter(String lineDelimiter) {
            if (this.isClosed()) {
                SWT.error(39);
            }
            this.write(lineDelimiter, 0, lineDelimiter.length());
            this.write("\\par ");
        }

        void writeStyledLine(String line, int lineOffset, int[] ranges, StyleRange[] styles, Color lineBackground, int indent, int alignment, boolean justify) {
            int lineLength = line.length();
            int startOffset = this.getStart();
            int writeOffset = startOffset - lineOffset;
            if (writeOffset >= lineLength) {
                return;
            }
            int lineIndex = Math.max(0, writeOffset);
            this.write("\\fi");
            this.write(indent);
            switch (alignment) {
                case 16384: {
                    this.write("\\ql");
                    break;
                }
                case 0x1000000: {
                    this.write("\\qc");
                    break;
                }
                case 131072: {
                    this.write("\\qr");
                }
            }
            if (justify) {
                this.write("\\qj");
            }
            this.write(" ");
            if (lineBackground != null) {
                this.write("{\\highlight");
                this.write(this.getColorIndex(lineBackground, 1));
                this.write(" ");
            }
            int endOffset = startOffset + super.getCharCount();
            int lineEndOffset = Math.min(lineLength, endOffset - lineOffset);
            int i2 = 0;
            while (i2 < styles.length) {
                int end;
                int start;
                StyleRange style = styles[i2];
                if (ranges != null) {
                    start = ranges[i2 << 1] - lineOffset;
                    end = start + ranges[(i2 << 1) + 1];
                } else {
                    start = style.start - lineOffset;
                    end = start + style.length;
                }
                if (end >= writeOffset) {
                    Font font;
                    if (start >= lineEndOffset) break;
                    if (lineIndex < start) {
                        this.write(line, lineIndex, start);
                        lineIndex = start;
                    }
                    this.write("{\\cf");
                    this.write(this.getColorIndex(style.foreground, 0));
                    int colorIndex = this.getColorIndex(style.background, 1);
                    if (colorIndex != 1) {
                        this.write("\\highlight");
                        this.write(colorIndex);
                    }
                    if ((font = style.font) != null) {
                        int fontIndex = this.getFontIndex(font);
                        this.write("\\f");
                        this.write(fontIndex);
                        FontData fontData = font.getFontData()[0];
                        this.write("\\fs");
                        this.write(fontData.getHeight() * 2);
                    } else {
                        if ((style.fontStyle & 1) != 0) {
                            this.write("\\b");
                        }
                        if ((style.fontStyle & 2) != 0) {
                            this.write("\\i");
                        }
                    }
                    if (style.underline) {
                        this.write("\\ul");
                    }
                    if (style.strikeout) {
                        this.write("\\strike");
                    }
                    this.write(" ");
                    int copyEnd = Math.min(end, lineEndOffset);
                    copyEnd = Math.max(copyEnd, lineIndex);
                    this.write(line, lineIndex, copyEnd);
                    if (font == null) {
                        if ((style.fontStyle & 1) != 0) {
                            this.write("\\b0");
                        }
                        if ((style.fontStyle & 2) != 0) {
                            this.write("\\i0");
                        }
                    }
                    if (style.underline) {
                        this.write("\\ul0");
                    }
                    if (style.strikeout) {
                        this.write("\\strike0");
                    }
                    this.write("}");
                    lineIndex = copyEnd;
                }
                ++i2;
            }
            if (lineIndex < lineEndOffset) {
                this.write(line, lineIndex, lineEndOffset);
            }
            if (lineBackground != null) {
                this.write("}");
            }
        }
    }

    static class Printing
    implements Runnable {
        static final int LEFT = 0;
        static final int CENTER = 1;
        static final int RIGHT = 2;
        Printer printer;
        StyledTextRenderer printerRenderer;
        StyledTextPrintOptions printOptions;
        Rectangle clientArea;
        FontData fontData;
        Font printerFont;
        Hashtable resources;
        int tabLength;
        GC gc;
        int pageWidth;
        int startPage;
        int endPage;
        int startLine;
        int endLine;
        boolean singleLine;
        Point selection = null;
        boolean mirrored;
        int lineSpacing;

        Printing(StyledText styledText, Printer printer, StyledTextPrintOptions printOptions) {
            this.printer = printer;
            this.printOptions = printOptions;
            this.mirrored = (styledText.getStyle() & 0x8000000) != 0;
            this.singleLine = styledText.isSingleLine();
            this.startPage = 1;
            this.endPage = Integer.MAX_VALUE;
            PrinterData data = printer.getPrinterData();
            if (data.scope == 1) {
                this.startPage = data.startPage;
                this.endPage = data.endPage;
                if (this.endPage < this.startPage) {
                    int temp = this.endPage;
                    this.endPage = this.startPage;
                    this.startPage = temp;
                }
            } else if (data.scope == 2) {
                this.selection = styledText.getSelectionRange();
            }
            this.printerRenderer = new StyledTextRenderer(printer, null);
            this.printerRenderer.setContent(this.copyContent(styledText.getContent()));
            this.cacheLineData(styledText);
        }

        void cacheLineData(StyledText styledText) {
            StyledTextRenderer renderer = styledText.renderer;
            renderer.copyInto(this.printerRenderer);
            this.fontData = styledText.getFont().getFontData()[0];
            this.tabLength = styledText.tabLength;
            int lineCount = this.printerRenderer.lineCount;
            if (styledText.isListening(3001) || styledText.isBidi() && styledText.isListening(3007) || styledText.isListening(3002)) {
                StyledTextContent content = this.printerRenderer.content;
                int i2 = 0;
                while (i2 < lineCount) {
                    String line = content.getLine(i2);
                    int lineOffset = content.getOffsetAtLine(i2);
                    StyledTextEvent event = styledText.getLineBackgroundData(lineOffset, line);
                    if (event != null && event.lineBackground != null) {
                        this.printerRenderer.setLineBackground(i2, 1, event.lineBackground);
                    }
                    if (styledText.isBidi()) {
                        int[] segments = styledText.getBidiSegments(lineOffset, line);
                        this.printerRenderer.setLineSegments(i2, 1, segments);
                    }
                    if ((event = styledText.getLineStyleData(lineOffset, line)) != null) {
                        this.printerRenderer.setLineIndent(i2, 1, event.indent);
                        this.printerRenderer.setLineAlignment(i2, 1, event.alignment);
                        this.printerRenderer.setLineJustify(i2, 1, event.justify);
                        this.printerRenderer.setLineBullet(i2, 1, event.bullet);
                        StyleRange[] styles = event.styles;
                        if (styles != null && styles.length > 0) {
                            this.printerRenderer.setStyleRanges(event.ranges, styles);
                        }
                    }
                    ++i2;
                }
            }
            Point screenDPI = styledText.getDisplay().getDPI();
            Point printerDPI = this.printer.getDPI();
            this.resources = new Hashtable();
            int i3 = 0;
            while (i3 < lineCount) {
                int indent;
                Color color = this.printerRenderer.getLineBackground(i3, null);
                if (color != null) {
                    if (this.printOptions.printLineBackground) {
                        Color printerColor = (Color)this.resources.get(color);
                        if (printerColor == null) {
                            printerColor = new Color(this.printer, color.getRGB());
                            this.resources.put(color, printerColor);
                        }
                        this.printerRenderer.setLineBackground(i3, 1, printerColor);
                    } else {
                        this.printerRenderer.setLineBackground(i3, 1, null);
                    }
                }
                if ((indent = this.printerRenderer.getLineIndent(i3, 0)) != 0) {
                    this.printerRenderer.setLineIndent(i3, 1, indent * printerDPI.x / screenDPI.x);
                }
                ++i3;
            }
            StyleRange[] styles = this.printerRenderer.styles;
            int i4 = 0;
            while (i4 < this.printerRenderer.styleCount) {
                Color printerColor;
                Color color;
                StyleRange style = styles[i4];
                Font font = style.font;
                if (style.font != null) {
                    Font printerFont = (Font)this.resources.get(font);
                    if (printerFont == null) {
                        printerFont = new Font((Device)this.printer, font.getFontData());
                        this.resources.put(font, printerFont);
                    }
                    style.font = printerFont;
                }
                if ((color = style.foreground) != null) {
                    printerColor = (Color)this.resources.get(color);
                    if (this.printOptions.printTextForeground) {
                        if (printerColor == null) {
                            printerColor = new Color(this.printer, color.getRGB());
                            this.resources.put(color, printerColor);
                        }
                        style.foreground = printerColor;
                    } else {
                        style.foreground = null;
                    }
                }
                if ((color = style.background) != null) {
                    printerColor = (Color)this.resources.get(color);
                    if (this.printOptions.printTextBackground) {
                        if (printerColor == null) {
                            printerColor = new Color(this.printer, color.getRGB());
                            this.resources.put(color, printerColor);
                        }
                        style.background = printerColor;
                    } else {
                        style.background = null;
                    }
                }
                if (!this.printOptions.printTextFontStyle) {
                    style.fontStyle = 0;
                }
                style.rise = style.rise * printerDPI.y / screenDPI.y;
                GlyphMetrics metrics = style.metrics;
                if (metrics != null) {
                    metrics.ascent = metrics.ascent * printerDPI.y / screenDPI.y;
                    metrics.descent = metrics.descent * printerDPI.y / screenDPI.y;
                    metrics.width = metrics.width * printerDPI.x / screenDPI.x;
                }
                ++i4;
            }
            this.lineSpacing = styledText.lineSpacing * printerDPI.y / screenDPI.y;
        }

        StyledTextContent copyContent(StyledTextContent original) {
            DefaultContent printerContent = new DefaultContent();
            int insertOffset = 0;
            int i2 = 0;
            while (i2 < original.getLineCount()) {
                int insertEndOffset = i2 < original.getLineCount() - 1 ? original.getOffsetAtLine(i2 + 1) : original.getCharCount();
                printerContent.replaceTextRange(insertOffset, 0, original.getTextRange(insertOffset, insertEndOffset - insertOffset));
                insertOffset = insertEndOffset;
                ++i2;
            }
            return printerContent;
        }

        void dispose() {
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
            if (this.resources != null) {
                Enumeration enumeration = this.resources.elements();
                while (enumeration.hasMoreElements()) {
                    Resource resource = (Resource)enumeration.nextElement();
                    resource.dispose();
                }
                this.resources = null;
            }
            if (this.printerFont != null) {
                this.printerFont.dispose();
                this.printerFont = null;
            }
            if (this.printerRenderer != null) {
                this.printerRenderer.dispose();
                this.printerRenderer = null;
            }
        }

        void init() {
            Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
            Point dpi = this.printer.getDPI();
            this.printerFont = new Font(this.printer, this.fontData.getName(), this.fontData.getHeight(), 0);
            this.clientArea = this.printer.getClientArea();
            this.pageWidth = this.clientArea.width;
            this.clientArea.x = dpi.x + trim.x;
            this.clientArea.y = dpi.y + trim.y;
            this.clientArea.width -= this.clientArea.x + trim.width;
            this.clientArea.height -= this.clientArea.y + trim.height;
            int style = this.mirrored ? 0x4000000 : 0x2000000;
            this.gc = new GC(this.printer, style);
            this.gc.setFont(this.printerFont);
            this.printerRenderer.setFont(this.printerFont, this.tabLength);
            int lineHeight = this.printerRenderer.getLineHeight();
            if (this.printOptions.header != null) {
                this.clientArea.y += lineHeight * 2;
                this.clientArea.height -= lineHeight * 2;
            }
            if (this.printOptions.footer != null) {
                this.clientArea.height -= lineHeight * 2;
            }
            StyledTextContent content = this.printerRenderer.content;
            this.startLine = 0;
            this.endLine = this.singleLine ? 0 : content.getLineCount() - 1;
            PrinterData data = this.printer.getPrinterData();
            if (data.scope == 1) {
                int pageSize = this.clientArea.height / lineHeight;
                this.startLine = (this.startPage - 1) * pageSize;
            } else if (data.scope == 2) {
                this.startLine = content.getLineAtOffset(this.selection.x);
                this.endLine = this.selection.y > 0 ? content.getLineAtOffset(this.selection.x + this.selection.y - 1) : this.startLine - 1;
            }
        }

        void print() {
            Color background = this.gc.getBackground();
            Color foreground = this.gc.getForeground();
            int paintY = this.clientArea.y;
            int paintX = this.clientArea.x;
            int page = this.startPage;
            int pageBottom = this.clientArea.y + this.clientArea.height;
            int orientation = this.gc.getStyle() & 0x6000000;
            int i2 = this.startLine;
            while (i2 <= this.endLine && page <= this.endPage) {
                if (paintY == this.clientArea.y) {
                    this.printer.startPage();
                    this.printDecoration(page, true);
                }
                TextLayout layout = this.printerRenderer.getTextLayout(i2, orientation, this.clientArea.width, this.lineSpacing);
                Color lineBackground = this.printerRenderer.getLineBackground(i2, background);
                int paragraphBottom = paintY + layout.getBounds().height;
                if (paragraphBottom <= pageBottom) {
                    this.printLine(paintX, paintY, this.gc, foreground, lineBackground, layout);
                    paintY = paragraphBottom;
                } else {
                    int lineCount = layout.getLineCount();
                    while (paragraphBottom > pageBottom && lineCount > 0) {
                        paragraphBottom -= layout.getLineBounds((int)(--lineCount)).height + layout.getSpacing();
                    }
                    if (lineCount == 0) {
                        this.printDecoration(page, false);
                        this.printer.endPage();
                        if (++page <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(page, true);
                            paintY = this.clientArea.y;
                            this.printLine(paintX, paintY, this.gc, foreground, lineBackground, layout);
                            paintY += layout.getBounds().height;
                        }
                    } else {
                        int height = paragraphBottom - paintY;
                        this.gc.setClipping(paintX, paintY, this.clientArea.width, height);
                        this.printLine(paintX, paintY, this.gc, foreground, lineBackground, layout);
                        this.printDecoration(page, false);
                        this.printer.endPage();
                        if (++page <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(page, true);
                            paintY = this.clientArea.y - height;
                            int layoutHeight = layout.getBounds().height;
                            this.gc.setClipping(paintX, this.clientArea.y, this.clientArea.width, layoutHeight - height);
                            this.printLine(paintX, paintY, this.gc, foreground, lineBackground, layout);
                            paintY += layoutHeight;
                        }
                        this.gc.setClipping((Rectangle)null);
                    }
                }
                this.printerRenderer.disposeTextLayout(layout);
                ++i2;
            }
            if (paintY > this.clientArea.y) {
                this.printDecoration(page, false);
                this.printer.endPage();
            }
        }

        void printDecoration(int page, boolean header) {
            String text;
            String string = text = header ? this.printOptions.header : this.printOptions.footer;
            if (text == null) {
                return;
            }
            int lastSegmentIndex = 0;
            int segmentCount = 3;
            int i2 = 0;
            while (i2 < segmentCount) {
                String segment;
                int segmentIndex = text.indexOf("\t", lastSegmentIndex);
                if (segmentIndex == -1) {
                    segment = text.substring(lastSegmentIndex);
                    this.printDecorationSegment(segment, i2, page, header);
                    break;
                }
                segment = text.substring(lastSegmentIndex, segmentIndex);
                this.printDecorationSegment(segment, i2, page, header);
                lastSegmentIndex = segmentIndex + "\t".length();
                ++i2;
            }
        }

        void printDecorationSegment(String segment, int alignment, int page, boolean header) {
            int pageIndex = segment.indexOf("<page>");
            if (pageIndex != -1) {
                int pageTagLength = "<page>".length();
                StringBuffer buffer = new StringBuffer(segment.substring(0, pageIndex));
                buffer.append(page);
                buffer.append(segment.substring(pageIndex + pageTagLength));
                segment = buffer.toString();
            }
            if (segment.length() > 0) {
                TextLayout layout = new TextLayout(this.printer);
                layout.setText(segment);
                layout.setFont(this.printerFont);
                int segmentWidth = layout.getBounds().width;
                int segmentHeight = this.printerRenderer.getLineHeight();
                int drawX = 0;
                if (alignment == 0) {
                    drawX = this.clientArea.x;
                } else if (alignment == 1) {
                    drawX = (this.pageWidth - segmentWidth) / 2;
                } else if (alignment == 2) {
                    drawX = this.clientArea.x + this.clientArea.width - segmentWidth;
                }
                int drawY = header ? this.clientArea.y - segmentHeight * 2 : this.clientArea.y + this.clientArea.height + segmentHeight;
                layout.draw(this.gc, drawX, drawY);
                layout.dispose();
            }
        }

        void printLine(int paintX, int paintY, GC gc, Color foreground, Color background, TextLayout layout) {
            if (background != null) {
                Rectangle rect = layout.getBounds();
                gc.setBackground(background);
                gc.fillRectangle(paintX, paintY, rect.width, rect.height);
            }
            gc.setForeground(foreground);
            layout.draw(gc, paintX, paintY);
        }

        public void run() {
            String jobName = this.printOptions.jobName;
            if (jobName == null) {
                jobName = "Printing";
            }
            if (this.printer.startJob(jobName)) {
                this.init();
                this.print();
                this.dispose();
                this.printer.endJob();
            }
        }
    }
}

