/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;

public final class Color
extends Resource {
    public java.awt.Color handle;

    Color() {
    }

    public Color(Device device, int n2, int n3, int n4) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n2, n3, n4);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Color(Device device, RGB rGB) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(device, rGB.red, rGB.green, rGB.blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    private void init(Device device, int n2, int n3, int n4) {
        if (0 > n2 || n2 > 255 || 0 > n3 || n3 > 255 || 0 > n4 || n4 > 255) {
            SWT.error(5);
        }
        this.device = device;
        this.handle = new java.awt.Color(n2, n3, n4);
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && this.handle.equals(color.handle);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.getBlue();
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.getGreen();
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.getRed();
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle.getRed(), this.handle.getGreen(), this.handle.getBlue());
    }

    public int hashCode() {
        return this.handle == null ? 0 : this.handle.hashCode();
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color swing_new(Device device, java.awt.Color color) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color2 = new Color();
        color2.handle = color;
        color2.device = device;
        return color2;
    }
}

