/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;

public final class Cursor
extends Resource {
    public java.awt.Cursor handle;

    Cursor() {
    }

    public Cursor(Device device, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        switch (n2) {
            case 21: {
                this.handle = java.awt.Cursor.getPredefinedCursor(12);
                break;
            }
            case 0: {
                this.handle = java.awt.Cursor.getPredefinedCursor(0);
                break;
            }
            case 1: {
                this.handle = java.awt.Cursor.getPredefinedCursor(3);
                break;
            }
            case 2: {
                this.handle = java.awt.Cursor.getPredefinedCursor(1);
                break;
            }
            case 5: {
                this.handle = java.awt.Cursor.getPredefinedCursor(13);
                break;
            }
            case 10: {
                this.handle = java.awt.Cursor.getPredefinedCursor(8);
                break;
            }
            case 11: {
                this.handle = java.awt.Cursor.getPredefinedCursor(9);
                break;
            }
            case 12: {
                this.handle = java.awt.Cursor.getPredefinedCursor(11);
                break;
            }
            case 13: {
                this.handle = java.awt.Cursor.getPredefinedCursor(10);
                break;
            }
            case 14: {
                this.handle = java.awt.Cursor.getPredefinedCursor(7);
                break;
            }
            case 15: {
                this.handle = java.awt.Cursor.getPredefinedCursor(5);
                break;
            }
            case 16: {
                this.handle = java.awt.Cursor.getPredefinedCursor(4);
                break;
            }
            case 17: {
                this.handle = java.awt.Cursor.getPredefinedCursor(6);
                break;
            }
            case 19: {
                this.handle = java.awt.Cursor.getPredefinedCursor(2);
                break;
            }
            case 3: {
                this.handle = java.awt.Cursor.getPredefinedCursor(3);
                break;
            }
            case 9: {
                this.handle = java.awt.Cursor.getPredefinedCursor(11);
                break;
            }
            case 7: {
                this.handle = java.awt.Cursor.getPredefinedCursor(8);
                break;
            }
            case 6: {
                this.handle = java.awt.Cursor.getPredefinedCursor(7);
                break;
            }
            case 8: {
                this.handle = java.awt.Cursor.getPredefinedCursor(6);
                break;
            }
            case 4: 
            case 18: 
            case 20: {
                this.handle = this.createCursor(n2);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    java.awt.Cursor createCursor(int n2) {
        Object object;
        Object object2;
        Object object3;
        String string = "";
        switch (n2) {
            case 18: {
                string = "UpCursor";
                break;
            }
            case 20: {
                string = "NoCursor";
                break;
            }
            case 4: {
                string = "HelpCursor";
                break;
            }
            default: {
                return java.awt.Cursor.getPredefinedCursor(12);
            }
        }
        InputStream inputStream = this.getClass().getResourceAsStream("resources/" + string + ".properties");
        if (inputStream == null) {
            return java.awt.Cursor.getPredefinedCursor(0);
        }
        String string2 = null;
        String string3 = null;
        try {
            object3 = new PropertyResourceBundle(inputStream);
            string2 = "resources/" + ((ResourceBundle)object3).getString("Cursor.File");
            string3 = ((ResourceBundle)object3).getString("Cursor.HotSpot");
        }
        catch (MissingResourceException missingResourceException) {
            return java.awt.Cursor.getPredefinedCursor(0);
        }
        catch (IOException iOException) {
            return java.awt.Cursor.getPredefinedCursor(0);
        }
        object3 = null;
        try {
            int n3;
            object2 = this.getClass().getResourceAsStream(string2);
            if (object2 == null) {
                return java.awt.Cursor.getPredefinedCursor(0);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object2);
            object = new ByteArrayOutputStream(1024);
            object3 = new byte[1024];
            while ((n3 = bufferedInputStream.read((byte[])object3)) > 0) {
                ((ByteArrayOutputStream)object).write((byte[])object3, 0, n3);
            }
            bufferedInputStream.close();
            ((OutputStream)object).flush();
            object3 = ((ByteArrayOutputStream)object).toByteArray();
            if (((Object)object3).length == 0) {
                return java.awt.Cursor.getPredefinedCursor(0);
            }
        }
        catch (IOException iOException) {
            return java.awt.Cursor.getPredefinedCursor(0);
        }
        object2 = new ImageIcon((byte[])object3);
        int n4 = string3.indexOf(44);
        object = new Point(Integer.parseInt(string3.substring(0, n4)), Integer.parseInt(string3.substring(n4 + 1)));
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(((ImageIcon)object2).getImage(), (Point)object, string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return java.awt.Cursor.getPredefinedCursor(0);
        }
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        imageData = ImageData.convertMask(imageData);
        BufferedImage bufferedImage = new BufferedImage(imageData.width, imageData.height, 2);
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            for (int i2 = 0; i2 < imageData.width; ++i2) {
                for (int i3 = 0; i3 < imageData.height; ++i3) {
                    int n4;
                    RGB rGB = imageData.palette.getRGB(imageData.getPixel(i2, i3));
                    int n5 = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                    rGB = imageData2.palette.getRGB(imageData2.getPixel(i2, i3));
                    int n6 = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                    if (n6 == 0 || (n4 = imageData.getAlpha(i2, i3)) <= 0) continue;
                    n5 = n5 & 0xFFFFFF | n4 << 24;
                    bufferedImage.setRGB(i2, i3, n5);
                }
            }
        } else {
            for (int i4 = 0; i4 < imageData.width; ++i4) {
                for (int i5 = 0; i5 < imageData.height; ++i5) {
                    int n7 = imageData.getPixel(i4, i5);
                    RGB rGB = imageData.palette.getRGB(n7);
                    int n8 = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                    if (n8 != 0) continue;
                    rGB = imageData2.palette.getRGB(imageData2.getPixel(i4, i5));
                    int n9 = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                    if (n9 > 0) {
                        bufferedImage.setRGB(i4, i5, -1);
                        continue;
                    }
                    bufferedImage.setRGB(i4, i5, -16777216);
                }
            }
        }
        this.createCursor(bufferedImage, n2, n3);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    protected void createCursor(BufferedImage bufferedImage, int n2, int n3) {
        this.handle = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(n2, n3), "Custom Cursor");
    }

    public Cursor(Device device, ImageData imageData, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (imageData == null) {
            SWT.error(4);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        this.createCursor(new Image((Device)device, (ImageData)imageData).handle, n2, n3);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle == null ? 0 : this.handle.hashCode();
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor swing_new(Device device, java.awt.Cursor cursor) {
        if (device == null) {
            device = Device.getDevice();
        }
        Cursor cursor2 = new Cursor();
        cursor2.handle = cursor;
        cursor2.device = device;
        return cursor2;
    }
}

