/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngFileReadState;

class PngIhdrChunk
extends PngChunk {
    static final int IHDR_DATA_LENGTH = 13;
    static final int WIDTH_DATA_OFFSET = 8;
    static final int HEIGHT_DATA_OFFSET = 12;
    static final int BIT_DEPTH_OFFSET = 16;
    static final int COLOR_TYPE_OFFSET = 17;
    static final int COMPRESSION_METHOD_OFFSET = 18;
    static final int FILTER_METHOD_OFFSET = 19;
    static final int INTERLACE_METHOD_OFFSET = 20;
    static final byte COLOR_TYPE_GRAYSCALE = 0;
    static final byte COLOR_TYPE_RGB = 2;
    static final byte COLOR_TYPE_PALETTE = 3;
    static final byte COLOR_TYPE_GRAYSCALE_WITH_ALPHA = 4;
    static final byte COLOR_TYPE_RGB_WITH_ALPHA = 6;
    static final int INTERLACE_METHOD_NONE = 0;
    static final int INTERLACE_METHOD_ADAM7 = 1;
    static final int FILTER_NONE = 0;
    static final int FILTER_SUB = 1;
    static final int FILTER_UP = 2;
    static final int FILTER_AVERAGE = 3;
    static final int FILTER_PAETH = 4;
    static final byte[] ValidBitDepths = new byte[]{1, 2, 4, 8, 16};
    static final byte[] ValidColorTypes = new byte[]{0, 2, 3, 4, 6};

    PngIhdrChunk(int n2, int n3, byte by, byte by2, byte by3, byte by4, byte by5) {
        super(13);
        this.setType(TYPE_IHDR);
        this.setWidth(n2);
        this.setHeight(n3);
        this.setBitDepth(by);
        this.setColorType(by2);
        this.setCompressionMethod(by3);
        this.setFilterMethod(by4);
        this.setInterlaceMethod(by5);
        this.setCRC(this.computeCRC());
    }

    PngIhdrChunk(byte[] byArray) {
        super(byArray);
    }

    int getWidth() {
        return this.getInt32(8);
    }

    void setWidth(int n2) {
        this.setInt32(8, n2);
    }

    int getHeight() {
        return this.getInt32(12);
    }

    void setHeight(int n2) {
        this.setInt32(12, n2);
    }

    byte getBitDepth() {
        return this.reference[16];
    }

    void setBitDepth(byte by) {
        this.reference[16] = by;
    }

    byte getColorType() {
        return this.reference[17];
    }

    void setColorType(byte by) {
        this.reference[17] = by;
    }

    byte getCompressionMethod() {
        return this.reference[18];
    }

    void setCompressionMethod(byte by) {
        this.reference[18] = by;
    }

    byte getFilterMethod() {
        return this.reference[19];
    }

    void setFilterMethod(byte by) {
        this.reference[19] = by;
    }

    byte getInterlaceMethod() {
        return this.reference[20];
    }

    void setInterlaceMethod(byte by) {
        this.reference[20] = by;
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        int n2;
        if (pngFileReadState.readIHDR || pngFileReadState.readPLTE || pngFileReadState.readIDAT || pngFileReadState.readIEND) {
            SWT.error(40);
        } else {
            pngFileReadState.readIHDR = true;
        }
        super.validate(pngFileReadState, pngIhdrChunk);
        if (this.getLength() != 13) {
            SWT.error(40);
        }
        if (this.getCompressionMethod() != 0) {
            SWT.error(40);
        }
        if (this.getInterlaceMethod() != 0 && this.getInterlaceMethod() != 1) {
            SWT.error(40);
        }
        boolean bl = false;
        byte by = this.getColorType();
        for (n2 = 0; n2 < ValidColorTypes.length; ++n2) {
            if (ValidColorTypes[n2] != by) continue;
            bl = true;
            break;
        }
        if (!bl) {
            SWT.error(40);
        }
        n2 = 0;
        byte by2 = this.getBitDepth();
        for (int i2 = 0; i2 < ValidBitDepths.length; ++i2) {
            if (ValidBitDepths[i2] != by2) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            SWT.error(40);
        }
        if ((by == 2 || by == 6 || by == 4) && by2 < 8) {
            SWT.error(40);
        }
        if (by == 3 && by2 > 8) {
            SWT.error(40);
        }
    }

    String getColorTypeString() {
        switch (this.getColorType()) {
            case 0: {
                return "Grayscale";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "Palette";
            }
            case 4: {
                return "Grayscale with Alpha";
            }
            case 6: {
                return "RGB with Alpha";
            }
        }
        return "Unknown - " + this.getColorType();
    }

    String getFilterMethodString() {
        switch (this.getFilterMethod()) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Sub";
            }
            case 2: {
                return "Up";
            }
            case 3: {
                return "Average";
            }
            case 4: {
                return "Paeth";
            }
        }
        return "Unknown";
    }

    String getInterlaceMethodString() {
        switch (this.getInterlaceMethod()) {
            case 0: {
                return "Not Interlaced";
            }
            case 1: {
                return "Interlaced - ADAM7";
            }
        }
        return "Unknown";
    }

    void contributeToString(StringBuffer stringBuffer) {
        stringBuffer.append("\n\tWidth: ");
        stringBuffer.append(this.getWidth());
        stringBuffer.append("\n\tHeight: ");
        stringBuffer.append(this.getHeight());
        stringBuffer.append("\n\tBit Depth: ");
        stringBuffer.append(this.getBitDepth());
        stringBuffer.append("\n\tColor Type: ");
        stringBuffer.append(this.getColorTypeString());
        stringBuffer.append("\n\tCompression Method: ");
        stringBuffer.append(this.getCompressionMethod());
        stringBuffer.append("\n\tFilter Method: ");
        stringBuffer.append(this.getFilterMethodString());
        stringBuffer.append("\n\tInterlace Method: ");
        stringBuffer.append(this.getInterlaceMethodString());
    }

    boolean getMustHavePalette() {
        return this.getColorType() == 3;
    }

    boolean getCanHavePalette() {
        byte by = this.getColorType();
        return by != 0 && by != 4;
    }

    int getBitsPerPixel() {
        byte by = this.getBitDepth();
        switch (this.getColorType()) {
            case 6: {
                return 4 * by;
            }
            case 2: {
                return 3 * by;
            }
            case 4: {
                return 2 * by;
            }
            case 0: 
            case 3: {
                return by;
            }
        }
        SWT.error(40);
        return 0;
    }

    int getSwtBitsPerPixel() {
        byte by = this.getBitDepth();
        switch (this.getColorType()) {
            case 2: 
            case 4: 
            case 6: {
                return 24;
            }
            case 0: 
            case 3: {
                return Math.min(by, 8);
            }
        }
        SWT.error(40);
        return 0;
    }

    int getFilterByteOffset() {
        if (this.getBitDepth() < 8) {
            return 1;
        }
        return this.getBitsPerPixel() / 8;
    }

    boolean usesDirectColor() {
        switch (this.getColorType()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    PaletteData createGrayscalePalette() {
        int n2 = Math.min(this.getBitDepth(), 8);
        int n3 = Compatibility.pow2(n2) - 1;
        int n4 = 255 / n3;
        int n5 = 0;
        RGB[] rGBArray = new RGB[n3 + 1];
        for (int i2 = 0; i2 <= n3; ++i2) {
            rGBArray[i2] = new RGB(n5, n5, n5);
            n5 += n4;
        }
        return new PaletteData(rGBArray);
    }

    PaletteData getPaletteData() {
        switch (this.getColorType()) {
            case 0: {
                return this.createGrayscalePalette();
            }
            case 2: 
            case 4: 
            case 6: {
                return new PaletteData(0xFF0000, 65280, 255);
            }
        }
        return null;
    }
}

