/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class CComboButton
extends JButton
implements SwingConstants {
    private static final int ARROW_SPACE_WIDTH = 7;
    private static final int ARROW_WIDTH = 5;
    protected MouseInputAdapter mouseHandler = new MouseInputAdapter(){

        public void mouseExited(MouseEvent e2) {
            CComboButton.this.isMouseOver = false;
            CComboButton.this.isArrowMouseOver = false;
            CComboButton.this.repaint();
        }

        public void mouseEntered(MouseEvent e2) {
            CComboButton.this.isMouseOver = true;
            this.processMouseEvent(e2);
            CComboButton.this.repaint();
        }

        public void mouseMoved(MouseEvent e2) {
            this.processMouseEvent(e2);
        }

        public void mouseReleased(MouseEvent e2) {
            this.processMouseEvent(e2);
        }

        protected void processMouseEvent(MouseEvent e2) {
            int right = CComboButton.this.originalBorder.getBorderInsets((Component)e2.getComponent()).right + 7;
            boolean bl = CComboButton.this.isArrowMouseOver = e2.getX() > CComboButton.this.getWidth() - right;
            if (CComboButton.this.isArrowMouseOver) {
                CComboButton.this.setActionCommand("Arrow");
            } else {
                CComboButton.this.setActionCommand("");
            }
        }
    };
    protected Border originalBorder = this.getBorder();
    protected boolean isMouseOver;
    protected boolean isArrowMouseOver;
    protected static Color shadow = UIManager.getColor("ComboBox.buttonShadow");
    protected static Color darkShadow = UIManager.getColor("ComboBox.buttonDarkShadow");
    protected static Color highlight = UIManager.getColor("ComboBox.buttonHighlight");

    public CComboButton() {
        this.setMargin(new Insets(0, 1, 0, 1));
        this.setBorder(BorderFactory.createCompoundBorder(this.originalBorder, BorderFactory.createEmptyBorder(0, 0, 0, 8)));
        this.setModel(new DefaultButtonModel(){

            public boolean isPressed() {
                return super.isPressed() && !CComboButton.this.isArrowMouseOver;
            }
        });
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                boolean oldIsArrowMouseOver = CComboButton.this.isArrowMouseOver;
                CComboButton.this.isArrowMouseOver = false;
                CComboButton.this.getModel().setPressed(false);
                CComboButton.this.isArrowMouseOver = oldIsArrowMouseOver;
            }
        });
    }

    public static boolean isArrowEvent(ActionEvent actionEvent) {
        return "Arrow".equals(actionEvent.getActionCommand());
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.isArrowMouseOver == CComboButton.isArrowEvent(actionEvent)) {
            super.fireActionPerformed(actionEvent);
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Insets insets = this.originalBorder.getBorderInsets(this);
        int n4 = n2 - 7 - insets.right + 1;
        boolean bl = this.isEnabled();
        if (this.isMouseOver && bl) {
            graphics.setColor(shadow);
            graphics.drawLine(n4, insets.top + 1, n4, n3 - insets.bottom - 1);
        }
        Color color = graphics.getColor();
        int n5 = 3;
        this.paintTriangle(graphics, n4 - 1 + 5, (n3 - n5) / 2, n5, bl);
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = Math.max(dimension.height, 12);
        return dimension;
    }

    protected void paintTriangle(Graphics graphics, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        Color color = graphics.getColor();
        n4 = Math.max(n4, 2);
        int n7 = n4 / 2 - 1;
        graphics.translate(n2, n3);
        if (bl) {
            graphics.setColor(darkShadow);
        } else if (!bl) {
            graphics.translate(1, 1);
            graphics.setColor(highlight);
            n6 = 0;
            for (n5 = n4 - 1; n5 >= 0; --n5) {
                graphics.drawLine(n7 - n5, n6, n7 + n5, n6);
                ++n6;
            }
            graphics.translate(-1, -1);
            graphics.setColor(shadow);
        }
        n6 = 0;
        for (n5 = n4 - 1; n5 >= 0; --n5) {
            graphics.drawLine(n7 - n5, n6, n7 + n5, n6);
            ++n6;
        }
        graphics.translate(-n2, -n3);
        graphics.setColor(color);
    }
}

