/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CExpandBar;
import org.eclipse.swt.internal.swing.JExpandPane;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;

class CExpandBarImplementation
extends JScrollPane
implements CExpandBar {
    protected ExpandBar handle;
    protected JExpandPane expandPane;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CExpandBarImplementation(ExpandBar expandBar, int n2) {
        this.handle = expandBar;
        this.expandPane = new JExpandPane(){

            public boolean isOpaque() {
                return CExpandBarImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(this.expandPane);
        JViewport jViewport = new JViewport(){

            public boolean isOpaque() {
                return CExpandBarImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                Utils.paintTiledImage(this, g2, CExpandBarImplementation.this.backgroundImageIcon);
                super.paintComponent(g2);
            }

            public Color getBackground() {
                return CExpandBarImplementation.this != null && CExpandBarImplementation.this.userAttributeHandler != null && CExpandBarImplementation.this.userAttributeHandler.background != null ? CExpandBarImplementation.this.userAttributeHandler.background : super.getBackground();
            }
        };
        this.setViewport(jViewport);
        jViewport.setView(this.expandPane);
        this.init(n2);
    }

    protected void init(int n2) {
        this.setHorizontalScrollBarPolicy(31);
        if ((n2 & 0x200) == 0) {
            this.setVerticalScrollBarPolicy(21);
        }
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.expandPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                CExpandBarImplementation.this.handle.processEvent(e2);
            }
        });
    }

    public Container getClientArea() {
        return this.expandPane;
    }

    public void addExpandPaneItem(String string, Icon icon, Component component) {
        this.expandPane.addExpandPaneItem(string, icon, component);
    }

    public void insertExpandPaneItem(String string, Icon icon, Component component, int n2) {
        this.expandPane.insertExpandPaneItem(string, icon, component, n2);
    }

    public void removeExpandPaneItem(Component component) {
        this.expandPane.removeExpandPaneItem(component);
    }

    public void setExpanded(Component component, boolean bl) {
        this.expandPane.getExpandItem(component).setExpanded(bl);
    }

    public boolean isExpanded(Component component) {
        return this.expandPane.getExpandItem(component).isExpanded();
    }

    public Dimension getTitleBarSize(Component component) {
        return this.expandPane.getExpandItem(component).getTitleBarSize();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                this.getViewport().setOpaque(true);
                this.expandPane.setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                this.getViewport().setOpaque(false);
                this.expandPane.setOpaque(false);
            }
        }
    }

    public void setIcon(Component component, ImageIcon imageIcon) {
        this.expandPane.getExpandItem(component).setIcon(imageIcon);
    }

    public void setText(Component component, String string) {
        this.expandPane.getExpandItem(component).setText(string);
    }

    public void setSpacing(int n2) {
        this.expandPane.setSpacing(n2);
    }

    public int getSpacing() {
        return this.expandPane.getSpacing();
    }
}

