/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.View;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CLink;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;

class CLinkImplementation
extends JEditorPane
implements CLink {
    protected Link handle;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected String text = this.getText();
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CLinkImplementation(Link link, int n2) {
        this.setFocusable(false);
        this.handle = link;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this){

            public void setForeground(Color foreground) {
                super.setForeground(foreground);
                CLinkImplementation.this.adjustStyles();
            }

            public void setFont(Font font) {
                super.setFont(font);
                CLinkImplementation.this.adjustStyles();
            }
        };
        this.setContentType("text/html");
        this.init(n2);
    }

    protected void init(int n2) {
        this.setEditable(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setOpaque(false);
        this.adjustStyles();
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e2) {
                if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    CLinkImplementation.this.handle.processEvent(e2);
                }
            }
        });
    }

    public int getPreferredWidth() {
        String string = this.getText();
        this.setText(this.text);
        int n2 = super.getPreferredSize().width;
        this.setText(string);
        return n2;
    }

    protected void adjustStyles() {
        this.updateUI();
        LookAndFeelUtils.applyLabelStyle(this);
        this.setMargin(new Insets(0, 0, 0, 0));
        if ((this.handle.getStyle() & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        }
        this.reshape(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
        View view = this.getUI().getRootView(this);
        if (view != null) {
            Border border = this.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n4 -= insets.left + insets.right;
                n5 -= insets.top + insets.bottom;
            }
            view.setSize(n4, n5);
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, super.getMaximumSize().height);
    }

    public boolean isOpaque() {
        return this.backgroundImageIcon == null && (this.userAttributeHandler != null && this.userAttributeHandler.background != null || super.isOpaque());
    }

    protected void paintComponent(Graphics graphics) {
        Utils.paintTiledImage(this, graphics, this.backgroundImageIcon);
        super.paintComponent(graphics);
    }

    public Container getClientArea() {
        return this;
    }

    public void setLinkText(String string) {
        this.text = string;
        super.setText("<html>" + CLinkImplementation.escapeXML(string) + "</html>");
        this.adjustStyles();
    }

    public static String escapeXML(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer((int)((double)n2 * 1.1));
        int n3 = -1;
        int n4 = -1;
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    n3 = i2;
                    continue block6;
                }
                case '>': {
                    if (n3 >= 0) {
                        String string2 = string.substring(n3, i2);
                        String string3 = string2.toLowerCase(Locale.ENGLISH);
                        if (string3.equals("</a")) {
                            if (n4 >= 0) {
                                String string4 = Utils.escapeSwingXML(string.substring(n4 + 1, i2 - 3));
                                stringBuffer.append("<a href=\"" + string4 + "\">" + string4 + "</a>");
                                n4 = -1;
                                n3 = -1;
                                continue block6;
                            }
                            stringBuffer.append("</a>");
                            n3 = -1;
                            continue block6;
                        }
                        if (!string3.startsWith("<a ") && !string3.startsWith("<a")) continue block6;
                        int n5 = string2.indexOf("href=\"");
                        if (n5 == -1) {
                            n4 = i2;
                            continue block6;
                        }
                        stringBuffer.append(string.substring(n3, i2 + 1));
                        n3 = -1;
                        continue block6;
                    }
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    if (n3 >= 0) continue block6;
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (n3 >= 0) continue block6;
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    if (n3 >= 0) continue block6;
                    stringBuffer.append(c2);
                }
            }
        }
        if (n3 >= 0) {
            stringBuffer.append(Utils.escapeSwingXML(string.substring(n3, string.length())));
        }
        return stringBuffer.toString();
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
    }
}

