/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CSash;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;

class CSashImplementation
extends JPanel
implements CSash {
    protected Sash handle;
    protected BasicSplitPaneDivider divider;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected int dragLocation = Integer.MIN_VALUE;

    public Container getSwingComponent() {
        return this.divider;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CSashImplementation(Sash sash, int n2) {
        super(new BorderLayout(0, 0));
        this.handle = sash;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        JSplitPane jSplitPane = new JSplitPane((n2 & 0x100) != 0 ? 0 : 1);
        this.divider = ((BasicSplitPaneUI)jSplitPane.getUI()).getDivider();
        if ((this.handle.getStyle() & 0x10000) == 0) {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
                protected Window splitterWindow;

                public void mousePressed(MouseEvent e2) {
                    if ((e2.getButton() & 1) == 0) {
                        return;
                    }
                    CSashImplementation.this.dragLocation = (CSashImplementation.this.handle.getStyle() & 0x200) != 0 ? CSashImplementation.this.getLocation().x : CSashImplementation.this.getLocation().y;
                    this.splitterWindow = new Window(this, SwingUtilities.getWindowAncestor(CSashImplementation.this)){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void update(Graphics g2) {
                            this.paint(g2);
                        }

                        public void paint(Graphics g2) {
                            super.paint(g2);
                            Dimension size = this.getSize();
                            Color background = this.getBackground();
                            int i2 = 0;
                            while (i2 < size.width) {
                                int j2 = 0;
                                while (j2 < size.height) {
                                    if ((i2 + j2) % 2 == 0) {
                                        g2.setColor(Color.BLACK);
                                        g2.drawLine(i2, j2, i2, j2);
                                    } else {
                                        g2.setColor(background);
                                        g2.drawLine(i2, j2, i2, j2);
                                    }
                                    ++j2;
                                }
                                ++i2;
                            }
                        }
                    };
                    this.splitterWindow.setCursor(CSashImplementation.this.divider.getCursor());
                    this.adjustWindowBounds();
                    this.splitterWindow.setVisible(true);
                }

                public void mouseReleased(MouseEvent e2) {
                    if ((e2.getButton() & 1) == 0) {
                        return;
                    }
                    this.splitterWindow.dispose();
                    this.splitterWindow = null;
                }

                public void mouseDragged(MouseEvent e2) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            this.this$1.adjustWindowBounds();
                        }
                    });
                }

                protected void adjustWindowBounds() {
                    if (this.splitterWindow == null) {
                        return;
                    }
                    Dimension size = CSashImplementation.this.divider.getSize();
                    Point location = CSashImplementation.this.divider.getLocation();
                    SwingUtilities.convertPointToScreen(location, CSashImplementation.this.divider.getParent());
                    Point screenDragLocation = new Point(CSashImplementation.this.dragLocation, CSashImplementation.this.dragLocation);
                    SwingUtilities.convertPointToScreen(screenDragLocation, CSashImplementation.this.getParent());
                    if ((CSashImplementation.this.handle.getStyle() & 0x200) != 0) {
                        location.x = screenDragLocation.x;
                    } else {
                        location.y = screenDragLocation.y;
                    }
                    this.splitterWindow.setBounds(location.x, location.y, size.width, size.height);
                }
            };
            this.divider.addMouseListener(mouseInputAdapter);
            this.divider.addMouseMotionListener(mouseInputAdapter);
        }
        this.add((Component)this.divider, "Center");
        this.init(n2);
    }

    protected void init(int n2) {
        if ((n2 & 0x800) != 0) {
            this.divider.setBorder(LookAndFeelUtils.getStandardBorder());
        }
        Utils.installMouseListener(this.divider, this.handle);
        Utils.installKeyListener(this.divider, this.handle);
        Utils.installFocusListener(this.divider, this.handle);
        Utils.installComponentListener(this, this.handle);
    }

    public Container getClientArea() {
        return this.divider;
    }

    public void setDragLocation(int n2) {
        this.dragLocation = n2;
        this.repaint();
    }

    public void setBackgroundImage(Image image) {
    }

    public void setBackgroundInheritance(int n2) {
    }
}

