/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.eclipse.swt.internal.swing.CButton;
import org.eclipse.swt.internal.swing.CScrollable;
import org.eclipse.swt.internal.swing.CShellDialog;
import org.eclipse.swt.internal.swing.CShellFrame;
import org.eclipse.swt.internal.swing.CShellPanel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public interface CShell
extends CScrollable {
    public static final int MAXIMIZED_BOTH = 6;
    public static final int ICONIFIED = 1;
    public static final int NORMAL = 0;

    public void forceActive();

    public String getTitle();

    public void setTitle(String var1);

    public void toFront();

    public int getExtendedState();

    public void setExtendedState(int var1);

    public void setIconImage(Image var1);

    public void setIconImages(List var1);

    public void setJMenuBar(JMenuBar var1);

    public void setDefaultButton(CButton var1);

    public ModalityHandler getModalityHandler();

    public void setModallyBlocked(boolean var1);

    public boolean isModallyBlocked();

    public void setActivationEventsBlocked(boolean var1);

    public static class Factory {
        static {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }

        private Factory() {
        }

        public static CShell newInstance(Shell shell, CShell parent, int style) {
            if (shell instanceof CEmbeddedShell) {
                return new CShellPanel(shell, style);
            }
            if (parent instanceof CShellFrame) {
                return new CShellDialog(shell, (CShellFrame)parent, style);
            }
            if (parent instanceof CShellDialog) {
                return new CShellDialog(shell, (CShellDialog)parent, style);
            }
            return new CShellFrame(shell, style);
        }
    }

    public static class ModalityHandler {
        protected List blockerList = new ArrayList(0);
        protected static List applicationBlockerList = new ArrayList(0);
        protected static final CShell[] NO_BLOCKERS = new CShell[0];
        protected static Set windowSet = new HashSet();
        protected Shell parent;
        protected CShell cShell;
        protected boolean isEnabled;

        public static void initialize() {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            defaultToolkit.addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    if (event.getSource() instanceof Window) {
                        switch (event.getID()) {
                            case 102: {
                                ModalityHandler.windowSet.add(event.getSource());
                                break;
                            }
                            case 103: {
                                ModalityHandler.windowSet.remove(event.getSource());
                            }
                        }
                    }
                }
            }, 1L);
            defaultToolkit.addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    CShell[] blockers;
                    Window window;
                    InputEvent ie = (InputEvent)event;
                    Component component = ie.getComponent();
                    if (component != null && (window = SwingUtilities.getWindowAncestor(component)) instanceof CShell && (blockers = ((CShell)((Object)window)).getModalityHandler().getBlockers()).length != 0) {
                        if (ie.getID() == 501) {
                            blockers[0].getModalityHandler().advertiseBlocker();
                        }
                        ie.consume();
                        return;
                    }
                }
            }, 56L);
        }

        protected boolean isBlocked() {
            if (this.blockerList.isEmpty() && applicationBlockerList.isEmpty()) {
                return false;
            }
            int i2 = this.blockerList.size() - 1;
            while (i2 >= 0) {
                if (this.blockerList.get(i2) == this.cShell) {
                    return true;
                }
                --i2;
            }
            if (!applicationBlockerList.isEmpty()) {
                i2 = applicationBlockerList.size() - 1;
                while (i2 >= 0) {
                    if (applicationBlockerList.get(i2) == this.cShell) {
                        return false;
                    }
                    --i2;
                }
                return true;
            }
            return false;
        }

        protected CShell[] getBlockers() {
            Object blocker;
            if (this.blockerList.isEmpty() && applicationBlockerList.isEmpty()) {
                return NO_BLOCKERS;
            }
            if (this.blockerList.size() + applicationBlockerList.size() == 1) {
                CShell blocker2;
                CShell cShell = blocker2 = this.blockerList.isEmpty() ? (CShell)applicationBlockerList.get(0) : (CShell)this.blockerList.get(0);
                if (blocker2 == this.cShell) {
                    return NO_BLOCKERS;
                }
                return new CShell[]{blocker2};
            }
            ArrayList shellList = new ArrayList();
            int i2 = this.blockerList.size() - 1;
            while (i2 >= 0) {
                blocker = this.blockerList.get(i2);
                if (blocker != this.cShell) {
                    shellList.add(blocker);
                }
                --i2;
            }
            if (!applicationBlockerList.contains(this.cShell)) {
                i2 = applicationBlockerList.size() - 1;
                while (i2 >= 0) {
                    blocker = applicationBlockerList.get(i2);
                    shellList.add(blocker);
                    --i2;
                }
            }
            return shellList.toArray(new CShell[0]);
        }

        protected ModalityHandler(CShell cShell) {
            this.cShell = cShell;
        }

        protected void adjustBlockedShells() {
            Iterator it = windowSet.iterator();
            while (it.hasNext()) {
                Window window = (Window)it.next();
                if (!(window instanceof CShell)) continue;
                CShell cShell = (CShell)((Object)window);
                cShell.setModallyBlocked(cShell.getModalityHandler().isBlocked());
            }
        }

        protected void setEnabled(boolean isEnabled) {
            if (this.isEnabled == isEnabled) {
                return;
            }
            Control handle = this.cShell.getSWTHandle();
            if (isEnabled) {
                if (!handle.isDisposed()) {
                    Composite parent;
                    this.parent = (Shell)this.cShell.getSWTHandle().getParent();
                    this.isEnabled = isEnabled;
                    int style = handle.getStyle();
                    if ((style & 0x10000) != 0 || (style & 0x20000) != 0) {
                        applicationBlockerList.add(this.cShell);
                    } else if ((style & 0x8000) != 0 && (parent = handle.getParent()) != null) {
                        ((CShell)((Object)parent.handle)).getModalityHandler().blockerList.add(this.cShell);
                    }
                }
            } else {
                applicationBlockerList.remove(this.cShell);
                if (this.parent != null) {
                    ((CShell)((Object)this.parent.handle)).getModalityHandler().blockerList.remove(this.cShell);
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ ModalityHandler this$1;
                    {
                        this.this$1 = modalityHandler;
                    }

                    public void run() {
                    }
                });
            }
            this.adjustBlockedShells();
        }

        protected void advertiseBlocker() {
            this.cShell.toFront();
        }
    }

    public static interface CEmbeddedShell {
    }
}

