/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Utils {
    protected static final String LIGHTPOPUPS_PROPERTY = "swt.swing.lightpopups";
    protected static final String LOOK_AND_FEEL_PROPERTY = "swt.swing.laf";
    protected static final String LOOK_AND_FEEL_DECORATED_PROPERTY = "swt.swing.laf.decorated";
    protected static final String DEFAULT_ARROW_BUTTONS_PROPERTY = "swt.swing.defaultarrowbuttons";
    protected static final String APPLEMENUBAR_PROPERTY = "apple.laf.useScreenMenuBar";
    public static final String SWTSwingGraphics2DClientProperty = "SWTSwingGraphics2DClientProperty";
    protected static Canvas panel = new Canvas();
    static long timeStamp = System.currentTimeMillis();
    public static int previousModifiersEx;
    public static int modifiersEx;
    public static boolean isLocalDragAndDropInProgress;
    protected static Point mouseLocation;
    protected static Component mouseComponent;
    public static Control capturedControl;
    public static Cursor globalCursor;

    protected Utils() {
    }

    public static boolean isLightweightPopups() {
        return "true".equals(System.getProperty(LIGHTPOPUPS_PROPERTY));
    }

    public static void initializeProperties() {
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        if (System.getProperty(APPLEMENUBAR_PROPERTY) == null) {
            System.setProperty(APPLEMENUBAR_PROPERTY, "true");
        }
    }

    protected static String getLookAndFeel() {
        return System.getProperty(LOOK_AND_FEEL_PROPERTY);
    }

    public static void installDefaultLookAndFeel() {
        boolean bl = false;
        String string = Utils.getLookAndFeel();
        if (string != null) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (lookAndFeel != null && string.equals(lookAndFeel.getClass().getName())) {
                bl = true;
            } else {
                try {
                    UIManager.setLookAndFeel(string);
                    bl = true;
                    Boolean bl2 = Utils.isLookAndFeelDecorated();
                    if (bl2 != null) {
                        boolean bl3 = bl2;
                        JFrame.setDefaultLookAndFeelDecorated(bl3);
                        JDialog.setDefaultLookAndFeelDecorated(bl3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (!bl) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static Boolean isLookAndFeelDecorated() {
        String string = System.getProperty(LOOK_AND_FEEL_DECORATED_PROPERTY);
        return string == null ? null : new Boolean(string);
    }

    public static Boolean isUsingDefaultArrowButtons() {
        String string = System.getProperty(DEFAULT_ARROW_BUTTONS_PROPERTY);
        return string == null ? null : new Boolean(string);
    }

    public static Component getDefaultComponent() {
        return panel;
    }

    static void installMouseListener(Component component, Control control) {
        component.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e2) {
                control.processEvent(e2);
            }

            public void mouseReleased(MouseEvent e2) {
                control.processEvent(e2);
            }

            public void mouseClicked(MouseEvent e2) {
                control.processEvent(e2);
            }

            public void mouseEntered(MouseEvent e2) {
                control.processEvent(e2);
            }

            public void mouseExited(MouseEvent e2) {
                control.processEvent(e2);
            }
        });
        component.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e2) {
                control.processEvent(e2);
            }

            public void mouseMoved(MouseEvent e2) {
                control.processEvent(e2);
            }
        });
        component.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e2) {
                control.processEvent(e2);
            }
        });
    }

    static void installKeyListener(Component component, Control control) {
        component.setFocusTraversalKeysEnabled(false);
        component.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        component.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        component.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                control.processEvent(e2);
            }

            public void keyReleased(KeyEvent e2) {
                control.processEvent(e2);
            }

            public void keyTyped(KeyEvent e2) {
                control.processEvent(e2);
            }
        });
    }

    static void installFocusListener(Component component, Control control) {
        component.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e2) {
                control.processEvent(e2);
            }

            public void focusLost(FocusEvent e2) {
                control.processEvent(e2);
            }
        });
    }

    static void installComponentListener(Component component, Control control) {
        component.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e2) {
                control.processEvent(e2);
            }

            public void componentShown(ComponentEvent e2) {
                control.processEvent(e2);
            }

            public void componentResized(ComponentEvent e2) {
                control.processEvent(e2);
            }

            public void componentMoved(ComponentEvent e2) {
                control.processEvent(e2);
            }
        });
    }

    public static String escapeSwingXML(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer((int)((double)n2 * 1.1));
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String unescapeXML(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 < 3) {
            return string;
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                String string2 = string.substring(i2 + 1);
                if (string2.startsWith("lt;")) {
                    cArray[n3] = 60;
                    i2 += 3;
                    continue;
                }
                if (string2.startsWith("gt;")) {
                    cArray[n3] = 62;
                    i2 += 3;
                    continue;
                }
                if (string2.startsWith("amp;")) {
                    cArray[n3] = 38;
                    i2 += 4;
                    continue;
                }
                if (string2.startsWith("apos;")) {
                    cArray[n3] = 39;
                    i2 += 5;
                    continue;
                }
                if (string2.startsWith("quot;")) {
                    cArray[n3] = 34;
                    i2 += 5;
                    continue;
                }
                cArray[n3++] = c2;
                continue;
            }
            cArray[n3++] = c2;
        }
        if (n3 == cArray.length) {
            return string;
        }
        return new String(cArray, 0, n3);
    }

    public static String convertStringToHTML(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("<html>");
        block4: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\r': {
                    stringBuffer.append("<p>");
                    continue block4;
                }
                case '\n': {
                    stringBuffer.append("<p>");
                    continue block4;
                }
                default: {
                    stringBuffer.append(Utils.escapeSwingXML(String.valueOf(c2)));
                }
            }
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public static int convertDnDActionsToSWT(int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x40000000) != 0) {
            n3 |= 4;
        }
        return n3;
    }

    public static int convertDnDActionsToSwing(int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        if ((n2 & 4) != 0) {
            n3 |= 0x40000000;
        }
        return n3;
    }

    public static int getCurrentTime() {
        return (int)(System.currentTimeMillis() - timeStamp);
    }

    public static boolean isFlatLayout(Control control) {
        if (!(control instanceof Composite)) {
            return false;
        }
        Layout layout = ((Composite)control).getLayout();
        if (layout == null) {
            return false;
        }
        return layout instanceof FillLayout || layout instanceof RowLayout || layout instanceof StackLayout;
    }

    public static void notImplemented() {
        if (System.getProperty("swt.swing.debug") == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = Compatibility.IS_JAVA_5_OR_GREATER ? Thread.currentThread().getStackTrace() : new Exception().getStackTrace();
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            if (!stackTraceElement.getClassName().equals("org.eclipse.swt.internal.swing.Utils") || !stackTraceElement.getMethodName().equals("notImplemented")) continue;
            System.out.println("Not implemented: " + stackTraceElementArray[i2 + 1]);
            break;
        }
    }

    public static void dumpTree(Control control) {
        Shell shell;
        Utils.dumpControlTree(shell, 0, (shell = control.getShell()) == control ? null : control);
    }

    protected static void dumpControlTree(Control control, int n2, Control control2) {
        Control[] controlArray;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            int n3 = n2;
            if (control == control2) {
                stringBuffer.append("> ");
            }
            while (true) {
                int n4 = --n3;
                --n3;
                if (n4 <= 0) break;
                stringBuffer.append("  ");
            }
        }
        stringBuffer.append(control);
        Rectangle rectangle = control.getBounds();
        stringBuffer.append(" - [").append(rectangle.x).append(", ").append(rectangle.y).append(", ").append(rectangle.width).append(", ").append(rectangle.height).append(']');
        if (control instanceof Composite && (controlArray = ((Composite)control).getLayout()) != null) {
            stringBuffer.append(" - ").append(controlArray.getClass().getName());
        }
        System.out.println(stringBuffer.toString());
        if (control instanceof Composite) {
            controlArray = ((Composite)control).getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Utils.dumpControlTree(controlArray[i2], n2 + 1, control2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintComponentImmediately(Component component) {
        if (SwingUtilities.isEventDispatchThread()) {
            Object object = component.getTreeLock();
            synchronized (object) {
                RepaintManager repaintManager = RepaintManager.currentManager(component);
                repaintManager.validateInvalidComponents();
                repaintManager.paintDirtyRegions();
            }
            return;
        }
        Object object = component.getTreeLock();
        synchronized (object) {
            component.paint(component.getGraphics());
        }
    }

    public static void paintTiledImage(Component component, Graphics graphics, ImageIcon imageIcon) {
        Dimension dimension = component.getSize();
        Utils.paintTiledImage(graphics, imageIcon, 0, 0, dimension.width, dimension.height);
    }

    public static void paintTiledImage(Graphics graphics, ImageIcon imageIcon, int n2, int n3, int n4, int n5) {
        if (imageIcon == null) {
            return;
        }
        int n6 = imageIcon.getIconWidth();
        int n7 = imageIcon.getIconHeight();
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        int n8 = n4 / n6 + (n4 % n6 == 0 ? 0 : 1);
        int n9 = n5 / n7 + (n5 % n7 == 0 ? 0 : 1);
        Image image = imageIcon.getImage();
        for (int i2 = 0; i2 < n8; ++i2) {
            for (int i3 = 0; i3 < n9; ++i3) {
                graphics.drawImage(image, i2 * n6 + n2, i3 * n7 + n3, null);
            }
        }
    }

    public static void throwUncheckedException(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throwable.printStackTrace();
    }

    public static void storeModifiersEx(int n2) {
        previousModifiersEx = modifiersEx;
        modifiersEx = n2;
    }

    public static void trackMouseProperties(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component.isShowing()) {
            mouseLocation = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(mouseLocation, component);
            if (mouseEvent.getID() == 505) {
                if (mouseComponent == component) {
                    mouseComponent = null;
                }
            } else {
                mouseComponent = component;
            }
        }
    }

    public static Point getTrakedMouseLocation() {
        return mouseLocation == null ? new Point(0, 0) : mouseLocation;
    }

    public static Control getTrakedMouseControl() {
        if (mouseComponent == null) {
            return null;
        }
        for (Component component = mouseComponent; component != null; component = component.getParent()) {
            if (!(component instanceof CControl)) continue;
            return ((CControl)((Object)component)).getSWTHandle();
        }
        return null;
    }

    public static boolean redispatchEvent(Control control, AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent && capturedControl != null && capturedControl != control) {
            Container container = ((CControl)((Object)Utils.capturedControl.handle)).getClientArea();
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), container);
            if (mouseEvent.getID() == 507) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
                mouseEvent = new MouseWheelEvent((Component)container, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
            } else {
                mouseEvent = new MouseEvent(container, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            }
            container.dispatchEvent(mouseEvent);
            return true;
        }
        return false;
    }

    public static void setGlobalCursor(Cursor cursor) {
        globalCursor = cursor;
    }
}

