/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n2 = OS.OpenThemeData((int)0, (char[])this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            if ((this.style & 0x400) != 0) {
                rECT.bottom = rectangle.y + rectangle.height - this.tabsHeight;
            } else {
                rECT.top += this.tabsHeight;
                rECT.bottom = rectangle.y + rectangle.height;
            }
            int[] nArray = this.getPartId(0);
            OS.DrawThemeBackground((int)n2, (int)gC.handle, (int)nArray[0], (int)nArray[1], (RECT)rECT, null);
            OS.CloseThemeData((int)n2);
            if (this.tabsArea != null) {
                this.tabsArea.x = rectangle.x;
                this.tabsArea.y = rectangle.y;
                this.tabsArea.width = rectangle.width;
                this.tabsArea.height = this.tabsHeight;
                if ((this.style & 0x400) != 0) {
                    this.tabsArea.y += rectangle.height - this.tabsHeight;
                }
            }
        }
    }

    char[] getClassId() {
        return TAB;
    }

    int[] getPartId(int n2) {
        int n3 = this.state[n2];
        int n4 = 9;
        int n5 = 1;
        if ((n3 & 0x20) != 0) {
            n5 = 4;
        } else {
            if ((n3 & 0x40) != 0) {
                n5 = 2;
            }
            if ((n3 & 2) != 0) {
                n5 = 3;
            }
        }
        return new int[]{n4, n5};
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        return 0;
    }
}

