/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleListener;

class OleEventTable {
    int[] types;
    OleListener[] handlers;

    OleEventTable() {
    }

    void hook(int n2, OleListener oleListener) {
        int n3;
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.handlers == null) {
            this.handlers = new OleListener[4];
        }
        for (n3 = 0; n3 < this.types.length; ++n3) {
            if (this.types[n3] != 0) continue;
            this.types[n3] = n2;
            this.handlers[n3] = oleListener;
            return;
        }
        n3 = this.types.length;
        int[] nArray = new int[n3 + 4];
        OleListener[] oleListenerArray = new OleListener[n3 + 4];
        System.arraycopy(this.types, 0, nArray, 0, n3);
        System.arraycopy(this.handlers, 0, oleListenerArray, 0, n3);
        this.types = nArray;
        this.handlers = oleListenerArray;
        this.types[n3] = n2;
        this.handlers[n3] = oleListener;
    }

    boolean hooks(int n2) {
        if (this.handlers == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            if (this.types[i2] != n2) continue;
            return true;
        }
        return false;
    }

    void sendEvent(OleEvent oleEvent) {
        if (this.handlers == null) {
            return;
        }
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            OleListener oleListener;
            if (this.types[i2] != oleEvent.type || (oleListener = this.handlers[i2]) == null) continue;
            oleListener.handleEvent(oleEvent);
        }
    }

    void unhook(int n2, OleListener oleListener) {
        if (this.handlers == null) {
            return;
        }
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            if (this.types[i2] != n2 || this.handlers[i2] != oleListener) continue;
            this.types[i2] = 0;
            this.handlers[i2] = null;
            return;
        }
    }

    boolean hasEntries() {
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            if (this.types[i2] == 0) continue;
            return true;
        }
        return false;
    }
}

