/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.event.ListSelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.swing.CList;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    boolean isAdjustingSelection;

    public List(Composite composite, int n2) {
        super(composite, List.checkStyle(n2));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        ((CList)((Object)this.handle)).addElement(string);
    }

    public void add(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n2 == -1) {
            this.error(6);
        }
        int n3 = this.getItemCount();
        if (n2 < 0 || n3 < n2) {
            this.error(6);
        }
        ((CList)((Object)this.handle)).addElement(string);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return List.checkBits(n2, 4, 2, 0, 0, 0, 0);
    }

    public void deselect(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            ((CList)((Object)this.handle)).removeSelectionInterval(n3, n3);
        }
    }

    Container createHandle() {
        return (Container)((Object)CList.Factory.newInstance(this, this.style));
    }

    public void deselect(int n2) {
        this.checkWidget();
        ((CList)((Object)this.handle)).removeSelectionInterval(n2, n2);
    }

    public void deselect(int n2, int n3) {
        this.checkWidget();
        ((CList)((Object)this.handle)).removeSelectionInterval(n2, n3);
    }

    public void deselectAll() {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n2 == 0) {
            return;
        }
        ((CList)((Object)this.handle)).removeSelectionInterval(0, n2 - 1);
    }

    public int getFocusIndex() {
        this.checkWidget();
        return ((CList)((Object)this.handle)).getFocusIndex();
    }

    public String getItem(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(6);
        }
        int n3 = this.getItemCount();
        if (n2 < 0 || n3 <= n2) {
            this.error(6);
        }
        return (String)((CList)((Object)this.handle)).getElementAt(n2);
    }

    public int getItemCount() {
        this.checkWidget();
        return ((CList)((Object)this.handle)).getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        Rectangle rectangle = ((CList)((Object)this.handle)).getCellBounds(0);
        if (rectangle == null) {
            return 16;
        }
        return rectangle.height;
    }

    public String[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getItem(i2);
        }
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = this.getItem(nArray[i2]);
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int n2 = ((CList)((Object)this.handle)).getMinSelectionIndex();
        if (n2 == -1) {
            return 0;
        }
        return ((CList)((Object)this.handle)).getMaxSelectionIndex() - n2 + 1;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return ((CList)((Object)this.handle)).getMinSelectionIndex();
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return ((CList)((Object)this.handle)).getSelectionIndices();
    }

    public int getTopIndex() {
        this.checkWidget();
        return ((CList)((Object)this.handle)).getFirstVisibleIndex();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        return ((CList)((Object)this.handle)).indexOf(string, n2);
    }

    public boolean isSelected(int n2) {
        this.checkWidget();
        return ((CList)((Object)this.handle)).isSelectedIndex(n2);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n2 = nArray2[nArray2.length - 1];
        int n3 = nArray2[0];
        int n4 = this.getItemCount();
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        CList cList = (CList)((Object)this.handle);
        for (int i2 = nArray2.length - 1; i2 >= 0; --i2) {
            cList.removeElementAt(nArray2[i2]);
        }
    }

    public void remove(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (n2 < 0 || n3 <= n2) {
            this.error(6);
        }
        ((CList)((Object)this.handle)).removeElementAt(n2);
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = this.getItemCount();
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        ((CList)((Object)this.handle)).removeRange(n2, n3);
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void removeAll() {
        this.checkWidget();
        ((CList)((Object)this.handle)).removeAllElements();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n2 = nArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.isAdjustingSelection = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            ((CList)((Object)this.handle)).addSelectionInterval(n3, n3);
        }
        this.isAdjustingSelection = false;
    }

    public void select(int n2) {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CList)((Object)this.handle)).addSelectionInterval(n2, n2);
        this.isAdjustingSelection = false;
    }

    public void select(int n2, int n3) {
        this.checkWidget();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = this.getItemCount();
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        this.isAdjustingSelection = true;
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        ((CList)((Object)this.handle)).addSelectionInterval(n2, n3);
        this.isAdjustingSelection = false;
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int n2 = this.getItemCount();
        if (n2 == 0) {
            return;
        }
        this.isAdjustingSelection = true;
        ((CList)((Object)this.handle)).setSelectionInterval(0, n2 - 1);
        this.isAdjustingSelection = false;
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        ((CList)((Object)this.handle)).setElementAt(string, n2);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] != null) continue;
            this.error(5);
        }
        ((CList)((Object)this.handle)).setElements(stringArray);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.isAdjustingSelection = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            ((CList)((Object)this.handle)).addSelectionInterval(n3, n3);
        }
        this.isAdjustingSelection = false;
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.isAdjustingSelection = true;
        this.deselectAll();
        int n2 = stringArray.length;
        if (n2 != 0 && ((this.style & 4) == 0 || n2 <= 1)) {
            ((CList)((Object)this.handle)).setSelectedElements(stringArray);
        }
        this.isAdjustingSelection = false;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.isAdjustingSelection = true;
        ((CList)((Object)this.handle)).setSelectionInterval(n2, n2);
        this.isAdjustingSelection = false;
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        this.deselectAll();
        if (n3 < 0 || n2 > n3 || (this.style & 4) != 0 && n2 != n3) {
            return;
        }
        int n4 = this.getItemCount();
        if (n4 == 0 || n2 >= n4) {
            return;
        }
        this.isAdjustingSelection = true;
        n2 = Math.max(0, n2);
        n3 = Math.min(n3, n4 - 1);
        ((CList)((Object)this.handle)).setSelectionInterval(n2, n3);
        this.isAdjustingSelection = false;
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        ((CList)((Object)this.handle)).setFirstVisibleIndex(n2);
    }

    public void showSelection() {
        this.checkWidget();
        ((CList)((Object)this.handle)).showSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (eventObject instanceof ListSelectionEvent) {
            if (!this.hooks(13) || this.isAdjustingSelection) {
                super.processEvent(eventObject);
                return;
            }
        } else {
            super.processEvent(eventObject);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(eventObject);
            return;
        }
        try {
            if (eventObject instanceof ListSelectionEvent && !((ListSelectionEvent)eventObject).getValueIsAdjusting()) {
                this.sendEvent(13);
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 1001: {
                if (this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 1001: {
                    this.sendEvent(14);
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

