/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.awt.im.InputSubset;
import javax.swing.SwingUtilities;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.swing.CShell;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    Menu activeMenu;
    int minWidth = -1;
    int minHeight = -1;
    Control lastActive;
    Region region;
    Control initialFocusedControl;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n2) {
        this((Display)null, n2);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n2) {
        this(display, null, n2, null);
    }

    Shell(Display display, Shell shell, int n2, Container container) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.style = Shell.checkStyle(n2);
        this.parent = shell;
        this.display = display;
        this.handle = container;
        this.createWidget();
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n2) {
        this(shell != null ? shell.display : null, shell, n2, null);
    }

    public static Shell swing_new(Display display, Container container) {
        return new Shell(display, null, 8, container);
    }

    static int checkStyle(int n2) {
        n2 = Decorations.checkStyle(n2);
        int n3 = 229376;
        int n4 = n2 & ~n3;
        if ((n2 & 0x20000) != 0) {
            return n4 | 0x20000;
        }
        if ((n2 & 0x10000) != 0) {
            return n4 | 0x10000;
        }
        if ((n2 & 0x8000) != 0) {
            return n4 | 0x8000;
        }
        return n4;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    protected Container createHandle() {
        CShell cShell = this.parent != null ? (CShell)((Object)this.parent.handle) : null;
        return (Container)((Object)CShell.Factory.newInstance(this, cShell, this.style));
    }

    public void dispose() {
        Display display = this.display;
        super.dispose();
        if (display != null) {
            display.wake();
        }
    }

    void fixShell(Shell shell, Control control) {
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        ((CShell)((Object)this.handle)).toFront();
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public Point getMinimumSize() {
        this.checkWidget();
        Dimension dimension = this.handle.getMinimumSize();
        return new Point(dimension.width, dimension.height);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        int n2;
        this.checkWidget();
        int n3 = 0;
        Shell[] shellArray2 = this.display.getShells();
        for (n2 = 0; n2 < shellArray2.length; ++n2) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray != this) continue;
            ++n3;
        }
        n2 = 0;
        shellArray = new Shell[n3];
        for (int i2 = 0; i2 < shellArray2.length; ++i2) {
            Composite composite = shellArray2[i2];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite != this) continue;
            shellArray[n2++] = shellArray2[i2];
        }
        return shellArray;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    protected boolean getTraversalKeyDefault(KeyEvent keyEvent) {
        return false;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (super.isFocusControl()) {
            return true;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getFocusOwner() == null && keyboardFocusManager.getFocusedWindow() == this.handle;
    }

    public void open() {
        this.checkWidget();
        this.bringToTop();
        if (this.isDisposed()) {
            return;
        }
        this.layout();
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
    }

    void releaseChildren(boolean bl) {
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell == null || shell.isDisposed()) continue;
            shell.release(false);
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.activeMenu = null;
        Window window = (Window)this.handle;
        window.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                window.dispose();
            }
        });
        this.lastActive = null;
        this.region = null;
    }

    void removeMenu(Menu menu) {
        super.removeMenu(menu);
        if (menu == this.activeMenu) {
            this.activeMenu = null;
        }
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    public void setActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        ((CShell)((Object)this.handle)).forceActive();
    }

    Control getActiveControl() {
        return this.lastActive;
    }

    void setActiveControl(Control control) {
        int n2;
        int n3;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n4 = Math.min(controlArray.length, controlArray2.length);
        for (n3 = 0; n3 < n4 && controlArray[n3] == controlArray2[n3]; ++n3) {
        }
        for (n2 = controlArray2.length - 1; n2 >= n3; --n2) {
            if (controlArray2[n2].isDisposed()) continue;
            controlArray2[n2].sendEvent(27);
        }
        for (n2 = controlArray.length - 1; n2 >= n3; --n2) {
            if (controlArray[n2].isDisposed()) continue;
            controlArray[n2].sendEvent(26);
        }
    }

    public void setImeInputMode(int n2) {
        this.checkWidget();
        InputContext inputContext = this.handle.getInputContext();
        boolean bl = n2 != 0 && n2 != 32;
        inputContext.setCompositionEnabled(bl);
        if (bl) {
            Character.Subset subset;
            boolean bl2;
            boolean bl3 = (n2 & 0x10) != 0;
            boolean bl4 = bl2 = (n2 & 8) != 0;
            if ((n2 & 2) != 0) {
                subset = InputSubset.FULLWIDTH_LATIN;
                if (bl2) {
                    subset = Character.UnicodeBlock.HIRAGANA;
                }
                if (bl3) {
                    subset = Character.UnicodeBlock.KATAKANA;
                }
            } else {
                subset = InputSubset.LATIN;
                if (bl3 || bl2) {
                    subset = InputSubset.HALFWIDTH_KATAKANA;
                }
            }
            inputContext.setCharacterSubsets(new Character.Subset[]{subset});
        }
    }

    public void setMinimumSize(int n2, int n3) {
        this.checkWidget();
        if (Compatibility.IS_JAVA_5_OR_GREATER) {
            this.handle.setMinimumSize(new Dimension(n2, n3));
        }
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    void setParent() {
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
    }

    void setInitialFocusedControl(Control control) {
        this.initialFocusedControl = control;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.handle.isVisible() == bl) {
            return;
        }
        boolean bl2 = this.handle instanceof Window ? ((Window)this.handle).getFocusableWindowState() : true;
        this.handle.setVisible(bl);
        if (bl) {
            if (this.initialFocusedControl != null) {
                this.initialFocusedControl.setFocus();
                this.initialFocusedControl = null;
            } else if (bl2 && !this.traverseGroup(true)) {
                this.setFocus();
            }
            this.layout();
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 1001: {
                if (this.hooks(31)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 205: {
                if (this.hooks(26)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 206: {
                if (this.hooks(27)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 202: {
                if (this.hooks(21)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 203: {
                if (this.hooks(19)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 204: {
                if (this.hooks(20)) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 201: {
                if (this.isEnabled()) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 205: {
                    this.sendEvent(26);
                    break;
                }
                case 206: {
                    this.sendEvent(27);
                    break;
                }
                case 202: {
                    this.sendEvent(21);
                    break;
                }
                case 203: {
                    this.sendEvent(19);
                    break;
                }
                case 204: {
                    this.sendEvent(20);
                    break;
                }
                case 201: {
                    if (!this.isEnabled()) break;
                    this.closeWidget();
                    break;
                }
                case 1001: {
                    Event event = new Event();
                    event.detail = 2;
                    this.sendEvent(31, event);
                    if (!event.doit) break;
                    this.close();
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

