/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.event.TableColumnModelEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.CTable;
import org.eclipse.swt.internal.swing.CTableColumn;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    CTableColumn handle = this.createHandle();
    boolean moveable;

    public TableColumn(Table table, int n2) {
        super(table, TableColumn.checkStyle(n2));
        this.parent = table;
        table.createItem(this, table.getColumnCount());
    }

    public TableColumn(Table table, int n2, int n3) {
        super(table, TableColumn.checkStyle(n2));
        this.parent = table;
        table.createItem(this, n3);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return TableColumn.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    CTableColumn createHandle() {
        return CTableColumn.Factory.newInstance(this, this.style);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return ((javax.swing.table.TableColumn)((Object)this.handle)).getResizable();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.handle.getToolTipText();
    }

    public int getWidth() {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return 0;
        }
        return ((javax.swing.table.TableColumn)((Object)this.handle)).getWidth();
    }

    public void pack() {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = this.getWidth();
        CTable cTable = (CTable)((Object)this.parent.handle);
        int n4 = cTable.getPreferredColumnWidth(n2);
        cTable.getColumnModel().getColumn(n2).setPreferredWidth(n4 + 2);
        if (n3 != n4) {
            this.sendEvent(11);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1 || n3 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        if ((this.style & 0x4000) == 16384) {
            this.handle.setAlignment(2);
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            this.handle.setAlignment(0);
        }
        if ((this.style & 0x20000) == 131072) {
            this.handle.setAlignment(4);
        }
    }

    public void setImage(Image image) {
        int n2;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setImage(image);
        this.handle.setIcon(image == null ? null : new ImageIcon(image.handle));
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.moveable = bl;
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        ((javax.swing.table.TableColumn)((Object)this.handle)).setResizable(bl);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        super.setText(string);
        ((javax.swing.table.TableColumn)((Object)this.handle)).setHeaderValue(string);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.handle.setToolTipText(string);
    }

    public void setWidth(int n2) {
        this.checkWidget();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        ((javax.swing.table.TableColumn)((Object)this.handle)).setPreferredWidth(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 500: {
                if (this.hooks(13)) break;
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            return;
        }
        try {
            switch (n2) {
                case 500: {
                    this.sendEvent(13);
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
            return;
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        if (eventObject instanceof PropertyChangeEvent) {
            if (!this.hooks(11) && !this.hooks(10) || !"width".equals(((PropertyChangeEvent)eventObject).getPropertyName())) {
                return;
            }
        } else if (eventObject instanceof TableColumnModelEvent) {
            if (!this.hooks(10)) {
                return;
            }
        } else {
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            return;
        }
        try {
            if (eventObject instanceof PropertyChangeEvent) {
                String string = ((PropertyChangeEvent)eventObject).getPropertyName();
                if ("width".equals(string)) {
                    this.sendEvent(11);
                    int n2 = this.parent.getColumnCount();
                    for (int i2 = this.parent.indexOf(this) + 1; i2 < n2; ++i2) {
                        this.parent.getColumn(i2).sendEvent(10);
                    }
                }
            } else if (eventObject instanceof TableColumnModelEvent) {
                this.sendEvent(10);
            }
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

