/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class NimRODDesktopIconUI
extends BasicDesktopIconUI {
    boolean hasFocus;
    private int width = UIManager.getInt("NimRODDesktopIcon.width");
    private int height = UIManager.getInt("NimRODDesktopIcon.height");
    private int bigWidth = UIManager.getInt("NimRODDesktopIconBig.width");
    private int bigHeight = UIManager.getInt("NimRODDesktopIconBig.height");
    private HackML hackML = new HackML();
    private Icon resizeIcon;
    private Icon antIcon;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.uninstallBorder(this.desktopIcon);
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        super.installListeners();
        if (this.frame != null) {
            this.desktopIcon.addMouseListener(this.hackML);
            this.desktopIcon.addMouseMotionListener(this.hackML);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.desktopIcon.removeMouseListener(this.hackML);
        this.desktopIcon.removeMouseMotionListener(this.hackML);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.frame.getFrameIcon() != this.antIcon) {
            this.antIcon = this.frame.getFrameIcon();
            this.resizeIcon = NimRODUtils.reescala(this.antIcon, this.bigWidth, this.bigHeight);
        }
        String string = this.frame.getTitle();
        int n = 0;
        if (this.resizeIcon != null) {
            n = (this.width - this.resizeIcon.getIconWidth()) / 2;
            this.resizeIcon.paintIcon(jComponent, graphics, n, 2);
        }
        graphics.setFont(UIManager.getFont("DesktopIcon.font"));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.hasFocus) {
            int n2 = 0;
            String string2 = this.getTitle(string, fontMetrics, this.width - 10);
            while (string2.length() > 0) {
                if (string2.endsWith("...")) {
                    string2 = string2.substring(0, string2.length() - 3);
                }
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string2, graphics);
                n = (int)((double)this.width - rectangle2D.getWidth()) / 2;
                n2 = (int)((double)n2 + rectangle2D.getHeight());
                NimRODUtils.paintShadowTitleFat(graphics, string2, n, n2, Color.white);
                string = string.substring(string2.length());
                string2 = this.getTitle(string, fontMetrics, this.width - 10);
            }
        } else {
            string = this.getTitle(string, fontMetrics, this.width - 10);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            n = (int)((double)this.width - rectangle2D.getWidth()) / 2;
            NimRODUtils.paintShadowTitleFat(graphics, string, n, this.height - 5, Color.white);
        }
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n) {
        String string2;
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = fontMetrics.stringWidth(string);
        if (n2 <= n) {
            return string;
        }
        int n3 = fontMetrics.stringWidth("...");
        if (n - n3 <= 0) {
            return "";
        }
        int n4 = 1;
        while ((n3 = fontMetrics.stringWidth(string2 = string.substring(0, n4++) + "...")) < n) {
        }
        return string.substring(0, n4 - 1) + "...";
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(this.width, this.height);
    }

    private class HackML
    extends MouseInputAdapter {
        private HackML() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            NimRODDesktopIconUI.this.hasFocus = false;
            this.dodo(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODDesktopIconUI.this.hasFocus = true;
            this.dodo(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        void dodo(MouseEvent mouseEvent) {
            if (NimRODDesktopIconUI.this.desktopIcon != null) {
                NimRODDesktopIconUI.this.desktopIcon.getDesktopPane().updateUI();
            }
        }
    }
}

