/*

@echo off
cls
echo.
echo This INSTALL routine requires OS/2 REXX support installed.
echo Run Selective Installation from the OS/2 Setup Folder to
echo install REXX support before attempting to run this CMD file.
pause
exit

       *-------------------------------------------------------------*
       |                                                             |
       |    Eclipse 3.2 eComStation (eCS) and OS/2 install script    |
       |                                                             |
       |         INSTOS2.CMD - Install procedure for                 |
       |                       Eclipse 3.2 plus SWTSwing/EOS         |
       |                                                             |
       |   Based on the Java Movie Database (JMDB) install script!   |
       |                                                             |
       |             (C)Copyright 2007 Juergen Ulbts                 |
       |             All Rights Reserved                             |
       |                                                             |
       *-------------------------------------------------------------*
*/

PARSE ARG arg '[' WarpIN ']'

'@echo off'

BootDrive             = ''
AppInstallPath        = directory()
JavaEXEString         = 'JAVA.EXE'
searchJavaString01    = 'JAVA'
JDKInstallPath        = ''
AppIcon               = AppInstallPath||'\eclipse_os2_40x40.ico'
AppIcon2              = AppInstallPath||'\eos_os2_40x40.ico'
AppName               = 'Eclipse plus SWTSwing/EOS'
ErrorCodeJAVA         = 0     /* ErrorCodes: 11=Java not found,...  */

CopyrightLine1  = 'eComStation (eCS) and OS/2 install script for the Eclipse IDE V3.2.x'
CopyrightLine2  = '(C) Copyright 2007 - Juergen Ulbts'
CopyrightLine3  = 'All Rights Reserved'
CopyrightLine4  = 'Provided AS IS without any warranty!!!'
CopyrightLine5  = 'The latest version can be found at: http://www.juergen-ulbts.de/swtswing'

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs


AvailDrives = SysDriveMap('C:', 'LOCAL')

/* Get boot drive letter */
done = 0
do while \ done
  IF WarpIN >< "WarpIN" then call ShowScriptCopyright
  BootDrive=GetBootDrive()
  done = 1
end

/* get the name of the Java version that has to be added to the startup script */
call getJavaVersion
if ErrorCodeJAVA = 0 then
  if JDKInstallPath='' then ErrorCodeJAVA = 11


/* Check if this is an automatically called script... */
if WarpIN = "WarpIN" then do
   call CreateSTARTOS2CMD_NOOUTPUT
   EXIT
end /* do */




/* --------------- */
if (ErrorCodeJAVA=0) then
	do forever   /* main selection loop */
		call ShowScriptCopyright
		say 'Select one of the following:'
		say
		say '  0. Exit '||AppName||' install'
		say '  1. Create '||AppName||' Desktop objects (incl startos2*.cmd)'
		say '  2. Create '||AppName||' "startos2*.cmd" only'
		say
		say '  ESC to quit'
		say
		call charout, 'Press 0,1,2 or ESC: '
		do forever 
			k = translate(SysGetKey('NOECHO'))
			if k = '0' | k = D2C(27) then
				call InstallEnd
			else do
				if k = '1' then do
					call CreatePMObjects
					leave
				end
			
				if k = '2' then do
					call CreateSTARTOS2CMD
					leave
				end
			end
			call beep 1760, 50
		end 
	end /* do forever */
/* --------------- */

Select

   when ErrorCodeJRE=11 then do
        say 'ERROR 11: Java Runtime not found! You have to manually update the CMD file!'
        say
        call PressAnyKey
        call InstallEnd
   end /* do */
        
   otherwise
        call InstallEnd
end  /* select */




/* ===================================== */
/*  ADDITIONAL PROCEDURES AND FUNCTIONS  */
/* ===================================== */


/* Create PM Objects on Desktop */
CreatePMObjects:
  call ShowScriptCopyright
  say
  call CreateSTARTOS2CMD_NOOUTPUT

/* 
 *  if SysCreateObject("WPFolder","Eclipse","<WP_DESKTOP>", "OBJECTID=<Eclipse_Folder>, ICONFILE="AppIcon2";ICONNFILE=1,"AppIcon2";", "R") Then Do
 */
  if SysCreateObject("WPFolder","Eclipse","<WP_DESKTOP>", "OBJECTID=<Eclipse_Folder>;ICONFILE="AppIcon2";ICONNFILE=1,"AppIcon2";", "R") Then Do
    if SysCreateObject("WPProgram", "Eclipse",               "<Eclipse_Folder>",  "EXENAME="AppInstallPath"\STARTOS2.CMD;STARTUPDIR="AppInstallPath";ICONFILE="AppIcon, "R") then 
      if SysCreateObject("WPProgram", "Eclipse Debug",    "<Eclipse_Folder>",  "EXENAME="AppInstallPath"\STARTOS2DEBUG.CMD;STARTUPDIR="AppInstallPath";ICONFILE="AppIcon, "R") then 
        if SysCreateObject("WPProgram", "Eclipse SWTSwing Readme", "<Eclipse_Folder>", "EXENAME=e.exe;PARAMETERS=Eclipse_Enabler_Readme.txt;STARTUPDIR="AppInstallPath";", "R") then
          if SysCreateObject("WPProgram", "Eclipse SWTSwing History", "<Eclipse_Folder>", "EXENAME=e.exe;PARAMETERS=Eclipse_Enabler_History.txt;STARTUPDIR="AppInstallPath";", "R") then
            if SysCreateObject("WPProgram", "Eclipse SWTSwing Bugs", "<Eclipse_Folder>", "EXENAME=e.exe;PARAMETERS=Eclipse_SWTSwing_Bugs.txt;STARTUPDIR="AppInstallPath";", "R") then
              if SysCreateObject("WPProgram", "Eclipse Log", "<Eclipse_Folder>", "EXENAME=epm.exe;PARAMETERS=eclipse_swtswing.log;STARTUPDIR="AppInstallPath";", "R") then
              say 'All objects were created!'
            Else say 'Failed to create Eclipse with SWTSwing bugs object!'
          Else say 'Failed to create Eclipse SWTSwing history object!'
        Else say 'Failed to create Eclipse SWTSwing readme object!'
      Else say 'Failed to create Eclipse Debug program object!'
    Else say 'Failed to create Eclipse program object!'
  Else say 'Failed to create Eclipse folder on the desktop! No other objects were created!'




  if SysCreateObject("WPFolder","Additional Links","<Eclipse_Folder>", "OBJECTID=<Eclipse_Links>", "R") Then Do
    if SysCreateObject("WPUrl", "Eclipse project", "<Eclipse_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.eclipse.org/;", "R") then
      if SysCreateObject("WPUrl", "SWTSwing project", "<Eclipse_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://swtswing.sf.net/;", "R") then
        if SysCreateObject("WPUrl", "Eclipse on Swing (EOS) project", "<Eclipse_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://eos.sf.net/;", "R") then
           if SysCreateObject("WPUrl", "Homepage of Juergen Ulbts (package creator)", "<Eclipse_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.juergen-ulbts.de/swtswing;", "R") then
           say 'All additional LINKS were created!'
        Else say 'Failed to create Eclipse on Swing (EOS) URL object!'
      Else say 'Failed to create SWTSwing URL object!'
    Else say 'Failed to create Eclipse URL object!'
  Else say 'Failed to create additional LINKS folder on the desktop! No additional URL objects were created!'

  call PressAnyKey
  return




/* Create startos2.cmd */
CreateSTARTOS2CMD:
  call ShowScriptCopyright
  say
  startfile = 'startos2.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF")
  rc = lineout(startfile, "REM You may have to add the path to the Java142 runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVAW.EXE -Xmx512m -jar startup.jar")
  say 'STARTOS2.CMD created.'

  startfile = 'startos2debug.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF")
  rc = lineout(startfile, "REM You may have to add the path to the Java142 runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVA.EXE -Xmx512m -jar startup.jar -consolelog  >eclipse_swtswing.log 2>&1 &")
  say 'STARTOS2DEBUG.CMD created.'

  call PressAnyKey
  return


/* Create startos2.cmd without screen output */
CreateSTARTOS2CMD_NOOUTPUT:
  startfile = 'startos2.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF" )
  rc = lineout(startfile, "REM You may have to add the path to the Java142 runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVAW.EXE -Xmx512m -jar startup.jar")
  
  startfile = 'startos2debug.cmd'
  '@del 'startfile' >nul 2>>&1'
  rc = lineout(startfile, "@ECHO OFF" )
  rc = lineout(startfile, "REM You may have to add the path to the Java142 runtime ('x:\java1xx\bin\jre\java.exe -cp ...') and maybe also the correct JDBC driver!")
  rc = lineout(startfile, JDKInstallPath||"JAVA.EXE -Xmx512m -jar startup.jar -consolelog  >eclipse_swtswing.log 2>&1 &")
  return


/* Show script copyright notice */
ShowScriptCopyright:
  call SysCls
  say
  say
  say CopyrightLine1
  say CopyrightLine2
  say CopyrightLine3
  say
  say CopyrightLine4
  say CopyrightLine5
  say
  say
  return


/* Get installed JAVA version from system */
getJavaVersion:
   /* Check INI-Files for Innotek Java */
   otherJavaInstVersion = SysIni(,'OS2 Kit for Java','CurrentVersion')
   otherJavaInstPath = SysInI(,'OS2 Kit for Java',otherJavaInstVersion)

/*
say 'JavaInstVersion = '||otherJavaInstVersion
say 'JavaInstPath    = '||otherJavaInstPath
*/

   if otherJavaInstPath = "ERROR:" then do
      otherJavaInstVersion = SysIni(,'OS2 Kit for Java SDK','CurrentVersion')
      otherJavaInstPath = SysInI(,'OS2 Kit for Java SDK',otherJavaInstVersion)
      if otherJavaInstPath = "ERROR:" then
         do
            otherJavaInstVersion = 0
            JDKInstallPath=''
         end /* do */
      else
         do
            /* iniJavaInstVersion = TRANSLATE(otherJavaInstVersion,'.','') */
            JDKInstallPath = otherJavaInstPath
         end /* do */
   end /* do */
   else do
      /* iniJavaInstVersion = TRANSLATE(otherJavaInstVersion,'.','') */
      JDKInstallPath=otherJavaInstPath
   end /* if..else do..end */

/*
  CRAP = SUBSTR(JDKInstallPath, LENGTH(JDKInstallPath), 1)
  say 'Crap='||CRAP
*/
  if LENGTH(JDKInstallPath)>0 then do
     JDKInstallPath=STRIP(JDKInstallPath,,SUBSTR(JDKInstallPath, LENGTH(JDKInstallPath), 1))
     JDKInstallPath=JDKInstallPath||'\bin\'
  end /* do */
     
  
  /* DEBUG */
/*  say 'Java EXE Path: '||JDKInstallPath */
  
  return JDKInstallPath
/* END GetJavaVersion */






/* Wait for a key press */
PressAnyKey:
  call charout, 'Press any key to continue...'
  call SysGetKey 'NOECHO'
  return



/* Get path from user */
GetPath:
  call charout, '> '
  parse pull APath
  len = length(APath)
  if len > 0 then
    if substr(APath, len, 1) = '\' then
      APath = substr(APath, 1, len-1)
  return APath




/*
GetBootDrive
   Use SysBootDrive (RexxUtils) if it is available, use RxBootDrive
   (RxExtras) if it is available, or use an alternate method to get the
   value if neither is available.  Uncomment following if GetBootDrive
   is imbedded in a routine.
*/

/* Get Bootdrive */
GetBootDrive: Procedure
If \Rxfuncquery('SysBootDrive') Then
   bootdrive = SysBootDrive()       /* Object or Updated Classic Rexx */
Else
   Do
      If \Rxfuncquery('RxBootDrive') Then
         bootdrive = RxBootDrive()                        /* RxExtras */
      Else
         Do                       /* Examine various config.sys items */
            Parse Upper Value Value('PATH', ,'OS2ENVIRONMENT') ,
               With ':\OS2\SYSTEM' - 1 bootdrive + 2
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('RUNWORKPLACE', ,'OS2ENVIRONMENT'), 1, 2 )
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('COMSPEC', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('OS2_SHELL', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('SYSTEM_INI', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('USER_INI', ,'OS2ENVIRONMENT'), 1, 2)
            If bootdrive = '' Then                      /* no guesses */
               bootdrive = 0
         End
   End
Return bootdrive               /* Returns BootDrive, letter and colon */



/* End message */
InstallEnd:
  call SysCls
  say
  say
  say ''||AppName||' INSTALL ended.'
  exit

