/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.extensions.BClass;
import bluej.extensions.BDependency;
import bluej.extensions.ExtensionException;
import bluej.extensions.Identifier;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BClassTarget {
    private Identifier targetId;

    BClassTarget(Identifier targetId) {
        this.targetId = targetId;
    }

    ClassTarget getClassTarget() throws ProjectNotOpenException, PackageNotFoundException {
        return this.targetId.getClassTarget();
    }

    void nameChanged(String newName) {
        try {
            Project bluejProject = this.targetId.getBluejProject();
            Package bluejPackage = this.targetId.getBluejPackage();
            this.targetId = new Identifier(bluejProject, bluejPackage, newName);
        }
        catch (ProjectNotOpenException e) {
        }
        catch (PackageNotFoundException packageNotFoundException) {
            // empty catch block
        }
    }

    public void recalcDependentPositions() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.getClassTarget();
        if (classTarget != null) {
            classTarget.recalcDependentPositions();
        }
    }

    public void revalidate() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.getClassTarget();
        if (classTarget != null) {
            classTarget.getPackage().getEditor().revalidate();
        }
    }

    public BClass getBClass() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.getClassTarget();
        return classTarget != null ? classTarget.getBClass() : null;
    }

    public boolean isInterface() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.getClassTarget();
        return classTarget != null ? classTarget.isInterface() : false;
    }

    public boolean isUnitTest() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.getClassTarget();
        return classTarget != null ? classTarget.isUnitTest() : false;
    }

    public boolean isVisible() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.getClassTarget();
        return classTarget != null ? classTarget.isVisible() : false;
    }

    public void setVisible(boolean visible) throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget classTarget = this.getClassTarget();
        if (classTarget != null) {
            classTarget.setVisible(visible);
        }
    }

    public BClassTarget getAssociation() throws ProjectNotOpenException, PackageNotFoundException {
        DependentTarget association;
        ClassTarget classTarget = this.getClassTarget();
        if (classTarget != null && (association = classTarget.getAssociation()) instanceof ClassTarget) {
            return ((ClassTarget)association).getBClassTarget();
        }
        return null;
    }

    public List<BDependency> getOutgoingDependencies() throws ProjectNotOpenException, PackageNotFoundException {
        ArrayList<BDependency> result = new ArrayList<BDependency>();
        ClassTarget classTarget = this.getClassTarget();
        if (classTarget != null) {
            result.addAll(this.getBDependencies(classTarget.dependencies()));
        }
        return result;
    }

    public List<BDependency> getIncomingDependencies() throws ProjectNotOpenException, PackageNotFoundException {
        ArrayList<BDependency> result = new ArrayList<BDependency>();
        ClassTarget classTarget = this.getClassTarget();
        if (classTarget != null) {
            result.addAll(this.getBDependencies(classTarget.dependents()));
        }
        return result;
    }

    private List<BDependency> getBDependencies(Iterator<? extends Dependency> dependencies) {
        ArrayList<BDependency> result = new ArrayList<BDependency>();
        while (dependencies.hasNext()) {
            Dependency dependency = dependencies.next();
            result.add(dependency.getBDependency());
        }
        return result;
    }

    public String toString() {
        try {
            ClassTarget classTarget = this.getClassTarget();
            return "BClassTarget: " + classTarget.getIdentifierName();
        }
        catch (ExtensionException e) {
            return "BClassTarget: INVALID";
        }
    }
}

