/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.NaviView;
import bluej.prefmgr.PrefMgr;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EditorDividerPanel
extends JPanel
implements MouseListener {
    boolean expanded = true;
    protected JLabel expandCollapseButton;
    private static final String EXPAND_COLLAPSE_NAVIVIEW = "expandCollapseNaviview";
    private NaviView nav;
    private ImageIcon openNavArrow;
    private ImageIcon closeNavArrow;
    private boolean currentlyHidden = false;

    public EditorDividerPanel(NaviView naviview, boolean expanded) {
        this.nav = naviview;
        this.expanded = expanded;
        this.openNavArrow = Config.getImageAsIcon((String)"image.editordivider.open");
        this.closeNavArrow = Config.getImageAsIcon((String)"image.editordivider.close");
        this.setPreferredSize(new Dimension(this.closeNavArrow.getIconWidth() + 2, 0));
        this.setMaximumSize(new Dimension(this.closeNavArrow.getIconWidth() + 2, Integer.MAX_VALUE));
        this.setLayout((LayoutManager)new DBoxLayout(DBox.X_AXIS, 0, 0));
        this.expandCollapseButton = new JLabel();
        this.expandCollapseButton.setName(EXPAND_COLLAPSE_NAVIVIEW);
        this.addMouseListener(this);
        this.add((Component)this.expandCollapseButton, "Center");
        if (this.isExpanded()) {
            this.expandCollapseButton.setIcon(this.closeNavArrow);
        } else {
            this.nav.setVisible(false);
            this.expandCollapseButton.setIcon(this.openNavArrow);
        }
    }

    protected boolean isExpanded() {
        return this.expanded;
    }

    protected void setExpanded(boolean expanded) {
        PrefMgr.setNaviviewExpanded((boolean)expanded);
        this.expanded = expanded;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.currentlyHidden) {
            return;
        }
        if (this.isExpanded()) {
            this.nav.setVisible(false);
            this.setExpanded(false);
            this.expandCollapseButton.setIcon(this.openNavArrow);
            this.mouseExited(e);
        } else {
            this.nav.setVisible(true);
            this.setExpanded(true);
            this.expandCollapseButton.setIcon(this.closeNavArrow);
            this.mouseExited(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setOpaque(true);
        this.setBackground(MoeEditor.lightGrey);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setOpaque(false);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void beginTemporaryHide() {
        this.currentlyHidden = true;
        this.nav.setVisible(false);
        this.expandCollapseButton.setIcon(this.openNavArrow);
        this.setVisible(false);
    }

    public void endTemporaryHide() {
        this.currentlyHidden = false;
        if (this.isExpanded()) {
            this.nav.setVisible(true);
            this.expandCollapseButton.setIcon(this.closeNavArrow);
        }
        this.setVisible(true);
    }
}

