/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.FindPanel;
import bluej.editor.moe.MoeEditor;
import bluej.prefmgr.PrefMgr;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReplacePanel
extends JPanel
implements ActionListener,
DocumentListener {
    private MoeEditor editor;
    private FindPanel finder;
    private Font font;
    private JTextField replaceText;
    private String replaceString = "";
    private JButton replaceButton;
    private JButton replaceAllButton;
    private static final String REPLACE_BUTTON_NAME = "replaceBtn";
    private static final String REPLACE_ALL_BUTTON_NAME = "replaceAllBtn";
    private static final String REPLACE_TEXTFIELD = "replaceTextField";

    public ReplacePanel(MoeEditor ed, FindPanel finder) {
        super(new BorderLayout());
        this.finder = finder;
        this.font = PrefMgr.getStandardFont();
        this.addReplaceBody();
        this.editor = ed;
    }

    protected JTextField getReplaceText() {
        return this.replaceText;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent src = (JComponent)e.getSource();
        this.setReplaceString(this.replaceText.getText());
        if (src.getName().equals(REPLACE_BUTTON_NAME) && this.getReplaceString() != null) {
            this.editor.replace(this.getReplaceString());
        }
        if (src.getName().equals(REPLACE_ALL_BUTTON_NAME) && this.getReplaceString() != null) {
            this.editor.replaceAll(this.getReplaceString());
        }
    }

    public void replaceEvent() {
        this.setReplaceString(this.replaceText.getText());
        this.enableButtons();
    }

    public void enableButtons() {
        if (this.editor.getFindSearchString() != null && this.editor.getFindSearchString().length() != 0 && this.editor.getSourcePane().getSelectedText() != null && this.editor.getSourcePane().getSelectedText().equals(this.editor.getFindSearchString())) {
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
    }

    private void addReplaceBody() {
        DBox rBody = new DBox(DBox.X_AXIS, 0, 11, 0.5f);
        DBox replaceBody = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.0f);
        DBox optionsBody = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.0f);
        if (!Config.isRaspberryPi()) {
            rBody.setOpaque(false);
        }
        if (!Config.isRaspberryPi()) {
            replaceBody.setOpaque(false);
        }
        if (!Config.isRaspberryPi()) {
            optionsBody.setOpaque(false);
        }
        JLabel replaceLabel = new JLabel(Config.getString((String)"editor.replacePanel.replaceLabel") + " ");
        replaceLabel.setFont(this.font);
        DBox replaceLabelBox = new DBox(DBox.X_AXIS, 0.5f);
        if (!Config.isRaspberryPi()) {
            replaceLabelBox.setOpaque(false);
        }
        replaceLabelBox.add(Box.createHorizontalGlue());
        replaceLabelBox.add((Component)replaceLabel);
        Dimension d = replaceLabelBox.getPreferredSize();
        d.width = this.finder.getLabelBoxWidth();
        replaceLabelBox.setPreferredSize(d);
        replaceLabelBox.setMaximumSize(d);
        this.replaceText = new JTextField(11);
        this.replaceText.setMaximumSize(this.replaceText.getPreferredSize());
        this.replaceText.setFont(this.font);
        this.replaceText.setText(this.getReplaceString());
        this.replaceText.getDocument().addDocumentListener(this);
        this.replaceText.setName(REPLACE_TEXTFIELD);
        this.replaceButton = new JButton();
        this.replaceButton.setName(REPLACE_BUTTON_NAME);
        this.replaceButton.setText(Config.getString((String)"editor.replacePanel.replaceOnce"));
        this.replaceButton.setFont(this.font);
        this.replaceButton.addActionListener(this);
        this.replaceButton.setEnabled(false);
        this.replaceAllButton = new JButton();
        this.replaceAllButton.setName(REPLACE_ALL_BUTTON_NAME);
        this.replaceAllButton.setText(" " + Config.getString((String)"editor.replacePanel.replaceAll") + "  ");
        this.replaceAllButton.setFont(this.font);
        this.replaceAllButton.addActionListener(this);
        this.replaceAllButton.setEnabled(false);
        if (Config.isMacOS()) {
            this.replaceButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.replaceButton.putClientProperty("JButton.segmentPosition", "only");
            this.replaceAllButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.replaceAllButton.putClientProperty("JButton.segmentPosition", "only");
        }
        replaceBody.add((Component)replaceLabelBox);
        replaceBody.add((Component)this.replaceText);
        optionsBody.add((Component)this.replaceButton);
        optionsBody.add((Component)this.replaceAllButton);
        rBody.add((Component)replaceBody);
        rBody.add((Component)optionsBody);
        rBody.setMaximumSize(rBody.getPreferredSize());
        this.add((Component)rBody, "West");
    }

    public void requestReplaceTextFocus() {
        this.replaceText.requestFocus();
        this.replaceText.setText(this.getReplaceString());
    }

    protected String getReplaceString() {
        return this.replaceString;
    }

    protected void setReplaceString(String replaceString) {
        this.replaceString = replaceString;
    }

    protected void enableButtons(boolean enable) {
        this.replaceAllButton.setEnabled(enable);
        this.replaceButton.setEnabled(enable);
    }

    protected void requestReplaceFocus() {
        this.replaceText.requestFocus();
    }

    protected void populateReplaceField(String replaceString) {
        this.replaceText.setText(replaceString);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.replaceEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.replaceEvent();
    }
}

