/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.Boot;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.extensions.event.ApplicationEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.actions.HelpAboutAction;
import bluej.pkgmgr.actions.PreferencesAction;
import bluej.pkgmgr.actions.QuitAction;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class Main {
    private static final int FIRST_X_LOCATION = 20;
    private static final int FIRST_Y_LOCATION = 20;
    private static boolean launched = false;
    private static List<File> initialProjects;
    private static QuitResponse macEventResponse;

    public Main() {
        Boot boot = Boot.getInstance();
        final String[] args = boot.getArgs();
        Properties commandLineProps = boot.getCommandLineProperties();
        File bluejLibDir = Boot.getBluejLibDir();
        Config.initialise(bluejLibDir, commandLineProps, boot.isGreenfoot());
        if (Config.isMacOS()) {
            Main.prepareMacOSApp();
        }
        if (Config.isGreenfoot()) {
            System.setProperty("java.rmi.server.useCodebaseOnly", "false");
        }
        DataCollector.bluejOpened(Main.getOperatingSystem(), Main.getJavaVersion(), Main.getBlueJVersion(), Main.getInterfaceLanguage(), ExtensionsManager.getInstance().getLoadedExtensions(null));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.processArgs(args);
            }
        });
        new Thread(){

            @Override
            public void run() {
                Main.updateStats();
            }
        }.start();
    }

    private static void processArgs(String[] args) {
        boolean openOrphans;
        launched = true;
        boolean oneOpened = false;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-") || !PkgMgrFrame.doOpen(new File(args[i]), null)) continue;
                oneOpened = true;
            }
        }
        if (initialProjects != null) {
            for (File initialProject : initialProjects) {
                oneOpened |= PkgMgrFrame.doOpen(initialProject, null);
            }
        }
        if (!oneOpened && (openOrphans = "true".equals(Config.getPropString("bluej.autoOpenLastProject"))) && Main.hadOrphanPackages()) {
            String exists = "";
            int i = 1;
            while (exists != null) {
                Project openProj;
                exists = Config.getPropString("bluej.openPackage" + i, null);
                if (exists != null && (openProj = Project.openProject(exists, null)) != null) {
                    Package pkg = openProj.getPackage(openProj.getInitialPackageName());
                    PkgMgrFrame.createFrame(pkg);
                    oneOpened = true;
                }
                ++i;
            }
        }
        if (!oneOpened && !Config.isGreenfoot()) {
            Main.openEmptyFrame();
        }
        if (!Config.isGreenfoot()) {
            Boot.getInstance().disposeSplashWindow();
        }
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)new ApplicationEvent(1));
    }

    private static void prepareMacOSApp() {
        Application macApp = Application.getApplication();
        if (macApp != null) {
            macApp.setAboutHandler(new AboutHandler(){

                public void handleAbout(AppEvent.AboutEvent e) {
                    HelpAboutAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
                }
            });
            macApp.setPreferencesHandler(new PreferencesHandler(){

                public void handlePreferences(AppEvent.PreferencesEvent e) {
                    PreferencesAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
                }
            });
            macApp.setQuitHandler(new QuitHandler(){

                public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse response) {
                    macEventResponse = response;
                    QuitAction.getInstance().actionPerformed(PkgMgrFrame.getMostRecent());
                }
            });
            macApp.setOpenFileHandler(new OpenFilesHandler(){

                public void openFiles(AppEvent.OpenFilesEvent e) {
                    if (launched) {
                        List files = e.getFiles();
                        for (File file : files) {
                            PkgMgrFrame.doOpen(file, null);
                        }
                    } else {
                        initialProjects = e.getFiles();
                    }
                }
            });
        }
        if (Config.isGreenfoot()) {
            Debug.message("Disabling App Nap");
            try {
                Runtime.getRuntime().exec("defaults write org.greenfoot NSAppSleepDisabled -bool YES");
            }
            catch (IOException e) {
                Debug.reportError("Error disabling App Nap", e);
            }
        }
    }

    public static void wantToQuit() {
        int answer = 0;
        if (Project.getOpenProjectCount() > 1) {
            answer = DialogManager.askQuestion(PkgMgrFrame.getMostRecent(), "quit-all");
        }
        if (answer == 0) {
            Main.doQuit();
        } else if (macEventResponse != null) {
            macEventResponse.cancelQuit();
            macEventResponse = null;
        }
    }

    public static void doQuit() {
        PkgMgrFrame[] pkgFrames = PkgMgrFrame.getAllFrames();
        Main.handleOrphanPackages(pkgFrames);
        for (int i = pkgFrames.length - 1; i >= 0; --i) {
            PkgMgrFrame aFrame = pkgFrames[i];
            aFrame.doSave();
            aFrame.closePackage();
            PkgMgrFrame.closeFrame(aFrame);
        }
        ExtensionsManager extMgr = ExtensionsManager.getInstance();
        extMgr.unloadExtensions();
        Main.exit();
    }

    private static void handleOrphanPackages(PkgMgrFrame[] openFrames) {
        if (Main.hadOrphanPackages()) {
            Main.removeOrphanPackageList();
        }
        for (int i = 0; i < openFrames.length; ++i) {
            PkgMgrFrame aFrame = openFrames[i];
            if (aFrame.isEmptyFrame()) continue;
            Config.putPropString("bluej.openPackage" + (i + 1), aFrame.getPackage().getPath().toString());
        }
    }

    public static boolean hadOrphanPackages() {
        String dir = "";
        int i = 1;
        while (dir != null) {
            dir = Config.getPropString("bluej.openPackage" + i, null);
            if (dir != null && Project.isProject(dir)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void removeOrphanPackageList() {
        String exists = "";
        int i = 1;
        while (exists != null) {
            exists = Config.removeProperty("bluej.openPackage" + i);
            ++i;
        }
    }

    private static void openEmptyFrame() {
        PkgMgrFrame frame = PkgMgrFrame.createFrame();
        frame.setLocation(20, 20);
        frame.setVisible(true);
    }

    private static void updateStats() {
        String appVersion;
        String baseURL;
        String uidPropName;
        if (Config.isGreenfoot()) {
            uidPropName = "greenfoot.uid";
            baseURL = "http://stats.greenfoot.org/updateGreenfoot.php";
            appVersion = Boot.GREENFOOT_VERSION;
        } else {
            uidPropName = "bluej.uid";
            baseURL = "http://stats.bluej.org/updateBlueJ.php";
            appVersion = Main.getBlueJVersion();
        }
        String language = Main.getInterfaceLanguage();
        String javaVersion = Main.getJavaVersion();
        String systemID = Main.getOperatingSystem();
        String uid = Config.getPropString(uidPropName, null);
        if (uid == null) {
            uid = UUID.randomUUID().toString();
            Config.putPropString(uidPropName, uid);
        } else if (uid.equalsIgnoreCase("private")) {
            return;
        }
        try {
            URL url = new URL(baseURL + "?uid=" + URLEncoder.encode(uid, "UTF-8") + "&osname=" + URLEncoder.encode(systemID, "UTF-8") + "&appversion=" + URLEncoder.encode(appVersion, "UTF-8") + "&javaversion=" + URLEncoder.encode(javaVersion, "UTF-8") + "&language=" + URLEncoder.encode(language, "UTF-8"));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int rc = conn.getResponseCode();
            conn.disconnect();
            if (rc != 200) {
                Debug.reportError("Update stats failed, HTTP response code: " + rc);
            }
        }
        catch (Exception ex) {
            Debug.reportError("Update stats failed: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    private static String getBlueJVersion() {
        return "3.1.1";
    }

    private static String getOperatingSystem() {
        return System.getProperty("os.name") + "/" + System.getProperty("os.arch") + "/" + System.getProperty("os.version");
    }

    private static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private static String getInterfaceLanguage() {
        return Config.language;
    }

    private static void exit() {
        if (PkgMgrFrame.frameCount() > 0) {
            Debug.reportError("Frame count was not zero when exiting. Work may not have been saved");
        }
        DataCollector.bluejClosed();
        Config.handleExit();
        System.exit(0);
    }

    static {
        macEventResponse = null;
    }
}

