/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileObserver;
import bluej.compiler.Diagnostic;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;

public final class EventqueueCompileObserver
implements CompileObserver,
Runnable {
    private CompileObserver link;
    private int command;
    private static final int COMMAND_START = 0;
    private static final int COMMAND_DIAG = 1;
    private static final int COMMAND_END = 2;
    private File[] sources;
    private boolean successful;
    private Diagnostic diagnostic;
    private boolean wasShown;

    public EventqueueCompileObserver(CompileObserver link) {
        this.link = link;
    }

    private void runOnEventQueue() {
        try {
            EventQueue.invokeAndWait(this);
        }
        catch (InterruptedException ie) {
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    @Override
    public synchronized boolean compilerMessage(Diagnostic diagnostic) {
        this.command = 1;
        this.diagnostic = diagnostic;
        this.runOnEventQueue();
        return this.wasShown;
    }

    @Override
    public synchronized void startCompile(File[] csources) {
        this.command = 0;
        this.sources = csources;
        this.runOnEventQueue();
    }

    @Override
    public synchronized void endCompile(File[] sources, boolean successful) {
        this.command = 2;
        this.sources = sources;
        this.successful = successful;
        this.runOnEventQueue();
    }

    @Override
    public void run() {
        switch (this.command) {
            case 0: {
                this.link.startCompile(this.sources);
                break;
            }
            case 1: {
                this.wasShown = this.link.compilerMessage(this.diagnostic);
                break;
            }
            case 2: {
                this.link.endCompile(this.sources, this.successful);
            }
        }
    }
}

