/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.utility.JavaNames;
import java.util.Map;

public abstract class GenTypeParameter {
    private static NameTransform stripPrefixNt = new NameTransform(){

        @Override
        public String transform(String x) {
            return JavaNames.stripPrefix(x);
        }
    };
    private static NameTransform nullTransform = new NameTransform(){

        @Override
        public String transform(String x) {
            return x;
        }
    };

    public abstract GenTypeParameter mapTparsToTypes(Map<String, ? extends GenTypeParameter> var1);

    public boolean equals(Object other) {
        if (other instanceof GenTypeParameter) {
            return this.equals((GenTypeParameter)other);
        }
        return false;
    }

    public abstract boolean equals(GenTypeParameter var1);

    public GenTypeParameter precisify(GenTypeParameter other) {
        GenTypeSolid upperBound = this.getUpperBound().asSolid();
        if (upperBound == null) {
            return this;
        }
        GenTypeSolid lowerBound = this.getLowerBound();
        GenTypeSolid newUpper = null;
        GenTypeSolid otherUpper = IntersectionType.getIntersection(other.getUpperBounds());
        newUpper = otherUpper == null ? upperBound : IntersectionType.getIntersection(new GenTypeSolid[]{otherUpper, upperBound});
        GenTypeSolid newLower = null;
        GenTypeSolid otherLower = other.getLowerBound();
        newLower = otherLower == null ? lowerBound : (lowerBound == null ? otherLower : GenTypeSolid.lub(new GenTypeSolid[]{otherLower, lowerBound}));
        if (newUpper != null && newUpper.equals(newLower)) {
            return newUpper;
        }
        return new GenTypeWildcard(newUpper, newLower);
    }

    public abstract GenTypeSolid[] getUpperBounds();

    public abstract JavaType getUpperBound();

    public abstract GenTypeSolid getLowerBound();

    public final boolean contains(GenTypeParameter other) {
        GenTypeSolid myLower = this.getLowerBound();
        JavaType myUpper = this.getUpperBound();
        GenTypeSolid otherLower = other.getLowerBound();
        JavaType otherUpper = other.getUpperBound();
        if (myUpper != null) {
            if (otherUpper == null) {
                if (myUpper.asClass() == null) {
                    return false;
                }
                if (!myUpper.asClass().classloaderName().equals("java.lang.Object")) {
                    return false;
                }
            } else if (!myUpper.isAssignableFrom(otherUpper)) {
                return false;
            }
        }
        if (myLower != null) {
            if (otherLower == null) {
                return false;
            }
            if (!otherLower.isAssignableFrom(myLower)) {
                return false;
            }
        }
        return true;
    }

    public String toString(boolean stripPrefix) {
        if (stripPrefix) {
            return this.toString(stripPrefixNt);
        }
        return this.toString(nullTransform);
    }

    public String toTypeArgString(boolean stripPrefix) {
        if (stripPrefix) {
            return this.toString(stripPrefixNt);
        }
        return this.toString(nullTransform);
    }

    public String toString(NameTransform nt) {
        return this.toString();
    }

    public abstract String toTypeArgString(NameTransform var1);

    public abstract JavaType getErasedType();

    public abstract JavaType getCapture();

    public boolean isPrimitive() {
        return false;
    }

    public abstract boolean isWildcard();

    public GenTypeParameter getArrayComponent() {
        return null;
    }
}

