/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;

public class MethodReflective {
    private String name;
    private JavaType returnType;
    private List<GenTypeDeclTpar> tparTypes;
    private List<JavaType> paramTypes;
    private boolean isVarArgs;
    private Reflective declaringType;
    private String javaDoc;
    private List<String> paramNames;
    private int modifiers;

    public MethodReflective(String name, JavaType returnType, List<GenTypeDeclTpar> tparTypes, List<JavaType> paramTypes, Reflective declaringType, boolean isVarArgs, int modifiers) {
        this.name = name;
        this.returnType = returnType;
        this.tparTypes = tparTypes;
        this.paramTypes = paramTypes;
        this.declaringType = declaringType;
        this.isVarArgs = isVarArgs;
        this.modifiers = modifiers;
    }

    public void setJavaDoc(String javaDoc) {
        this.javaDoc = javaDoc;
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public void setParamNames(List<String> paramNames) {
        this.paramNames = paramNames;
    }

    public List<String> getParamNames() {
        return this.paramNames;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isAbstract() {
        return false;
    }

    public List<JavaType> getParamTypes() {
        return this.paramTypes;
    }

    public List<GenTypeDeclTpar> getTparTypes() {
        return this.tparTypes == null ? Collections.emptyList() : this.tparTypes;
    }

    public JavaType getReturnType() {
        return this.returnType;
    }

    public Reflective getDeclaringType() {
        return this.declaringType;
    }
}

