/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.Config;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import java.io.File;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SvnShareCommand
extends SvnCommand {
    public SvnShareCommand(SvnRepository repository) {
        super(repository);
    }

    @Override
    protected TeamworkCommandResult doCommand() {
        block3: {
            SVNClientInterface client = this.getClient();
            File projectPath = this.getRepository().getProjectPath();
            String projUrl = this.getRepository().getReposUrl() + "/" + projectPath.getName();
            try {
                client.mkdir(new String[]{projUrl}, Config.getString("team.import.initialMessage"));
                client.checkout(projUrl, projectPath.getAbsolutePath(), Revision.HEAD, Revision.HEAD, 0, false, true);
                if (!this.isCancelled()) {
                    return new TeamworkCommandResult();
                }
            }
            catch (ClientException ce) {
                if (this.isCancelled()) break block3;
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
        }
        return new TeamworkCommandAborted();
    }
}

