/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import bluej.utility.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;
import org.tigris.subversion.javahl.SubversionException;

public class SvnUpdateToCommand
extends SvnCommand
implements UpdateResults {
    private long version;
    private Set<File> files;
    private Set<File> forceFiles;
    private UpdateListener listener;
    private List<File> conflicts = new ArrayList<File>();
    private Set<File> binaryConflicts = new HashSet<File>();

    public SvnUpdateToCommand(SvnRepository repository, UpdateListener listener, long version, Set<File> files, Set<File> forceFiles) {
        super(repository);
        this.version = version;
        this.files = files;
        this.forceFiles = forceFiles;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TeamworkCommandResult doCommand() {
        SVNClientInterface client = this.getClient();
        final ArrayList addedList = new ArrayList();
        final ArrayList updatedList = new ArrayList();
        final ArrayList removedList = new ArrayList();
        final ArrayList removedDirs = new ArrayList();
        try {
            String[] paths = new String[this.forceFiles.size() + this.files.size()];
            int j = 0;
            for (File file : this.forceFiles) {
                paths[j++] = file.getAbsolutePath();
                file.delete();
            }
            for (File file : this.files) {
                paths[j++] = file.getAbsolutePath();
            }
            client.notification2(new Notify2(){

                public void onNotify(NotifyInformation ninfo) {
                    int action;
                    if (ninfo.getKind() == 1 || ninfo.getKind() == 0) {
                        int action2 = ninfo.getAction();
                        if (ninfo.getPath() != null) {
                            File file = new File(ninfo.getPath());
                            if (action2 == 9 || action2 == 3) {
                                addedList.add(file);
                            } else if (action2 == 10) {
                                updatedList.add(file);
                                if (ninfo.getContentState() == 7) {
                                    SvnUpdateToCommand.this.conflicts.add(file);
                                }
                            } else if (action2 == 8) {
                                removedList.add(file);
                            } else if (action2 == 38) {
                                SvnUpdateToCommand.this.binaryConflicts.add(file);
                            }
                        }
                    } else if (ninfo.getKind() == 2 && (action = ninfo.getAction()) == 8) {
                        removedDirs.add(new File(ninfo.getPath()));
                    }
                }
            });
            client.update(paths, Revision.getInstance((long)this.version), 2, false, false, false);
        }
        catch (ClientException ce) {
            if (this.isCancelled()) {
                TeamworkCommandAborted teamworkCommandAborted = new TeamworkCommandAborted();
                return teamworkCommandAborted;
            }
            TeamworkCommandError teamworkCommandError = new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            return teamworkCommandError;
        }
        finally {
            client.notification2(null);
            Iterator<Object> i = addedList.iterator();
            while (i.hasNext()) {
                this.listener.fileAdded((File)i.next());
            }
            i = updatedList.iterator();
            while (i.hasNext()) {
                this.listener.fileUpdated((File)i.next());
            }
            i = removedList.iterator();
            while (i.hasNext()) {
                this.listener.fileRemoved((File)i.next());
            }
            i = removedDirs.iterator();
            while (i.hasNext()) {
                this.listener.dirRemoved((File)i.next());
            }
            if (!this.conflicts.isEmpty()) {
                i = this.conflicts.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    try {
                        PropertyData pdata = client.propertyGet(file.getAbsolutePath(), "svn:mime-type", Revision.getInstance((long)this.version));
                        if (pdata != null && "application/octet-stream".equals(pdata.getValue())) {
                            i.remove();
                            this.binaryConflicts.add(file);
                            continue;
                        }
                        client.resolve(file.getAbsolutePath(), 0, 6);
                    }
                    catch (SubversionException se) {
                        Debug.message("Subversion client exception when resolving conflicts: " + se.getLocalizedMessage());
                        Debug.message("   (on file: " + file + ")");
                    }
                }
            }
            if (!this.conflicts.isEmpty() || !this.binaryConflicts.isEmpty()) {
                this.listener.handleConflicts(this);
            }
        }
        return new TeamworkCommandResult();
    }

    @Override
    public Set<File> getBinaryConflicts() {
        return this.binaryConflicts;
    }

    @Override
    public List<File> getConflicts() {
        return this.conflicts;
    }

    @Override
    public void overrideFiles(final Set<File> files) {
        final SVNClientInterface client = this.getRepository().getClient();
        StatusCallback scb = new StatusCallback(){

            public void doStatus(Status status) {
                File file = new File(status.getPath());
                try {
                    String conflictOld;
                    ConflictDescriptor cd = status.getConflictDescriptor();
                    if (cd != null) {
                        int action = cd.getAction();
                        int kind = cd.getKind();
                        int reason = cd.getReason();
                        if (kind != 0) {
                            return;
                        }
                        if (action == 2 && reason == 0) {
                            client.resolve(file.getAbsolutePath(), 0, 6);
                            boolean keepLocal = !files.contains(file);
                            String[] paths = new String[]{file.getPath()};
                            client.remove(paths, "", true, keepLocal, Collections.emptyMap());
                            return;
                        }
                        if (action == 0 && reason == 2) {
                            client.resolve(file.getAbsolutePath(), 0, 2);
                        }
                    }
                    if ((conflictOld = status.getConflictOld()) != null) {
                        File oldRev = new File(file.getParent(), status.getConflictOld());
                        oldRev.delete();
                    }
                    if (files.contains(file)) {
                        client.resolve(file.getAbsolutePath(), 0, 2);
                    } else {
                        client.resolve(file.getAbsolutePath(), 0, 3);
                    }
                }
                catch (SubversionException sve) {
                    Debug.message("Subversion library exception trying to resolve binary conflict: " + sve.getLocalizedMessage());
                    Debug.message("   (on file: " + file + ")");
                }
            }
        };
        for (File file : this.binaryConflicts) {
            try {
                client.status(file.getAbsolutePath(), 0, false, true, true, true, new String[0], scb);
            }
            catch (ClientException ce) {
                Debug.message("Subversion library exception trying to resolve binary conflict: " + ce.getLocalizedMessage());
                Debug.message("   (on file: " + file + ")");
            }
        }
    }
}

